/*
 * Decompiled with CFR 0.152.
 */
package visad.bio;

import java.awt.Cursor;
import java.io.File;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.bio.ImageStackWidget;
import visad.bio.MeasureMatrix;
import visad.bio.MeasureToolbar;
import visad.bio.StepWidget;
import visad.data.DefaultFamily;

public class FileSeriesWidget
extends StepWidget {
    static final RealType COLOR_TYPE = RealType.getRealType("color");
    private final DefaultFamily loader = new DefaultFamily("loader");
    private DataReferenceImpl ref;
    private File[] files;
    private int curFile;
    private ImageStackWidget isw;
    private MeasureToolbar toolbar;
    private ScalarMap animMap2;
    private ScalarMap xMap2;
    private ScalarMap yMap2;
    private ScalarMap xMap3;
    private ScalarMap yMap3;
    private ScalarMap zMap3;
    private ScalarMap zMap3b;
    private MeasureMatrix matrix;
    private DisplayImpl display2;
    private DisplayImpl display3;

    public MeasureMatrix getMatrix() {
        return this.matrix;
    }

    public void setSeries(File[] fileArray) {
        this.files = fileArray;
        this.matrix = new MeasureMatrix(fileArray.length, this.display2, this.display3, this.toolbar);
        this.isw.setMatrix(this.matrix);
        this.loadFile(true);
        this.updateSlider();
    }

    public void setDisplay(DisplayImpl displayImpl) {
        this.display2 = displayImpl;
    }

    public void setDisplay3d(DisplayImpl displayImpl) {
        this.display3 = displayImpl;
    }

    public void setWidget(ImageStackWidget imageStackWidget) {
        this.isw = imageStackWidget;
    }

    public void setToolbar(MeasureToolbar measureToolbar) {
        this.toolbar = measureToolbar;
    }

    public void updateStep() {
        if (this.files != null && this.curFile != this.cur - 1 && !this.step.getValueIsAdjusting()) {
            this.curFile = this.cur - 1;
            this.loadFile(false);
        }
    }

    private void updateSlider() {
        int n = 1;
        if (this.files == null) {
            this.toolbar.setEnabled(false);
            this.setEnabled(false);
        } else {
            this.toolbar.setEnabled(true);
            this.setEnabled(true);
            n = this.files.length;
            this.curFile = 0;
        }
        this.setBounds(1, n, 1);
    }

    private void loadFile(boolean bl) {
        Object object;
        int n;
        ScalarMap[] scalarMapArray;
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        File file = this.files[this.curFile];
        DataImpl dataImpl = null;
        try {
            dataImpl = this.loader.open(file.getPath());
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        if (dataImpl == null) {
            if (jRootPane != null) {
                jRootPane.setCursor(Cursor.getDefaultCursor());
            }
            JOptionPane.showMessageDialog(this, "Cannot import data from " + file.getName(), "Cannot load file", 0);
            return;
        }
        FieldImpl fieldImpl = null;
        if (dataImpl instanceof FieldImpl) {
            fieldImpl = (FieldImpl)dataImpl;
        } else if (dataImpl instanceof Tuple) {
            scalarMapArray = (ScalarMap[])dataImpl;
            n = scalarMapArray.getDimension();
            int n2 = 0;
            while (n2 < n) {
                try {
                    object = scalarMapArray.getComponent(n2);
                    if (object instanceof FieldImpl) {
                        fieldImpl = (FieldImpl)object;
                        break;
                    }
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                ++n2;
            }
        }
        if (fieldImpl == null) {
            if (jRootPane != null) {
                jRootPane.setCursor(Cursor.getDefaultCursor());
            }
            JOptionPane.showMessageDialog(this, file.getName() + " does not contain an image stack", "Cannot load file", 0);
            return;
        }
        if (bl && this.display2 != null) {
            try {
                this.display2.removeAllReferences();
                this.display2.clearMaps();
                if (this.display3 != null) {
                    this.display3.removeAllReferences();
                    this.display3.clearMaps();
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            this.yMap2 = null;
            this.xMap2 = null;
            this.animMap2 = null;
            this.zMap3 = null;
            this.yMap3 = null;
            this.xMap3 = null;
            scalarMapArray = fieldImpl.getType().guessMaps(false);
            n = 0;
            while (n < scalarMapArray.length) {
                ScalarMap scalarMap;
                ScalarMap scalarMap2 = scalarMapArray[n];
                object = scalarMap2.getDisplayScalar();
                boolean bl2 = Display.Animation.equals(object);
                ScalarMap scalarMap3 = scalarMap = bl2 ? null : (ScalarMap)scalarMap2.clone();
                if (bl2) {
                    this.animMap2 = scalarMap2;
                    if (this.display3 != null) {
                        try {
                            scalarMap = this.zMap3 = new ScalarMap(scalarMap2.getScalar(), Display.ZAxis);
                        }
                        catch (VisADException visADException) {
                            visADException.printStackTrace();
                        }
                    }
                } else if (Display.XAxis.equals(object)) {
                    this.xMap2 = scalarMap2;
                    if (this.display3 != null) {
                        this.xMap3 = scalarMap;
                    }
                } else if (Display.YAxis.equals(object)) {
                    this.yMap2 = scalarMap2;
                    if (this.display3 != null) {
                        this.yMap3 = scalarMap;
                    }
                }
                try {
                    this.display2.addMap(scalarMap2);
                    if (this.display3 != null) {
                        this.display3.addMap(scalarMap);
                    }
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                ++n;
            }
            this.isw.setGrayscale(true);
            try {
                ScalarMap scalarMap = new ScalarMap(COLOR_TYPE, Display.RGB);
                scalarMap.setRange(0.0, 255.0);
                this.display2.addMap(scalarMap);
                this.display2.addReference(this.ref);
                if (this.display3 != null) {
                    this.display3.addMap((ScalarMap)scalarMap.clone());
                    this.zMap3b = new ScalarMap(MeasureMatrix.ZAXIS_TYPE, Display.ZAxis);
                    this.display3.addMap(this.zMap3b);
                    this.display3.addReference(this.ref);
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        try {
            this.ref.setData(fieldImpl);
            this.matrix.init(fieldImpl, new ScalarMap[][]{{this.xMap2, this.xMap3}, {this.yMap2, this.yMap3}, {this.zMap3, this.zMap3b}});
            this.matrix.setIndex(this.curFile);
            if (this.isw != null && this.animMap2 != null) {
                this.isw.setMap(this.animMap2);
            }
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    public FileSeriesWidget(boolean bl) {
        super(bl);
        try {
            this.ref = new DataReferenceImpl("ref");
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
    }
}

