/*
 * Decompiled with CFR 0.152.
 */
package visad.benjamin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.Action;
import visad.ActionImpl;
import visad.CellImpl;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.ContourControl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.PlotText;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteActionImpl;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.UnionSet;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.util.LabeledColorWidget;
import visad.util.VisADSlider;

public class Galaxy
implements ActionListener {
    static int NxpxMAX;
    static int NypxMAX;
    static int NRMAX;
    static int NZMAX;
    static int NXP;
    static int NYP;
    static int NZP;
    static int NX;
    static int NY;
    static int NZ;
    static double llast;
    static double elast;
    static final double F1 = 0.36;
    static final double F2 = 40.0;
    static final double Fa = 6.0;
    RemoteServerImpl server_server;
    RemoteServer client_server;
    Linear3DSet grid_set;
    Linear2DSet image_set;
    Linear2DSet lonlat_set;
    Linear1DSet distSol_set;
    Set distDomain;
    Set velDomain;
    Gridded3DSet line_to_sol;
    Gridded3DSet x_to_sol;
    Gridded3DSet y_to_sol;
    Gridded3DSet z_to_sol;
    SampledSet[] set_s = new SampledSet[3];
    UnionSet sol_sight;
    RealTuple sol;
    float sol_x = 0.0f;
    float sol_y = 8.5f;
    float sol_z = 0.0f;
    int npts = 2;
    float[][] samples = new float[3][this.npts];
    int n_profpts = 50;
    float[] xprof = new float[this.n_profpts];
    float[] yprof = new float[this.n_profpts];
    float[][] yprof_a = new float[1][this.n_profpts];
    float[][] xprof_a = new float[1][this.n_profpts];
    int i_type = 1;
    float last_x;
    float last_y;
    float last_z;
    float l;
    float b;
    float d;
    float[] lbd = new float[3];
    float[][] lonlat_b;
    float[][] image_b;
    int length_0;
    int length_1;
    RealType gridx;
    RealType gridy;
    RealType gridz;
    RealTupleType grid_domain;
    RealType density;
    RealType emission;
    RealType Intensity;
    RealType distance;
    RealType v_LSR;
    FunctionType grid_type;
    FunctionType dist_density;
    FunctionType vel_intensity;
    FlatField field_D;
    FlatField field_E;
    RealType line;
    RealType element;
    RealTupleType image_domain;
    RealType radiance;
    FunctionType image_type;
    RealType lon;
    RealType lat;
    RealTupleType lonlat_range;
    FunctionType lonlat_type;
    DataReference grid_ref;
    DataReference image_ref;
    DataReference lonlat_ref;
    DataReference sphrSkyMap_ref;
    DataReference ireg_set_ref;
    DataReference line_to_sol_ref;
    DataReference sol_ref;
    DataReference sol_sightRef;
    DataReference red_cursor_ref;
    DataReference dist_densityRef;
    DataReference vel_intensityRef;
    DataReference n1_ref;
    DataReference h1_ref;
    DataReference A1_ref;
    DataReference n2_ref;
    DataReference h2_ref;
    DataReference A2_ref;
    DataReference na_ref;
    DataReference ha_ref;
    DataReference wa_ref;
    DataReference Aa_ref;
    DataReference density_ref;
    DataReference contour_button_ref;
    DataReference compute_button_ref;
    DataReference reset_button_ref;
    DataReference density_button_ref;
    DataReference flat_sphere_button_ref;
    DisplayImpl display1;
    DisplayImpl display2;
    DisplayImpl display3;
    DisplayImpl display4;
    DisplayImpl display5;
    JTextField[] coord_fields = new JTextField[3];
    JPanel center;
    JButton flat_sphere_button;
    JPanel panel2;
    JPanel panel5;
    JPanel widget_panel;
    LabeledColorWidget lw2;
    LabeledColorWidget lw5;
    ConstantMap[] cmaps;
    ConstantMap[] cmaps_sol;
    ConstantMap[] cmaps_line;
    ConstantMap[] yellow;
    ScalarMap linemap;

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        Galaxy galaxy = new Galaxy(stringArray);
        if (galaxy.client_server != null) {
            galaxy.setupClient();
        } else if (galaxy.server_server != null) {
            System.loadLibrary("Galaxy");
            galaxy.setupServer();
        } else {
            System.loadLibrary("Galaxy");
            galaxy.setupServer();
        }
    }

    void setupServer() throws VisADException, RemoteException {
        int[] nArray = new int[4];
        this.getcon_c(nArray);
        NxpxMAX = nArray[0];
        NypxMAX = nArray[1];
        NRMAX = nArray[2];
        NZMAX = nArray[3];
        NYP = NXP = NRMAX - 1;
        NZP = NZMAX - 1;
        NX = 2 * NXP + 1;
        NY = 2 * NYP + 1;
        NZ = 2 * NZP + 1;
        this.gridx = new RealType("gridx", null, null);
        this.gridy = new RealType("gridy", null, null);
        this.gridz = new RealType("gridz", null, null);
        this.grid_domain = new RealTupleType(this.gridx, this.gridy, this.gridz);
        this.density = new RealType("density", null, null);
        this.Intensity = new RealType("Intensity", null, null);
        this.distance = new RealType("distance", null, null);
        this.v_LSR = new RealType("v_LSR", null, null);
        this.grid_type = new FunctionType(this.grid_domain, this.density);
        this.dist_density = new FunctionType(this.distance, this.density);
        this.vel_intensity = new FunctionType(this.v_LSR, this.Intensity);
        this.line = new RealType("line", null, null);
        this.element = new RealType("element", null, null);
        this.image_domain = new RealTupleType(this.element, this.line);
        this.radiance = new RealType("H-alpha", null, null);
        this.image_type = new FunctionType(this.image_domain, this.radiance);
        this.lon = new RealType("lon", CommonUnit.degree, null);
        this.lat = new RealType("lat", CommonUnit.degree, null);
        this.lonlat_range = new RealTupleType(this.lon, this.lat);
        this.lonlat_type = new FunctionType(this.image_domain, this.lonlat_range);
        this.grid_ref = new DataReferenceImpl("grid_ref");
        float[][] fArray = new float[1][NX * NY * NZ];
        this.image_ref = new DataReferenceImpl("image_ref");
        float[][] fArray2 = new float[1][NxpxMAX * NypxMAX];
        this.lonlat_ref = new DataReferenceImpl("lonlat_ref");
        float[][] fArray3 = new float[2][NxpxMAX * NypxMAX];
        this.sphrSkyMap_ref = new DataReferenceImpl("sphrSkyMap_ref");
        this.ireg_set_ref = new DataReferenceImpl("ireg_set_ref");
        this.n1_ref = new DataReferenceImpl("n1_ref");
        this.h1_ref = new DataReferenceImpl("h1_ref");
        this.A1_ref = new DataReferenceImpl("A1_ref");
        this.n2_ref = new DataReferenceImpl("n2_ref");
        this.h2_ref = new DataReferenceImpl("h2_ref");
        this.A2_ref = new DataReferenceImpl("A2_ref");
        this.na_ref = new DataReferenceImpl("na_ref");
        this.ha_ref = new DataReferenceImpl("ha_ref");
        this.wa_ref = new DataReferenceImpl("wa_ref");
        this.Aa_ref = new DataReferenceImpl("Aa_ref");
        this.compute_button_ref = new DataReferenceImpl("compute_button");
        this.contour_button_ref = new DataReferenceImpl("contour_button");
        this.reset_button_ref = new DataReferenceImpl("reset_button");
        this.density_button_ref = new DataReferenceImpl("density_button");
        this.density_ref = new DataReferenceImpl("density");
        this.red_cursor_ref = new DataReferenceImpl("red_cursor_ref");
        this.sol_ref = new DataReferenceImpl("sol_ref");
        this.dist_densityRef = new DataReferenceImpl("dist_densityRef");
        this.vel_intensityRef = new DataReferenceImpl("vel_intensityRef");
        this.flat_sphere_button_ref = new DataReferenceImpl("flat_sphere_button");
        this.flat_sphere_button_ref.setData(new Real(0.0));
        RealTuple realTuple = new RealTuple(new Real[]{new Real(this.gridx, 0.0), new Real(this.gridy, 0.0), new Real(this.gridz, 20.0)});
        this.sol_sightRef = new DataReferenceImpl("sol_sight");
        this.samples[0][0] = this.sol_x;
        this.samples[1][0] = this.sol_y;
        this.samples[2][0] = this.sol_z;
        this.samples[0][1] = 20.0f;
        this.samples[1][1] = this.sol_y;
        this.samples[2][1] = this.sol_z;
        this.x_to_sol = new Gridded3DSet((MathType)this.grid_domain, this.samples, this.npts, null, null, null);
        this.samples[0][1] = this.sol_x;
        this.samples[1][1] = 20.0f;
        this.samples[2][1] = this.sol_z;
        this.y_to_sol = new Gridded3DSet((MathType)this.grid_domain, this.samples, this.npts, null, null, null);
        this.samples[0][1] = this.sol_x;
        this.samples[1][1] = this.sol_y;
        this.samples[2][1] = 80.0f;
        this.z_to_sol = new Gridded3DSet((MathType)this.grid_domain, this.samples, this.npts, null, null, null);
        this.set_s[0] = this.x_to_sol;
        this.set_s[1] = this.y_to_sol;
        this.set_s[2] = this.z_to_sol;
        this.sol_sight = new UnionSet((MathType)this.grid_domain, this.set_s);
        this.sol_sightRef.setData(this.sol_sight);
        RealTuple realTuple2 = new RealTuple(new Real[]{new Real(this.gridx, 0.0), new Real(this.gridy, 8.5), new Real(this.gridz, 0.0)});
        this.sol_ref.setData(realTuple2);
        this.line_to_sol_ref = new DataReferenceImpl("line_to_sol_ref");
        DisplayImpl[] displayImplArray = new DisplayImpl[5];
        VisADSlider[] visADSliderArray = new VisADSlider[1];
        this.setupDisplays(false, displayImplArray, visADSliderArray);
        this.setupUI(displayImplArray, visADSliderArray);
        int[] nArray2 = new int[5];
        float[] fArray4 = new float[13];
        CellImpl cellImpl = new CellImpl(this, fArray4, nArray2, fArray, fArray2, fArray3, realTuple){
            private final /* synthetic */ Galaxy this$0;
            private final /* synthetic */ float[] val$params;
            private final /* synthetic */ int[] val$sizes;
            private final /* synthetic */ float[][] val$grid_a;
            private final /* synthetic */ float[][] val$image_a;
            private final /* synthetic */ float[][] val$lonlat_a;
            private final /* synthetic */ RealTuple val$init_red_cursor;

            public void doAction() throws VisADException, RemoteException {
                File file = new File("./switch.out");
                file.delete();
                this.val$params[0] = (float)((Real)this.this$0.n1_ref.getData()).getValue();
                this.val$params[1] = (float)((Real)this.this$0.h1_ref.getData()).getValue();
                this.val$params[2] = (float)((Real)this.this$0.A1_ref.getData()).getValue();
                this.val$params[3] = 0.36f;
                this.val$params[4] = (float)((Real)this.this$0.n2_ref.getData()).getValue();
                this.val$params[5] = (float)((Real)this.this$0.h2_ref.getData()).getValue();
                this.val$params[6] = (float)((Real)this.this$0.A2_ref.getData()).getValue();
                this.val$params[7] = 40.0f;
                this.val$params[8] = (float)((Real)this.this$0.na_ref.getData()).getValue();
                this.val$params[9] = (float)((Real)this.this$0.ha_ref.getData()).getValue();
                this.val$params[10] = (float)((Real)this.this$0.wa_ref.getData()).getValue();
                this.val$params[11] = (float)((Real)this.this$0.Aa_ref.getData()).getValue();
                this.val$params[12] = 6.0f;
                Galaxy.access$0(this.this$0, this.val$params, this.val$sizes, this.val$grid_a[0], this.val$image_a[0], this.val$lonlat_a[0], this.val$lonlat_a[1]);
                elast = (double)this.val$sizes[0] - 1.0;
                llast = (double)this.val$sizes[1] - 1.0;
                this.this$0.length_0 = this.val$sizes[0];
                this.this$0.length_1 = this.val$sizes[1];
                this.this$0.image_set = this.this$0.lonlat_set = new Linear2DSet(0.0, elast, this.val$sizes[0], 0.0, llast, this.val$sizes[1]);
                this.this$0.linemap.setRange(-0.5 * llast, 1.5 * llast + 1.0);
                FlatField flatField = new FlatField(this.this$0.image_type, this.this$0.image_set);
                this.this$0.image_b = new float[1][this.val$sizes[0] * this.val$sizes[1]];
                System.arraycopy(this.val$image_a[0], 0, this.this$0.image_b[0], 0, this.this$0.image_b[0].length);
                flatField.setSamples(this.this$0.image_b);
                this.this$0.image_ref.setData(flatField);
                FlatField flatField2 = new FlatField(this.this$0.lonlat_type, this.this$0.lonlat_set);
                this.this$0.lonlat_b = new float[2][this.val$sizes[0] * this.val$sizes[1]];
                System.arraycopy(this.val$lonlat_a[0], 0, this.this$0.lonlat_b[0], 0, this.this$0.lonlat_b[0].length);
                System.arraycopy(this.val$lonlat_a[1], 0, this.this$0.lonlat_b[1], 0, this.this$0.lonlat_b[1].length);
                FlatField flatField3 = Galaxy.access$1(this.this$0);
                this.this$0.sphrSkyMap_ref.setData(flatField3);
                int n = 0;
                while (n < this.val$sizes[0] * this.val$sizes[1]) {
                    if (this.this$0.lonlat_b[0][n] < -400.0f) {
                        this.this$0.lonlat_b[0][n] = Float.NaN;
                    }
                    if (this.this$0.lonlat_b[1][n] < -400.0f) {
                        this.this$0.lonlat_b[1][n] = Float.NaN;
                    }
                    ++n;
                }
                flatField2.setSamples(this.this$0.lonlat_b);
                this.this$0.lonlat_ref.setData(flatField2);
                double d = 0.5 * ((double)this.val$sizes[2] - 1.0);
                double d2 = 0.5 * ((double)this.val$sizes[3] - 1.0);
                double d3 = 0.5 * ((double)this.val$sizes[4] - 1.0);
                this.this$0.grid_set = new Linear3DSet(-d, d, this.val$sizes[2], -d2, d2, this.val$sizes[3], -d3, d3, this.val$sizes[4]);
                FlatField flatField4 = new FlatField(this.this$0.grid_type, this.this$0.grid_set);
                float[][] fArray = new float[1][this.val$sizes[2] * this.val$sizes[3] * this.val$sizes[4]];
                System.arraycopy(this.val$grid_a[0], 0, fArray[0], 0, fArray[0].length);
                flatField4.setSamples(fArray);
                this.this$0.grid_ref.setData(flatField4);
                this.this$0.red_cursor_ref.setData(this.val$init_red_cursor);
            }
            {
                this.val$params = fArray;
                this.val$sizes = nArray;
                this.val$grid_a = fArray2;
                this.val$image_a = fArray3;
                this.val$lonlat_a = fArray4;
                this.val$init_red_cursor = realTuple;
                this.this$0 = galaxy;
                this.constructor$0(galaxy);
            }

            private final void constructor$0(Galaxy galaxy) {
            }
        };
        Real real = new Real(0.0);
        this.compute_button_ref.setData(real);
        cellImpl.addReference(this.compute_button_ref);
        CellImpl cellImpl2 = new CellImpl(this){
            boolean first;
            private final /* synthetic */ Galaxy this$0;

            public void doAction() throws VisADException, RemoteException {
                if (!this.first) {
                    System.out.println("reset:doAction");
                    this.this$0.n1_ref.setData(new Real(0.025));
                    this.this$0.h1_ref.setData(new Real(0.906));
                    this.this$0.A1_ref.setData(new Real(19.957));
                    this.this$0.n2_ref.setData(new Real(0.099));
                    this.this$0.h2_ref.setData(new Real(0.15));
                    this.this$0.A2_ref.setData(new Real(3.693));
                    this.this$0.na_ref.setData(new Real(0.074));
                    this.this$0.ha_ref.setData(new Real(0.297));
                    this.this$0.wa_ref.setData(new Real(0.298));
                    this.this$0.Aa_ref.setData(new Real(8.278));
                } else {
                    this.first = false;
                }
            }
            {
                this.this$0 = galaxy;
                this.first = true;
                this.constructor$0(galaxy);
            }

            private final void constructor$0(Galaxy galaxy) {
            }
        };
        cellImpl2.addReference(this.reset_button_ref);
        CellImpl cellImpl3 = new CellImpl(this){
            private final /* synthetic */ Galaxy this$0;

            public void doAction() throws VisADException, RemoteException {
                RealTuple realTuple = (RealTuple)this.this$0.red_cursor_ref.getData();
                if (realTuple == null) {
                    return;
                }
                this.this$0.last_x = (float)((Real)realTuple.getComponent(0)).getValue();
                this.this$0.last_y = (float)((Real)realTuple.getComponent(1)).getValue();
                this.this$0.last_z = (float)((Real)realTuple.getComponent(2)).getValue();
                double d = (((Real)realTuple.getComponent(0)).getValue() - (double)this.this$0.sol_x) / ((double)this.this$0.npts - 1.0);
                double d2 = (((Real)realTuple.getComponent(1)).getValue() - (double)this.this$0.sol_y) / ((double)this.this$0.npts - 1.0);
                double d3 = (((Real)realTuple.getComponent(2)).getValue() - (double)this.this$0.sol_z) / ((double)this.this$0.npts - 1.0);
                int n = 0;
                while (n < this.this$0.npts) {
                    this.this$0.samples[0][n] = (float)((double)this.this$0.sol_x + (double)n * d);
                    this.this$0.samples[1][n] = (float)((double)this.this$0.sol_y + (double)n * d2);
                    this.this$0.samples[2][n] = (float)((double)this.this$0.sol_z + (double)n * d3);
                    ++n;
                }
                this.this$0.line_to_sol = new Gridded3DSet(realTuple.getType(), this.this$0.samples, this.this$0.npts, null, null, null);
                this.this$0.line_to_sol_ref.setData(this.this$0.line_to_sol);
                Galaxy.access$2(this.this$0, this.this$0.last_x, this.this$0.last_y, this.this$0.last_z, this.this$0.lbd);
                this.this$0.coord_fields[0].setText(PlotText.shortString(this.this$0.lbd[0]));
                this.this$0.coord_fields[1].setText(PlotText.shortString(this.this$0.lbd[1]));
                this.this$0.coord_fields[2].setText(PlotText.shortString(this.this$0.lbd[2]));
                this.this$0.density_button_ref.setData(new Real(0.0));
            }
            {
                this.this$0 = galaxy;
                this.constructor$0(galaxy);
            }

            private final void constructor$0(Galaxy galaxy) {
            }
        };
        this.red_cursor_ref.setData(realTuple);
        cellImpl3.addReference(this.red_cursor_ref);
        CellImpl cellImpl4 = new CellImpl(this){
            private final /* synthetic */ Galaxy this$0;

            public void doAction() throws VisADException, RemoteException {
                this.this$0.i_type = 1;
                Galaxy.access$3(this.this$0, this.this$0.i_type, this.this$0.n_profpts, this.this$0.last_x, this.this$0.last_y, this.this$0.last_z, this.this$0.xprof, this.this$0.yprof);
                this.this$0.distDomain = new Linear1DSet((MathType)this.this$0.distance, this.this$0.xprof[0], this.this$0.xprof[this.this$0.n_profpts - 1], this.this$0.n_profpts);
                this.this$0.field_D = new FlatField(this.this$0.dist_density, this.this$0.distDomain);
                this.this$0.yprof_a[0] = this.this$0.yprof;
                this.this$0.field_D.setSamples(this.this$0.yprof_a);
                this.this$0.dist_densityRef.setData(this.this$0.field_D);
                this.this$0.i_type = 2;
                Galaxy.access$3(this.this$0, this.this$0.i_type, this.this$0.n_profpts, this.this$0.last_x, this.this$0.last_y, this.this$0.last_z, this.this$0.xprof, this.this$0.yprof);
                this.this$0.velDomain = new Linear1DSet((MathType)this.this$0.v_LSR, this.this$0.xprof[0], this.this$0.xprof[this.this$0.n_profpts - 1], this.this$0.n_profpts);
                this.this$0.field_E = new FlatField(this.this$0.vel_intensity, this.this$0.velDomain);
                this.this$0.yprof_a[0] = this.this$0.yprof;
                this.this$0.field_E.setSamples(this.this$0.yprof_a);
                this.this$0.vel_intensityRef.setData(this.this$0.field_E);
            }
            {
                this.this$0 = galaxy;
                this.constructor$0(galaxy);
            }

            private final void constructor$0(Galaxy galaxy) {
            }
        };
        cellImpl4.addReference(this.density_button_ref);
        if (this.server_server != null) {
            RemoteDataReferenceImpl[] remoteDataReferenceImplArray = new RemoteDataReferenceImpl[]{new RemoteDataReferenceImpl((DataReferenceImpl)this.grid_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.image_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.lonlat_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.n1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.h1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.A1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.n2_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.h2_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.A2_ref), null, new RemoteDataReferenceImpl((DataReferenceImpl)this.na_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.ha_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.wa_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.Aa_ref), null, new RemoteDataReferenceImpl((DataReferenceImpl)this.compute_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.contour_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.density_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.reset_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.red_cursor_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.sol_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.line_to_sol_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.dist_densityRef), new RemoteDataReferenceImpl((DataReferenceImpl)this.vel_intensityRef), new RemoteDataReferenceImpl((DataReferenceImpl)this.sol_sightRef), new RemoteDataReferenceImpl((DataReferenceImpl)this.density_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.sphrSkyMap_ref)};
            this.server_server.setDataReferences(remoteDataReferenceImplArray);
        }
    }

    void setupClient() throws VisADException, RemoteException {
        RemoteDataReference[] remoteDataReferenceArray = this.client_server.getDataReferences();
        if (remoteDataReferenceArray == null) {
            System.out.println("Cannot connect to server");
            System.exit(0);
        }
        this.grid_ref = remoteDataReferenceArray[0];
        this.image_ref = remoteDataReferenceArray[1];
        this.lonlat_ref = remoteDataReferenceArray[2];
        this.n1_ref = remoteDataReferenceArray[3];
        this.h1_ref = remoteDataReferenceArray[4];
        this.A1_ref = remoteDataReferenceArray[5];
        this.n2_ref = remoteDataReferenceArray[6];
        this.h2_ref = remoteDataReferenceArray[7];
        this.A2_ref = remoteDataReferenceArray[8];
        this.na_ref = remoteDataReferenceArray[10];
        this.ha_ref = remoteDataReferenceArray[11];
        this.wa_ref = remoteDataReferenceArray[12];
        this.Aa_ref = remoteDataReferenceArray[13];
        this.compute_button_ref = remoteDataReferenceArray[15];
        this.contour_button_ref = remoteDataReferenceArray[16];
        this.density_ref = remoteDataReferenceArray[17];
        this.reset_button_ref = remoteDataReferenceArray[18];
        this.red_cursor_ref = remoteDataReferenceArray[19];
        this.sol_ref = remoteDataReferenceArray[20];
        this.line_to_sol_ref = remoteDataReferenceArray[21];
        this.dist_densityRef = remoteDataReferenceArray[22];
        this.vel_intensityRef = remoteDataReferenceArray[23];
        this.sol_sightRef = remoteDataReferenceArray[24];
        this.density_button_ref = remoteDataReferenceArray[25];
        this.sphrSkyMap_ref = remoteDataReferenceArray[26];
        this.flat_sphere_button_ref = new DataReferenceImpl("flat_sphere_button");
        this.flat_sphere_button_ref.setData(new Real(0.0));
        this.grid_type = (FunctionType)this.grid_ref.getType();
        this.grid_domain = this.grid_type.getDomain();
        this.density = (RealType)this.grid_type.getRange();
        this.gridx = (RealType)this.grid_domain.getComponent(0);
        this.gridy = (RealType)this.grid_domain.getComponent(1);
        this.gridz = (RealType)this.grid_domain.getComponent(2);
        this.distance = (RealType)((FunctionType)this.dist_densityRef.getType()).getDomain().getComponent(0);
        this.v_LSR = (RealType)((FunctionType)this.vel_intensityRef.getType()).getDomain().getComponent(0);
        this.Intensity = (RealType)((FunctionType)this.vel_intensityRef.getType()).getRange();
        Field field = (Field)this.grid_ref.getData();
        this.grid_set = (Linear3DSet)field.getDomainSet();
        int[] nArray = this.grid_set.getLengths();
        NX = nArray[0];
        NY = nArray[1];
        NZ = nArray[2];
        this.image_type = (FunctionType)this.image_ref.getType();
        this.image_domain = this.image_type.getDomain();
        this.radiance = (RealType)this.image_type.getRange();
        this.element = (RealType)this.image_domain.getComponent(0);
        this.line = (RealType)this.image_domain.getComponent(1);
        this.lonlat_type = (FunctionType)this.lonlat_ref.getType();
        this.lonlat_range = (RealTupleType)this.lonlat_type.getRange();
        this.lon = (RealType)this.lonlat_range.getComponent(0);
        this.lat = (RealType)this.lonlat_range.getComponent(1);
        Field field2 = (Field)this.lonlat_ref.getData();
        this.lonlat_set = (Linear2DSet)field2.getDomainSet();
        nArray = this.lonlat_set.getLengths();
        elast = nArray[0];
        llast = nArray[1];
        DisplayImpl[] displayImplArray = new DisplayImpl[5];
        VisADSlider[] visADSliderArray = new VisADSlider[1];
        this.setupDisplays(true, displayImplArray, visADSliderArray);
        this.setupUI(displayImplArray, visADSliderArray);
    }

    void setupDisplays(boolean bl, DisplayImpl[] displayImplArray, VisADSlider[] visADSliderArray) throws VisADException, RemoteException {
        RemoteDisplayImpl remoteDisplayImpl;
        Serializable serializable;
        Serializable serializable2;
        Action action;
        Serializable serializable3;
        this.display1 = new DisplayImplJ3D("display1");
        this.display1.addMap(new ScalarMap(this.gridx, Display.XAxis));
        this.display1.addMap(new ScalarMap(this.gridy, Display.YAxis));
        ScalarMap scalarMap = new ScalarMap(this.gridz, Display.ZAxis);
        scalarMap.setRange(-NZ, 2 * NZ - 1);
        this.display1.addMap(scalarMap);
        GraphicsModeControl graphicsModeControl = this.display1.getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        ScalarMap scalarMap2 = new ScalarMap(this.density, Display.IsoContour);
        this.display1.addMap(scalarMap2);
        ContourControl contourControl = (ContourControl)scalarMap2.getControl();
        contourControl.setSurfaceValue(0.06f);
        contourControl.enableContours(true);
        this.cmaps = new ConstantMap[4];
        this.cmaps[0] = new ConstantMap(0.0, Display.Blue);
        this.cmaps[1] = new ConstantMap(1.0, Display.Red);
        this.cmaps[2] = new ConstantMap(0.0, Display.Green);
        this.cmaps[3] = new ConstantMap(4.0, Display.PointSize);
        this.cmaps_sol = new ConstantMap[4];
        this.cmaps_sol[0] = new ConstantMap(0.0, Display.Blue);
        this.cmaps_sol[1] = new ConstantMap(1.0, Display.Red);
        this.cmaps_sol[2] = new ConstantMap(1.0, Display.Green);
        this.cmaps_sol[3] = new ConstantMap(6.0, Display.PointSize);
        this.cmaps_line = new ConstantMap[3];
        this.cmaps_line[0] = new ConstantMap(0.0, Display.Blue);
        this.cmaps_line[1] = new ConstantMap(1.0, Display.Green);
        this.cmaps_line[2] = new ConstantMap(0.0, Display.Red);
        this.yellow = new ConstantMap[3];
        this.yellow[0] = new ConstantMap(0.0, Display.Blue);
        this.yellow[1] = new ConstantMap(1.0, Display.Green);
        this.yellow[2] = new ConstantMap(1.0, Display.Red);
        if (bl) {
            serializable3 = new RemoteDisplayImpl(this.display1);
            ((RemoteDisplayImpl)serializable3).addReference(this.grid_ref);
            ((RemoteDisplayImpl)serializable3).addReference(this.sol_ref, this.cmaps_sol);
            ((RemoteDisplayImpl)serializable3).addReference(this.line_to_sol_ref, this.cmaps_line);
            ((RemoteDisplayImpl)serializable3).addReference(this.sol_sightRef, this.yellow);
            ((RemoteDisplayImpl)serializable3).addReferences(new DirectManipulationRendererJ3D(), this.red_cursor_ref, this.cmaps);
        } else {
            this.display1.addReference(this.grid_ref);
            this.display1.addReference(this.sol_ref, this.cmaps_sol);
            this.display1.addReference(this.line_to_sol_ref, this.cmaps_line);
            this.display1.addReference(this.sol_sightRef, this.yellow);
            this.display1.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.red_cursor_ref, this.cmaps);
        }
        serializable3 = new VisADSlider("density", 0, 400, 60, 0.001, this.density_ref, RealType.Generic);
        Dimension dimension = ((JComponent)serializable3).getMinimumSize();
        dimension.width = 70;
        ((JComponent)serializable3).setMinimumSize(dimension);
        this.display2 = new DisplayImplJ2D("display2");
        this.display2.setAlwaysAutoScale(true);
        GraphicsModeControl graphicsModeControl2 = this.display2.getGraphicsModeControl();
        graphicsModeControl2.setScaleEnable(false);
        DisplayRenderer displayRenderer = this.display2.getDisplayRenderer();
        displayRenderer.setBoxOn(false);
        this.display2.addMap(new ScalarMap(this.element, Display.XAxis));
        this.linemap = new ScalarMap(this.line, Display.YAxis);
        this.display2.addMap(this.linemap);
        ScalarMap scalarMap3 = new ScalarMap(this.radiance, Display.RGB);
        this.display2.addMap(scalarMap3);
        ScalarMap scalarMap4 = new ScalarMap(this.lon, Display.IsoContour);
        this.display2.addMap(scalarMap4);
        ScalarMap scalarMap5 = new ScalarMap(this.lat, Display.IsoContour);
        this.display2.addMap(scalarMap5);
        this.lw2 = new LabeledColorWidget(scalarMap3);
        ContourControl contourControl2 = (ContourControl)scalarMap4.getControl();
        contourControl2.enableContours(true);
        contourControl2.setContourInterval(30.0f, -180.0f, 180.0f, -180.0f);
        ContourControl contourControl3 = (ContourControl)scalarMap5.getControl();
        contourControl3.enableContours(true);
        contourControl3.setContourInterval(30.0f, -90.0f, 89.0f, -90.0f);
        if (bl) {
            this.linemap.setRange(-0.5 * llast, 1.5 * llast + 1.0);
            action = new RemoteDisplayImpl(this.display2);
            ((RemoteDisplayImpl)action).addReference(this.image_ref);
            ((RemoteDisplayImpl)action).addReference(this.lonlat_ref);
        } else {
            this.display2.addReference(this.image_ref);
            this.display2.addReference(this.lonlat_ref);
        }
        action = new ContourCell(contourControl, this.density_ref);
        Real real = new Real(0.0);
        this.contour_button_ref.setData(real);
        if (bl) {
            serializable2 = new RemoteCellImpl((CellImpl)action);
            ((RemoteActionImpl)serializable2).addReference(this.contour_button_ref);
        } else {
            ((ActionImpl)action).addReference(this.contour_button_ref);
        }
        this.display3 = new DisplayImplJ2D("display3");
        this.display4 = new DisplayImplJ2D("display4");
        this.display3.setAlwaysAutoScale(true);
        this.display4.setAlwaysAutoScale(true);
        serializable2 = this.display3.getGraphicsModeControl();
        ((GraphicsModeControl)serializable2).setScaleEnable(true);
        GraphicsModeControl graphicsModeControl3 = this.display4.getGraphicsModeControl();
        graphicsModeControl3.setScaleEnable(true);
        this.display3.addMap(new ScalarMap(this.distance, Display.XAxis));
        this.display3.addMap(new ScalarMap(this.density, Display.YAxis));
        this.display3.addMap(new ScalarMap(this.density, Display.Green));
        this.display4.addMap(new ScalarMap(this.v_LSR, Display.XAxis));
        this.display4.addMap(new ScalarMap(this.Intensity, Display.YAxis));
        this.display4.addMap(new ScalarMap(this.Intensity, Display.Green));
        if (bl) {
            serializable = new RemoteDisplayImpl(this.display3);
            serializable.addReference(this.dist_densityRef);
            remoteDisplayImpl = new RemoteDisplayImpl(this.display4);
            remoteDisplayImpl.addReference(this.vel_intensityRef);
        } else {
            this.display3.addReference(this.dist_densityRef);
            this.display4.addReference(this.vel_intensityRef);
        }
        this.display5 = new DisplayImplJ3D("display5");
        this.display5.addMap(new ScalarMap(this.lon, Display.Longitude));
        this.display5.addMap(new ScalarMap(this.lat, Display.Latitude));
        serializable = new ScalarMap(this.radiance, Display.RGB);
        this.display5.addMap((ScalarMap)serializable);
        this.lw5 = new LabeledColorWidget((ScalarMap)serializable);
        if (bl) {
            remoteDisplayImpl = new RemoteDisplayImpl(this.display5);
            remoteDisplayImpl.addReference(this.sphrSkyMap_ref);
        } else {
            this.display5.addReference(this.sphrSkyMap_ref);
        }
        visADSliderArray[0] = serializable3;
        displayImplArray[0] = this.display1;
        displayImplArray[1] = this.display2;
        displayImplArray[2] = this.display3;
        displayImplArray[3] = this.display4;
        displayImplArray[4] = this.display5;
    }

    void setupUI(DisplayImpl[] displayImplArray, VisADSlider[] visADSliderArray) throws VisADException, RemoteException {
        Serializable serializable;
        Serializable serializable2;
        JFrame jFrame = new JFrame("VisAD Collaborative Galaxy Designer");
        jFrame.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ Galaxy this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = galaxy;
                this.constructor$0(galaxy);
            }

            private final void constructor$0(Galaxy galaxy) {
            }
        });
        int n = 1200;
        int n2 = 950;
        ((Component)jFrame).setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2.add(new JLabel("Interactive Milky Way galaxy design"));
        jPanel2.add(new JLabel("using VisAD  -  see:"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("for more information about VisAD."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Bill Hibbard and Bob Benjamin"));
        jPanel2.add(new JLabel("University of Wisconsin - Madison"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Adjust Milky Way galaxy parameters using"));
        jPanel2.add(new JLabel("sliders."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Then press 'Compute' button to compute"));
        jPanel2.add(new JLabel("new galaxy."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  "));
        JPanel jPanel3 = new JPanel();
        jPanel3.setName("Galaxy Sliders");
        jPanel3.setFont(new Font("Dialog", 0, 12));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel3.add(new VisADSlider("n1", 0, 500, 250, 1.0E-4, this.n1_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("h1", 0, 300, 91, 0.01, this.h1_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("A1", 50, 400, 200, 0.1, this.A1_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("n2", 0, 500, 100, 0.001, this.n2_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("h2", 0, 300, 150, 0.001, this.h2_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("A2", 10, 600, 370, 0.01, this.A2_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("na", 0, 200, 80, 0.001, this.na_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("ha", 0, 100, 30, 0.01, this.ha_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("wa", 0, 500, 300, 0.001, this.wa_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new VisADSlider("Aa", 50, 200, 85, 0.1, this.Aa_ref, RealType.Generic));
        jPanel3.add(new JLabel("  "));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setAlignmentX(0.0f);
        JButton jButton = new JButton("Compute");
        jButton.addActionListener(this);
        jButton.setActionCommand("compute");
        jPanel4.add(jButton);
        JButton jButton2 = new JButton("Reset");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("reset");
        jPanel4.add(jButton2);
        jPanel3.add(jPanel4);
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("  "));
        this.widget_panel = new JPanel();
        this.widget_panel.setName("Color Widget");
        this.widget_panel.setFont(new Font("Dialog", 0, 12));
        this.widget_panel.setLayout(new BoxLayout(this.widget_panel, 1));
        this.widget_panel.setAlignmentY(0.0f);
        this.widget_panel.setAlignmentX(0.0f);
        Dimension dimension2 = new Dimension(400, 950);
        jPanel2.setMaximumSize(dimension2);
        jPanel2.add(this.widget_panel);
        dimension2 = new Dimension(300, 170);
        this.lw2.setMaximumSize(dimension2);
        this.lw5.setMaximumSize(dimension2);
        this.widget_panel.add(this.lw2);
        this.center = new JPanel();
        this.center.setLayout(new BoxLayout(this.center, 1));
        this.center.setAlignmentY(0.0f);
        this.center.setAlignmentX(0.0f);
        dimension2 = new Dimension(400, 950);
        this.center.setMaximumSize(dimension2);
        this.center.setPreferredSize(new Dimension(400, 950));
        jPanel.add(this.center);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setAlignmentY(0.0f);
        jPanel5.setAlignmentX(0.0f);
        jPanel5.add(visADSliderArray[0]);
        JButton jButton3 = new JButton("Contour");
        jButton3.setAlignmentY(0.0f);
        jButton3.setAlignmentX(0.0f);
        jButton3.addActionListener(this);
        jButton3.setActionCommand("contour");
        jPanel5.add(jButton3);
        JPanel jPanel6 = (JPanel)displayImplArray[0].getComponent();
        this.panel2 = (JPanel)displayImplArray[1].getComponent();
        JPanel jPanel7 = (JPanel)displayImplArray[2].getComponent();
        JPanel jPanel8 = (JPanel)displayImplArray[3].getComponent();
        this.panel5 = (JPanel)displayImplArray[4].getComponent();
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        jPanel6.setBorder(compoundBorder);
        this.panel2.setBorder(compoundBorder);
        jPanel7.setBorder(compoundBorder);
        jPanel8.setBorder(compoundBorder);
        this.panel5.setBorder(compoundBorder);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.setAlignmentY(0.0f);
        jPanel9.setAlignmentX(0.0f);
        this.coord_fields[0] = new JTextField("---");
        this.coord_fields[0].setBackground(Color.black);
        this.coord_fields[0].setForeground(Color.white);
        this.coord_fields[1] = new JTextField("---");
        this.coord_fields[1].setBackground(Color.black);
        this.coord_fields[1].setForeground(Color.white);
        this.coord_fields[2] = new JTextField("---");
        this.coord_fields[2].setBackground(Color.black);
        this.coord_fields[2].setForeground(Color.white);
        int n3 = 0;
        while (n3 < 3) {
            serializable2 = this.coord_fields[n3].getMaximumSize();
            serializable = this.coord_fields[n3].getPreferredSize();
            serializable2.height = serializable.height;
            this.coord_fields[n3].setMaximumSize((Dimension)serializable2);
            ++n3;
        }
        JLabel jLabel = new JLabel("L:");
        jPanel9.add(jLabel);
        jPanel9.add(this.coord_fields[0]);
        jLabel = new JLabel("B:");
        jPanel9.add(jLabel);
        jPanel9.add(this.coord_fields[1]);
        jLabel = new JLabel("D:");
        jPanel9.add(jLabel);
        jPanel9.add(this.coord_fields[2]);
        serializable2 = new JLabel("3D isodensity surface of Galaxy");
        serializable = new JLabel("set density slider and press Contour button");
        JLabel jLabel2 = new JLabel("H-alpha emission sky map");
        JLabel jLabel3 = new JLabel("as seen from Earth");
        this.flat_sphere_button = new JButton("flat > sphere");
        this.flat_sphere_button.addActionListener(this);
        this.flat_sphere_button.setActionCommand("flat/sphere");
        this.center.add(jPanel5);
        this.center.add(jPanel6);
        this.center.add((Component)serializable2);
        this.center.add((Component)serializable);
        this.center.add(jPanel9);
        this.center.add(this.panel2);
        this.center.add(this.flat_sphere_button);
        this.center.add(jLabel2);
        this.center.add(jLabel3);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        jPanel10.setAlignmentY(0.0f);
        jPanel10.setAlignmentX(0.0f);
        jPanel10.setPreferredSize(new Dimension(400, 950));
        jPanel.add(jPanel10);
        jPanel10.add(jPanel7);
        jPanel10.add(jPanel8);
        ((Component)jFrame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("contour")) {
            try {
                this.contour_button_ref.setData(new Real(0.0));
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string.equals("compute")) {
            try {
                this.compute_button_ref.setData(new Real(0.0));
                this.density_button_ref.setData(new Real(0.0));
            }
            catch (VisADException visADException) {
                System.out.println(visADException.getMessage());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string.equals("reset")) {
            try {
                this.reset_button_ref.setData(new Real(0.0));
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string.equals("density/emission")) {
            try {
                this.density_button_ref.setData(new Real(0.0));
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string.equals("flat/sphere")) {
            try {
                double d = ((Real)this.flat_sphere_button_ref.getData()).getValue();
                if (d < 0.5) {
                    d = 1.0;
                    this.center.remove(this.panel2);
                    this.center.add((Component)this.panel5, 5);
                    this.widget_panel.remove(this.lw2);
                    this.widget_panel.add((Component)this.lw5, 0);
                    this.flat_sphere_button.setText("sphere > flat");
                } else {
                    d = 0.0;
                    this.center.remove(this.panel5);
                    this.center.add((Component)this.panel2, 5);
                    this.widget_panel.remove(this.lw5);
                    this.widget_panel.add((Component)this.lw2, 0);
                    this.flat_sphere_button.setText("flat > sphere");
                }
                this.flat_sphere_button_ref.setData(new Real(d));
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private float[][] getLonLat(float[][] fArray, int n, int n2) {
        float[][] fArray2 = new float[2][fArray[0].length];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = (int)((float)n4 * 25.0f) / 10;
                int n6 = (int)((float)n3 * 25.0f) / 10;
                int n7 = n3 * n + n4;
                if (fArray[1][n7] < -400.0f) {
                    float f;
                    float f2;
                    float f3 = ((float)(2 * n5) - 1.0f - 181.0f) / 180.0f;
                    float f4 = ((float)(2 * n6) - 1.0f - 91.0f) / 180.0f;
                    float f5 = (float)Math.sqrt(f3 * f3 + 4.0f * f4 * f4);
                    float f6 = (float)Math.sqrt((4.0f * f4 * f4 - 1.0f) * (4.0f * f4 * f4 - 1.0f) + f3 * f4 * 2.0f * (f3 * f4 * 2.0f));
                    if (Math.abs(f6) > 1.0f) {
                        f2 = 0.0f;
                    } else {
                        float f7 = (float)(Math.asin(f6) * 57.2957795);
                        f2 = 90.0f - f7;
                    }
                    if (f4 < 0.0f) {
                        f2 = -f2;
                    }
                    if ((double)f6 <= 1.0E-4) {
                        f = 180.0f;
                        f = (float)Math.IEEEremainder(f, 360.0);
                    } else {
                        float f8 = (1.0f - f3 * f3 - 4.0f * f4 * f4) / f6;
                        if (f8 > 1.0f) {
                            f = 0.0f;
                            f2 = 0.0f;
                        } else {
                            float f9;
                            float f10 = (float)(Math.acos(f8) * 57.2957795);
                            f = f9 = 2.0f * f10;
                            if (f3 > 0.0f) {
                                f = 360.0f - f;
                            }
                            if ((float)n4 > 36.0f) {
                                f -= 360.0f;
                            }
                        }
                    }
                    fArray2[0][n7] = f;
                    fArray2[1][n7] = f2;
                } else {
                    fArray2[0][n7] = fArray[0][n7];
                    fArray2[1][n7] = fArray[1][n7];
                }
                ++n4;
            }
            ++n3;
        }
        return fArray2;
    }

    private FlatField makeSphericalSkyMap() {
        int n;
        int n2;
        int n3;
        float[][] fArray = new float[2][this.length_0 * this.length_1];
        float[] fArray2 = new float[this.length_0 * this.length_1];
        fArray = this.getLonLat(this.lonlat_b, this.length_0, this.length_1);
        float[][] fArray3 = new float[2][this.length_0 * (this.length_1 - 1)];
        float[][] fArray4 = new float[1][this.length_0 * (this.length_1 - 1)];
        int n4 = 1;
        while (n4 < this.length_1) {
            int n5 = 0;
            while (n5 < this.length_0) {
                n3 = n4 * this.length_0 + n5;
                n2 = (n4 - 1) * this.length_0 + n5;
                fArray3[0][n2] = fArray[0][n3];
                fArray3[1][n2] = fArray[1][n3];
                fArray4[0][n2] = this.lonlat_b[0][n3] < -400.0f || this.lonlat_b[1][n3] < -400.0f ? Float.NaN : this.image_b[0][n3];
                ++n5;
            }
            ++n4;
        }
        float[] fArray5 = new float[this.length_1 - 1];
        n3 = 0;
        while (n3 < this.length_1 - 1) {
            n4 = 0;
            fArray5[n3] = Float.NaN;
            n2 = 0;
            while (n2 < this.length_0) {
                n = n3 * this.length_0 + n2;
                if (!Float.isNaN(fArray4[0][n]) && n4 == 0) {
                    fArray5[n3] = fArray4[0][n];
                    n4 = 1;
                }
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.length_1 - 1) {
            n2 = 0;
            while (n2 < this.length_0) {
                n = n3 * this.length_0 + n2;
                if (Float.isNaN(fArray4[0][n])) {
                    fArray4[0][n] = fArray5[n3];
                }
                ++n2;
            }
            ++n3;
        }
        FlatField flatField = null;
        try {
            Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)this.lonlat_range, fArray3, this.length_0, this.length_1 - 1);
            FlatField flatField2 = new FlatField(new FunctionType(this.lonlat_range, this.radiance), gridded2DSet);
            flatField2.setSamples(fArray4);
            flatField = (FlatField)flatField2.resample(new LinearLatLonSet((MathType)this.lonlat_range, -180.0, 180.0, 60, -77.0, 67.0, 50), 101, 202);
        }
        catch (VisADException visADException) {
            System.out.println(visADException.getMessage());
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException.getMessage());
        }
        return flatField;
    }

    private native void getcon_c(int[] var1);

    private native void ismgsc_c(float[] var1, int[] var2, float[] var3, float[] var4, float[] var5, float[] var6);

    private native void profile_c(int var1, int var2, float var3, float var4, float var5, float[] var6, float[] var7);

    private native void galtosol(float var1, float var2, float var3, float[] var4);

    static /* synthetic */ void access$0(Galaxy galaxy, float[] fArray, int[] nArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        galaxy.ismgsc_c(fArray, nArray, fArray2, fArray3, fArray4, fArray5);
    }

    static /* synthetic */ FlatField access$1(Galaxy galaxy) {
        return galaxy.makeSphericalSkyMap();
    }

    static /* synthetic */ void access$2(Galaxy galaxy, float f, float f2, float f3, float[] fArray) {
        galaxy.galtosol(f, f2, f3, fArray);
    }

    static /* synthetic */ void access$3(Galaxy galaxy, int n, int n2, float f, float f2, float f3, float[] fArray, float[] fArray2) {
        galaxy.profile_c(n, n2, f, f2, f3, fArray, fArray2);
    }

    public Galaxy(String[] stringArray) throws VisADException, RemoteException {
        if (stringArray.length > 0) {
            String string = "//" + stringArray[0] + "/Galaxy";
            try {
                this.client_server = (RemoteServer)Naming.lookup(string);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException notBoundException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException accessException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
        } else {
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///Galaxy", this.server_server);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException accessException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
        }
    }

    class ContourCell
    extends CellImpl {
        ContourControl control;
        DataReference ref;
        double value;

        public void doAction() throws VisADException, RemoteException {
            double d = ((Real)this.ref.getData()).getValue();
            if (d == d && d != this.value) {
                this.control.setSurfaceValue((float)((Real)this.ref.getData()).getValue());
                this.control.enableContours(true);
                this.value = d;
            }
        }

        ContourCell(ContourControl contourControl, DataReference dataReference) throws VisADException, RemoteException {
            this.control = contourControl;
            this.ref = dataReference;
            this.value = ((Real)this.ref.getData()).getValue();
        }
    }
}

