/*
 * Decompiled with CFR 0.152.
 */
package visad.aune;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Set;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.Delay;
import visad.util.VisADSlider;

public class ShallowFluid {
    public static int WIDTH = 1200;
    public static int HEIGHT = 1000;
    RemoteServerImpl server_server;
    RemoteServer client_server;
    RealType xloc;
    RealType yloc;
    RealType u;
    RealType v;
    RealType h;
    RealType cc;
    RealType udiff;
    RealType vdiff;
    RealType hdiff;
    RealType ccdiff;
    RealType time;
    RealTupleType loc;
    FunctionType vol;
    FunctionType voldiff;
    Set linear59x49;
    DataReference sim_time_ref;
    DataReference new_state_ref;
    DataReference old_state_ref;
    DataReference oldest_state_ref;
    DataReference newold_diff_ref;
    DataReference iopt_ref;
    DataReference ibc_ref;
    DataReference gravity_ref;
    DataReference alat_ref;
    DataReference ubar1_ref;
    DataReference vbar1_ref;
    DataReference hprm11_ref;
    DataReference hprm12_ref;
    DataReference delt_ref;
    DataReference eps_ref;
    DataReference adiff_ref;
    DataReference tfilt_ref;
    DataReference anim_delay_ref;
    public boolean initial = true;

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        ShallowFluid shallowFluid = new ShallowFluid(stringArray);
        if (shallowFluid.client_server != null) {
            shallowFluid.setupClient();
        } else if (shallowFluid.server_server != null) {
            System.loadLibrary("ShallowFluid");
            shallowFluid.setupServer();
        } else {
            System.loadLibrary("ShallowFluid");
            shallowFluid.setupServer();
        }
    }

    void setupServer() throws VisADException, RemoteException {
        RealTupleType realTupleType = new RealTupleType(RealType.Generic, RealType.Generic);
        this.linear59x49 = new Linear2DSet((MathType)realTupleType, 1.0, 59.0, 59, 1.0, 49.0, 49);
        this.xloc = new RealType("xloc", null, null);
        this.yloc = new RealType("yloc", null, null);
        this.u = new RealType("u", null, null);
        this.v = new RealType("v", null, null);
        this.h = new RealType("h", null, null);
        this.cc = new RealType("cc", null, null);
        this.udiff = new RealType("udiff", null, null);
        this.vdiff = new RealType("vdiff", null, null);
        this.hdiff = new RealType("hdiff", null, null);
        this.ccdiff = new RealType("ccdiff", null, null);
        this.time = new RealType("time", null, null);
        this.loc = new RealTupleType(this.xloc, this.yloc, null, this.linear59x49);
        this.vol = new FunctionType(this.loc, new RealTupleType(this.u, this.v, this.h, this.cc));
        this.voldiff = new FunctionType(this.loc, new RealTupleType(this.udiff, this.vdiff, this.hdiff, this.ccdiff));
        Real real = new Real(this.time, 0.0);
        this.sim_time_ref = new DataReferenceImpl("sim_time");
        this.sim_time_ref.setData(real);
        FlatField flatField = new FlatField(this.vol);
        this.new_state_ref = new DataReferenceImpl("new_state");
        this.new_state_ref.setData(flatField);
        FlatField flatField2 = new FlatField(this.vol);
        this.old_state_ref = new DataReferenceImpl("old_state");
        this.old_state_ref.setData(flatField2);
        FlatField flatField3 = new FlatField(this.vol);
        this.oldest_state_ref = new DataReferenceImpl("oldest_state");
        this.oldest_state_ref.setData(flatField3);
        FlatField flatField4 = new FlatField(this.voldiff);
        this.newold_diff_ref = new DataReferenceImpl("newold_diff");
        this.newold_diff_ref.setData(flatField4);
        this.iopt_ref = new DataReferenceImpl("iopt");
        this.ibc_ref = new DataReferenceImpl("ibc");
        this.gravity_ref = new DataReferenceImpl("gravity");
        this.alat_ref = new DataReferenceImpl("alat");
        this.ubar1_ref = new DataReferenceImpl("ubar1");
        this.vbar1_ref = new DataReferenceImpl("vbar1");
        this.hprm11_ref = new DataReferenceImpl("hprm11");
        this.hprm12_ref = new DataReferenceImpl("hprm12");
        this.delt_ref = new DataReferenceImpl("delt");
        this.eps_ref = new DataReferenceImpl("eps");
        this.adiff_ref = new DataReferenceImpl("adiff");
        this.tfilt_ref = new DataReferenceImpl("tfilt");
        this.anim_delay_ref = new DataReferenceImpl("anim_delay");
        DisplayImpl[] displayImplArray = new DisplayImpl[2];
        this.setupDisplays(false, displayImplArray);
        this.setupUI(displayImplArray);
        this.initial = true;
        shalstepCell shalstepCell2 = new shalstepCell("shalstep_cell");
        shalstepCell2.addReference(this.new_state_ref);
        initializeCell initializeCell2 = new initializeCell();
        initializeCell2.addReference(this.iopt_ref);
        if (this.server_server != null) {
            RemoteDataReferenceImpl[] remoteDataReferenceImplArray = new RemoteDataReferenceImpl[]{new RemoteDataReferenceImpl((DataReferenceImpl)this.new_state_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.iopt_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.ibc_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.gravity_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.alat_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.ubar1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.vbar1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.hprm11_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.hprm12_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.delt_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.eps_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.adiff_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.tfilt_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.anim_delay_ref)};
            this.server_server.setDataReferences(remoteDataReferenceImplArray);
        }
    }

    void setupClient() throws VisADException, RemoteException {
        RemoteDataReference[] remoteDataReferenceArray = this.client_server.getDataReferences();
        if (remoteDataReferenceArray == null) {
            System.out.println("Cannot connect to server");
            System.exit(0);
        }
        this.new_state_ref = remoteDataReferenceArray[0];
        this.iopt_ref = remoteDataReferenceArray[1];
        this.ibc_ref = remoteDataReferenceArray[2];
        this.gravity_ref = remoteDataReferenceArray[3];
        this.alat_ref = remoteDataReferenceArray[4];
        this.ubar1_ref = remoteDataReferenceArray[5];
        this.vbar1_ref = remoteDataReferenceArray[6];
        this.hprm11_ref = remoteDataReferenceArray[7];
        this.hprm12_ref = remoteDataReferenceArray[8];
        this.delt_ref = remoteDataReferenceArray[9];
        this.eps_ref = remoteDataReferenceArray[10];
        this.adiff_ref = remoteDataReferenceArray[11];
        this.tfilt_ref = remoteDataReferenceArray[12];
        this.anim_delay_ref = remoteDataReferenceArray[13];
        this.vol = (FunctionType)this.new_state_ref.getType();
        this.loc = this.vol.getDomain();
        this.xloc = (RealType)this.loc.getComponent(0);
        this.yloc = (RealType)this.loc.getComponent(1);
        RealTupleType realTupleType = (RealTupleType)this.vol.getRange();
        this.u = (RealType)realTupleType.getComponent(0);
        this.v = (RealType)realTupleType.getComponent(1);
        this.h = (RealType)realTupleType.getComponent(2);
        this.cc = (RealType)realTupleType.getComponent(3);
        DisplayImpl[] displayImplArray = new DisplayImpl[2];
        this.setupDisplays(true, displayImplArray);
        this.setupUI(displayImplArray);
    }

    void setupDisplays(boolean bl, DisplayImpl[] displayImplArray) throws VisADException, RemoteException {
        Display display;
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("display1");
        displayImplJ3D.addMap(new ScalarMap(this.xloc, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(this.yloc, Display.YAxis));
        ScalarMap scalarMap = new ScalarMap(this.h, Display.ZAxis);
        scalarMap.setRange(5450.0, 5700.0);
        displayImplJ3D.addMap(scalarMap);
        ScalarMap scalarMap2 = new ScalarMap(this.cc, Display.Green);
        scalarMap2.setRange(-40.0, 40.0);
        displayImplJ3D.addMap(scalarMap2);
        ScalarMap scalarMap3 = new ScalarMap(this.u, Display.Flow1X);
        displayImplJ3D.addMap(scalarMap3);
        displayImplJ3D.addMap(new ScalarMap(this.v, Display.Flow1Y));
        ((FlowControl)scalarMap3.getControl()).setFlowScale(0.15f);
        displayImplJ3D.addMap(new ConstantMap(0.5, Display.Red));
        displayImplJ3D.addMap(new ConstantMap(0.5, Display.Blue));
        if (bl) {
            display = new RemoteDisplayImpl(displayImplJ3D);
            ((RemoteDisplayImpl)display).addReference(this.new_state_ref);
        } else {
            displayImplJ3D.addReference(this.new_state_ref);
        }
        display = new DisplayImplJ3D("display2");
        ((DisplayImpl)display).addMap(new ScalarMap(this.xloc, Display.XAxis));
        ((DisplayImpl)display).addMap(new ScalarMap(this.yloc, Display.YAxis));
        ScalarMap scalarMap4 = new ScalarMap(this.h, Display.ZAxis);
        scalarMap4.setRange(5450.0, 5700.0);
        ((DisplayImpl)display).addMap(scalarMap4);
        ScalarMap scalarMap5 = new ScalarMap(this.cc, Display.Green);
        scalarMap5.setRange(-40.0, 40.0);
        ((DisplayImpl)display).addMap(scalarMap5);
        GraphicsModeControl graphicsModeControl = ((DisplayImplJ3D)display).getGraphicsModeControl();
        graphicsModeControl.setTextureEnable(false);
        ((DisplayImpl)display).addMap(new ConstantMap(0.5, Display.Red));
        ((DisplayImpl)display).addMap(new ConstantMap(0.5, Display.Blue));
        if (bl) {
            RemoteDisplayImpl remoteDisplayImpl = new RemoteDisplayImpl((DisplayImpl)display);
            remoteDisplayImpl.addReference(this.new_state_ref);
        } else {
            ((DisplayImpl)display).addReference(this.new_state_ref);
        }
        displayImplArray[0] = displayImplJ3D;
        displayImplArray[1] = display;
    }

    void setupUI(DisplayImpl[] displayImplArray) throws VisADException, RemoteException {
        JFrame jFrame = new JFrame("ShallowFluid");
        WindowAdapter windowAdapter = new WindowAdapter(this){
            private final /* synthetic */ ShallowFluid this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = shallowFluid;
                this.constructor$0(shallowFluid);
            }

            private final void constructor$0(ShallowFluid shallowFluid) {
            }
        };
        jFrame.addWindowListener(windowAdapter);
        ((Component)jFrame).setSize(WIDTH, HEIGHT);
        ((Component)jFrame).setCursor(Cursor.getPredefinedCursor(0));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - WIDTH / 2, dimension.height / 2 - HEIGHT / 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel3.add(new JLabel("Interactive 2-D shallow fluid model"));
        jPanel3.add(new JLabel("using VisAD  -  see:"));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("for more information about VisAD."));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("Bill Hibbard and Bob Aune"));
        jPanel3.add(new JLabel("Space Science and Engineering Center"));
        jPanel3.add(new JLabel("University of Wisconsin - Madison"));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("Move initial configuration slider to restart model."));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("Move animation delay slider to adjust model speed."));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("Move other sliders to adjust model parameters."));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("Rotate scenes with text mouse button."));
        jPanel3.add(new JLabel("  "));
        jPanel3.add(new JLabel("  "));
        JPanel jPanel4 = new JPanel();
        jPanel4.setName("ShallowFluid Sliders");
        jPanel4.setFont(new Font("Dialog", 0, 12));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jPanel4);
        jPanel4.add(new VisADSlider("initial configuration", 1, 5, 5, 1.0, this.iopt_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("boundary condition", 1, 3, 3, 1.0, this.ibc_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("gravity constant", 0, 9806, 9806, 0.001, this.gravity_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("latitude of south boundary", 0, 90, 10, 1.0, this.alat_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("mean u", -100, 100, 0, 1.0, this.ubar1_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("mean v", -100, 100, 0, 1.0, this.vbar1_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("hprm11", -100, 200, -100, 1.0, this.hprm11_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("hprm12", -100, 200, -66, 1.0, this.hprm12_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("simulated time step", 0, 1200, 325, 1.0, this.delt_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("spatial filter constant", 0, 200, 0, 0.01, this.eps_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("interior diffusion coefficient", 0, 1000000, 0, 1.0, this.adiff_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("temporal filter constant", 0, 100, 0, 0.01, this.tfilt_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        jPanel4.add(new VisADSlider("animation delay (ms)", 10, 2000, 2000, 1.0, this.anim_delay_ref, RealType.Generic));
        jPanel4.add(new JLabel("  "));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setAlignmentY(0.0f);
        jPanel5.setAlignmentX(0.0f);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setAlignmentY(0.0f);
        jPanel6.setAlignmentX(0.0f);
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.setAlignmentY(0.0f);
        jPanel7.setAlignmentX(0.0f);
        jPanel5.add(jPanel7);
        JPanel jPanel8 = (JPanel)displayImplArray[0].getComponent();
        JPanel jPanel9 = (JPanel)displayImplArray[1].getComponent();
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        jPanel8.setBorder(compoundBorder);
        jPanel9.setBorder(compoundBorder);
        JLabel jLabel = new JLabel("fluid flow vectors");
        JLabel jLabel2 = new JLabel("fluid height surface");
        jPanel6.add(jPanel8);
        jPanel6.add(jLabel);
        jPanel7.add(jPanel9);
        jPanel7.add(jLabel2);
        ((Component)jFrame).setVisible(true);
    }

    private native void shalstep_c(int var1, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6, float[] var7, float[] var8, float[] var9, float[] var10, float[] var11, float[] var12, float[] var13, int var14, int var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24, float var25);

    public ShallowFluid(String[] stringArray) throws VisADException, RemoteException {
        if (stringArray.length > 0) {
            String string = "//" + stringArray[0] + "/ShallowFluid";
            try {
                this.client_server = (RemoteServer)Naming.lookup(string);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException notBoundException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException accessException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
        } else {
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///ShallowFluid", this.server_server);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException accessException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException remoteException) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
        }
    }

    class shalstepCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            float[][] fArray;
            float[][] fArray2;
            float[][] fArray3;
            int n = (int)((Real)ShallowFluid.this.sim_time_ref.getData()).getValue();
            int n2 = (int)((Real)ShallowFluid.this.iopt_ref.getData()).getValue();
            int n3 = (int)((Real)ShallowFluid.this.ibc_ref.getData()).getValue();
            float f = (float)((Real)ShallowFluid.this.gravity_ref.getData()).getValue();
            float f2 = (float)((Real)ShallowFluid.this.alat_ref.getData()).getValue();
            float f3 = (float)((Real)ShallowFluid.this.ubar1_ref.getData()).getValue();
            float f4 = (float)((Real)ShallowFluid.this.vbar1_ref.getData()).getValue();
            float f5 = (float)((Real)ShallowFluid.this.hprm11_ref.getData()).getValue();
            float f6 = (float)((Real)ShallowFluid.this.hprm12_ref.getData()).getValue();
            float f7 = (float)((Real)ShallowFluid.this.delt_ref.getData()).getValue();
            float f8 = (float)((Real)ShallowFluid.this.eps_ref.getData()).getValue();
            float f9 = (float)((Real)ShallowFluid.this.adiff_ref.getData()).getValue();
            float f10 = (float)((Real)ShallowFluid.this.tfilt_ref.getData()).getValue();
            int n4 = (int)((Real)ShallowFluid.this.anim_delay_ref.getData()).getValue();
            if (ShallowFluid.this.initial) {
                n = 0;
                f7 = 0.0f;
                fArray3 = new float[4][2891];
                fArray2 = new float[4][2891];
                fArray = new float[4][2891];
            } else {
                fArray3 = Set.doubleToFloat(((FlatField)ShallowFluid.this.new_state_ref.getData()).getValues());
                fArray2 = Set.doubleToFloat(((FlatField)ShallowFluid.this.old_state_ref.getData()).getValues());
                fArray = Set.doubleToFloat(((FlatField)ShallowFluid.this.oldest_state_ref.getData()).getValues());
            }
            ShallowFluid.this.shalstep_c(n, fArray[0], fArray[1], fArray[2], fArray[3], fArray2[0], fArray2[1], fArray2[2], fArray2[3], fArray3[0], fArray3[1], fArray3[2], fArray3[3], n2, n3, f, f2, f3, f4, f5, f6, f7, f8, f9, f10);
            ((FlatField)ShallowFluid.this.new_state_ref.getData()).setSamples(fArray3);
            if (ShallowFluid.this.initial) {
                ShallowFluid.this.initial = false;
                ShallowFluid.this.old_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.new_state_ref.getData()).clone());
                ShallowFluid.this.oldest_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.new_state_ref.getData()).clone());
            } else {
                ShallowFluid.this.newold_diff_ref.setData(ShallowFluid.this.new_state_ref.getData().subtract(ShallowFluid.this.oldest_state_ref.getData()));
                ShallowFluid.this.oldest_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.old_state_ref.getData()).clone());
                ShallowFluid.this.old_state_ref.setData((FlatField)((FlatField)ShallowFluid.this.new_state_ref.getData()).clone());
            }
            ShallowFluid.this.sim_time_ref.setData(new Real(ShallowFluid.this.time, (double)(++n)));
            new Delay(n4);
        }

        public shalstepCell(String string) throws VisADException, RemoteException {
            super(string);
        }
    }

    class initializeCell
    extends CellImpl {
        public void doAction() throws VisADException, RemoteException {
            ShallowFluid.this.initial = true;
        }
    }
}

