/*
 * Decompiled with CFR 0.152.
 */
package visad.aeri;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.ControlEvent;
import visad.ControlListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.FieldImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.ShapeControl;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADTriangleStripArray;
import visad.aeri.Aeri;
import visad.aeri.LinearVectorPointMethod;
import visad.aeri.Qdiv;
import visad.bom.WindPolarCoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADSerialForm;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceManager;
import visad.meteorology.NavigatedImage;
import visad.meteorology.SingleBandedImage;
import visad.util.AnimationWidget;
import visad.util.ColorMapWidget;
import visad.util.LabeledColorWidget;

public class Qdiv
implements ScalarMapListener {
    RealType latitude;
    RealType longitude;
    RealType altitude;
    RealTupleType spatial_domain;
    RealType time;
    RealType stn_idx;
    RealType temp;
    RealType dwpt;
    RealType wvmr;
    RealType RH;
    RealType theta;
    RealType thetaE;
    RealType u_wind;
    RealType v_wind;
    RealType wvmr_u;
    RealType wvmr_v;
    RealType band1;
    RealType div_qV;
    RealType q_divV;
    RealType qAdvct;
    RealType shape;
    RealTupleType wind_aeri;
    RealTupleType div_qV_comps;
    FunctionType alt_to_wind_aeri;
    FunctionType time_to_alt_to_wind_aeri;
    FunctionType alt_to_divqV;
    FunctionType time_to_alt_to_divqV;
    FieldImpl advect_field;
    FieldImpl stations_field;
    FieldImpl divqV_field;
    ImageSequence image_seq;
    Set timeDomain;
    int n_stations = 3;
    double[] station_lat;
    double[] station_lon;
    double[] station_alt;
    double[] station_id;
    double[] stat_xoffset = new double[this.n_stations];
    double[] stat_yoffset = new double[this.n_stations];
    double[][] centroid_ll;
    BaseMapAdapter baseMap;
    DataReference map_ref;
    ScalarMap xmap;
    ScalarMap ymap;
    ScalarMap zmap;
    ScalarMap img_map;
    boolean xmapEvent = false;
    boolean ymapEvent = false;
    boolean imgEvent = false;
    boolean firstEvent = false;
    boolean first_img_Event = false;
    float latmin;
    float latmax;
    float lonmin;
    float lonmax;
    float del_lat;
    float del_lon;
    double[] x_range;
    double[] y_range;
    int height_limit = 4000;
    int time_intrvl = 900;
    boolean rh = false;
    boolean tm = false;
    boolean pt = false;
    boolean ept = false;
    int start_date = 0;
    double start_time = 0.0;
    double[] scale_offset_x = new double[2];
    double[] scale_offset_y = new double[2];
    AnimationControl ani_cntrl;
    int alt_factor = 8;
    int n_hres_alt_samples;
    float alt_min;
    float alt_max;
    double hgt_max = -1.7976931348623157E308;

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        Qdiv qdiv = new Qdiv(stringArray);
    }

    void init_from_cdf(String string) throws VisADException, RemoteException, IOException {
        this.station_lat = new double[this.n_stations];
        this.station_lon = new double[this.n_stations];
        this.station_alt = new double[this.n_stations];
        this.station_id = new double[this.n_stations];
        this.longitude = RealType.Longitude;
        this.latitude = RealType.Latitude;
        this.RH = new RealType("RH", (Unit)SI.second, null);
        this.stn_idx = new RealType("stn_idx", null, null);
        this.theta = new RealType("theta", null, null);
        this.thetaE = new RealType("thetaE", null, null);
        this.u_wind = new RealType("u_wind", null, null);
        this.v_wind = new RealType("v_wind", null, null);
        this.wvmr_u = new RealType("wvmr_u", null, null);
        this.wvmr_v = new RealType("wvmr_v", null, null);
        this.div_qV = new RealType("div_qV", null, null);
        this.q_divV = new RealType("q_divV", null, null);
        this.qAdvct = new RealType("qAdvct", null, null);
        this.shape = new RealType("shape", null, null);
        String[] stringArray = new String[this.n_stations];
        String[] stringArray2 = new String[this.n_stations];
        String string2 = string;
        stringArray[0] = "./data/" + string + "_lamont_windprof.cdf";
        stringArray[1] = "./data/" + string + "_vici_windprof.cdf";
        stringArray[2] = "./data/" + string + "_purcell_windprof.cdf";
        stringArray2[0] = "./data/lamont_" + string2 + "AG.cdf";
        stringArray2[1] = "./data/vici_" + string2 + "AG.cdf";
        stringArray2[2] = "./data/purcell_" + string2 + "AG.cdf";
        File file = new File("./data/lamont_" + string2 + "AP.cdf");
        stringArray2[0] = file.exists() ? "./data/lamont_" + string2 + "AP.cdf" : "./data/lamont_" + string2 + "AG.cdf";
        file = new File("./data/vici_" + string2 + "AP.cdf");
        stringArray2[1] = file.exists() ? "./data/vici_" + string2 + "AP.cdf" : "./data/vici_" + string2 + "AG.cdf";
        file = new File("./data/purcell_" + string2 + "AP.cdf");
        stringArray2[2] = file.exists() ? "./data/purcell_" + string2 + "AP.cdf" : "./data/purcell_" + string2 + "AG.cdf";
        FieldImpl[] fieldImplArray = this.makeWinds(stringArray);
        System.out.println(fieldImplArray[0].getType().prettyString());
        FieldImpl[] fieldImplArray2 = this.makeAeri(stringArray2);
        System.out.println(fieldImplArray2[0].getType().prettyString());
        RealType[] realTypeArray = new RealType[]{this.u_wind, this.v_wind, this.temp, this.dwpt, this.wvmr, this.wvmr_u, this.wvmr_v, this.thetaE};
        this.wind_aeri = new RealTupleType(realTypeArray);
        this.alt_to_wind_aeri = new FunctionType(this.altitude, this.wind_aeri);
        this.time_to_alt_to_wind_aeri = new FunctionType(RealType.Time, this.alt_to_wind_aeri);
        this.div_qV_comps = new RealTupleType(new RealType[]{this.div_qV, this.thetaE, this.shape});
        this.alt_to_divqV = new FunctionType(this.altitude, this.div_qV_comps);
        this.time_to_alt_to_divqV = new FunctionType(RealType.Time, this.alt_to_divqV);
        this.spatial_domain = new RealTupleType(this.longitude, this.latitude, this.altitude);
        this.stations_field = this.make_wind_aeri(fieldImplArray, fieldImplArray2);
        System.out.println(this.stations_field.getType().prettyString());
        this.divqV_field = this.makeDivqV(this.stations_field);
        System.out.println("makeDivqV:  Done");
    }

    void init_from_vad(String string) throws VisADException, RemoteException, IOException {
        VisADSerialForm visADSerialForm = new VisADSerialForm();
        this.stations_field = (FieldImpl)visADSerialForm.open(string);
        MathType mathType = this.stations_field.getType();
        this.stn_idx = (RealType)((FunctionType)mathType).getDomain().getComponent(0);
        FunctionType functionType = (FunctionType)((FunctionType)mathType).getRange();
        this.time = (RealType)functionType.getDomain().getComponent(0);
        FunctionType functionType2 = (FunctionType)functionType.getRange();
        this.spatial_domain = functionType2.getDomain();
        this.longitude = (RealType)this.spatial_domain.getComponent(0);
        this.latitude = (RealType)this.spatial_domain.getComponent(1);
        this.altitude = (RealType)this.spatial_domain.getComponent(2);
        RealTupleType realTupleType = (RealTupleType)functionType2.getRange();
        this.temp = (RealType)realTupleType.getComponent(0);
        this.dwpt = (RealType)realTupleType.getComponent(1);
        this.wvmr = (RealType)realTupleType.getComponent(2);
        this.RH = (RealType)realTupleType.getComponent(3);
        this.theta = (RealType)realTupleType.getComponent(4);
        this.thetaE = (RealType)realTupleType.getComponent(5);
    }

    public static ImageSequence init_images(String string) throws VisADException, RemoteException, IOException {
        String string2 = System.getProperty("file.separator");
        if (string == null) {
            string = "." + string2 + "data" + string2 + "image" + string2 + "ir_display";
        }
        File file = new File(string);
        String[] stringArray = file.list();
        int n = stringArray.length;
        SingleBandedImage[] singleBandedImageArray = new NavigatedImage[n];
        int n2 = 0;
        while (n2 < n) {
            AreaAdapter areaAdapter = new AreaAdapter(string + string2 + stringArray[n2]);
            FlatField flatField = areaAdapter.getData();
            DateTime dateTime = areaAdapter.getImageStartTime();
            singleBandedImageArray[n2] = new NavigatedImage(flatField, dateTime, "AREA");
            ++n2;
        }
        ImageSequenceManager imageSequenceManager = new ImageSequenceManager(singleBandedImageArray);
        return imageSequenceManager.getImageSequence();
    }

    DisplayImpl makeDisplay(JPanel jPanel, JPanel jPanel2) throws VisADException, RemoteException, IOException {
        Object object;
        DataReferenceImpl dataReferenceImpl;
        this.del_lon = 8.0f;
        this.del_lat = 8.0f;
        this.baseMap = new BaseMapAdapter("OUTLUSAM");
        this.map_ref = new DataReferenceImpl("map");
        if (!this.baseMap.isEastPositive()) {
            this.baseMap.setEastPositive(true);
        }
        DataImpl dataImpl = this.makePoles();
        DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("poles");
        dataReferenceImpl2.setData(dataImpl);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("aeri");
        GraphicsModeControl graphicsModeControl = ((DisplayImpl)displayImplJ3D).getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        graphicsModeControl.setLineWidth(1.5f);
        DisplayRenderer displayRenderer = displayImplJ3D.getDisplayRenderer();
        displayRenderer.setBoxOn(false);
        this.xmap = new ScalarMap(this.longitude, Display.XAxis);
        this.xmap.setScaleEnable(false);
        this.xmap.addScalarMapListener(this);
        this.ymap = new ScalarMap(this.latitude, Display.YAxis);
        this.ymap.setScaleEnable(false);
        this.ymap.addScalarMapListener(this);
        double[] dArray = Qdiv.getArrayMinMax(this.station_lon);
        double[] dArray2 = Qdiv.getArrayMinMax(this.station_lat);
        this.baseMap.setLatLonLimits((float)(dArray2[0] - (double)this.del_lat), (float)(dArray2[1] + (double)this.del_lat), (float)(dArray[0] - (double)this.del_lon), (float)(dArray[1] + (double)this.del_lon));
        UnionSet unionSet = this.baseMap.getData();
        this.map_ref.setData(unionSet);
        this.zmap = new ScalarMap(this.altitude, Display.ZAxis);
        displayImplJ3D.addMap(this.xmap);
        displayImplJ3D.addMap(this.ymap);
        displayImplJ3D.addMap(this.zmap);
        float f = 0.06f;
        float f2 = 0.0078375f;
        ScalarMap scalarMap = new ScalarMap(this.shape, Display.Shape);
        displayImplJ3D.addMap(scalarMap);
        VisADTriangleStripArray visADTriangleStripArray = Qdiv.makeCylinder(14, f, f2);
        System.out.println("makeCylinder done");
        VisADGeometryArray[] visADGeometryArrayArray = new VisADGeometryArray[]{visADTriangleStripArray};
        ShapeControl shapeControl = (ShapeControl)scalarMap.getControl();
        shapeControl.setShapeSet(new Integer1DSet(1));
        shapeControl.setShapes(visADGeometryArrayArray);
        ScalarMap scalarMap2 = new ScalarMap(this.wvmr_u, Display.Flow1X);
        ScalarMap scalarMap3 = new ScalarMap(this.wvmr_v, Display.Flow1Y);
        displayImplJ3D.addMap(scalarMap2);
        displayImplJ3D.addMap(scalarMap3);
        FlowControl flowControl = (FlowControl)scalarMap2.getControl();
        flowControl.setFlowScale(0.5f);
        flowControl = (FlowControl)scalarMap3.getControl();
        flowControl.setFlowScale(0.5f);
        ScalarMap scalarMap4 = null;
        scalarMap4 = this.rh ? new ScalarMap(this.RH, Display.RGB) : (this.tm ? new ScalarMap(this.temp, Display.RGB) : (this.pt ? new ScalarMap(this.theta, Display.RGB) : (this.ept ? new ScalarMap(this.thetaE, Display.RGB) : new ScalarMap(this.wvmr, Display.RGB))));
        displayImplJ3D.addMap(scalarMap4);
        ScalarMap scalarMap5 = new ScalarMap(this.thetaE, Display.RGB);
        displayImplJ3D.addMap(scalarMap5);
        ColorMapWidget colorMapWidget = new ColorMapWidget(scalarMap4, null, true, false);
        LabeledColorWidget labeledColorWidget = new LabeledColorWidget(colorMapWidget);
        ScalarMap scalarMap6 = new ScalarMap(RealType.Time, Display.Animation);
        displayImplJ3D.addMap(scalarMap6);
        this.ani_cntrl = (AnimationControl)((Object)scalarMap6.getControl());
        this.ani_cntrl.setStep(200);
        AnimationWidget animationWidget = new AnimationWidget(scalarMap6);
        this.zmap.setRange(0.0, this.hgt_max);
        this.img_map = new ScalarMap(this.band1, Display.RGB);
        this.img_map.addScalarMapListener(this);
        displayImplJ3D.addMap(this.img_map);
        ColorControl colorControl = (ColorControl)this.img_map.getControl();
        colorControl.initGreyWedge();
        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue), new ConstantMap(-0.98, Display.ZAxis)};
        displayImplJ3D.addReference(dataReferenceImpl2);
        displayImplJ3D.addReference(this.map_ref, constantMapArray);
        ConstantMap[] constantMapArray2 = new ConstantMap[2];
        int n = 0;
        while (n < this.n_stations) {
            double d = this.station_lon[n] * this.scale_offset_x[0] + this.scale_offset_x[1];
            constantMapArray2[0] = new ConstantMap(d, Display.XAxis);
            double d2 = this.station_lat[n] * this.scale_offset_y[0] + this.scale_offset_y[1];
            constantMapArray2[1] = new ConstantMap(d2, Display.YAxis);
            dataReferenceImpl = new DataReferenceImpl("station: " + n);
            dataReferenceImpl.setData(this.stations_field.getSample(n));
            displayImplJ3D.addReference(dataReferenceImpl, constantMapArray2);
            ++n;
        }
        double d = this.centroid_ll[0][0] * 57.29577951308232 * this.scale_offset_x[0] + this.scale_offset_x[1];
        double d3 = this.centroid_ll[1][0] * 57.29577951308232 * this.scale_offset_y[0] + this.scale_offset_y[1];
        ConstantMap[] constantMapArray3 = new ConstantMap[]{new ConstantMap(d, Display.XAxis), new ConstantMap(d3, Display.YAxis)};
        dataReferenceImpl = new DataReferenceImpl("centroid");
        dataReferenceImpl.setData(this.divqV_field);
        displayImplJ3D.addReference(dataReferenceImpl, constantMapArray3);
        ConstantMap[] constantMapArray4 = new ConstantMap[]{new ConstantMap(-0.99, Display.ZAxis)};
        if (this.image_seq != null) {
            object = new DataReferenceImpl("image");
            object.setData(this.image_seq);
            displayImplJ3D.addReference((DataReference)object, constantMapArray4);
        }
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        ((Container)object).add(displayImplJ3D.getComponent());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        labeledColorWidget.setMaximumSize(new Dimension(400, 100));
        animationWidget.setMaximumSize(new Dimension(400, 200));
        jPanel3.add(labeledColorWidget);
        jPanel3.add(animationWidget);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.makeDisplay2(jPanel4);
        jPanel3.add(jPanel4);
        Dimension dimension = new Dimension(400, 800);
        jPanel3.setMaximumSize(dimension);
        jPanel.add((Component)object);
        jPanel.add(jPanel3);
        return displayImplJ3D;
    }

    void makeDisplay2(JPanel jPanel) throws VisADException, RemoteException, IOException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("components", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        DisplayRenderer displayRenderer = displayImplJ3D.getDisplayRenderer();
        displayRenderer.setBoxOn(false);
        ScalarMap scalarMap = new ScalarMap(RealType.Time, Display.XAxis);
        ScalarMap scalarMap2 = new ScalarMap(this.altitude, Display.YAxis);
        ScalarMap scalarMap3 = new ScalarMap(this.div_qV, Display.RGB);
        displayImplJ3D.addMap(scalarMap);
        displayImplJ3D.addMap(scalarMap2);
        displayImplJ3D.addMap(scalarMap3);
        class Listener
        implements ControlListener {
            double[][] value;
            private final /* synthetic */ Qdiv this$0;
            private final /* synthetic */ ScalarMap val$xmap;

            public void controlChanged(ControlEvent controlEvent) {
                int n = this.this$0.ani_cntrl.getCurrent();
                try {
                    this.value = this.this$0.timeDomain.indexToDouble(new int[]{n});
                    this.val$xmap.setRange(this.value[0][0] - 14400.0, this.value[0][0]);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }

            /* synthetic */ Listener(Qdiv qdiv, ScalarMap scalarMap) {
                this.val$xmap = scalarMap;
                this.this$0 = qdiv;
                this.constructor$0(qdiv);
            }

            private final void constructor$0(Qdiv qdiv) {
            }
        }
        this.ani_cntrl.addControlListener(new Listener(this, scalarMap));
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("time_height_ref");
        dataReferenceImpl.setData(this.divqV_field.domainMultiply());
        displayImplJ3D.addReference(dataReferenceImpl);
        GraphicsModeControl graphicsModeControl = ((DisplayImpl)displayImplJ3D).getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        jPanel.add(displayImplJ3D.getComponent());
    }

    public static double[] getArrayMinMax(double[] dArray) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double[] dArray2 = new double[2];
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] > d2) {
                d2 = dArray[n];
            }
            if (dArray[n] < d) {
                d = dArray[n];
            }
            ++n;
        }
        dArray2[0] = d;
        dArray2[1] = d2;
        return dArray2;
    }

    DataImpl makePoles() throws VisADException, RemoteException {
        SampledSet[] sampledSetArray = new SampledSet[this.n_stations];
        int n = 0;
        float[][] fArray = new float[3][2];
        int n2 = 0;
        while (n2 < this.n_stations) {
            boolean bl = false;
            float f = -3.4028235E38f;
            FieldImpl fieldImpl = (FieldImpl)this.stations_field.getSample(n2);
            if (fieldImpl != null) {
                int n3 = fieldImpl.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    FieldImpl fieldImpl2 = (FieldImpl)fieldImpl.getSample(n4);
                    if (fieldImpl2 != null && fieldImpl2.getLength() >= 2) {
                        Set set = fieldImpl2.getDomainSet();
                        float[][] fArray2 = set.getSamples(false);
                        float[] fArray3 = ((SampledSet)set).getHi();
                        if (fArray3[0] > f) {
                            f = fArray3[0];
                        }
                        if (!bl && fArray2[0][0] == fArray2[0][0]) {
                            bl = true;
                            fArray[0][0] = (float)this.station_lon[n2];
                            fArray[1][0] = (float)this.station_lat[n2];
                            fArray[0][1] = fArray[0][0];
                            fArray[1][1] = fArray[1][0];
                        }
                    }
                    ++n4;
                }
                if (bl) {
                    fArray[2][0] = 0.0f;
                    fArray[2][1] = f;
                    sampledSetArray[n++] = new Gridded3DSet((MathType)this.spatial_domain, fArray, 2, null, null, null);
                    if ((double)f > this.hgt_max) {
                        this.hgt_max = f;
                    }
                }
            }
            ++n2;
        }
        SampledSet[] sampledSetArray2 = new SampledSet[n];
        System.arraycopy(sampledSetArray, 0, sampledSetArray2, 0, n);
        return new UnionSet((MathType)this.spatial_domain, sampledSetArray2);
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) throws VisADException, RemoteException {
        double[] dArray;
        if (this.xmap.equals(scalarMapEvent.getScalarMap())) {
            this.xmapEvent = true;
        } else if (this.ymap.equals(scalarMapEvent.getScalarMap())) {
            this.ymapEvent = true;
        } else if (this.img_map.equals(scalarMapEvent.getScalarMap())) {
            this.imgEvent = true;
        }
        if (this.xmapEvent && this.ymapEvent && !this.firstEvent) {
            dArray = Qdiv.getArrayMinMax(this.station_lat);
            this.latmin = (float)dArray[0];
            this.latmax = (float)dArray[1];
            dArray = Qdiv.getArrayMinMax(this.station_lon);
            this.lonmin = (float)dArray[0];
            this.lonmax = (float)dArray[1];
            this.firstEvent = true;
            this.xmap.setRange(this.lonmin, this.lonmax);
            this.ymap.setRange(this.latmin, this.latmax);
            double[] dArray2 = new double[2];
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[2];
            this.xmap.getScale(dArray2, dArray3, dArray4);
            this.scale_offset_x[0] = dArray2[0];
            this.scale_offset_x[1] = dArray2[1];
            this.ymap.getScale(dArray2, dArray3, dArray4);
            this.scale_offset_y[0] = dArray2[0];
            this.scale_offset_y[1] = dArray2[1];
        }
        if (this.imgEvent && !this.first_img_Event) {
            dArray = this.img_map.getRange();
            System.out.println(dArray[0] + " " + dArray[1]);
            this.first_img_Event = true;
            this.img_map.setRange(dArray[1], dArray[0]);
        }
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
    }

    FieldImpl[] makeWinds(String[] stringArray) throws VisADException, RemoteException, IOException {
        DataImpl[] dataImplArray = new DataImpl[this.n_stations];
        FieldImpl[] fieldImplArray = new FieldImpl[this.n_stations];
        double[][] dArray = null;
        double[] dArray2 = new double[this.n_stations];
        double[] dArray3 = new double[this.n_stations];
        Gridded1DSet gridded1DSet = null;
        FlatField flatField = null;
        Plain plain = new Plain();
        int n = 0;
        while (n < this.n_stations) {
            dataImplArray[n] = plain.open(stringArray[n]);
            ++n;
        }
        MathType mathType = dataImplArray[0].getType();
        System.out.println(mathType.prettyString());
        System.out.println();
        FunctionType functionType = (FunctionType)((TupleType)mathType).getComponent(2);
        int n2 = ((TupleType)functionType.getRange()).getDimension();
        FunctionType functionType2 = (FunctionType)((TupleType)functionType.getRange()).getComponent(n2 - 1);
        RealTupleType realTupleType = (RealTupleType)functionType2.getRange();
        int n3 = realTupleType.getIndex("Altitude");
        this.altitude = (RealType)realTupleType.getComponent(n3);
        int n4 = realTupleType.getIndex("windSpeed");
        RealType realType = (RealType)realTupleType.getComponent(n4);
        int n5 = realTupleType.getIndex("windDir");
        RealType realType2 = (RealType)realTupleType.getComponent(n5);
        RealType[] realTypeArray = new RealType[]{realType2, realType};
        RealType[] realTypeArray2 = new RealType[]{this.u_wind, this.v_wind};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        WindPolarCoordinateSystem windPolarCoordinateSystem = new WindPolarCoordinateSystem(realTupleType2);
        RealTupleType realTupleType3 = new RealTupleType(realTypeArray, (CoordinateSystem)windPolarCoordinateSystem, null);
        FunctionType functionType3 = new FunctionType(this.altitude, realTupleType3);
        FunctionType functionType4 = new FunctionType(this.altitude, realTupleType2);
        RealType realType3 = (RealType)((TupleType)functionType.getRange()).getComponent(0);
        this.time = RealType.Time;
        FunctionType functionType5 = new FunctionType(RealType.Time, functionType4);
        FieldImpl[] fieldImplArray2 = new FieldImpl[this.n_stations];
        int n6 = 0;
        while (n6 < this.n_stations) {
            DataImpl dataImpl;
            Object object;
            dArray2[n6] = ((Real)((Tuple)dataImplArray[n6]).getComponent(0)).getValue();
            dArray3[n6] = ((Real)((Tuple)dataImplArray[n6]).getComponent(1)).getValue();
            fieldImplArray[n6] = (FieldImpl)((Tuple)dataImplArray[n6]).getComponent(2);
            this.station_lat[n6] = ((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(6)).getValue();
            this.station_lon[n6] = -((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(7)).getValue();
            this.station_alt[n6] = ((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(8)).getValue();
            this.station_id[n6] = ((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(9)).getValue();
            if (n6 == 0) {
                this.start_time = dArray3[0];
                this.start_date = (int)dArray2[0];
            }
            int n7 = fieldImplArray[n6].getLength();
            double[][] dArray4 = new double[1][n7];
            dArray = new double[1][n7];
            FlatField[] flatFieldArray = new FlatField[n7];
            double[][] dArray5 = null;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n7) {
                object = (Tuple)fieldImplArray[n6].getSample(n9);
                dArray[0][n9] = ((Real)((Tuple)object).getComponent(0)).getValue();
                dataImpl = (FlatField)((Tuple)object).getComponent(n2 - 1);
                double[][] dArray6 = dataImpl.getValues();
                double[][] dArray7 = new double[2][dArray6[0].length];
                if (n9 == 0) {
                    dArray5 = new double[1][dArray6[0].length];
                    System.arraycopy(dArray6[n3], 0, dArray5[0], 0, dArray5[0].length);
                    gridded1DSet = new Gridded1DSet((MathType)this.altitude, Set.doubleToFloat(dArray5), dArray5[0].length);
                }
                flatField = new FlatField(functionType4, gridded1DSet);
                int n10 = 0;
                int n11 = dArray6[0].length;
                int[] nArray = new int[n11];
                int n12 = 0;
                while (n12 < n11) {
                    dArray7[0][n12] = dArray6[n5][n12] <= -9999.0 ? Double.NaN : dArray6[n5][n12];
                    dArray7[1][n12] = dArray6[n4][n12] <= -9999.0 ? Double.NaN : dArray6[n4][n12];
                    if (dArray7[0][n12] == dArray7[0][n12] && dArray7[1][n12] == dArray7[1][n12]) {
                        nArray[n10] = n12;
                        ++n10;
                    }
                    ++n12;
                }
                if (n11 - 7 < n10 && n10 <= n11) {
                    int n13;
                    n12 = n10;
                    if (nArray[0] > 0) {
                        n12 += nArray[0];
                    }
                    if ((n13 = dArray6[0].length - (nArray[n10 - 1] + 1)) > 0) {
                        n12 += n13;
                    }
                    float[][] fArray = new float[2][n12];
                    float[][] fArray2 = new float[1][n12];
                    int n14 = 0;
                    while (n14 < n10) {
                        fArray[0][nArray[0] + n14] = (float)dArray7[0][nArray[n14]];
                        fArray[1][nArray[0] + n14] = (float)dArray7[1][nArray[n14]];
                        fArray2[0][nArray[0] + n14] = (float)dArray5[0][nArray[n14]];
                        ++n14;
                    }
                    n14 = 0;
                    while (n14 < nArray[0]) {
                        fArray[0][n14] = (float)dArray7[0][nArray[0]];
                        fArray[1][n14] = (float)dArray7[1][nArray[0]];
                        fArray2[0][n14] = (float)dArray5[0][nArray[0]];
                        ++n14;
                    }
                    n14 = 0;
                    while (n14 < n13) {
                        fArray[0][nArray[0] + n10 + n14] = (float)dArray7[0][nArray[n10 - 1]];
                        fArray[1][nArray[0] + n10 + n14] = (float)dArray7[1][nArray[n10 - 1]];
                        fArray2[0][nArray[0] + n10 + n14] = (float)dArray5[0][nArray[n10 - 1]];
                        ++n14;
                    }
                    Gridded1DSet gridded1DSet2 = new Gridded1DSet((MathType)this.altitude, fArray2, n12);
                    FlatField flatField2 = new FlatField(functionType4, gridded1DSet2);
                    flatField2.setSamples(((CoordinateSystem)windPolarCoordinateSystem).toReference(fArray));
                    flatFieldArray[n8] = flatField = (FlatField)flatField2.resample(gridded1DSet, 101, 202);
                    dArray4[0][n8] = dArray3[0] + dArray[0][n9];
                    ++n8;
                }
                ++n9;
            }
            double[][] dArray8 = new double[1][n8];
            object = new Data[n8];
            System.arraycopy(dArray4[0], 0, dArray8[0], 0, n8);
            System.arraycopy(flatFieldArray, 0, object, 0, n8);
            System.out.println("n_not_all_miss: " + n8);
            dataImpl = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(dArray8), n8);
            fieldImplArray2[n6] = new FieldImpl(functionType5, (Set)dataImpl);
            fieldImplArray2[n6].setSamples((Data[])object, false);
            ++n6;
        }
        return fieldImplArray2;
    }

    FieldImpl[] makeAeri(String[] stringArray) throws VisADException, RemoteException, IOException {
        DataImpl[] dataImplArray = new DataImpl[this.n_stations];
        FieldImpl[] fieldImplArray = new FieldImpl[this.n_stations];
        double[][] dArray = null;
        double[] dArray2 = new double[this.n_stations];
        double[] dArray3 = new double[this.n_stations];
        Plain plain = new Plain();
        int n = 0;
        while (n < this.n_stations) {
            dataImplArray[n] = plain.open(stringArray[n]);
            ++n;
        }
        System.out.println(dataImplArray[0].getType().prettyString());
        MathType mathType = dataImplArray[0].getType();
        FunctionType functionType = (FunctionType)((TupleType)mathType).getComponent(1);
        FunctionType functionType2 = (FunctionType)((TupleType)functionType.getRange()).getComponent(1);
        RealTupleType realTupleType = (RealTupleType)functionType2.getRange();
        RealType realType = new RealType("press", null, null);
        this.temp = new RealType("temp", null, null);
        this.dwpt = new RealType("dwpt", null, null);
        this.wvmr = new RealType("wvmr", null, null);
        RealType[] realTypeArray = new RealType[]{realType, this.temp, this.dwpt, this.wvmr};
        functionType2 = new FunctionType(functionType2.getDomain(), new RealTupleType(realTypeArray));
        RealType realType2 = (RealType)((TupleType)functionType.getRange()).getComponent(0);
        FunctionType functionType3 = new FunctionType(RealType.Time, functionType2);
        FieldImpl[] fieldImplArray2 = new FieldImpl[this.n_stations];
        int n2 = 0;
        while (n2 < this.n_stations) {
            DataImpl dataImpl;
            Data[] dataArray;
            dArray3[n2] = ((Real)((Tuple)dataImplArray[n2]).getComponent(0)).getValue();
            fieldImplArray[n2] = (FieldImpl)((Tuple)dataImplArray[n2]).getComponent(1);
            dArray2[n2] = ((Real)((Tuple)dataImplArray[n2]).getComponent(2)).getValue();
            int n3 = fieldImplArray[n2].getLength();
            dArray = new double[1][n3];
            Data[] dataArray2 = new Data[n3];
            double[][] dArray4 = new double[1][n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                dataArray = (Data[])fieldImplArray[n2].getSample(n5);
                dArray[0][n5] = ((Real)dataArray.getComponent(0)).getValue();
                dataImpl = (FlatField)dataArray.getComponent(1);
                double[][] dArray5 = ((FlatField)dataImpl).getValues();
                double[][] dArray6 = new double[4][dArray5[0].length];
                int n6 = 0;
                int n7 = dArray5[0].length;
                int n8 = 0;
                while (n8 < n7) {
                    dArray6[0][n8] = dArray5[0][n8] == -9999.0 ? Double.NaN : dArray5[0][n8];
                    dArray6[1][n8] = dArray5[1][n8] == -9999.0 ? Double.NaN : dArray5[1][n8];
                    dArray6[2][n8] = dArray5[2][n8] == -9999.0 ? Double.NaN : dArray5[2][n8];
                    if (dArray5[3][n8] == -9999.0) {
                        dArray6[3][n8] = Double.NaN;
                        ++n6;
                    } else {
                        dArray6[3][n8] = dArray5[3][n8];
                    }
                    ++n8;
                }
                if (n6 < 3) {
                    FlatField flatField = new FlatField(functionType2, ((FieldImpl)dataImpl).getDomainSet());
                    flatField.setSamples(dArray6);
                    dataArray2[n4] = flatField;
                    dArray4[0][n4] = dArray3[0] + dArray[0][n5];
                    ++n4;
                }
                ++n5;
            }
            System.out.println("not_all_missing: " + n4);
            double[][] dArray7 = new double[1][n4];
            dataArray = new Data[n4];
            System.arraycopy(dArray4[0], 0, dArray7[0], 0, n4);
            System.arraycopy(dataArray2, 0, dataArray, 0, n4);
            dataImpl = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(dArray7), n4);
            fieldImplArray2[n2] = new FieldImpl(functionType3, (Set)dataImpl);
            fieldImplArray2[n2].setSamples(dataArray, false);
            ++n2;
        }
        return fieldImplArray2;
    }

    FieldImpl make_wind_aeri(FieldImpl[] fieldImplArray, FieldImpl[] fieldImplArray2) throws VisADException, RemoteException, IOException {
        float[][] fArray = new float[1][1];
        int[] nArray = new int[1];
        boolean bl = false;
        double[][] dArray = null;
        FieldImpl fieldImpl = new FieldImpl(new FunctionType(this.stn_idx, this.time_to_alt_to_wind_aeri), new Integer1DSet(this.stn_idx, this.n_stations, null, null, null));
        double[] dArray2 = new double[this.n_stations * 2];
        double[] dArray3 = new double[this.n_stations * 2];
        int n = 0;
        while (n < this.n_stations) {
            Set set = fieldImplArray[n].getDomainSet();
            dArray2[n] = ((SampledSet)set).getLow()[0];
            dArray3[n] = ((SampledSet)set).getHi()[0];
            set = fieldImplArray2[n].getDomainSet();
            dArray2[this.n_stations + n] = ((SampledSet)set).getLow()[0];
            dArray3[this.n_stations + n] = ((SampledSet)set).getHi()[0];
            ++n;
        }
        double[] dArray4 = Qdiv.getArrayMinMax(dArray2);
        double d = dArray4[1];
        dArray4 = Qdiv.getArrayMinMax(dArray3);
        double d2 = dArray4[0];
        System.out.println("hi_low: " + d);
        System.out.println("low_hi: " + d2);
        this.timeDomain = new Linear1DSet((MathType)this.time, d, d2, (int)(d2 - d) / this.time_intrvl);
        int n2 = 0;
        while (n2 < this.n_stations) {
            FieldImpl fieldImpl2 = new FieldImpl(this.time_to_alt_to_wind_aeri, this.timeDomain);
            FieldImpl fieldImpl3 = (FieldImpl)fieldImplArray[n2].resample(this.timeDomain, 101, 202);
            FieldImpl fieldImpl4 = (FieldImpl)fieldImplArray2[n2].resample(this.timeDomain, 101, 202);
            int n3 = ((RealTupleType)((FunctionType)this.time_to_alt_to_wind_aeri.getRange()).getRange()).getDimension();
            int n4 = this.timeDomain.getLength();
            Set set = null;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                Object object;
                Object object2;
                Object object3;
                FieldImpl fieldImpl5 = (FieldImpl)fieldImpl4.getSample(n6);
                FieldImpl fieldImpl6 = (FieldImpl)fieldImpl3.getSample(n6);
                if (n6 == 0) {
                    set = fieldImpl6.getDomainSet();
                    object3 = set.getSamples();
                    object2 = new float[object3[0].length];
                    int n7 = 0;
                    while (n7 < object3[0].length) {
                        if ((double)object3[0][n7] - this.station_alt[n2] < (double)this.height_limit) {
                            object2[n5] = object3[0][n7] - (float)this.station_alt[n2];
                            ++n5;
                        }
                        ++n7;
                    }
                    object = new float[1][n5];
                    System.arraycopy(object2, 0, object[0], 0, n5);
                    set = new Gridded1DSet(set.getType(), (float[][])object, n5);
                    dArray = new double[n3][n5];
                }
                FieldImpl fieldImpl7 = (FieldImpl)fieldImpl5.resample(set, 101, 202);
                object3 = fieldImpl6.getValues();
                object2 = fieldImpl7.getValues();
                int n8 = 0;
                while (n8 < n5) {
                    dArray[0][n8] = object3[0][n8];
                    dArray[1][n8] = object3[1][n8];
                    dArray[2][n8] = object2[1][n8];
                    dArray[3][n8] = object2[2][n8];
                    dArray[4][n8] = object2[3][n8];
                    dArray[5][n8] = object3[0][n8] * object2[3][n8];
                    dArray[6][n8] = object3[1][n8] * object2[3][n8];
                    dArray[7][n8] = Aeri.equivPotentialTemperatureStar(Aeri.potentialTemperature((double)object2[1][n8], (double)object2[0][n8]), (double)object2[3][n8], (double)object2[1][n8]);
                    ++n8;
                }
                object = new FlatField(this.alt_to_wind_aeri, set);
                ((FlatField)object).setSamples(dArray);
                fieldImpl2.setSample(n6, (Data)object);
                ++n6;
            }
            fieldImpl.setSample(n2, (Data)fieldImpl2, false);
            ++n2;
        }
        return fieldImpl;
    }

    FieldImpl makeDivqV(FieldImpl fieldImpl) throws VisADException, RemoteException {
        double[][] dArray = new double[2][3];
        double[][] dArray2 = new double[2][3];
        dArray2[0][0] = this.station_lon[0] * (Math.PI / 180);
        dArray2[0][1] = this.station_lon[1] * (Math.PI / 180);
        dArray2[0][2] = this.station_lon[2] * (Math.PI / 180);
        dArray2[1][0] = this.station_lat[0] * (Math.PI / 180);
        dArray2[1][1] = this.station_lat[1] * (Math.PI / 180);
        dArray2[1][2] = this.station_lat[2] * (Math.PI / 180);
        LinearVectorPointMethod linearVectorPointMethod = new LinearVectorPointMethod(dArray2);
        this.centroid_ll = linearVectorPointMethod.getCentroid();
        FieldImpl fieldImpl2 = (FieldImpl)fieldImpl.getSample(0);
        FieldImpl fieldImpl3 = (FieldImpl)fieldImpl.getSample(1);
        FieldImpl fieldImpl4 = (FieldImpl)fieldImpl.getSample(2);
        FlatField flatField = (FlatField)fieldImpl2.getSample(0);
        Set set = flatField.getDomainSet();
        int n = set.getLength();
        this.alt_min = ((SampledSet)set).getLow()[0];
        this.alt_max = ((SampledSet)set).getHi()[0];
        this.n_hres_alt_samples = n * this.alt_factor;
        Linear1DSet linear1DSet = new Linear1DSet(set.getType(), this.alt_min, this.alt_max, this.n_hres_alt_samples);
        FieldImpl fieldImpl5 = new FieldImpl(this.time_to_alt_to_divqV, fieldImpl2.getDomainSet());
        int n2 = 0;
        while (n2 < fieldImpl2.getLength()) {
            FlatField flatField2 = (FlatField)fieldImpl2.getSample(n2);
            FlatField flatField3 = (FlatField)fieldImpl3.getSample(n2);
            FlatField flatField4 = (FlatField)fieldImpl4.getSample(n2);
            double[][] dArray3 = flatField2.getValues(false);
            double[][] dArray4 = flatField3.getValues(false);
            double[][] dArray5 = flatField4.getValues(false);
            FlatField flatField5 = new FlatField(this.alt_to_divqV, set);
            double[][] dArray6 = new double[3][n];
            int n3 = 0;
            while (n3 < n) {
                boolean bl = false;
                dArray[0][0] = dArray3[0][n3];
                dArray[1][0] = dArray3[1][n3];
                dArray[0][1] = dArray4[0][n3];
                dArray[1][1] = dArray4[1][n3];
                dArray[0][2] = dArray5[0][n3];
                dArray[1][2] = dArray5[1][n3];
                if (Double.isNaN(dArray[0][0]) || Double.isNaN(dArray[1][0])) {
                    bl = true;
                } else if (Double.isNaN(dArray[0][1]) || Double.isNaN(dArray[1][1])) {
                    bl = true;
                } else if (Double.isNaN(dArray[0][2]) || Double.isNaN(dArray[1][2])) {
                    bl = true;
                }
                if (!bl) {
                    double[] dArray7 = linearVectorPointMethod.getKinematics(dArray);
                    dArray6[0][n3] = dArray7[4];
                    dArray6[1][n3] = (dArray3[7][n3] + dArray4[7][n3] + dArray5[7][n3]) / 3.0;
                } else {
                    dArray6[0][n3] = Double.NaN;
                    dArray6[1][n3] = Double.NaN;
                }
                ++n3;
            }
            flatField5.setSamples(dArray6);
            fieldImpl5.setSample(n2, (Data)flatField5.resample(linear1DSet, 101, 202), false);
            ++n2;
        }
        return fieldImpl5;
    }

    public static VisADTriangleStripArray makeCylinder(int n, float f, float f2) {
        int n2;
        float[][] fArray = new float[2][n];
        double d = Math.PI * 2 / (double)n;
        double d2 = d / 2.0;
        int[] nArray = new int[n + 1];
        int n3 = 0;
        while (n3 < n) {
            fArray[0][n3] = (float)Math.cos(d2);
            fArray[1][n3] = (float)Math.sin(d2);
            d2 += d;
            nArray[n3] = n3;
            ++n3;
        }
        nArray[n] = 0;
        VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
        visADTriangleStripArray.vertexCount = 2 * (n + 1);
        visADTriangleStripArray.coordinates = new float[visADTriangleStripArray.vertexCount * 3];
        visADTriangleStripArray.normals = new float[visADTriangleStripArray.vertexCount * 3];
        visADTriangleStripArray.stripVertexCounts = new int[1];
        visADTriangleStripArray.stripVertexCounts[0] = visADTriangleStripArray.vertexCount;
        int n4 = 0;
        while (n4 < n + 1) {
            n2 = n4 * 6;
            visADTriangleStripArray.coordinates[n2] = f * fArray[0][nArray[n4]];
            visADTriangleStripArray.coordinates[n2 + 1] = f * fArray[1][nArray[n4]];
            visADTriangleStripArray.coordinates[n2 + 2] = f2;
            visADTriangleStripArray.coordinates[n2 += 3] = f * fArray[0][nArray[n4]];
            visADTriangleStripArray.coordinates[n2 + 1] = f * fArray[1][nArray[n4]];
            visADTriangleStripArray.coordinates[n2 + 2] = -f2;
            ++n4;
        }
        n4 = 0;
        while (n4 < n + 1) {
            n2 = n4 * 6;
            visADTriangleStripArray.normals[n2] = fArray[0][nArray[n4]];
            visADTriangleStripArray.normals[n2 + 1] = fArray[1][nArray[n4]];
            visADTriangleStripArray.normals[n2 + 2] = 0.0f;
            visADTriangleStripArray.normals[n2 += 3] = fArray[0][nArray[n4]];
            visADTriangleStripArray.normals[n2 + 1] = fArray[1][nArray[n4]];
            visADTriangleStripArray.normals[n2 + 2] = 0.0f;
            ++n4;
        }
        return visADTriangleStripArray;
    }

    public Qdiv(String[] stringArray) throws VisADException, RemoteException, IOException {
        Object object;
        String string = null;
        String string2 = "19991226";
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                if (stringArray[n].endsWith(".vad")) {
                    string = stringArray[n];
                } else if (stringArray[n].equals("-limit") && n + 1 < stringArray.length) {
                    try {
                        this.height_limit = Integer.parseInt(stringArray[n + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("bad height limit: " + stringArray[n + 1]);
                    }
                    ++n;
                } else if (stringArray[n].equals("-date") && n + 1 < stringArray.length) {
                    string2 = stringArray[n + 1];
                    ++n;
                } else if (stringArray[n].equals("-rh")) {
                    this.rh = true;
                    this.tm = false;
                } else if (stringArray[n].equals("-temp")) {
                    this.tm = true;
                    this.rh = false;
                } else if (stringArray[n].equals("-theta")) {
                    this.pt = true;
                } else if (stringArray[n].equals("-thetaE")) {
                    this.ept = true;
                }
            }
            ++n;
        }
        if (string != null) {
            this.init_from_vad(string);
        } else {
            this.init_from_cdf(string2);
        }
        this.wvmr.alias("MR");
        this.temp.alias("T");
        try {
            object = System.getProperty("file.separator");
            this.image_seq = Qdiv.init_images("." + (String)object + "data" + (String)object + "image" + (String)object + string2);
            this.band1 = (RealType)((RealTupleType)((FunctionType)((FunctionType)this.image_seq.getType()).getRange()).getRange()).getComponent(0);
        }
        catch (Exception exception) {
            System.out.println("no AREA image data");
            this.image_seq = null;
        }
        object = new JFrame("VisAD AERI/QDIV Viewer");
        ((Window)object).addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ Qdiv this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = qdiv;
                this.constructor$0(qdiv);
            }

            private final void constructor$0(Qdiv qdiv) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ((JFrame)object).getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        DisplayImpl displayImpl = this.makeDisplay(jPanel, jPanel2);
        int n2 = 1200;
        int n3 = 800;
        ((Component)object).setSize(n2, n3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)object).setLocation(dimension.width / 2 - n2 / 2, dimension.height / 2 - n3 / 2);
        ((Component)object).setVisible(true);
        JFrame jFrame = new JFrame("image color");
        ((Component)jFrame).setSize(400, 200);
        jFrame.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ Qdiv this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = qdiv;
                this.constructor$0(qdiv);
            }

            private final void constructor$0(Qdiv qdiv) {
            }
        });
        jFrame.getContentPane().add(jPanel2);
    }
}

