/*
 * Decompiled with CFR 0.152.
 */
package visad.aeri;

import java.lang.reflect.InvocationTargetException;
import visad.CoordinateSystem;
import visad.FlatField;
import visad.VisADException;
import visad.data.hdfeos.PolarStereographic;
import visad.matrix.JamaMatrix;

public class LinearVectorPointMethod {
    JamaMatrix jm_A;
    double scale_1;
    double scale_2;
    double scale_3;
    double[][] centroid_ll;

    public double[][] getCentroid() {
        return this.centroid_ll;
    }

    public double[] getKinematics(double[][] dArray) throws VisADException {
        double[][] dArray2 = new double[1][6];
        dArray2[0][0] = dArray[0][0] / this.scale_1;
        dArray2[0][1] = dArray[1][0] / this.scale_1;
        dArray2[0][2] = dArray[0][1] / this.scale_2;
        dArray2[0][3] = dArray[1][1] / this.scale_2;
        dArray2[0][4] = dArray[0][2] / this.scale_3;
        dArray2[0][5] = dArray[1][2] / this.scale_3;
        FlatField flatField = null;
        try {
            JamaMatrix jamaMatrix = new JamaMatrix(dArray2);
            flatField = this.jm_A.solve(jamaMatrix.transpose());
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return flatField.getValues()[0];
    }

    public static void main(String[] stringArray) throws VisADException {
        double[][] dArray = new double[2][3];
        dArray[0][0] = -1.7014342213066722;
        dArray[1][0] = 0.6388777726925243;
        dArray[0][1] = -1.7314364311484545;
        dArray[1][1] = 0.6295751677793946;
        dArray[0][2] = -1.7020799931299102;
        dArray[1][2] = 0.6105859855176963;
        LinearVectorPointMethod linearVectorPointMethod = new LinearVectorPointMethod(dArray);
        double[][] dArray2 = new double[2][3];
        dArray2[0][0] = 6.5;
        dArray2[1][0] = 19.8;
        dArray2[0][1] = 11.0;
        dArray2[1][1] = 9.2;
        dArray2[0][2] = 8.2;
        dArray2[1][2] = 11.7;
        double[] dArray3 = linearVectorPointMethod.getKinematics(dArray2);
        int n = 0;
        while (n < dArray3.length) {
            System.out.println(dArray3[n]);
            ++n;
        }
        System.out.println(Double.NaN);
    }

    private static double[] triangleCentroid(double[][] dArray) {
        double[] dArray2 = new double[2];
        double[][] dArray3 = new double[2][1];
        double[][] dArray4 = new double[2][1];
        double[][] dArray5 = new double[2][3];
        dArray5[0][0] = dArray[0][0];
        dArray5[0][1] = dArray[0][1];
        dArray5[0][2] = dArray[0][2];
        dArray5[1][0] = dArray[1][0];
        dArray5[1][1] = dArray[1][1];
        dArray5[1][2] = dArray[1][2];
        boolean bl = false;
        dArray3[0][0] = (dArray5[0][1] - dArray5[0][0]) / 2.0 + dArray5[0][0];
        dArray3[1][0] = (dArray5[1][1] - dArray5[1][0]) / 2.0 + dArray5[1][0];
        dArray4[0][0] = (dArray5[0][2] - dArray5[0][0]) / 2.0 + dArray5[0][0];
        dArray4[1][0] = (dArray5[1][2] - dArray5[1][0]) / 2.0 + dArray5[1][0];
        double d = (dArray5[1][2] - dArray3[1][0]) / (dArray5[0][2] - dArray3[0][0]);
        double d2 = (dArray5[1][1] - dArray4[1][0]) / (dArray5[0][1] - dArray4[0][0]);
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            System.out.println("infinite slope");
            LinearVectorPointMethod.rotate_clockwise(dArray5, 1.5707963267948966);
            LinearVectorPointMethod.rotate_clockwise(dArray3, 1.5707963267948966);
            LinearVectorPointMethod.rotate_clockwise(dArray4, 1.5707963267948966);
            bl = true;
        }
        double d3 = dArray5[1][2] - d * dArray5[0][2];
        double d4 = dArray5[1][1] - d2 * dArray5[0][1];
        dArray2[0] = (d3 - d4) / (d2 - d);
        dArray2[1] = d * dArray2[0] + d3;
        if (bl) {
            double[][] dArray6 = new double[2][1];
            dArray6[0][0] = dArray2[0];
            dArray6[1][0] = dArray2[1];
            LinearVectorPointMethod.rotate_clockwise(dArray6, -1.5707963267948966);
            dArray2[0] = dArray6[0][0];
            dArray2[1] = dArray6[1][0];
        }
        return dArray2;
    }

    private static void rotate_clockwise(double[][] dArray, double d) {
        int n = 0;
        while (n < dArray[0].length) {
            double d2 = dArray[0][n];
            double d3 = dArray[1][n];
            double d4 = Math.atan2(d3, d2);
            double d5 = Math.sqrt(d2 * d2 + d3 * d3);
            dArray[0][n] = d5 * Math.cos(d4 - d);
            dArray[1][n] = d5 * Math.sin(d4 - d);
            ++n;
        }
    }

    public LinearVectorPointMethod(double[][] dArray) throws VisADException {
        if (dArray[0].length != 3) {
            throw new VisADException("number of points must equal 3");
        }
        this.scale_1 = 1.0;
        this.scale_2 = (1.0 + Math.sin(dArray[1][0])) / (1.0 + Math.sin(dArray[1][1]));
        this.scale_3 = (1.0 + Math.sin(dArray[1][0])) / (1.0 + Math.sin(dArray[1][2]));
        PolarStereographic polarStereographic = new PolarStereographic(dArray[0][0], dArray[1][0]);
        double[][] dArray2 = ((CoordinateSystem)polarStereographic).fromReference(dArray);
        double[][] dArray3 = new double[2][dArray[0].length];
        double[] dArray4 = LinearVectorPointMethod.triangleCentroid(dArray2);
        this.centroid_ll = ((CoordinateSystem)polarStereographic).toReference(new double[][]{{dArray4[0]}, {dArray4[1]}});
        System.out.println("centroid lon: " + this.centroid_ll[0][0] * 57.29577951308232);
        System.out.println("centroid lat: " + this.centroid_ll[1][0] * 57.29577951308232);
        double d = (1.0 + Math.sin(dArray[1][0])) / (1.0 + Math.sin(this.centroid_ll[1][0]));
        double d2 = d * d;
        dArray3[0][0] = dArray2[0][0] - dArray4[0];
        dArray3[1][0] = dArray2[1][0] - dArray4[1];
        dArray3[0][1] = dArray2[0][1] - dArray4[0];
        dArray3[1][1] = dArray2[1][1] - dArray4[1];
        dArray3[0][2] = dArray2[0][2] - dArray4[0];
        dArray3[1][2] = dArray2[1][2] - dArray4[1];
        double[][] dArray5 = new double[6][6];
        dArray5[0][0] = 1.0;
        dArray5[0][1] = 0.0;
        dArray5[0][2] = 1.0;
        dArray5[0][3] = 0.0;
        dArray5[0][4] = 1.0;
        dArray5[0][5] = 0.0;
        dArray5[1][0] = 0.0;
        dArray5[1][1] = 1.0;
        dArray5[1][2] = 0.0;
        dArray5[1][3] = 1.0;
        dArray5[1][4] = 0.0;
        dArray5[1][5] = 1.0;
        dArray5[2][0] = dArray3[0][0] / d2;
        dArray5[2][1] = -dArray3[1][0] / d2;
        dArray5[2][2] = dArray3[0][1] / d2;
        dArray5[2][3] = -dArray3[1][1] / d2;
        dArray5[2][4] = dArray3[0][2] / d2;
        dArray5[2][5] = -dArray3[1][2] / d2;
        dArray5[3][0] = dArray3[1][0] / d2;
        dArray5[3][1] = dArray3[0][0] / d2;
        dArray5[3][2] = dArray3[1][1] / d2;
        dArray5[3][3] = dArray3[0][1] / d2;
        dArray5[3][4] = dArray3[1][2] / d2;
        dArray5[3][5] = dArray3[0][2] / d2;
        dArray5[4][0] = dArray3[0][0] / d2;
        dArray5[4][1] = dArray3[1][0] / d2;
        dArray5[4][2] = dArray3[0][1] / d2;
        dArray5[4][3] = dArray3[1][1] / d2;
        dArray5[4][4] = dArray3[0][2] / d2;
        dArray5[4][5] = dArray3[1][2] / d2;
        dArray5[5][0] = -dArray3[1][0] / d2;
        dArray5[5][1] = dArray3[0][0] / d2;
        dArray5[5][2] = -dArray3[1][1] / d2;
        dArray5[5][3] = dArray3[0][1] / d2;
        dArray5[5][4] = -dArray3[1][2] / d2;
        dArray5[5][5] = dArray3[0][2] / d2;
        try {
            this.jm_A = new JamaMatrix(dArray5);
            this.jm_A = this.jm_A.transpose();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

