/*
 * Decompiled with CFR 0.152.
 */
package visad.aeri;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.BaseColorControl;
import visad.ColorControl;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.ThingReference;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.bom.WindPolarCoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.data.netcdf.Plain;
import visad.data.visad.VisADSerialForm;
import visad.java3d.DisplayImplJ3D;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceManager;
import visad.meteorology.NavigatedImage;
import visad.meteorology.SingleBandedImage;
import visad.util.AnimationWidget;
import visad.util.ColorMapWidget;
import visad.util.LabeledColorWidget;

public class Aeri
implements ScalarMapListener {
    RealType latitude;
    RealType longitude;
    RealType altitude;
    RealTupleType spatial_domain;
    RealType time;
    RealType stn_idx;
    RealType temp;
    RealType dwpt;
    RealType wvmr;
    RealType RH;
    RealType theta;
    RealType thetaE;
    RealType band1 = null;
    RealTupleType advect_range;
    FunctionType advect_type;
    FunctionType advect_field_type;
    FieldImpl advect_field;
    FieldImpl stations_field;
    ImageSequence image_seq;
    int n_stations = 5;
    double[] station_lat;
    double[] station_lon;
    double[] station_alt;
    double[] station_id;
    BaseMapAdapter baseMap;
    DataReference map_ref;
    DataReference img_ref;
    ScalarMap xmap;
    ScalarMap ymap;
    ScalarMap zmap;
    ScalarMap img_map;
    boolean xmapEvent = false;
    boolean ymapEvent = false;
    boolean imgEvent = false;
    boolean first_xy_Event = false;
    boolean first_img_Event = false;
    float latmin;
    float latmax;
    float lonmin;
    float lonmax;
    float del_lat;
    float del_lon;
    double[] x_range;
    double[] y_range;
    int height_limit = 3000;
    boolean rh = false;
    boolean tm = false;
    boolean pt = false;
    boolean ept = false;
    int start_date = 0;
    double start_time = 0.0;
    double lon_min = Double.MAX_VALUE;
    double lon_max = -1.7976931348623157E308;
    double lat_min = Double.MAX_VALUE;
    double lat_max = -1.7976931348623157E308;
    double hgt_max = -1.7976931348623157E308;

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        Aeri aeri = new Aeri(stringArray);
    }

    void init_from_cdf(String string) throws VisADException, RemoteException, IOException {
        this.station_lat = new double[this.n_stations];
        this.station_lon = new double[this.n_stations];
        this.station_alt = new double[this.n_stations];
        this.station_id = new double[this.n_stations];
        this.longitude = RealType.Longitude;
        this.latitude = RealType.Latitude;
        this.RH = new RealType("RH", (Unit)SI.second, null);
        this.stn_idx = new RealType("stn_idx", null, null);
        this.theta = new RealType("theta", null, null);
        this.thetaE = new RealType("thetaE", null, null);
        String[] stringArray = new String[this.n_stations];
        String[] stringArray2 = new String[this.n_stations];
        String string2 = string;
        stringArray[0] = "./data/" + string + "_lamont_windprof.cdf";
        stringArray[1] = "./data/" + string + "_hillsboro_windprof.cdf";
        stringArray[2] = "./data/" + string + "_morris_windprof.cdf";
        stringArray[3] = "./data/" + string + "_purcell_windprof.cdf";
        stringArray[4] = "./data/" + string + "_vici_windprof.cdf";
        File file = new File("./data/lamont_" + string2 + "AP.cdf");
        stringArray2[0] = file.exists() ? "./data/lamont_" + string2 + "AP.cdf" : "./data/lamont_" + string2 + "AG.cdf";
        file = new File("./data/hillsboro_" + string2 + "AP.cdf");
        stringArray2[1] = file.exists() ? "./data/hillsboro_" + string2 + "AP.cdf" : "./data/hillsboro_" + string2 + "AG.cdf";
        file = new File("./data/morris_" + string2 + "AP.cdf");
        stringArray2[2] = file.exists() ? "./data/morris_" + string2 + "AP.cdf" : "./data/morris_" + string2 + "AG.cdf";
        file = new File("./data/purcell_" + string2 + "AP.cdf");
        stringArray2[3] = file.exists() ? "./data/purcell_" + string2 + "AP.cdf" : "./data/purcell_" + string2 + "AG.cdf";
        file = new File("./data/vici_" + string2 + "AP.cdf");
        stringArray2[4] = file.exists() ? "./data/vici_" + string2 + "AP.cdf" : "./data/vici_" + string2 + "AG.cdf";
        FieldImpl[] fieldImplArray = this.makeWinds(stringArray);
        System.out.println(fieldImplArray[0].getType().prettyString());
        FieldImpl[] fieldImplArray2 = this.makeAeri(stringArray2);
        System.out.println(fieldImplArray2[0].getType().prettyString());
        this.spatial_domain = new RealTupleType(this.longitude, this.latitude, this.altitude);
        RealType[] realTypeArray = new RealType[]{this.temp, this.dwpt, this.wvmr, this.RH, this.theta, this.thetaE};
        this.advect_range = new RealTupleType(realTypeArray);
        this.advect_type = new FunctionType(this.spatial_domain, this.advect_range);
        this.advect_field_type = new FunctionType(RealType.Time, this.advect_type);
        this.stations_field = new FieldImpl(new FunctionType(this.stn_idx, this.advect_field_type), new Integer1DSet(this.stn_idx, this.n_stations, null, null, null));
        int n = 0;
        while (n < this.n_stations) {
            this.advect_field = this.makeAdvect(fieldImplArray[n], fieldImplArray2[n], n);
            this.stations_field.setSample(n, (Data)this.advect_field);
            ++n;
        }
        VisADSerialForm visADSerialForm = new VisADSerialForm();
        visADSerialForm.save("aeri_winds_" + string + "." + this.height_limit + ".vad", this.stations_field, true);
        System.out.println(this.stations_field.getType().prettyString());
    }

    void init_from_vad(String string) throws VisADException, RemoteException, IOException {
        VisADSerialForm visADSerialForm = new VisADSerialForm();
        this.stations_field = (FieldImpl)visADSerialForm.open(string);
        MathType mathType = this.stations_field.getType();
        this.stn_idx = (RealType)((FunctionType)mathType).getDomain().getComponent(0);
        FunctionType functionType = (FunctionType)((FunctionType)mathType).getRange();
        this.time = (RealType)functionType.getDomain().getComponent(0);
        FunctionType functionType2 = (FunctionType)functionType.getRange();
        this.spatial_domain = functionType2.getDomain();
        this.longitude = (RealType)this.spatial_domain.getComponent(0);
        this.latitude = (RealType)this.spatial_domain.getComponent(1);
        this.altitude = (RealType)this.spatial_domain.getComponent(2);
        RealTupleType realTupleType = (RealTupleType)functionType2.getRange();
        this.temp = (RealType)realTupleType.getComponent(0);
        this.dwpt = (RealType)realTupleType.getComponent(1);
        this.wvmr = (RealType)realTupleType.getComponent(2);
        this.RH = (RealType)realTupleType.getComponent(3);
        this.theta = (RealType)realTupleType.getComponent(4);
        this.thetaE = (RealType)realTupleType.getComponent(5);
    }

    public static ImageSequence init_images(String string) throws VisADException, RemoteException, IOException {
        String string2 = System.getProperty("file.separator");
        if (string == null) {
            string = "." + string2 + "data" + string2 + "image" + string2 + "ir_display";
        }
        File file = new File(string);
        String[] stringArray = file.list();
        int n = stringArray.length;
        SingleBandedImage[] singleBandedImageArray = new NavigatedImage[n];
        int n2 = 0;
        while (n2 < n) {
            AreaAdapter areaAdapter = new AreaAdapter(string + string2 + stringArray[n2]);
            FlatField flatField = areaAdapter.getData();
            DateTime dateTime = areaAdapter.getImageStartTime();
            singleBandedImageArray[n2] = new NavigatedImage(flatField, dateTime, "AREA");
            ++n2;
        }
        ImageSequenceManager imageSequenceManager = new ImageSequenceManager(singleBandedImageArray);
        return imageSequenceManager.getImageSequence();
    }

    DisplayImpl makeDisplay(JPanel jPanel) throws VisADException, RemoteException, IOException {
        Object object;
        this.del_lon = 15.0f;
        this.del_lat = 15.0f;
        this.baseMap = new BaseMapAdapter("OUTLUSAM");
        this.map_ref = new DataReferenceImpl("map");
        if (!this.baseMap.isEastPositive()) {
            this.baseMap.setEastPositive(true);
        }
        DataImpl dataImpl = this.makePoles();
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("poles");
        dataReferenceImpl.setData(dataImpl);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("aeri");
        GraphicsModeControl graphicsModeControl = ((DisplayImpl)displayImplJ3D).getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        DisplayRenderer displayRenderer = displayImplJ3D.getDisplayRenderer();
        displayRenderer.setBoxOn(false);
        this.xmap = new ScalarMap(this.longitude, Display.XAxis);
        this.xmap.setScaleEnable(false);
        this.ymap = new ScalarMap(this.latitude, Display.YAxis);
        this.ymap.setScaleEnable(false);
        this.zmap = new ScalarMap(this.altitude, Display.ZAxis);
        displayImplJ3D.addMap(this.xmap);
        displayImplJ3D.addMap(this.ymap);
        displayImplJ3D.addMap(this.zmap);
        ScalarMap scalarMap = null;
        scalarMap = this.rh ? new ScalarMap(this.RH, Display.RGB) : (this.tm ? new ScalarMap(this.temp, Display.RGB) : (this.pt ? new ScalarMap(this.theta, Display.RGB) : (this.ept ? new ScalarMap(this.thetaE, Display.RGB) : new ScalarMap(this.wvmr, Display.RGB))));
        displayImplJ3D.addMap(scalarMap);
        ColorMapWidget colorMapWidget = new ColorMapWidget(scalarMap, null, true, false);
        LabeledColorWidget labeledColorWidget = new LabeledColorWidget(colorMapWidget);
        ScalarMap scalarMap2 = new ScalarMap(RealType.Time, Display.Animation);
        displayImplJ3D.addMap(scalarMap2);
        AnimationControl animationControl = (AnimationControl)((Object)scalarMap2.getControl());
        animationControl.setStep(50);
        AnimationWidget animationWidget = new AnimationWidget(scalarMap2);
        if (this.image_seq != null) {
            this.img_map = new ScalarMap(this.band1, Display.RGB);
            this.img_map.addScalarMapListener(this);
            displayImplJ3D.addMap(this.img_map);
            object = (ColorControl)this.img_map.getControl();
            ((BaseColorControl)object).initGreyWedge();
        }
        this.zmap.setRange(0.0, this.hgt_max);
        object = new DataReferenceImpl("advect_ref");
        object.setData(this.stations_field);
        ConstantMap[] constantMapArray = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(1.0, Display.Blue), new ConstantMap(-0.98, Display.ZAxis)};
        ConstantMap[] constantMapArray2 = new ConstantMap[]{new ConstantMap(-0.99, Display.ZAxis)};
        this.img_ref = new DataReferenceImpl("image");
        displayImplJ3D.disableAction();
        displayImplJ3D.addReference(dataReferenceImpl);
        displayImplJ3D.addReference((ThingReference)object);
        displayImplJ3D.addReference(this.map_ref, constantMapArray);
        if (this.image_seq != null) {
            displayImplJ3D.addReference(this.img_ref, constantMapArray2);
        }
        this.xmap.addScalarMapListener(this);
        this.ymap.addScalarMapListener(this);
        displayImplJ3D.enableAction();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(displayImplJ3D.getComponent());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        labeledColorWidget.setMaximumSize(new Dimension(400, 200));
        animationWidget.setMaximumSize(new Dimension(400, 400));
        jPanel3.add(labeledColorWidget);
        jPanel3.add(animationWidget);
        Dimension dimension = new Dimension(400, 600);
        jPanel3.setMaximumSize(dimension);
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        return displayImplJ3D;
    }

    DataImpl makePoles() throws VisADException, RemoteException {
        SampledSet[] sampledSetArray = new SampledSet[this.n_stations];
        int n = 0;
        float[][] fArray = new float[3][2];
        int n2 = 0;
        while (n2 < this.n_stations) {
            boolean bl = false;
            float f = -3.4028235E38f;
            FieldImpl fieldImpl = (FieldImpl)this.stations_field.getSample(n2);
            if (fieldImpl != null) {
                int n3 = fieldImpl.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    FieldImpl fieldImpl2 = (FieldImpl)fieldImpl.getSample(n4);
                    if (fieldImpl2 != null && fieldImpl2.getLength() >= 2) {
                        Set set = fieldImpl2.getDomainSet();
                        float[][] fArray2 = set.getSamples(false);
                        float[] fArray3 = ((SampledSet)set).getHi();
                        if (fArray3[2] > f) {
                            f = fArray3[2];
                        }
                        if (!bl && fArray2[0][0] == fArray2[0][0] && fArray2[1][0] == fArray2[1][0]) {
                            bl = true;
                            fArray[0][0] = fArray2[0][0];
                            fArray[1][0] = fArray2[1][0];
                            fArray[0][1] = fArray2[0][0];
                            fArray[1][1] = fArray2[1][0];
                            if ((double)fArray2[0][0] > this.lat_max) {
                                this.lat_max = fArray2[0][0];
                            }
                            if ((double)fArray2[0][0] < this.lat_min) {
                                this.lat_min = fArray2[0][0];
                            }
                            if ((double)fArray2[1][0] > this.lon_max) {
                                this.lon_max = fArray2[1][0];
                            }
                            if ((double)fArray2[1][0] < this.lon_min) {
                                this.lon_min = fArray2[1][0];
                            }
                        }
                    }
                    ++n4;
                }
                if (bl) {
                    fArray[2][0] = 0.0f;
                    fArray[2][1] = f;
                    sampledSetArray[n++] = new Gridded3DSet((MathType)this.spatial_domain, fArray, 2, null, null, null);
                    if ((double)f > this.hgt_max) {
                        this.hgt_max = f;
                    }
                }
            }
            ++n2;
        }
        SampledSet[] sampledSetArray2 = new SampledSet[n];
        System.arraycopy(sampledSetArray, 0, sampledSetArray2, 0, n);
        return new UnionSet((MathType)this.spatial_domain, sampledSetArray2);
    }

    public void mapChanged(ScalarMapEvent scalarMapEvent) throws VisADException, RemoteException {
        Object object;
        if (this.xmap.equals(scalarMapEvent.getScalarMap())) {
            this.xmapEvent = true;
        } else if (this.ymap.equals(scalarMapEvent.getScalarMap())) {
            this.ymapEvent = true;
        } else if (this.img_map.equals(scalarMapEvent.getScalarMap())) {
            this.imgEvent = true;
        }
        if (this.xmapEvent && this.ymapEvent && !this.first_xy_Event) {
            this.x_range = this.xmap.getRange();
            this.y_range = this.ymap.getRange();
            this.latmin = (float)this.y_range[0];
            this.latmax = (float)this.y_range[1];
            this.lonmin = (float)this.x_range[0];
            this.lonmax = (float)this.x_range[1];
            this.baseMap.setLatLonLimits(this.latmin - this.del_lat, this.latmax + this.del_lat, this.lonmin - this.del_lon, this.lonmax + this.del_lon);
            object = this.baseMap.getData();
            this.map_ref.setData((Data)object);
            this.first_xy_Event = true;
            this.xmap.setRange(this.lonmin, this.lonmax);
            this.ymap.setRange(this.latmin, this.latmax);
            this.img_ref.setData(this.image_seq);
        }
        if (this.imgEvent && !this.first_img_Event) {
            object = this.img_map.getRange();
            System.out.println(object[0] + " " + object[1]);
            this.first_img_Event = true;
            this.img_map.setRange(object[1], object[0]);
        }
    }

    public void controlChanged(ScalarMapControlEvent scalarMapControlEvent) {
    }

    FieldImpl[] makeWinds(String[] stringArray) throws VisADException, RemoteException, IOException {
        RealType realType;
        DataImpl[] dataImplArray = new DataImpl[this.n_stations];
        FieldImpl[] fieldImplArray = new FieldImpl[this.n_stations];
        double[][] dArray = null;
        double[] dArray2 = new double[this.n_stations];
        double[] dArray3 = new double[this.n_stations];
        Gridded1DSet gridded1DSet = null;
        FlatField flatField = null;
        RealType realType2 = new RealType("u_wind", null, null);
        RealType realType3 = new RealType("v_wind", null, null);
        Plain plain = new Plain();
        int n = 0;
        while (n < this.n_stations) {
            dataImplArray[n] = plain.open(stringArray[n]);
            ++n;
        }
        MathType mathType = dataImplArray[0].getType();
        System.out.println(mathType.prettyString());
        System.out.println();
        FunctionType functionType = (FunctionType)((TupleType)mathType).getComponent(2);
        TupleType tupleType = (TupleType)functionType.getRange();
        int n2 = tupleType.getDimension() - 1;
        FunctionType functionType2 = (FunctionType)tupleType.getComponent(n2);
        RealTupleType realTupleType = (RealTupleType)functionType2.getRange();
        int n3 = realTupleType.getIndex("Altitude");
        this.altitude = (RealType)realTupleType.getComponent(n3);
        int n4 = realTupleType.getIndex("windSpeed");
        RealType realType4 = (RealType)realTupleType.getComponent(n4);
        int n5 = realTupleType.getIndex("windDir");
        RealType realType5 = (RealType)realTupleType.getComponent(n5);
        RealType[] realTypeArray = new RealType[]{realType5, realType4};
        RealType[] realTypeArray2 = new RealType[]{realType2, realType3};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        WindPolarCoordinateSystem windPolarCoordinateSystem = new WindPolarCoordinateSystem(realTupleType2);
        RealTupleType realTupleType3 = new RealTupleType(realTypeArray, (CoordinateSystem)windPolarCoordinateSystem, null);
        FunctionType functionType3 = new FunctionType(this.altitude, realTupleType3);
        FunctionType functionType4 = new FunctionType(this.altitude, realTupleType2);
        this.time = realType = (RealType)((TupleType)functionType.getRange()).getComponent(0);
        FunctionType functionType5 = new FunctionType(RealType.Time, functionType4);
        FieldImpl[] fieldImplArray2 = new FieldImpl[this.n_stations];
        int n6 = 0;
        while (n6 < this.n_stations) {
            DataImpl dataImpl;
            dArray2[n6] = ((Real)((Tuple)dataImplArray[n6]).getComponent(0)).getValue();
            dArray3[n6] = ((Real)((Tuple)dataImplArray[n6]).getComponent(1)).getValue();
            fieldImplArray[n6] = (FieldImpl)((Tuple)dataImplArray[n6]).getComponent(2);
            this.station_lat[n6] = ((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(6)).getValue();
            this.station_lon[n6] = -((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(7)).getValue();
            this.station_alt[n6] = ((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(8)).getValue();
            this.station_id[n6] = ((Real)((Tuple)fieldImplArray[n6].getSample(0)).getComponent(9)).getValue();
            if (n6 == 0) {
                this.start_time = dArray3[0];
                this.start_date = (int)dArray2[0];
            }
            int n7 = fieldImplArray[n6].getLength();
            dArray = new double[1][n7];
            Data[] dataArray = new FlatField[n7];
            double[][] dArray4 = null;
            int n8 = 0;
            while (n8 < n7) {
                dataImpl = (Tuple)fieldImplArray[n6].getSample(n8);
                dArray[0][n8] = ((Real)((Tuple)dataImpl).getComponent(0)).getValue();
                FlatField flatField2 = (FlatField)((Tuple)dataImpl).getComponent(n2);
                double[][] dArray5 = flatField2.getValues();
                double[][] dArray6 = new double[2][dArray5[0].length];
                if (n8 == 0) {
                    dArray4 = new double[1][dArray5[0].length];
                    System.arraycopy(dArray5[n3], 0, dArray4[0], 0, dArray4[0].length);
                    gridded1DSet = new Gridded1DSet((MathType)this.altitude, Set.doubleToFloat(dArray4), dArray4[0].length);
                }
                flatField = new FlatField(functionType4, gridded1DSet);
                int n9 = 0;
                int[] nArray = new int[dArray5[0].length];
                int n10 = 0;
                while (n10 < dArray5[0].length) {
                    dArray6[0][n10] = dArray5[n5][n10] <= -9999.0 ? Double.NaN : dArray5[n5][n10];
                    dArray6[1][n10] = dArray5[n4][n10] <= -9999.0 ? Double.NaN : dArray5[n4][n10];
                    if (dArray6[0][n10] == dArray6[0][n10] && dArray6[1][n10] == dArray6[1][n10]) {
                        nArray[n9] = n10;
                        ++n9;
                    }
                    ++n10;
                }
                if (n9 > 0 && n9 < dArray5[0].length) {
                    int n11;
                    n10 = n9;
                    if (nArray[0] > 0) {
                        n10 += nArray[0];
                    }
                    if ((n11 = dArray5[0].length - (nArray[n9 - 1] + 1)) > 0) {
                        n10 += n11;
                    }
                    float[][] fArray = new float[2][n10];
                    float[][] fArray2 = new float[1][n10];
                    int n12 = 0;
                    while (n12 < n9) {
                        fArray[0][nArray[0] + n12] = (float)dArray6[0][nArray[n12]];
                        fArray[1][nArray[0] + n12] = (float)dArray6[1][nArray[n12]];
                        fArray2[0][nArray[0] + n12] = (float)dArray4[0][nArray[n12]];
                        ++n12;
                    }
                    n12 = 0;
                    while (n12 < nArray[0]) {
                        fArray[0][n12] = (float)dArray6[0][nArray[0]];
                        fArray[1][n12] = (float)dArray6[1][nArray[0]];
                        fArray2[0][n12] = (float)dArray4[0][nArray[0]];
                        ++n12;
                    }
                    n12 = 0;
                    while (n12 < n11) {
                        fArray[0][nArray[0] + n9 + n12] = (float)dArray6[0][nArray[n9 - 1]];
                        fArray[1][nArray[0] + n9 + n12] = (float)dArray6[1][nArray[n9 - 1]];
                        fArray2[0][nArray[0] + n9 + n12] = (float)dArray4[0][nArray[n9 - 1]];
                        ++n12;
                    }
                    Gridded1DSet gridded1DSet2 = new Gridded1DSet((MathType)this.altitude, fArray2, n10);
                    FlatField flatField3 = new FlatField(functionType4, gridded1DSet2);
                    flatField3.setSamples(((CoordinateSystem)windPolarCoordinateSystem).toReference(fArray));
                    flatField = (FlatField)flatField3.resample(gridded1DSet, 101, 202);
                } else {
                    flatField.setSamples(((CoordinateSystem)windPolarCoordinateSystem).toReference(dArray6));
                }
                dataArray[n8] = flatField;
                ++n8;
            }
            double[][] dArray7 = new double[1][n7];
            int n13 = 0;
            while (n13 < n7) {
                dArray7[0][n13] = dArray3[0] + dArray[0][n13];
                ++n13;
            }
            dataImpl = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(dArray7), n7);
            fieldImplArray2[n6] = new FieldImpl(functionType5, (Set)dataImpl);
            fieldImplArray2[n6].setSamples(dataArray, false);
            ++n6;
        }
        plain = null;
        return fieldImplArray2;
    }

    FieldImpl[] makeAeri(String[] stringArray) throws VisADException, RemoteException, IOException {
        DataImpl[] dataImplArray = new DataImpl[this.n_stations];
        FieldImpl[] fieldImplArray = new FieldImpl[this.n_stations];
        double[] dArray = new double[this.n_stations];
        double[] dArray2 = new double[this.n_stations];
        double[] dArray3 = new double[this.n_stations];
        double[] dArray4 = new double[this.n_stations];
        double[][] dArray5 = null;
        double[] dArray6 = new double[this.n_stations];
        double[] dArray7 = new double[this.n_stations];
        Plain plain = new Plain();
        int n = 0;
        while (n < this.n_stations) {
            dataImplArray[n] = plain.open(stringArray[n]);
            ++n;
        }
        System.out.println(dataImplArray[0].getType().prettyString());
        MathType mathType = dataImplArray[0].getType();
        FunctionType functionType = (FunctionType)((TupleType)mathType).getComponent(1);
        FunctionType functionType2 = (FunctionType)((TupleType)functionType.getRange()).getComponent(1);
        RealTupleType realTupleType = (RealTupleType)functionType2.getRange();
        this.temp = (RealType)realTupleType.getComponent(1);
        this.dwpt = (RealType)realTupleType.getComponent(2);
        this.wvmr = (RealType)realTupleType.getComponent(3);
        RealType realType = (RealType)((TupleType)functionType.getRange()).getComponent(0);
        FunctionType functionType3 = new FunctionType(RealType.Time, functionType2);
        FieldImpl[] fieldImplArray2 = new FieldImpl[this.n_stations];
        int n2 = 0;
        while (n2 < this.n_stations) {
            DataImpl dataImpl;
            dArray7[n2] = ((Real)((Tuple)dataImplArray[n2]).getComponent(0)).getValue();
            fieldImplArray[n2] = (FieldImpl)((Tuple)dataImplArray[n2]).getComponent(1);
            dArray6[n2] = ((Real)((Tuple)dataImplArray[n2]).getComponent(2)).getValue();
            int n3 = fieldImplArray[n2].getLength();
            dArray5 = new double[1][n3];
            Data[] dataArray = new Data[n3];
            int n4 = 0;
            while (n4 < n3) {
                dataImpl = (Tuple)fieldImplArray[n2].getSample(n4);
                dArray5[0][n4] = ((Real)((Tuple)dataImpl).getComponent(0)).getValue();
                FlatField flatField = (FlatField)((Tuple)dataImpl).getComponent(1);
                double[][] dArray8 = flatField.getValues();
                double[][] dArray9 = new double[4][dArray8[0].length];
                int n5 = 0;
                while (n5 < dArray8[0].length) {
                    dArray9[0][n5] = dArray8[0][n5] == -9999.0 ? Double.NaN : dArray8[0][n5];
                    dArray9[1][n5] = dArray8[1][n5] == -9999.0 ? Double.NaN : dArray8[1][n5];
                    dArray9[2][n5] = dArray8[2][n5] == -9999.0 ? Double.NaN : dArray8[2][n5];
                    dArray9[3][n5] = dArray8[3][n5] == -9999.0 ? Double.NaN : dArray8[3][n5];
                    ++n5;
                }
                flatField.setSamples(dArray9);
                if (!functionType2.equals(flatField.getType())) {
                    flatField = (FlatField)flatField.changeMathType(functionType2);
                }
                dataArray[n4] = flatField;
                ++n4;
            }
            double[][] dArray10 = new double[1][n3];
            int n6 = 0;
            while (n6 < n3) {
                dArray10[0][n6] = dArray7[0] + dArray5[0][n6];
                ++n6;
            }
            dataImpl = new Gridded1DSet((MathType)RealType.Time, Set.doubleToFloat(dArray10), n3);
            fieldImplArray2[n2] = new FieldImpl(functionType3, (Set)dataImpl);
            fieldImplArray2[n2].setSamples(dataArray, false);
            ++n2;
        }
        return fieldImplArray2;
    }

    FieldImpl makeAdvect(FieldImpl fieldImpl, FieldImpl fieldImpl2, int n) throws VisADException, RemoteException, IOException {
        int n2;
        Object object;
        FieldImpl fieldImpl3;
        float[][] fArray = new float[1][1];
        int[] nArray = new int[1];
        double d = 3600.0;
        double d2 = 476.0;
        int n3 = 10;
        int n4 = 65;
        float[][] fArray2 = new float[3][n3 * n4];
        float[][] fArray3 = new float[6][n3 * n4];
        boolean bl = false;
        double d3 = 4.504504504504505E-6;
        d3 *= 1.1;
        FieldImpl fieldImpl4 = new FieldImpl(this.advect_field_type, fieldImpl2.getDomainSet());
        Set set = fieldImpl2.getDomainSet();
        FieldImpl fieldImpl5 = (FieldImpl)fieldImpl.resample(set, 101, 202);
        int n5 = fieldImpl2.getLength();
        FlatField[] flatFieldArray = new FlatField[n5];
        FieldImpl[] fieldImplArray = new FieldImpl[n5];
        int n6 = 0;
        while (n6 < n5) {
            FieldImpl fieldImpl6 = (FieldImpl)fieldImpl2.getSample(n6);
            fieldImpl3 = (FieldImpl)fieldImpl5.getSample(n6);
            Set set2 = fieldImpl3.getDomainSet();
            float[][] fArray4 = set2.getSamples();
            object = new float[fArray4[0].length];
            n2 = 0;
            int n7 = 0;
            while (n7 < fArray4[0].length) {
                if (fArray4[0][n7] < (float)this.height_limit) {
                    object[n2] = fArray4[0][n7];
                    ++n2;
                }
                ++n7;
            }
            float[][] fArray5 = new float[1][n2];
            System.arraycopy(object, 0, fArray5[0], 0, n2);
            set2 = new Gridded1DSet(set2.getType(), fArray5, n2);
            fieldImplArray[n6] = (FieldImpl)fieldImpl3.resample(set2, 101, 202);
            flatFieldArray[n6] = (FlatField)fieldImpl6.resample(set2, 101, 202);
            ++n6;
        }
        float[][] fArray6 = set.getSamples();
        float[] fArray7 = fArray6[0];
        int n8 = n3;
        while (n8 < n5) {
            Object object2;
            int n9 = n8;
            fieldImpl3 = fieldImplArray[n8];
            int n10 = fieldImpl3.getLength();
            double[][] dArray = fieldImpl3.getValues();
            object = fieldImpl3.getDomainSet().getSamples();
            int n11 = 0;
            double d4 = fArray7[n8];
            n2 = 0;
            while (n2 < n10) {
                void var36_42 = object[0][n2];
                int n12 = 0;
                while (n12 < n3) {
                    double d5 = fArray7[n9 - n12];
                    double d6 = d5 - d4;
                    double d7 = Math.PI / 180 * this.station_lat[n];
                    fArray2[0][n11] = (float)(-dArray[0][n2] * d6 * d3 / Math.cos(d7) + this.station_lon[n]);
                    fArray2[1][n11] = (float)(-dArray[1][n2] * d6 * d3 + this.station_lat[n]);
                    fArray2[2][n11] = var36_42;
                    object2 = flatFieldArray[n9 - n12].getValues();
                    fArray3[0][n11] = (float)object2[1][n2];
                    fArray3[1][n11] = (float)object2[2][n2];
                    fArray3[2][n11] = (float)object2[3][n2];
                    fArray3[3][n11] = (float)Aeri.relativeHumidity(object2[1][n2], object2[2][n2]);
                    fArray3[4][n11] = (float)Aeri.potentialTemperature(object2[1][n2], object2[0][n2]);
                    fArray3[5][n11] = (float)Aeri.equivPotentialTemperature(fArray3[4][n11], object2[1][n2], object2[0][n2]);
                    ++n11;
                    ++n12;
                }
                ++n2;
            }
            n2 = n11 / n10;
            int n13 = n10;
            float[][] fArray8 = new float[3][n2 * n13];
            System.arraycopy(fArray2[0], 0, fArray8[0], 0, n11);
            System.arraycopy(fArray2[1], 0, fArray8[1], 0, n11);
            System.arraycopy(fArray2[2], 0, fArray8[2], 0, n11);
            float[][] fArray9 = new float[6][n11];
            System.arraycopy(fArray3[0], 0, fArray9[0], 0, n11);
            System.arraycopy(fArray3[1], 0, fArray9[1], 0, n11);
            System.arraycopy(fArray3[2], 0, fArray9[2], 0, n11);
            System.arraycopy(fArray3[3], 0, fArray9[3], 0, n11);
            System.arraycopy(fArray3[4], 0, fArray9[4], 0, n11);
            System.arraycopy(fArray3[5], 0, fArray9[5], 0, n11);
            object2 = new Gridded3DSet((MathType)this.spatial_domain, fArray8, n2, n13);
            FlatField flatField = new FlatField(this.advect_type, (Set)object2);
            flatField.setSamples(fArray9);
            fieldImpl4.setSample(n8, (Data)flatField, false);
            ++n8;
        }
        return fieldImpl4;
    }

    public static double satVapPres(double d) {
        double d2;
        int n;
        double[] dArray = new double[]{6.1104546, 0.4442351, 0.014302099, 2.6454708E-4, 3.0357098E-6, 2.0972268E-8, 6.0487594E-11, -1.469687E-13};
        double[] dArray2 = new double[]{0.06485546857696639, 0.03783195122560735, 0.02224449342887902, 0.013182892842468312, 0.007874020771412448, 0.004739730494884733, 0.0028751203550435793, 0.001757430376758103, 0.0010824173951885098, 6.717089391856059E-4, 4.199647026320394E-4, 2.645243638634699E-4, 1.6784796373681322E-4, 1.0728539763162038E-4, 6.907426344961356E-5, 4.479404897680843E-5, 2.925704195639373E-5, 1.9245291263499416E-5, 1.2749137241074795E-5, 8.505070102755051E-6, 5.713400253349711E-6, 3.864650296738762E-6, 2.632109719650053E-6, 1.8049107293057043E-6, 1.2460785055581605E-6, 8.660705713468708E-7, 6.059822176688955E-7, 4.2682119794324277E-7, 3.026165085143795E-7, 2.15963854234914E-7, 1.5512895457833687E-7};
        double d3 = d - 273.16;
        double d4 = d3 != d3 ? Double.NaN : (d3 > -50.0 ? dArray[0] + d3 * (dArray[1] + d3 * (dArray[2] + d3 * (dArray[3] + d3 * (dArray[4] + d3 * (dArray[5] + d3 * (dArray[6] + d3 * dArray[7])))))) : ((n = (int)(d2 = (-d3 - 50.0) / 5.0)) < dArray2.length ? dArray2[n] + d2 % 1.0 * (dArray2[n + 1] - dArray2[n]) : 1.0E-7));
        return d4;
    }

    public static double mixingRatio(double d, double d2) {
        double d3 = Aeri.satVapPres(d);
        return 621.97 * d3 / (d2 - d3);
    }

    public static double relativeHumidity(double d, double d2) {
        return Aeri.satVapPres(d2) / Aeri.satVapPres(d);
    }

    public static double potentialTemperature(double d, double d2) {
        double d3 = 0.28585;
        double d4 = 1000.0;
        return d * Math.pow(d4 / d2, d3);
    }

    public static double equivPotentialTemperature(double d, double d2, double d3) {
        double d4 = 2500000.0;
        double d5 = 1004.0;
        double d6 = Aeri.mixingRatio(d2, d3 * 100.0);
        double d7 = d * Math.exp(d4 * (d6 /= 1000.0) / (d5 * d2));
        return d7;
    }

    public static double equivPotentialTemperatureStar(double d, double d2, double d3) {
        double d4 = 2500000.0;
        double d5 = 1004.0;
        return d * Math.exp(d4 * (d2 /= 1000.0) / (d5 * d3));
    }

    public Aeri(String[] stringArray) throws VisADException, RemoteException, IOException {
        Object object;
        String string = null;
        String string2 = "20000112";
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                if (stringArray[n].endsWith(".vad")) {
                    string = stringArray[n];
                } else if (stringArray[n].equals("-limit") && n + 1 < stringArray.length) {
                    try {
                        this.height_limit = Integer.parseInt(stringArray[n + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("bad height limit: " + stringArray[n + 1]);
                    }
                    ++n;
                } else if (stringArray[n].equals("-date") && n + 1 < stringArray.length) {
                    string2 = stringArray[n + 1];
                    ++n;
                } else if (stringArray[n].equals("-rh")) {
                    this.rh = true;
                    this.tm = false;
                } else if (stringArray[n].equals("-temp")) {
                    this.tm = true;
                    this.rh = false;
                } else if (stringArray[n].equals("-theta")) {
                    this.pt = true;
                } else if (stringArray[n].equals("-thetaE")) {
                    this.ept = true;
                }
            }
            ++n;
        }
        if (string != null) {
            this.init_from_vad(string);
        } else {
            this.init_from_cdf(string2);
        }
        this.wvmr.alias("MR");
        this.temp.alias("T");
        try {
            object = System.getProperty("file.separator");
            this.image_seq = Aeri.init_images("." + (String)object + "data" + (String)object + "image" + (String)object + string2);
            this.band1 = (RealType)((RealTupleType)((FunctionType)((FunctionType)this.image_seq.getType()).getRange()).getRange()).getComponent(0);
        }
        catch (Exception exception) {
            System.out.println("no AREA image data, proceeding...");
            this.image_seq = null;
        }
        object = new JFrame("VisAD AERI Viewer");
        ((Window)object).addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ Aeri this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = aeri;
                this.constructor$0(aeri);
            }

            private final void constructor$0(Aeri aeri) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ((JFrame)object).getContentPane().add(jPanel);
        DisplayImpl displayImpl = this.makeDisplay(jPanel);
        int n2 = 1000;
        int n3 = 600;
        ((Component)object).setSize(n2, n3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)object).setLocation(dimension.width / 2 - n2 / 2, dimension.height / 2 - n3 / 2);
        ((Component)object).setVisible(true);
    }
}

