/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.ShadowType;
import visad.SphericalCoordinateSystem;
import visad.VisADException;
import visad.VisADGeometryArray;

public class VisADLineStripArray
extends VisADGeometryArray {
    private static final int TEST = 1;
    private static final float LIMIT = 4.0f;
    private static final float ALPHA = 0.1f;
    public int[] stripVertexCounts;

    public static VisADLineStripArray merge(VisADLineStripArray[] visADLineStripArrayArray) throws VisADException {
        if (visADLineStripArrayArray == null || visADLineStripArrayArray.length == 0) {
            return null;
        }
        VisADLineStripArray visADLineStripArray = new VisADLineStripArray();
        VisADGeometryArray.merge(visADLineStripArrayArray, visADLineStripArray);
        int n = visADLineStripArrayArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (visADLineStripArrayArray[n3] != null) {
                n2 += visADLineStripArrayArray[n3].stripVertexCounts.length;
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (visADLineStripArrayArray[n4] != null) {
                int n5 = visADLineStripArrayArray[n4].stripVertexCounts.length;
                int n6 = 0;
                while (n6 < n5) {
                    nArray[n2 + n6] = visADLineStripArrayArray[n4].stripVertexCounts[n6];
                    ++n6;
                }
                n2 += n5;
            }
            ++n4;
        }
        visADLineStripArray.stripVertexCounts = nArray;
        return visADLineStripArray;
    }

    public VisADGeometryArray adjustSeam(DataRenderer dataRenderer) throws VisADException {
        CoordinateSystem coordinateSystem = dataRenderer.getDisplayCoordinateSystem();
        if (coordinateSystem == null || coordinateSystem instanceof SphericalCoordinateSystem) {
            return this;
        }
        int n = this.coordinates.length / 3;
        if (n < 6) {
            return this;
        }
        float[][] fArray = new float[3][n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            fArray[0][n3] = this.coordinates[n2++];
            fArray[1][n3] = this.coordinates[n2++];
            fArray[2][n3] = this.coordinates[n2++];
            ++n3;
        }
        float[][] fArray2 = coordinateSystem.fromReference(fArray);
        boolean[] blArray = new boolean[n];
        if (n < 2) {
            return this;
        }
        Object object = new float[3][n - 1];
        float f = 1.1f;
        int n4 = 0;
        while (n4 < n - 1) {
            object[0][n4] = f * fArray2[0][n4] - 0.1f * fArray2[0][n4 + 1];
            object[1][n4] = f * fArray2[1][n4] - 0.1f * fArray2[1][n4 + 1];
            object[2][n4] = f * fArray2[2][n4] - 0.1f * fArray2[2][n4 + 1];
            ++n4;
        }
        Object object2 = coordinateSystem.toReference((float[][])object);
        float f2 = 10.0f;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.stripVertexCounts.length) {
            int n7 = n5;
            while (n7 < n5 + this.stripVertexCounts[n6] - 1) {
                float f3 = fArray[0][n7 + 1] - fArray[0][n7];
                float f4 = fArray[1][n7 + 1] - fArray[1][n7];
                float f5 = fArray[2][n7 + 1] - fArray[2][n7];
                float f6 = f2 * (fArray[0][n7] - object2[0][n7]);
                float f7 = f2 * (fArray[1][n7] - object2[1][n7]);
                float f8 = f2 * (fArray[2][n7] - object2[2][n7]);
                float f9 = f3 * f3 + f4 * f4 + f5 * f5;
                float f10 = f6 * f6 + f7 * f7 + f8 * f8;
                float f11 = f6 * f3 + f7 * f4 + f8 * f5;
                float f12 = f11 / f10;
                float f13 = f11 * f11 / (f9 * f10);
                blArray[n7] = !(0.5f < f12 && f12 < 2.0f && 0.5f < f13);
                ++n7;
            }
            n5 += this.stripVertexCounts[n6];
            ++n6;
        }
        fArray = null;
        fArray2 = null;
        object = null;
        byte[] byArray = null;
        object2 = new VisADLineStripArray();
        float[] fArray3 = new float[3 * this.coordinates.length];
        n6 = 0;
        byte[] byArray2 = null;
        if (this.colors != null) {
            n6 = 3;
            byArray2 = new byte[3 * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                n6 = 4;
            }
        }
        int[] nArray = new int[this.coordinates.length];
        int n8 = 0;
        n5 = 0;
        int[] nArray2 = new int[]{0, 0};
        n2 = 0;
        boolean bl = false;
        int n9 = 0;
        while (n9 < this.stripVertexCounts.length) {
            int n10 = 0;
            n2 = n6 * n5 / 3;
            int n11 = n5;
            while (n11 < n5 + this.stripVertexCounts[n9] * 3) {
                float[] fArray4 = new float[]{this.coordinates[n11], this.coordinates[n11 + 1], this.coordinates[n11 + 2]};
                byte[] byArray3 = null;
                if (n6 == 3) {
                    byArray3 = new byte[]{this.colors[n2], this.colors[n2 + 1], this.colors[n2 + 2]};
                } else if (n6 == 4) {
                    byArray3 = new byte[]{this.colors[n2], this.colors[n2 + 1], this.colors[n2 + 2], this.colors[n2 + 3]};
                }
                if (++n10 == 1) {
                    object = fArray4;
                    byArray = byArray3;
                } else {
                    this.nextPoint(n10, n6, fArray3, byArray2, fArray4, byArray3, (float[])object, byArray, nArray2);
                }
                if (n11 != n5 + this.stripVertexCounts[n9] * 3 - 3) {
                    if (blArray[n11 / 3]) {
                        bl = true;
                        if (n10 >= 2) {
                            nArray[n8] = n10;
                            ++n8;
                        }
                        n10 = 0;
                    }
                    n2 += n6;
                }
                n11 += 3;
            }
            if (n10 >= 2) {
                nArray[n8] = n10;
                ++n8;
            }
            n5 += this.stripVertexCounts[n9] * 3;
            ++n9;
        }
        if (!bl) {
            return this;
        }
        object2.vertexCount = nArray2[0] / 3;
        object2.coordinates = new float[nArray2[0]];
        System.arraycopy(fArray3, 0, object2.coordinates, 0, nArray2[0]);
        if (this.colors != null) {
            object2.colors = new byte[nArray2[1]];
            System.arraycopy(byArray2, 0, object2.colors, 0, nArray2[1]);
        }
        object2.stripVertexCounts = new int[n8];
        System.arraycopy(nArray, 0, object2.stripVertexCounts, 0, n8);
        return object2;
    }

    public VisADGeometryArray adjustLongitude(DataRenderer dataRenderer) throws VisADException {
        float[] fArray = this.getLongitudes(dataRenderer);
        if (fArray == null) {
            return this;
        }
        int[] nArray = new int[1];
        float[] fArray2 = new float[2];
        float[] fArray3 = this.getLongitudeRange(fArray, nArray, fArray2);
        if (fArray3[0] != fArray3[0] || fArray3[1] != fArray3[1]) {
            return this;
        }
        float f = fArray3[0];
        float f2 = fArray3[1];
        float f3 = f + 30.0f;
        float f4 = f2 - 30.0f;
        int n = nArray[0];
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float[] fArray4 = null;
        byte[] byArray = null;
        VisADLineStripArray visADLineStripArray = new VisADLineStripArray();
        float[] fArray5 = new float[3 * this.coordinates.length];
        int n2 = 0;
        byte[] byArray2 = null;
        if (this.colors != null) {
            n2 = 3;
            byArray2 = new byte[3 * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                n2 = 4;
            }
        }
        int[] nArray2 = new int[this.coordinates.length];
        int n3 = 0;
        int n4 = 0;
        int[] nArray3 = new int[]{0, 0};
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        while (n6 < this.stripVertexCounts.length) {
            int n7 = 0;
            n5 = n2 * n4 / 3;
            int n8 = n4;
            while (n8 < n4 + this.stripVertexCounts[n6] * 3) {
                float[] fArray6 = new float[]{this.coordinates[n8], this.coordinates[n8 + 1], this.coordinates[n8 + 2]};
                byte[] byArray3 = null;
                if (n2 == 3) {
                    byArray3 = new byte[]{this.colors[n5], this.colors[n5 + 1], this.colors[n5 + 2]};
                } else if (n2 == 4) {
                    byArray3 = new byte[]{this.colors[n5], this.colors[n5 + 1], this.colors[n5 + 2], this.colors[n5 + 3]};
                }
                if (++n7 == 1) {
                    fArray4 = fArray6;
                    byArray = byArray3;
                } else {
                    this.nextPoint(n7, n2, fArray5, byArray2, fArray6, byArray3, fArray4, byArray, nArray3);
                }
                if (n8 != n4 + this.stripVertexCounts[n6] * 3 - 3) {
                    int n9 = n8 / 3;
                    if (fArray[n9] < f3 && f4 < fArray[n9 + 1] || fArray[n9 + 1] < f3 && f4 < fArray[n9]) {
                        bl = true;
                        if (n < 0) {
                            if (n7 >= 2) {
                                nArray2[n3] = n7;
                                ++n3;
                            }
                            n7 = 0;
                        } else {
                            float f7;
                            float f8;
                            float f9;
                            float f10;
                            if (fArray[n9] < f3) {
                                f10 = fArray[n9] - f;
                                f9 = f2 - fArray[n9 + 1];
                                f8 = f5;
                                f7 = f6;
                            } else {
                                f10 = f2 - fArray[n9];
                                f9 = fArray[n9 + 1] - f;
                                f8 = f6;
                                f7 = f5;
                            }
                            float f11 = f9 / (f10 + f9);
                            f11 = f11 != f11 || f11 < 0.0f ? 0.0f : (1.0f < f11 ? 1.0f : f11);
                            float f12 = 1.0f - f11;
                            fArray6 = new float[]{f11 * this.coordinates[n8] + f12 * this.coordinates[n8 + 3], f11 * this.coordinates[n8 + 1] + f12 * this.coordinates[n8 + 4], f11 * this.coordinates[n8 + 2] + f12 * this.coordinates[n8 + 5]};
                            fArray6[n] = f8;
                            byArray3 = null;
                            if (n2 == 3) {
                                byArray3 = new byte[]{ShadowType.floatToByte(f11 * ShadowType.byteToFloat(this.colors[n5]) + f12 * ShadowType.byteToFloat(this.colors[n5 + 3])), ShadowType.floatToByte(f11 * ShadowType.byteToFloat(this.colors[n5 + 1]) + f12 * ShadowType.byteToFloat(this.colors[n5 + 4])), ShadowType.floatToByte(f11 * ShadowType.byteToFloat(this.colors[n5 + 2]) + f12 * ShadowType.byteToFloat(this.colors[n5 + 5]))};
                            } else if (n2 == 4) {
                                byArray3 = new byte[]{ShadowType.floatToByte(f11 * ShadowType.byteToFloat(this.colors[n5]) + f12 * ShadowType.byteToFloat(this.colors[n5 + 4])), ShadowType.floatToByte(f11 * ShadowType.byteToFloat(this.colors[n5 + 1]) + f12 * ShadowType.byteToFloat(this.colors[n5 + 5])), ShadowType.floatToByte(f11 * ShadowType.byteToFloat(this.colors[n5 + 2]) + f12 * ShadowType.byteToFloat(this.colors[n5 + 6])), ShadowType.floatToByte(f11 * ShadowType.byteToFloat(this.colors[n5 + 3]) + f12 * ShadowType.byteToFloat(this.colors[n5 + 7]))};
                            }
                            if (++n7 == 1) {
                                fArray4 = fArray6;
                                byArray = byArray3;
                            } else {
                                this.nextPoint(n7, n2, fArray5, byArray2, fArray6, byArray3, fArray4, byArray, nArray3);
                            }
                            if (n7 >= 2) {
                                nArray2[n3] = n7;
                                ++n3;
                            }
                            n7 = 0;
                            fArray6[n] = f7;
                            if (++n7 == 1) {
                                fArray4 = fArray6;
                                byArray = byArray3;
                            } else {
                                this.nextPoint(n7, n2, fArray5, byArray2, fArray6, byArray3, fArray4, byArray, nArray3);
                            }
                        }
                    }
                    n5 += n2;
                }
                n8 += 3;
            }
            if (n7 >= 2) {
                nArray2[n3] = n7;
                ++n3;
            }
            n4 += this.stripVertexCounts[n6] * 3;
            ++n6;
        }
        if (!bl) {
            return this;
        }
        visADLineStripArray.vertexCount = nArray3[0] / 3;
        visADLineStripArray.coordinates = new float[nArray3[0]];
        System.arraycopy(fArray5, 0, visADLineStripArray.coordinates, 0, nArray3[0]);
        if (this.colors != null) {
            visADLineStripArray.colors = new byte[nArray3[1]];
            System.arraycopy(byArray2, 0, visADLineStripArray.colors, 0, nArray3[1]);
        }
        visADLineStripArray.stripVertexCounts = new int[n3];
        System.arraycopy(nArray2, 0, visADLineStripArray.stripVertexCounts, 0, n3);
        return visADLineStripArray;
    }

    private void nextPoint(int n, int n2, float[] fArray, byte[] byArray, float[] fArray2, byte[] byArray2, float[] fArray3, byte[] byArray3, int[] nArray) {
        if (n == 2) {
            fArray[nArray[0]] = fArray3[0];
            fArray[nArray[0] + 1] = fArray3[1];
            fArray[nArray[0] + 2] = fArray3[2];
            nArray[0] = nArray[0] + 3;
            if (this.colors != null) {
                byArray[nArray[1]] = byArray3[0];
                byArray[nArray[1] + 1] = byArray3[1];
                byArray[nArray[1] + 2] = byArray3[2];
                nArray[1] = nArray[1] + 3;
                if (n2 == 4) {
                    int n3 = nArray[1];
                    nArray[1] = n3 + 1;
                    byArray[n3] = byArray3[3];
                }
            }
        }
        fArray[nArray[0]] = fArray2[0];
        fArray[nArray[0] + 1] = fArray2[1];
        fArray[nArray[0] + 2] = fArray2[2];
        nArray[0] = nArray[0] + 3;
        if (this.colors != null) {
            byArray[nArray[1]] = byArray2[0];
            byArray[nArray[1] + 1] = byArray2[1];
            byArray[nArray[1] + 2] = byArray2[2];
            nArray[1] = nArray[1] + 3;
            if (n2 == 4) {
                int n4 = nArray[1];
                nArray[1] = n4 + 1;
                byArray[n4] = byArray2[3];
            }
        }
    }

    public VisADGeometryArray removeMissing() {
        VisADLineStripArray visADLineStripArray = new VisADLineStripArray();
        float[] fArray = new float[this.coordinates.length];
        int n = 3;
        byte[] byArray = null;
        if (this.colors != null) {
            byArray = new byte[this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                n = 4;
            }
        }
        int[] nArray = new int[this.coordinates.length / 4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        while (n7 < this.stripVertexCounts.length) {
            int n8 = 0;
            n6 = n * n3 / 3;
            int n9 = n3;
            while (n9 < n3 + this.stripVertexCounts[n7] * 3) {
                if (this.coordinates[n9] == this.coordinates[n9] && this.coordinates[n9 + 1] == this.coordinates[n9 + 1] && this.coordinates[n9 + 2] == this.coordinates[n9 + 2]) {
                    if (++n8 >= 2) {
                        int n10 = n9;
                        int n11 = n6;
                        if (n8 == 2) {
                            n10 = n9 - 3;
                            n11 = n6 - n;
                        }
                        int n12 = n11;
                        int n13 = n10;
                        while (n13 <= n9) {
                            fArray[n4] = this.coordinates[n13];
                            fArray[n4 + 1] = this.coordinates[n13 + 1];
                            fArray[n4 + 2] = this.coordinates[n13 + 2];
                            if (this.colors != null) {
                                byArray[n5] = this.colors[n12];
                                byArray[n5 + 1] = this.colors[n12 + 1];
                                byArray[n5 + 2] = this.colors[n12 + 2];
                                n5 += 3;
                                if (n == 4) {
                                    byArray[n5++] = this.colors[n12 + 3];
                                }
                            }
                            n4 += 3;
                            n12 += n;
                            n13 += 3;
                        }
                    }
                } else {
                    bl = true;
                    if (n8 >= 2) {
                        nArray[n2] = n8;
                        ++n2;
                    }
                    n8 = 0;
                }
                n6 += n;
                n9 += 3;
            }
            if (n8 >= 2) {
                nArray[n2] = n8;
                ++n2;
            }
            n3 += this.stripVertexCounts[n7] * 3;
            ++n7;
        }
        if (!bl) {
            return this;
        }
        visADLineStripArray.vertexCount = n4 / 3;
        visADLineStripArray.coordinates = new float[n4];
        System.arraycopy(fArray, 0, visADLineStripArray.coordinates, 0, n4);
        if (this.colors != null) {
            visADLineStripArray.colors = new byte[n5];
            System.arraycopy(byArray, 0, visADLineStripArray.colors, 0, n5);
        }
        visADLineStripArray.stripVertexCounts = new int[n2];
        System.arraycopy(nArray, 0, visADLineStripArray.stripVertexCounts, 0, n2);
        return visADLineStripArray;
    }

    public Object clone() {
        VisADLineStripArray visADLineStripArray = new VisADLineStripArray();
        this.copy(visADLineStripArray);
        if (this.stripVertexCounts != null) {
            visADLineStripArray.stripVertexCounts = new int[this.stripVertexCounts.length];
            System.arraycopy(this.stripVertexCounts, 0, visADLineStripArray.stripVertexCounts, 0, this.stripVertexCounts.length);
        }
        return visADLineStripArray;
    }
}

