/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Enumeration;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SphericalCoordinateSystem;
import visad.VisADException;
import visad.VisADPointArray;
import visad.VisADSceneGraphObject;

public abstract class VisADGeometryArray
extends VisADSceneGraphObject
implements Cloneable {
    public int vertexCount = 0;
    public int vertexFormat = 0;
    public float[] coordinates = null;
    public float[] normals = null;
    public byte[] colors = null;
    public float[] texCoords = null;
    boolean any_longitude_rotate = false;
    int longitude_axis = -1;
    ScalarMap longitude_map = null;

    public VisADGeometryArray adjustSeam(DataRenderer dataRenderer) throws VisADException {
        CoordinateSystem coordinateSystem = dataRenderer.getDisplayCoordinateSystem();
        if (coordinateSystem == null || coordinateSystem instanceof SphericalCoordinateSystem) {
            return this;
        }
        return this;
    }

    public VisADGeometryArray adjustLongitude(DataRenderer dataRenderer) throws VisADException {
        float[] fArray = this.getLongitudes(dataRenderer);
        if (this.any_longitude_rotate) {
            VisADPointArray visADPointArray = new VisADPointArray();
            visADPointArray.vertexCount = this.vertexCount;
            visADPointArray.coordinates = this.coordinates;
            visADPointArray.colors = this.colors;
            return visADPointArray;
        }
        return this;
    }

    static float rotateOneLongitude(float f, float f2) {
        if (f == f) {
            float f3;
            return f3 + ((f3 = (f - f2) % 360.0f) < 0.0f ? 360.0f + f2 : f2);
        }
        return f;
    }

    void rotateLongitudes(float[] fArray, float f, int n, ScalarMap scalarMap) {
        int n2 = 0;
        while (n2 < this.vertexCount) {
            float f2;
            if (fArray[n2] == fArray[n2] && (f2 += (f2 = (fArray[n2] - f) % 360.0f) < 0.0f ? 360.0f + f : f) != fArray[n2]) {
                fArray[n2] = f2;
                this.any_longitude_rotate = true;
            }
            ++n2;
        }
        if (this.any_longitude_rotate) {
            float[] fArray2 = scalarMap.scaleValues(fArray);
            int n3 = 0;
            while (n3 < this.vertexCount) {
                this.coordinates[3 * n3 + n] = fArray2[n3];
                ++n3;
            }
        }
    }

    float[] getLongitudes(DataRenderer dataRenderer) throws VisADException {
        Object object;
        Object object2;
        this.any_longitude_rotate = false;
        this.longitude_map = null;
        this.longitude_axis = -1;
        Vector vector = dataRenderer.getDisplay().getMapVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            float f;
            object2 = (ScalarMap)enumeration.nextElement();
            object = object2.getDisplayScalar();
            DisplayTupleType displayTupleType = ((DisplayRealType)object).getTuple();
            if (!RealType.Longitude.equals(object2.getScalar())) continue;
            if (Display.Longitude.equals(object)) {
                return null;
            }
            if (!Display.DisplaySpatialCartesianTuple.equals(displayTupleType)) continue;
            double[] dArray = object2.getRange();
            float f2 = (float)dArray[0];
            float f3 = (float)dArray[1];
            int n = ((DisplayRealType)object).getTupleIndex();
            this.longitude_map = object2;
            this.longitude_axis = n;
            float[] fArray = new float[this.vertexCount];
            int n2 = 0;
            while (n2 < this.vertexCount) {
                fArray[n2] = this.coordinates[3 * n2 + n];
                ++n2;
            }
            fArray = object2.inverseScaleValues(fArray);
            float f4 = Float.MAX_VALUE;
            float f5 = -3.4028235E38f;
            int n3 = 0;
            while (n3 < this.vertexCount) {
                if (fArray[n3] == fArray[n3]) {
                    if (fArray[n3] < f4) {
                        f4 = fArray[n3];
                    }
                    if (fArray[n3] > f5) {
                        f5 = fArray[n3];
                    }
                }
                ++n3;
            }
            if (f4 == Float.MAX_VALUE) {
                return fArray;
            }
            n3 = 0;
            if (f2 == f2 && f3 == f3 && (f2 + (f = 0.1f * (f3 - f2)) < f4 && f3 + f < f5 || f4 < f2 - f && f5 < f3 - f)) {
                float f6;
                float f7;
                float f8;
                float f9;
                float f10 = VisADGeometryArray.rotateOneLongitude(f4, f2);
                float f11 = VisADGeometryArray.rotateOneLongitude(f5, f2);
                float f12 = f4 < f2 ? f2 - f4 : (f9 = f3 < f4 ? f4 - f3 : 0.0f);
                float f13 = f10 < f2 ? f2 - f10 : (f8 = f3 < f10 ? f10 - f3 : 0.0f);
                float f14 = f5 < f2 ? f2 - f5 : (f7 = f3 < f5 ? f5 - f3 : 0.0f);
                float f15 = f11 < f2 ? f2 - f11 : (f6 = f3 < f11 ? f11 - f3 : 0.0f);
                if (f8 + f6 < f9 + f7) {
                    n3 = 1;
                    this.rotateLongitudes(fArray, f2, n, (ScalarMap)object2);
                }
            }
            if (n3 == 0 && f4 + 360.0f < f5) {
                this.rotateLongitudes(fArray, f4, n, (ScalarMap)object2);
            }
            return fArray;
        }
        object2 = dataRenderer.getLatLonIndices();
        if (object2[0] < 0 || object2[1] < 0) {
            return null;
        }
        object = new float[3][this.vertexCount];
        int n = 0;
        int n4 = 0;
        while (n4 < this.vertexCount) {
            object[0][n4] = this.coordinates[n++];
            object[1][n4] = this.coordinates[n++];
            object[2][n4] = this.coordinates[n++];
            ++n4;
        }
        float[][] fArray = dataRenderer.earthToSpatial((float[][])object, null);
        return fArray[1];
    }

    float[] getLongitudeRange(float[] fArray, int[] nArray, float[] fArray2) {
        float[] fArray3 = new float[]{Float.NaN, Float.NaN};
        nArray[0] = -1;
        fArray2[0] = Float.NaN;
        fArray2[1] = Float.NaN;
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        int n = 0;
        while (n < this.vertexCount) {
            if (fArray[n] == fArray[n]) {
                if (fArray[n] < f) {
                    f = fArray[n];
                }
                if (fArray[n] > f2) {
                    f2 = fArray[n];
                }
            }
            ++n;
        }
        if (f2 - f < 1.0f) {
            f2 += 0.5f;
            f -= 0.5f;
        }
        if (f <= f2) {
            float f3;
            float f4;
            float f5 = (f2 - f) / 10.0f;
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            if ((f4 = (f + f5) % 180.0f) < 0.0f) {
                f4 += 180.0f;
            }
            if (f2 - f5 < (f3 = f + f5 - f4) + 360.0f) {
                fArray3[0] = f3;
                fArray3[1] = f3 + 360.0f;
            } else {
                fArray3[0] = f;
                fArray3[1] = f + 360.0f;
            }
            nArray[0] = this.longitude_axis;
            if (this.longitude_map != null) {
                float[] fArray4 = this.longitude_map.scaleValues(fArray3);
                fArray2[0] = fArray4[0];
                fArray2[1] = fArray4[1];
            } else {
                fArray2[0] = Float.NaN;
                fArray2[1] = Float.NaN;
            }
        }
        return fArray3;
    }

    public VisADGeometryArray removeMissing() {
        VisADPointArray visADPointArray = new VisADPointArray();
        float[] fArray = new float[this.coordinates.length];
        int n = 3;
        byte[] byArray = null;
        if (this.colors != null) {
            byArray = new byte[this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                n = 4;
            }
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.coordinates.length) {
            if (this.coordinates[n5] == this.coordinates[n5] && this.coordinates[n5 + 1] == this.coordinates[n5 + 1] && this.coordinates[n5 + 2] == this.coordinates[n5 + 2]) {
                fArray[n2] = this.coordinates[n5];
                fArray[n2 + 1] = this.coordinates[n5 + 1];
                fArray[n2 + 2] = this.coordinates[n5 + 2];
                if (this.colors != null) {
                    byArray[n3] = this.colors[n4];
                    byArray[n3 + 1] = this.colors[n4 + 1];
                    byArray[n3 + 2] = this.colors[n4 + 2];
                    n3 += 3;
                    if (n == 4) {
                        byArray[n3++] = this.colors[n4 + 3];
                    }
                }
                n2 += 3;
            } else {
                bl = true;
            }
            n4 += n;
            n5 += 3;
        }
        if (!bl) {
            return this;
        }
        visADPointArray.coordinates = new float[n2];
        System.arraycopy(fArray, 0, visADPointArray.coordinates, 0, n2);
        if (this.colors != null) {
            visADPointArray.colors = new byte[n3];
            System.arraycopy(byArray, 0, visADPointArray.colors, 0, n3);
        }
        return visADPointArray;
    }

    static void merge(VisADGeometryArray[] visADGeometryArrayArray, VisADGeometryArray visADGeometryArray) throws VisADException {
        if (visADGeometryArrayArray == null || visADGeometryArrayArray.length == 0 || visADGeometryArray == null) {
            return;
        }
        int n = visADGeometryArrayArray.length;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (visADGeometryArrayArray[n4] != null) {
                bl = visADGeometryArrayArray[n4].colors != null;
                bl2 = visADGeometryArrayArray[n4].normals != null;
                bl3 = visADGeometryArrayArray[n4].texCoords != null;
                n3 = visADGeometryArrayArray[n4].vertexFormat;
                bl4 = true;
            }
            ++n4;
        }
        if (!bl4) {
            return;
        }
        n4 = 0;
        while (n4 < n) {
            if (visADGeometryArrayArray[n4] != null) {
                n2 += visADGeometryArrayArray[n4].vertexCount;
                if (bl != (visADGeometryArrayArray[n4].colors != null) || bl2 != (visADGeometryArrayArray[n4].normals != null) || bl3 != (visADGeometryArrayArray[n4].texCoords != null)) {
                    throw new DisplayException("VisADGeometryArray.merge: formats don't match");
                }
            }
            ++n4;
        }
        float[] fArray = new float[3 * n2];
        byte[] byArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        if (bl) {
            byArray = new byte[3 * n2];
        }
        if (bl2) {
            fArray2 = new float[3 * n2];
        }
        if (bl3) {
            fArray3 = new float[3 * n2];
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            if (visADGeometryArrayArray[n9] != null) {
                float[] fArray4 = visADGeometryArrayArray[n9].coordinates;
                int n10 = 0;
                while (n10 < 3 * visADGeometryArrayArray[n9].vertexCount) {
                    fArray[n5++] = fArray4[n10];
                    ++n10;
                }
                if (bl) {
                    byte[] byArray2 = visADGeometryArrayArray[n9].colors;
                    int n11 = 0;
                    while (n11 < 3 * visADGeometryArrayArray[n9].vertexCount) {
                        byArray[n6++] = byArray2[n11];
                        ++n11;
                    }
                }
                if (bl2) {
                    fArray4 = visADGeometryArrayArray[n9].normals;
                    int n12 = 0;
                    while (n12 < 3 * visADGeometryArrayArray[n9].vertexCount) {
                        fArray2[n7++] = fArray4[n12];
                        ++n12;
                    }
                }
                if (bl3) {
                    fArray4 = visADGeometryArrayArray[n9].texCoords;
                    int n13 = 0;
                    while (n13 < 3 * visADGeometryArrayArray[n9].vertexCount) {
                        fArray3[n8++] = fArray4[n13];
                        ++n13;
                    }
                }
            }
            ++n9;
        }
        visADGeometryArray.vertexCount = n2;
        visADGeometryArray.coordinates = fArray;
        visADGeometryArray.colors = byArray;
        visADGeometryArray.normals = fArray2;
        visADGeometryArray.texCoords = fArray3;
        visADGeometryArray.vertexFormat = n3;
    }

    public String toString() {
        String string = "GeometryArray, vertexCount = " + this.vertexCount + " vertexFormat = " + this.vertexFormat;
        if (this.coordinates != null) {
            string = string + "\n coordinates = " + VisADGeometryArray.floatArrayString(this.coordinates);
        }
        if (this.colors != null) {
            string = string + "\n colors = " + VisADGeometryArray.byteArrayString(this.colors);
        }
        if (this.normals != null) {
            string = string + "\n normals = " + VisADGeometryArray.floatArrayString(this.normals);
        }
        if (this.texCoords != null) {
            string = string + "\n texCoords = " + VisADGeometryArray.floatArrayString(this.texCoords);
        }
        return string;
    }

    static String floatArrayString(float[] fArray) {
        String string = "";
        int n = 0;
        while (n < fArray.length) {
            string = string + " " + fArray[n];
            ++n;
        }
        return string;
    }

    static String byteArrayString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            string = string + " " + byArray[n];
            ++n;
        }
        return string;
    }

    public void copy(VisADGeometryArray visADGeometryArray) {
        visADGeometryArray.vertexCount = this.vertexCount;
        visADGeometryArray.vertexFormat = this.vertexFormat;
        if (this.coordinates != null) {
            visADGeometryArray.coordinates = new float[this.coordinates.length];
            System.arraycopy(this.coordinates, 0, visADGeometryArray.coordinates, 0, this.coordinates.length);
        }
        if (this.normals != null) {
            visADGeometryArray.normals = new float[this.normals.length];
            System.arraycopy(this.normals, 0, visADGeometryArray.normals, 0, this.normals.length);
        }
        if (this.colors != null) {
            visADGeometryArray.colors = new byte[this.colors.length];
            System.arraycopy(this.colors, 0, visADGeometryArray.colors, 0, this.colors.length);
        }
        if (this.texCoords != null) {
            visADGeometryArray.texCoords = new float[this.texCoords.length];
            System.arraycopy(this.texCoords, 0, visADGeometryArray.texCoords, 0, this.texCoords.length);
        }
    }

    public abstract Object clone();
}

