/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import visad.BaseUnit;
import visad.CommonUnit;
import visad.DerivedUnit;
import visad.ErrorEstimate;
import visad.OffsetUnit;
import visad.PromiscuousUnit;
import visad.ScaledUnit;
import visad.UnitException;
import visad.UnitExistsException;
import visad.VisADException;

public abstract class Unit
implements Serializable {
    private static final Map identifierMap = new WeakHashMap();
    private final String identifier;

    public static double[][] convertTuple(double[][] dArray, Unit[] unitArray, Unit[] unitArray2) throws VisADException {
        double[][] dArray2 = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            if (unitArray2[n] == null) {
                if (unitArray[n] != null && !(unitArray[n] instanceof PromiscuousUnit)) {
                    throw new UnitException("Unit.convertTuple: illegal Unit conversion");
                }
                dArray2[n] = dArray[n];
            } else {
                dArray2[n] = unitArray2[n].toThis(dArray[n], unitArray[n]);
            }
            ++n;
        }
        return dArray2;
    }

    public static float[][] convertTuple(float[][] fArray, Unit[] unitArray, Unit[] unitArray2) throws VisADException {
        float[][] fArray2 = new float[fArray.length][];
        int n = 0;
        while (n < fArray.length) {
            if (unitArray2[n] == null) {
                if (unitArray[n] != null && !(unitArray[n] instanceof PromiscuousUnit)) {
                    throw new UnitException("Unit.convertTuple: illegal Unit conversion");
                }
                fArray2[n] = fArray[n];
            } else {
                fArray2[n] = unitArray2[n].toThis(fArray[n], unitArray[n]);
            }
            ++n;
        }
        return fArray2;
    }

    public static boolean canConvert(Unit unit, Unit unit2) {
        if (CommonUnit.promiscuous.equals(unit)) {
            unit = null;
        }
        if (CommonUnit.promiscuous.equals(unit2)) {
            unit2 = null;
        }
        if (unit == null && unit2 == null) {
            return true;
        }
        if (unit == null || unit2 == null) {
            return false;
        }
        return unit.isConvertible(unit2);
    }

    public abstract boolean isConvertible(Unit var1);

    public static boolean canConvertArray(Unit[] unitArray, Unit[] unitArray2) {
        int n;
        if (unitArray == null && unitArray2 == null) {
            return true;
        }
        if (unitArray == null) {
            unitArray = new Unit[unitArray2.length];
        }
        if (unitArray2 == null) {
            unitArray2 = new Unit[unitArray.length];
        }
        if ((n = unitArray.length) != unitArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!Unit.canConvert(unitArray[n2], unitArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Unit[] copyUnitsArray(Unit[] unitArray) {
        return unitArray == null ? null : (Unit[])unitArray.clone();
    }

    public abstract boolean equals(Unit var1);

    public static double[] transformUnits(Unit unit, ErrorEstimate[] errorEstimateArray, Unit unit2, ErrorEstimate errorEstimate, double[] dArray) throws VisADException {
        if (unit == null || unit2 == null) {
            errorEstimateArray[0] = errorEstimate;
            return dArray;
        }
        double[] dArray2 = unit.toThis(dArray, unit2);
        if (errorEstimate == null) {
            errorEstimateArray[0] = null;
        } else {
            double d = 0.5 * errorEstimate.getErrorValue();
            double d2 = errorEstimate.getMean();
            double d3 = Math.abs(unit.toThis(d2 + d, unit2) - unit.toThis(d2 - d, unit2));
            errorEstimateArray[0] = new ErrorEstimate(dArray2, d3, unit);
        }
        return dArray2;
    }

    public static float[] transformUnits(Unit unit, ErrorEstimate[] errorEstimateArray, Unit unit2, ErrorEstimate errorEstimate, float[] fArray) throws VisADException {
        if (unit == null || unit2 == null) {
            errorEstimateArray[0] = errorEstimate;
            return fArray;
        }
        float[] fArray2 = unit.toThis(fArray, unit2);
        if (errorEstimate == null) {
            errorEstimateArray[0] = null;
        } else {
            double d = 0.5 * errorEstimate.getErrorValue();
            double d2 = errorEstimate.getMean();
            double d3 = Math.abs(unit.toThis(d2 + d, unit2) - unit.toThis(d2 - d, unit2));
            errorEstimateArray[0] = new ErrorEstimate(fArray2, d3, unit);
        }
        return fArray2;
    }

    Unit scale(double d, boolean bl) {
        return new ScaledUnit(d, (BaseUnit)this);
    }

    protected final String adjustCheckAndCache(String string) throws UnitExistsException {
        if (string != null && string.length() > 0) {
            string = string.replace(' ', '_');
        }
        return string;
    }

    public Unit clone(String string) throws UnitException {
        return this.protectedClone(this.adjustCheckAndCache(string));
    }

    protected abstract Unit protectedClone(String var1) throws UnitException;

    public abstract Unit pow(int var1) throws UnitException;

    public abstract Unit root(int var1) throws IllegalArgumentException, UnitException;

    public Unit sqrt() throws IllegalArgumentException, UnitException {
        return this.root(2);
    }

    public abstract Unit pow(double var1) throws UnitException, IllegalArgumentException;

    public Unit scale(double d) throws UnitException {
        if (this instanceof BaseUnit) {
            return new ScaledUnit(d, (BaseUnit)this);
        }
        if (this instanceof DerivedUnit) {
            return new ScaledUnit(d, (DerivedUnit)this);
        }
        if (this instanceof ScaledUnit) {
            return new ScaledUnit(d, (ScaledUnit)this);
        }
        if (this instanceof OffsetUnit) {
            return new OffsetUnit(((OffsetUnit)this).offset / d, new ScaledUnit(d, ((OffsetUnit)this).scaledUnit));
        }
        throw new UnitException("Unknown unit subclass: " + this);
    }

    public Unit shift(double d) throws UnitException {
        OffsetUnit offsetUnit;
        if (this instanceof BaseUnit) {
            offsetUnit = new OffsetUnit(d, (BaseUnit)this);
        } else if (this instanceof DerivedUnit) {
            offsetUnit = new OffsetUnit(d, (DerivedUnit)this);
        } else if (this instanceof ScaledUnit) {
            offsetUnit = new OffsetUnit(d, (ScaledUnit)this);
        } else if (this instanceof OffsetUnit) {
            offsetUnit = new OffsetUnit(d, (OffsetUnit)this);
        } else {
            throw new UnitException("Unit.shift(): Unknown unit subclass: " + this);
        }
        return offsetUnit;
    }

    public abstract Unit multiply(Unit var1) throws UnitException;

    public abstract Unit divide(Unit var1) throws UnitException;

    protected abstract Unit divideInto(Unit var1) throws UnitException;

    public double toThis(double d, Unit unit) throws UnitException {
        return this.toThis(new double[]{d}, unit)[0];
    }

    public abstract double[] toThis(double[] var1, Unit var2) throws UnitException;

    public abstract float[] toThis(float[] var1, Unit var2) throws UnitException;

    public double toThat(double d, Unit unit) throws UnitException {
        return this.toThat(new double[]{d}, unit)[0];
    }

    public abstract double[] toThat(double[] var1, Unit var2) throws UnitException;

    public abstract float[] toThat(float[] var1, Unit var2) throws UnitException;

    public final String toString() {
        String string = this.getIdentifier();
        if (string == null) {
            string = this.getDefinition();
        }
        return string;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public abstract String getDefinition();

    public Unit getAbsoluteUnit() {
        return this;
    }

    protected Unit() {
        this.identifier = null;
    }

    protected Unit(String string) {
        try {
            string = this.adjustCheckAndCache(string);
        }
        catch (UnitExistsException unitExistsException) {
            System.err.println("WARNING: " + unitExistsException);
        }
        this.identifier = string;
    }
}

