/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Irregular1DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADTriangleStripArray;

public class UnionSet
extends SampledSet {
    SampledSet[] Sets;

    private static int find_manifold_dim(SampledSet[] sampledSetArray) throws VisADException {
        if (sampledSetArray == null || sampledSetArray.length == 0 || sampledSetArray[0] == null) {
            throw new SetException("UnionSet: Sets cannot be missing");
        }
        if (sampledSetArray.length < 2) {
            return sampledSetArray[0].ManifoldDimension;
        }
        int n = sampledSetArray[0].DomainDimension;
        int n2 = sampledSetArray[0].ManifoldDimension;
        CoordinateSystem coordinateSystem = sampledSetArray[0].getCoordinateSystem();
        Unit[] unitArray = sampledSetArray[0].getSetUnits();
        int n3 = 1;
        while (n3 < sampledSetArray.length) {
            if (sampledSetArray[n3] == null) {
                throw new SetException("UnionSet: Sets cannot be missing");
            }
            if (sampledSetArray[n3].DomainDimension != n) {
                throw new SetException("UnionSet: set #" + n3 + " Domain dimension is " + sampledSetArray[n3].DomainDimension + ", not " + n);
            }
            if (sampledSetArray[n3].ManifoldDimension != n2) {
                throw new SetException("UnionSet: set #" + n3 + " Manifold dimension is " + sampledSetArray[n3].ManifoldDimension + ", not " + n2);
            }
            CoordinateSystem coordinateSystem2 = sampledSetArray[n3].getCoordinateSystem();
            if (!(coordinateSystem == null && coordinateSystem2 == null || coordinateSystem != null && coordinateSystem2 != null && coordinateSystem.equals(coordinateSystem2))) {
                throw new CoordinateSystemException("UnionSet: Coordinate system #" + n3 + " (" + (coordinateSystem2 == null ? null : coordinateSystem2.getReference()) + " must match #0 " + (coordinateSystem == null ? null : coordinateSystem.getReference()));
            }
            Unit[] unitArray2 = sampledSetArray[n3].getSetUnits();
            if (unitArray != null || unitArray2 != null) {
                if (unitArray == null || unitArray2 == null || unitArray.length != unitArray2.length) {
                    throw new SetException("UnionSet: Expected " + (unitArray == null ? "null" : Integer.toString(unitArray.length)) + " units for set " + n3 + ", not " + (unitArray2 == null ? "null" : Integer.toString(unitArray2.length)));
                }
                int n4 = 0;
                while (n4 < unitArray.length) {
                    if (!(unitArray[n4] == null && unitArray2[n4] == null || unitArray[n4] != null && unitArray2[n4] != null && unitArray[n4].equals(unitArray2[n4]))) {
                        throw new SetException("UnionSet: Expected set " + n3 + ", element " + n4 + " units to be " + unitArray[n4] + " not " + unitArray2[n4]);
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return n2;
    }

    public SampledSet[] getSets() {
        return (SampledSet[])this.Sets.clone();
    }

    public SampledSet product() throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sampledSetArray = new SampledSet[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.Sets[n3] instanceof GriddedSet || this.Sets[n3] instanceof IrregularSet) {
                sampledSetArray[n3] = this.Sets[n3];
            } else if (this.Sets[n3] instanceof ProductSet) {
                sampledSetArray[n3] = ((ProductSet)this.Sets[n3]).product();
            } else if (this.Sets[n3] instanceof UnionSet) {
                sampledSetArray[n3] = ((UnionSet)this.Sets[n3]).product();
            } else {
                throw new UnimplementedException("UnionSet.product: " + this.Sets[n3].getClass());
            }
            n2 = sampledSetArray[n3] instanceof UnionSet ? (n2 += ((UnionSet)sampledSetArray[n3]).Sets.length) : ++n2;
            ++n3;
        }
        SampledSet[] sampledSetArray2 = new SampledSet[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (sampledSetArray[n5] instanceof UnionSet) {
                int n6 = 0;
                while (n6 < ((UnionSet)sampledSetArray[n5]).Sets.length) {
                    sampledSetArray2[n4++] = ((UnionSet)sampledSetArray[n5]).Sets[n6];
                    ++n6;
                }
            } else {
                sampledSetArray2[n4++] = sampledSetArray[n5];
            }
            ++n5;
        }
        return new UnionSet(this.getType(), sampledSetArray2);
    }

    public SampledSet product(SampledSet sampledSet) throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sampledSetArray = new SampledSet[n];
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (this.Sets[n2] instanceof ProductSet) {
                sampledSetArray[n2] = ((ProductSet)this.Sets[n2]).product(sampledSet);
            } else if (sampledSet instanceof ProductSet) {
                sampledSetArray[n2] = ((ProductSet)sampledSet).inverseProduct(this.Sets[n2]);
            } else if (sampledSet instanceof UnionSet) {
                sampledSetArray[n2] = ((UnionSet)sampledSet).inverseProduct(this.Sets[n2]);
                bl = true;
            } else {
                sampledSetArray[n2] = new ProductSet(new SampledSet[]{this.Sets[n2], sampledSet});
            }
            ++n2;
        }
        SampledSet sampledSet2 = new UnionSet(sampledSetArray);
        if (bl) {
            sampledSet2 = sampledSet2.product();
        }
        return sampledSet2;
    }

    public SampledSet inverseProduct(SampledSet sampledSet) throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sampledSetArray = new SampledSet[n];
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (this.Sets[n2] instanceof ProductSet) {
                sampledSetArray[n2] = ((ProductSet)this.Sets[n2]).inverseProduct(sampledSet);
            } else if (sampledSet instanceof ProductSet) {
                sampledSetArray[n2] = ((ProductSet)sampledSet).product(this.Sets[n2]);
            } else if (sampledSet instanceof UnionSet) {
                sampledSetArray[n2] = ((UnionSet)sampledSet).product(this.Sets[n2]);
                bl = true;
            } else {
                sampledSetArray[n2] = new ProductSet(new SampledSet[]{sampledSet, this.Sets[n2]});
            }
            ++n2;
        }
        SampledSet sampledSet2 = new UnionSet(sampledSetArray);
        if (bl) {
            sampledSet2 = sampledSet2.product();
        }
        return sampledSet2;
    }

    public Set makeSpatial(SetType setType, float[][] fArray) throws VisADException {
        int n = this.Sets.length;
        int n2 = fArray.length;
        SampledSet[] sampledSetArray = new SampledSet[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.Sets[n4].Length;
            float[][] fArray2 = new float[n2][n5];
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n5) {
                    fArray2[n6][n7] = fArray[n6][n3 + n7];
                    ++n7;
                }
                ++n6;
            }
            sampledSetArray[n4] = (SampledSet)this.Sets[n4].makeSpatial(setType, fArray2);
            n3 += n5;
            ++n4;
        }
        UnionSet unionSet = new UnionSet((MathType)((SetType)sampledSetArray[0].getType()), sampledSetArray);
        return unionSet;
    }

    public void cram_missing(boolean[] blArray) {
        int n = blArray.length;
        int n2 = this.Sets.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            try {
                n5 = this.Sets[n4].getLength();
            }
            catch (VisADException visADException) {
                return;
            }
            if (n3 + n5 > n) {
                return;
            }
            boolean[] blArray2 = new boolean[n5];
            System.arraycopy(blArray, n3, blArray2, 0, n5);
            this.Sets[n4].cram_missing(blArray2);
            n3 += n5;
            ++n4;
        }
    }

    public VisADGeometryArray make2DGeometry(byte[][] byArray, boolean bl) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("UnionSet.make2DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new SetException("UnionSet.make2DGeometry: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int n2 = this.DomainDimension;
        if (byArray != null && n2 != byArray.length) {
            throw new SetException("UnionSet.make2DGeometry: color_values dimension should be " + n2 + ", not " + byArray.length);
        }
        if (bl) {
            VisADIndexedTriangleStripArray[] visADIndexedTriangleStripArrayArray = new VisADIndexedTriangleStripArray[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                VisADGeometryArray visADGeometryArray;
                int n5 = this.Sets[n4].Length;
                byte[][] byArray2 = null;
                if (byArray != null) {
                    byArray2 = new byte[n2][n5];
                    int n6 = 0;
                    while (n6 < n2) {
                        int n7 = 0;
                        while (n7 < n5) {
                            byArray2[n6][n7] = byArray[n6][n3 + n7];
                            ++n7;
                        }
                        ++n6;
                    }
                }
                visADIndexedTriangleStripArrayArray[n4] = (visADGeometryArray = this.Sets[n4].make2DGeometry(byArray2, bl)) instanceof VisADIndexedTriangleStripArray ? (VisADIndexedTriangleStripArray)visADGeometryArray : null;
                n3 += n5;
                ++n4;
            }
            return VisADIndexedTriangleStripArray.merge(visADIndexedTriangleStripArrayArray);
        }
        VisADTriangleStripArray[] visADTriangleStripArrayArray = new VisADTriangleStripArray[n];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            VisADGeometryArray visADGeometryArray;
            int n10 = this.Sets[n9].Length;
            byte[][] byArray3 = null;
            if (byArray != null) {
                byArray3 = new byte[n2][n10];
                int n11 = 0;
                while (n11 < n2) {
                    int n12 = 0;
                    while (n12 < n10) {
                        byArray3[n11][n12] = byArray[n11][n8 + n12];
                        ++n12;
                    }
                    ++n11;
                }
            }
            visADTriangleStripArrayArray[n9] = (visADGeometryArray = this.Sets[n9].make2DGeometry(byArray3, bl)) instanceof VisADTriangleStripArray ? (VisADTriangleStripArray)visADGeometryArray : null;
            n8 += n10;
            ++n9;
        }
        return VisADTriangleStripArray.merge(visADTriangleStripArrayArray);
    }

    public VisADGeometryArray make1DGeometry(byte[][] byArray) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("UnionSet.make1DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 1) {
            throw new SetException("UnionSet.make1DGeometry: ManifoldDimension must be 1, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int n2 = this.DomainDimension;
        if (byArray != null && n2 != byArray.length) {
            throw new SetException("UnionSet.make1DGeometry: color_values dimension should be " + n2 + ", not " + byArray.length);
        }
        VisADLineStripArray[] visADLineStripArrayArray = new VisADLineStripArray[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            VisADGeometryArray visADGeometryArray;
            int n5 = this.Sets[n4].Length;
            byte[][] byArray2 = null;
            if (byArray != null) {
                byArray2 = new byte[n2][n5];
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = 0;
                    while (n7 < n5) {
                        byArray2[n6][n7] = byArray[n6][n3 + n7];
                        ++n7;
                    }
                    ++n6;
                }
            }
            visADLineStripArrayArray[n4] = (visADGeometryArray = this.Sets[n4].make1DGeometry(byArray2)) instanceof VisADLineStripArray ? (VisADLineStripArray)visADGeometryArray : null;
            n3 += n5;
            ++n4;
        }
        VisADLineStripArray visADLineStripArray = VisADLineStripArray.merge(visADLineStripArrayArray);
        return visADLineStripArray;
    }

    public VisADGeometryArray[] makeIsoLines(float[] fArray, float f, float f2, float f3, float[] fArray2, byte[][] byArray, boolean[] blArray, boolean bl) throws VisADException {
        Object object;
        int n;
        if (this.DomainDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoLines: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new DisplayException("UnionSet.makeIsoLines: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n2 = this.Sets.length;
        int n3 = byArray.length;
        if (n3 != this.DomainDimension) {
            throw new SetException("UnionSet.makeIsoLines: color_values dimension should be " + this.DomainDimension + ", not " + n3);
        }
        VisADLineArray[][] visADLineArrayArray = new VisADLineArray[n2][];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n = this.Sets[n5].Length;
            object = new byte[n3][n];
            float[] fArray3 = new float[n];
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n) {
                    object[n6][n7] = byArray[n6][n4 + n7];
                    ++n7;
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < n) {
                fArray3[n6] = fArray2[n4 + n6];
                ++n6;
            }
            visADLineArrayArray[n5] = (VisADLineArray[])this.Sets[n5].makeIsoLines(fArray, f, f2, f3, fArray3, (byte[][])object, blArray, bl);
            n4 += n;
            ++n5;
        }
        VisADGeometryArray[] visADGeometryArrayArray = new VisADLineArray[3];
        n = 0;
        while (n < 3) {
            object = new VisADLineArray[n2];
            int n8 = 0;
            while (n8 < n2) {
                object[n8] = (byte[])visADLineArrayArray[n8][n];
                ++n8;
            }
            visADGeometryArrayArray[n] = VisADLineArray.merge((VisADLineArray[])object);
            ++n;
        }
        return visADGeometryArrayArray;
    }

    public VisADGeometryArray makeIsoSurface(float f, float[] fArray, byte[][] byArray, boolean bl) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("UnionSet.makeIsoSurface: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int n = this.Sets.length;
        int n2 = byArray.length;
        if (n2 != this.DomainDimension) {
            throw new SetException("UnionSet.makeIsoSurface: color_values dimension should be " + this.DomainDimension + ", not " + n2);
        }
        if (bl) {
            VisADIndexedTriangleStripArray[] visADIndexedTriangleStripArrayArray = new VisADIndexedTriangleStripArray[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5 = this.Sets[n4].Length;
                byte[][] byArray2 = new byte[n2][n5];
                float[] fArray2 = new float[n5];
                int n6 = 0;
                while (n6 < n2) {
                    int n7 = 0;
                    while (n7 < n5) {
                        byArray2[n6][n7] = byArray[n6][n3 + n7];
                        ++n7;
                    }
                    ++n6;
                }
                n6 = 0;
                while (n6 < n5) {
                    fArray2[n6] = fArray[n3 + n6];
                    ++n6;
                }
                visADIndexedTriangleStripArrayArray[n4] = (VisADIndexedTriangleStripArray)this.Sets[n4].makeIsoSurface(f, fArray2, byArray2, bl);
                n3 += n5;
                ++n4;
            }
            return VisADIndexedTriangleStripArray.merge(visADIndexedTriangleStripArrayArray);
        }
        VisADTriangleStripArray[] visADTriangleStripArrayArray = new VisADTriangleStripArray[n];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            int n10 = this.Sets[n9].Length;
            byte[][] byArray3 = new byte[n2][n10];
            float[] fArray3 = new float[n10];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = 0;
                while (n12 < n10) {
                    byArray3[n11][n12] = byArray[n11][n8 + n12];
                    ++n12;
                }
                ++n11;
            }
            n11 = 0;
            while (n11 < n10) {
                fArray3[n11] = fArray[n8 + n11];
                ++n11;
            }
            visADTriangleStripArrayArray[n9] = (VisADTriangleStripArray)this.Sets[n9].makeIsoSurface(f, fArray3, byArray3, bl);
            n8 += n10;
            ++n9;
        }
        return VisADTriangleStripArray.merge(visADTriangleStripArrayArray);
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToValue(nArray);
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n;
        int n2;
        int n3 = this.Sets.length;
        int n4 = nArray.length;
        float[][] fArray = new float[this.DomainDimension][n4];
        if (n4 == this.getLength()) {
            boolean bl = true;
            int n5 = 0;
            while (n5 < n4) {
                if (nArray[n5] != n5) {
                    bl = false;
                    break;
                }
                ++n5;
            }
            if (bl) {
                n5 = 0;
                int n6 = 0;
                while (n6 < n3) {
                    int n7 = this.Sets[n6].getLength();
                    int[] nArray2 = new int[n7];
                    int n8 = 0;
                    while (n8 < n7) {
                        nArray2[n8] = n8;
                        ++n8;
                    }
                    float[][] fArray2 = this.Sets[n6].indexToValue(nArray2);
                    int n9 = 0;
                    while (n9 < this.DomainDimension) {
                        System.arraycopy(fArray2[n9], 0, fArray[n9], n5, n7);
                        ++n9;
                    }
                    n5 += n7;
                    ++n6;
                }
                return fArray;
            }
        }
        int[][] nArray3 = new int[n3][];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int n10 = 0;
        while (n10 < n4) {
            n2 = 0;
            n = nArray[n10];
            while (n2 < n3 && n >= this.Sets[n2].Length) {
                n -= this.Sets[n2++].Length;
            }
            if (n2 == n3) {
                n += this.Sets[--n2].Length;
            }
            int n11 = n2;
            nArray4[n11] = nArray4[n11] + 1;
            nArray5[n10] = n2;
            nArray6[n10] = n;
            ++n10;
        }
        n10 = 0;
        while (n10 < n3) {
            nArray3[n10] = nArray4[n10] > 0 ? new int[nArray4[n10]] : null;
            nArray4[n10] = 0;
            ++n10;
        }
        n10 = 0;
        while (n10 < n4) {
            int n12 = nArray5[n10];
            int n13 = nArray4[n12];
            nArray4[n12] = n13 + 1;
            nArray3[nArray5[n10]][n13] = nArray6[n10];
            ++n10;
        }
        float[][][] fArray3 = new float[n3][][];
        n2 = 0;
        while (n2 < n3) {
            if (nArray3[n2] != null) {
                fArray3[n2] = this.Sets[n2].indexToValue(nArray3[n2]);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n3) {
            nArray4[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < n4) {
            n = 0;
            while (n < this.DomainDimension) {
                fArray[n][n2] = fArray3[nArray5[n2]][n][nArray4[nArray5[n2]]];
                ++n;
            }
            int n14 = nArray5[n2];
            nArray4[n14] = nArray4[n14] + 1;
            ++n2;
        }
        return fArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        int n = this.Sets.length;
        int n2 = fArray[0].length;
        int[] nArray = new int[n2];
        int[][] nArray2 = new int[n][];
        int n3 = 0;
        while (n3 < n) {
            nArray2[n3] = this.Sets[n3].valueToIndex(fArray);
            ++n3;
        }
        float[][][] fArray2 = new float[n][][];
        int n4 = 0;
        while (n4 < n) {
            fArray2[n4] = this.Sets[n4].indexToValue(nArray2[n4]);
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            float[] fArray3 = new float[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                fArray3[n6] = 0.0f;
                int n7 = 0;
                while (n7 < this.DomainDimension) {
                    if (nArray2[n6][n4] == -1) {
                        fArray3[n6] = Float.MAX_VALUE;
                        break;
                    }
                    float f = fArray2[n6][n7][n4] - fArray[n7][n4];
                    int n8 = n6;
                    fArray3[n8] = fArray3[n8] + f * f;
                    ++n7;
                }
                if (fArray3[n5] > fArray3[n6]) {
                    n5 = n6;
                }
                ++n6;
            }
            n6 = nArray2[n5][n4];
            while (n5 > 0) {
                n6 += this.Sets[--n5].Length;
            }
            nArray[n4] = n6;
            ++n4;
        }
        return nArray;
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n = this.Sets.length;
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int[][] nArray2 = new int[n2][];
            float[][] fArray3 = new float[n2][];
            this.Sets[n4].valueToInterp(fArray, nArray2, fArray3);
            int n5 = 0;
            while (n5 < n2) {
                if (nArray[n5] == null && nArray2[n5] != null) {
                    int n6 = nArray2[n5].length;
                    nArray[n5] = new int[n6];
                    fArray2[n5] = new float[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        nArray[n5][n7] = nArray2[n5][n7] + n3;
                        fArray2[n5][n7] = fArray3[n5][n7];
                        ++n7;
                    }
                }
                ++n5;
            }
            n3 += this.Sets[n4].getLength();
            ++n4;
        }
    }

    public Object clone() {
        try {
            return new UnionSet(this.Type, this.Sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("UnionSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new UnionSet(mathType, this.Sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnionSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        UnionSet unionSet = (UnionSet)object;
        if (unionSet.DomainDimension != this.DomainDimension || unionSet.ManifoldDimension != this.ManifoldDimension) {
            return false;
        }
        int n = 0;
        while (n < this.Sets.length) {
            if (!this.Sets[n].equals(unionSet.Sets[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.DomainDimension ^ this.ManifoldDimension;
            int n = 0;
            while (n < this.Sets.length) {
                this.hashCode ^= this.Sets[n].hashCode();
                ++n;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public boolean isMissing() {
        int n = 0;
        while (n < this.Sets.length) {
            if (this.Sets[n].isMissing()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void main(String[] stringArray) throws VisADException {
        RealType realType = new RealType("1D", null, null);
        RealType[] realTypeArray = new RealType[]{realType};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        float[][] fArray = new float[][]{{2.0f, 4.0f, 6.0f, 8.0f, 10.0f, 12.0f, 14.0f, 16.0f}};
        Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)realTupleType, fArray, 8);
        float[][] fArray2 = new float[][]{{100.0f, 90.0f, 110.0f, 80.0f, 120.0f, 70.0f, 130.0f, 60.0f}};
        Irregular1DSet irregular1DSet = new Irregular1DSet((MathType)realTupleType, fArray2);
        SampledSet[] sampledSetArray = new SampledSet[]{gridded1DSet, irregular1DSet};
        UnionSet unionSet = new UnionSet((MathType)realTupleType, sampledSetArray);
        System.out.println("UnionSet created.");
        System.out.println("ManifoldDimension = " + unionSet.getManifoldDimension());
        System.out.println("-----------------");
        System.out.println("indexToValue test:");
        int[] nArray = new int[]{0, 3, 9, 12, 6, 15};
        float[][] fArray3 = unionSet.indexToValue(nArray);
        int n = 0;
        while (n < nArray.length) {
            System.out.print("index " + nArray[n] + " \t==> (" + fArray3[0][n]);
            int n2 = 1;
            while (n2 < fArray3.length) {
                System.out.print(", " + fArray3[n2][n]);
                ++n2;
            }
            System.out.println(")");
            ++n;
        }
        System.out.println("-----------------");
        System.out.println("valueToIndex test:");
        float[][] fArray4 = new float[][]{{15.0f, 40.0f, 92.0f, 25.0f, 50.0f, 103.0f, 37.0f, 77.0f}};
        int[] nArray2 = unionSet.valueToIndex(fArray4);
        int n3 = 0;
        while (n3 < nArray2.length) {
            System.out.print("(" + fArray4[0][n3]);
            int n4 = 1;
            while (n4 < fArray4.length) {
                System.out.print(", " + fArray4[n4][n3]);
                ++n4;
            }
            System.out.println(")\t==> index " + nArray2[n3]);
            ++n3;
        }
        System.out.println("-----------------");
        System.out.println("valueToInterp test:");
        n3 = fArray4[0].length;
        int[][] nArray3 = new int[n3][];
        float[][] fArray5 = new float[n3][];
        unionSet.valueToInterp(fArray4, nArray3, fArray5);
        int n5 = 0;
        while (n5 < n3) {
            System.out.print("(" + fArray4[0][n5]);
            int n6 = 1;
            while (n6 < fArray4.length) {
                System.out.print(", " + fArray4[n6][n5]);
                ++n6;
            }
            System.out.print(")\t==>");
            if (nArray3[n5] == null || nArray3[n5].length == 0) {
                System.out.println(" missing");
            } else {
                n6 = nArray3[n5].length;
                int n7 = 0;
                while (n7 < n6) {
                    System.out.print(" (" + nArray3[n5][n7] + "," + fArray5[n5][n7] + ")");
                    ++n7;
                }
                System.out.println(" ");
            }
            ++n5;
        }
        System.out.println();
    }

    public String longString(String string) throws VisADException {
        String string2 = string + "UnionSet: Dimension = " + this.DomainDimension + " Length = " + this.getLength() + "\n";
        int n = this.Sets.length;
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + this.Sets[n2].toString();
            ++n2;
        }
        return string2;
    }

    public UnionSet(MathType mathType, SampledSet[] sampledSetArray) throws VisADException {
        this(mathType, sampledSetArray, null, null, null, true);
    }

    private UnionSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, sampledSetArray, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    private UnionSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, UnionSet.find_manifold_dim(sampledSetArray), sampledSetArray[0].getCoordinateSystem(), sampledSetArray[0].getSetUnits(), null);
        int n;
        this.DomainDimension = sampledSetArray[0].DomainDimension;
        if (bl) {
            this.Sets = new SampledSet[sampledSetArray.length];
            n = 0;
            while (n < sampledSetArray.length) {
                this.Sets[n] = (SampledSet)sampledSetArray[n].clone();
                ++n;
            }
        } else {
            this.Sets = sampledSetArray;
        }
        this.Length = 0;
        n = 0;
        while (n < sampledSetArray.length) {
            this.Length += this.Sets[n].Length;
            ++n;
        }
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
        n = 0;
        while (n < this.DomainDimension) {
            this.Low[n] = this.Sets[0].Low[n];
            this.Hi[n] = this.Sets[0].Hi[n];
            int n2 = 1;
            while (n2 < sampledSetArray.length) {
                if (sampledSetArray[n2].Low[n] < this.Low[n]) {
                    this.Low[n] = sampledSetArray[n2].Low[n];
                }
                if (sampledSetArray[n2].Hi[n] > this.Hi[n]) {
                    this.Hi[n] = sampledSetArray[n2].Hi[n];
                }
                ++n2;
            }
            ++n;
        }
    }

    public UnionSet(SampledSet[] sampledSetArray) throws VisADException {
        this(sampledSetArray[0].getType(), sampledSetArray, null, null, null, true);
    }
}

