/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowType;
import visad.Tuple;
import visad.TypeException;
import visad.VisADException;

public class TupleType
extends MathType {
    private MathType[] tupleComponents;
    private boolean Flat;
    private final RealType[] realComponents;
    private int[] lows;
    private int[] his;

    public int getDimension() {
        return this.tupleComponents.length;
    }

    public MathType[] getComponents() {
        return this.tupleComponents;
    }

    public RealType[] getRealComponents() {
        return this.realComponents;
    }

    public int getNumberOfRealComponents() {
        return this.realComponents.length;
    }

    public MathType __getitem__(int n) throws VisADException {
        return this.getComponent(n);
    }

    public int __len__() {
        return this.tupleComponents.length;
    }

    public MathType getComponent(int n) throws VisADException {
        if (n >= 0 && n < this.tupleComponents.length) {
            return this.tupleComponents[n];
        }
        throw new TypeException("TupleType: component index out of range");
    }

    public int getIndex(String string) {
        return this.getIndex(RealType.getRealTypeByName(string));
    }

    public int getIndex(MathType mathType) {
        int n = 0;
        while (n < this.tupleComponents.length) {
            if (this.tupleComponents[n].equals(mathType)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)object).getDimension()) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.tupleComponents[n2].equals(((TupleType)object).getComponent(n2))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (VisADException visADException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.asList(this.tupleComponents).hashCode();
    }

    public boolean equalsExceptName(MathType mathType) {
        if (!(mathType instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)mathType).getDimension()) {
                return false;
            }
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                bl = bl && this.tupleComponents[n2].equalsExceptName(((TupleType)mathType).getComponent(n2));
                ++n2;
            }
            return bl;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public boolean equalsExceptNameButUnits(MathType mathType) {
        if (!(mathType instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)mathType).getDimension()) {
                return false;
            }
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                bl = bl && this.tupleComponents[n2].equalsExceptNameButUnits(((TupleType)mathType).getComponent(n2));
                ++n2;
            }
            return bl;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public MathType cloneDerivative(RealType realType) throws VisADException {
        int n = this.tupleComponents.length;
        MathType[] mathTypeArray = new MathType[n];
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            mathTypeArray[n2] = this.getComponent(n2).cloneDerivative(realType);
            if (!(mathTypeArray[n2] instanceof RealType)) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            RealType[] realTypeArray = new RealType[n];
            int n3 = 0;
            while (n3 < n) {
                realTypeArray[n3] = (RealType)mathTypeArray[n3];
                ++n3;
            }
            return new RealTupleType(realTypeArray);
        }
        return new TupleType(mathTypeArray);
    }

    public MathType binary(MathType mathType, int n, Vector vector) throws VisADException {
        if (mathType == null) {
            throw new TypeException("TupleType.binary: type may not be null");
        }
        if (mathType instanceof RealTupleType) {
            throw new TypeException("TupleType.binary: types don't match");
        }
        if (mathType instanceof TupleType) {
            int n2 = this.tupleComponents.length;
            MathType[] mathTypeArray = new MathType[n2];
            int n3 = 0;
            while (n3 < n2) {
                MathType mathType2 = ((TupleType)mathType).getComponent(n3);
                mathTypeArray[n3] = this.getComponent(n3).binary(mathType2, n, vector);
                ++n3;
            }
            return new TupleType(mathTypeArray);
        }
        if (mathType instanceof RealType) {
            int n4 = this.tupleComponents.length;
            MathType[] mathTypeArray = new MathType[n4];
            int n5 = 0;
            while (n5 < n4) {
                mathTypeArray[n5] = this.getComponent(n5).binary(mathType, n, vector);
                ++n5;
            }
            return new TupleType(mathTypeArray);
        }
        if (mathType instanceof FunctionType && ((FunctionType)mathType).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)mathType).getDomain(), ((FunctionType)mathType).getRange().binary(this, DataImpl.invertOp(n), vector));
        }
        throw new TypeException("TupleType.binary: types don't match");
    }

    public MathType unary(int n, Vector vector) throws VisADException {
        int n2 = this.tupleComponents.length;
        MathType[] mathTypeArray = new MathType[n2];
        int n3 = 0;
        while (n3 < n2) {
            mathTypeArray[n3] = this.getComponent(n3).unary(n, vector);
            ++n3;
        }
        return new TupleType(mathTypeArray);
    }

    public boolean getFlat() {
        return this.Flat;
    }

    public String prettyString(int n) {
        int n2 = this.tupleComponents.length;
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            stringArray[n5] = this.tupleComponents[n5].prettyString(n + 1);
            nArray[n5] = stringArray[n5].length();
            if (nArray[n5] > n3) {
                n3 = nArray[n5];
            }
            n4 += nArray[n5];
            ++n5;
        }
        if (n4 + n <= 72) {
            String string = "(" + stringArray[0];
            int n6 = 1;
            while (n6 < n2) {
                string = string + ", " + stringArray[n6];
                ++n6;
            }
            return string + ")";
        }
        String string = "";
        int n7 = 0;
        while (n7 < n + 1) {
            string = string + " ";
            ++n7;
        }
        String string2 = "(" + stringArray[0];
        if (1 < n2) {
            string2 = string2 + ",";
        }
        int n8 = 1;
        while (n8 < n2) {
            string2 = string2 + "\n" + string + stringArray[n8];
            if (n8 + 1 < n2) {
                string2 = string2 + ",";
            }
            ++n8;
        }
        return string2 + ")";
    }

    public Data missingData() {
        return new Tuple(this);
    }

    public ShadowType buildShadowType(DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return dataDisplayLink.getRenderer().makeShadowTupleType(this, dataDisplayLink, shadowType);
    }

    public TupleType(MathType[] mathTypeArray) throws VisADException {
        boolean bl = true;
        this.Flat = true;
        int n = mathTypeArray.length;
        int n2 = 0;
        this.tupleComponents = new MathType[n];
        if (n < 1) {
            throw new TypeException("TupleType: # components must be > 0");
        }
        int n3 = 0;
        while (n3 < n) {
            if (mathTypeArray[n3] == null) {
                throw new TypeException("TupleType: components must be non-null");
            }
            this.tupleComponents[n3] = mathTypeArray[n3];
            if (!(mathTypeArray[n3] instanceof RealType)) {
                bl = false;
            }
            if (mathTypeArray[n3] instanceof RealType) {
                ++n2;
            } else if (mathTypeArray[n3] instanceof RealTupleType) {
                n2 += ((RealTupleType)mathTypeArray[n3]).getDimension();
            } else {
                this.Flat = false;
            }
            ++n3;
        }
        if (bl && !(this instanceof RealTupleType)) {
            throw new TypeException("TupleType: all components are RealType, must use RealTupleType");
        }
        this.realComponents = new RealType[n2];
        this.lows = new int[n];
        this.his = new int[n];
        n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            this.lows[n4] = n3;
            if (mathTypeArray[n4] instanceof RealType) {
                this.realComponents[n3] = (RealType)mathTypeArray[n4];
            } else if (mathTypeArray[n4] instanceof RealTupleType) {
                int n5 = ((RealTupleType)mathTypeArray[n4]).getDimension();
                int n6 = 0;
                while (n6 < n5) {
                    this.realComponents[n3] = (RealType)((RealTupleType)mathTypeArray[n4]).getComponent(n6);
                    ++n3;
                    ++n6;
                }
            }
            this.his[n4] = ++n3;
            ++n4;
        }
    }

    TupleType(RealType[] realTypeArray, boolean bl) {
        super(bl);
        boolean bl2 = true;
        this.Flat = true;
        int n = realTypeArray.length;
        int n2 = 0;
        this.tupleComponents = new MathType[n];
        int n3 = 0;
        while (n3 < n) {
            this.tupleComponents[n3] = realTypeArray[n3];
            ++n2;
            ++n3;
        }
        this.realComponents = new RealType[n2];
        this.lows = new int[n];
        this.his = new int[n];
        n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            this.lows[n4] = n3;
            if (realTypeArray[n4] instanceof RealType) {
                this.realComponents[n3] = realTypeArray[n4];
            }
            this.his[n4] = ++n3;
            ++n4;
        }
    }
}

