/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.Field;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.Text;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.VisADError;
import visad.VisADException;

public class Tuple
extends DataImpl
implements TupleIface {
    Data[] tupleComponents;

    public static Tuple makeTuple(Data[] dataArray) throws VisADException, RemoteException {
        return new Tuple(dataArray);
    }

    static boolean checkTupleType(TupleType tupleType, Data[] dataArray) throws VisADException, RemoteException {
        if (dataArray == null || tupleType == null) {
            return false;
        }
        int n = dataArray.length;
        if (n != tupleType.getDimension()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!tupleType.getComponent(n2).equals(dataArray[n2].getType())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static TupleType buildTupleType(Data[] dataArray) throws VisADException, RemoteException {
        if (dataArray == null) {
            throw new TypeException("Tuple: # components must be > 0");
        }
        int n = dataArray.length;
        if (n < 1) {
            throw new TypeException("Tuple: # components must be > 0");
        }
        MathType[] mathTypeArray = new MathType[n];
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            mathTypeArray[n2] = dataArray[n2].getType();
            if (!(mathTypeArray[n2] instanceof RealType)) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            RealType[] realTypeArray = new RealType[n];
            int n3 = 0;
            while (n3 < n) {
                realTypeArray[n3] = (RealType)mathTypeArray[n3];
                ++n3;
            }
            return new RealTupleType(realTypeArray);
        }
        return new TupleType(mathTypeArray);
    }

    public Real[] getRealComponents() throws VisADException, RemoteException {
        if (this.tupleComponents == null) {
            return null;
        }
        Vector<Data> vector = new Vector<Data>();
        int n = 0;
        while (n < this.tupleComponents.length) {
            if (this.tupleComponents[n] instanceof Real) {
                vector.addElement(this.tupleComponents[n]);
            } else if (this.tupleComponents[n] instanceof RealTuple) {
                RealTuple realTuple = (RealTuple)this.tupleComponents[n];
                int n2 = 0;
                while (n2 < realTuple.getDimension()) {
                    vector.addElement(realTuple.getComponent(n2));
                    ++n2;
                }
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        Real[] realArray = new Real[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            realArray[n3] = (Real)vector.elementAt(n3);
            ++n3;
        }
        return realArray;
    }

    public Data[] getComponents() {
        return this.tupleComponents;
    }

    public int getDimension() {
        if (this.tupleComponents != null) {
            return this.tupleComponents.length;
        }
        return ((TupleType)this.getType()).getDimension();
    }

    public Data getComponent(int n) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return ((TupleType)this.Type).getComponent(n).missingData();
        }
        if (n >= 0 && n < this.tupleComponents.length) {
            return this.tupleComponents[n];
        }
        throw new TypeException("Tuple: component index out of range");
    }

    public boolean isMissing() {
        return this.tupleComponents == null;
    }

    public Data binary(Data data, int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof RealTuple) {
            throw new TypeException("Tuple.binary: types don't match");
        }
        if (data instanceof Tuple) {
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("Tuple.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(mathType)) {
                throw new TypeException();
            }
            if (this.isMissing() || data.isMissing()) {
                return new Tuple((TupleType)mathType);
            }
            Data[] dataArray = new Data[this.tupleComponents.length];
            int n4 = 0;
            while (n4 < this.tupleComponents.length) {
                MathType mathType2 = ((TupleType)mathType).getComponent(n4);
                dataArray[n4] = this.tupleComponents[n4].binary(((Tuple)data).getComponent(n4), n, mathType2, n2, n3);
                ++n4;
            }
            return new Tuple(dataArray);
        }
        if (data instanceof Real) {
            if (!this.Type.equalsExceptName(mathType)) {
                throw new TypeException();
            }
            if (this.isMissing() || data.isMissing()) {
                return new Tuple((TupleType)mathType);
            }
            Data[] dataArray = new Data[this.tupleComponents.length];
            int n5 = 0;
            while (n5 < this.tupleComponents.length) {
                MathType mathType3 = ((TupleType)mathType).getComponent(n5);
                dataArray[n5] = this.tupleComponents[n5].binary(data, n, mathType3, n2, n3);
                ++n5;
            }
            return new Tuple(dataArray);
        }
        if (data instanceof Text) {
            throw new TypeException("Tuple.binary: types don't match");
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(mathType)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(n), mathType, n2, n3);
        }
        throw new TypeException("Tuple.binary");
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(mathType)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        TupleType tupleType = (TupleType)mathType;
        if (this.isMissing()) {
            return new Tuple((TupleType)mathType);
        }
        Data[] dataArray = new Data[this.tupleComponents.length];
        int n4 = 0;
        while (n4 < this.tupleComponents.length) {
            dataArray[n4] = this.tupleComponents[n4].unary(n, tupleType.getComponent(n4), n2, n3);
            ++n4;
        }
        return new Tuple(dataArray);
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return dataShadow;
        }
        int n = 0;
        while (n < this.tupleComponents.length) {
            dataShadow = this.tupleComponents[n].computeRanges(((ShadowTupleType)shadowType).getComponent(n), dataShadow);
            ++n;
        }
        return dataShadow;
    }

    public Data adjustSamplingError(Data data, int n) throws VisADException, RemoteException {
        if (this.isMissing() || data == null || data.isMissing()) {
            return this;
        }
        int n2 = this.tupleComponents.length;
        Data[] dataArray = new Data[n2];
        int n3 = 0;
        while (n3 < n2) {
            Data data2 = ((Tuple)data).getComponent(n3);
            dataArray[n3] = this.tupleComponents[n3].adjustSamplingError(data2, n);
            ++n3;
        }
        return new Tuple(dataArray);
    }

    public Data __getitem__(int n) throws VisADException, RemoteException {
        return this.getComponent(n);
    }

    public int __len__() {
        return this.getDimension();
    }

    public int getLength() {
        return this.getDimension();
    }

    public Object clone() {
        Tuple tuple;
        try {
            if (this.tupleComponents == null) {
                tuple = new Tuple((TupleType)this.getType());
            } else {
                int n = this.tupleComponents.length;
                Data[] dataArray = new Data[n];
                int n2 = 0;
                while (n2 < n) {
                    dataArray[n2] = (Data)this.tupleComponents[n2].dataClone();
                    ++n2;
                }
                tuple = new Tuple(dataArray);
            }
        }
        catch (VisADException visADException) {
            throw new VisADError("Tuple.clone: VisADException occurred");
        }
        catch (RemoteException remoteException) {
            throw new VisADError("Tuple.clone: RemoteException occurred");
        }
        return tuple;
    }

    public String longString(String string) throws VisADException, RemoteException {
        String string2 = string + "Tuple\n" + string + "  Type: " + this.Type.toString() + "\n";
        if (this.isMissing()) {
            return string2 + "  missing\n";
        }
        int n = 0;
        while (n < this.tupleComponents.length) {
            string2 = string2 + string + "  Tuple Component " + n + ":\n" + this.tupleComponents[n].longString(string + "    ");
            ++n;
        }
        return string2;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Tuple)) {
            bl = false;
        } else {
            Tuple tuple = (Tuple)object;
            if (this == tuple) {
                bl = true;
            } else if (this.tupleComponents == null || tuple.tupleComponents == null) {
                bl = this.tupleComponents == tuple.tupleComponents;
            } else if (this.tupleComponents.length != tuple.tupleComponents.length) {
                bl = false;
            } else {
                bl = true;
                int n = 0;
                while (n < this.tupleComponents.length) {
                    if (!this.tupleComponents[n].equals(tuple.tupleComponents[n])) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.tupleComponents != null) {
            int n2 = 0;
            while (n2 < this.tupleComponents.length) {
                n ^= this.tupleComponents[n2].hashCode();
                ++n2;
            }
        }
        return n;
    }

    public Tuple(TupleType tupleType) {
        super(tupleType);
        if (tupleType instanceof RealTupleType && !(this instanceof RealTuple)) {
            throw new VisADError("must construct as RealTupleType");
        }
    }

    public Tuple(TupleType tupleType, Data[] dataArray) throws VisADException, RemoteException {
        this(tupleType, dataArray, true);
    }

    public Tuple(TupleType tupleType, Data[] dataArray, boolean bl) throws VisADException, RemoteException {
        super(tupleType);
        if (!Tuple.checkTupleType(tupleType, dataArray)) {
            throw new TypeException("Tuple: type does not match data");
        }
        if (tupleType instanceof RealTupleType && !(this instanceof RealTuple)) {
            throw new TypeException("must construct as RealTupleType");
        }
        int n = dataArray.length;
        this.tupleComponents = new Data[n];
        int n2 = 0;
        while (n2 < n) {
            this.tupleComponents[n2] = bl ? (Data)dataArray[n2].dataClone() : dataArray[n2];
            if (this.tupleComponents[n2] instanceof DataImpl) {
                ((DataImpl)this.tupleComponents[n2]).setParent(this);
            }
            ++n2;
        }
    }

    public Tuple(Data[] dataArray, boolean bl) throws VisADException, RemoteException {
        this(Tuple.buildTupleType(dataArray), dataArray, bl);
    }

    public Tuple(Data[] dataArray) throws VisADException, RemoteException {
        this(Tuple.buildTupleType(dataArray), dataArray, true);
    }
}

