/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Control;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;

public class ToggleControl
extends Control {
    private boolean on;
    private Control parent;

    public Control getParent() {
        return this.parent;
    }

    public boolean getOn() {
        return this.on;
    }

    public void setOn(boolean bl) throws VisADException, RemoteException {
        this.on = bl;
        this.changeControl(true);
    }

    private boolean parentEquals(Control control) {
        if (this.parent == null) {
            if (control != null) {
                return false;
            }
        } else {
            if (control == null) {
                return false;
            }
            if (!this.parent.equals(control)) {
                return false;
            }
        }
        return true;
    }

    public String getSaveString() {
        return "" + this.on;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        this.setOn(Convert.getBoolean(string));
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof ToggleControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        ToggleControl toggleControl = (ToggleControl)control;
        boolean bl = false;
        if (this.on != toggleControl.on) {
            bl = true;
            this.on = toggleControl.on;
        }
        if (!this.parentEquals(toggleControl.parent)) {
            bl = true;
            this.parent = toggleControl.parent;
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ToggleControl toggleControl = (ToggleControl)object;
        if (this.on != toggleControl.on) {
            return false;
        }
        return this.parentEquals(toggleControl.parent);
    }

    public ToggleControl(DisplayImpl displayImpl, Control control) {
        super(displayImpl);
        this.parent = control;
        this.on = true;
    }
}

