/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.Action;
import visad.ActionImpl;
import visad.ReferenceException;
import visad.RemoteAction;
import visad.RemoteThing;
import visad.RemoteThingReference;
import visad.RemoteVisADException;
import visad.Thing;
import visad.ThingChangedEvent;
import visad.ThingChangedLink;
import visad.ThingChangedListener;
import visad.ThingReference;
import visad.VisADException;

public class ThingReferenceImpl
implements ThingReference {
    String Name;
    private transient Thing thing;
    private transient ThingReference ref;
    private long Tick;
    transient Vector ListenerVector = new Vector();

    public Thing getThing() {
        return this.thing;
    }

    public synchronized void setThing(Thing thing) throws VisADException, RemoteException {
        if (thing instanceof RemoteThing) {
            throw new RemoteVisADException("ThingReferenceImpl.setThing: cannot use RemoteThing");
        }
        if (this.thing != null) {
            this.thing.removeReference(this.ref);
        }
        this.ref = this;
        this.thing = thing;
        if (thing != null) {
            thing.addReference(this.ref);
        }
        this.incTick();
    }

    synchronized void adaptedSetThing(RemoteThing remoteThing, RemoteThingReference remoteThingReference) throws VisADException, RemoteException {
        if (this.thing != null) {
            this.thing.removeReference(this.ref);
        }
        this.ref = remoteThingReference;
        this.thing = remoteThing;
        remoteThing.addReference(this.ref);
        this.incTick();
    }

    public long getTick() {
        return this.Tick;
    }

    public synchronized long incTick() throws VisADException, RemoteException {
        ++this.Tick;
        if (this.Tick == Long.MAX_VALUE) {
            this.Tick = -9223372036854775807L;
        }
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                int n = 0;
                while (n < this.ListenerVector.size()) {
                    ThingChangedLink thingChangedLink = (ThingChangedLink)this.ListenerVector.elementAt(n);
                    ThingChangedEvent thingChangedEvent = new ThingChangedEvent(thingChangedLink.getId(), this.Tick);
                    try {
                        thingChangedLink.queueThingChangedEvent(thingChangedEvent);
                        ++n;
                    }
                    catch (ConnectException connectException) {
                        this.ListenerVector.remove(n);
                    }
                }
            }
        }
        return this.Tick;
    }

    public ThingChangedEvent acknowledgeThingChanged(Action action) throws VisADException {
        if (!(action instanceof ActionImpl)) {
            throw new RemoteVisADException("ThingReferenceImpl.acknowledgeThingChanged: Action must be local");
        }
        if (this.ListenerVector == null) {
            return null;
        }
        ThingChangedLink thingChangedLink = this.findThingChangedLink(action);
        if (thingChangedLink == null) {
            return null;
        }
        return thingChangedLink.acknowledgeThingChangedEvent();
    }

    public ThingChangedEvent adaptedAcknowledgeThingChanged(RemoteAction remoteAction) throws VisADException {
        if (this.ListenerVector == null) {
            return null;
        }
        ThingChangedLink thingChangedLink = this.findThingChangedLink(remoteAction);
        if (thingChangedLink == null) {
            return null;
        }
        return thingChangedLink.acknowledgeThingChangedEvent();
    }

    public ThingChangedLink findThingChangedLink(Action action) throws VisADException {
        if (action == null) {
            throw new ReferenceException("ThingReferenceImpl.findThingChangedLink: Action cannot be null");
        }
        if (this.ListenerVector == null) {
            return null;
        }
        Vector vector = this.ListenerVector;
        synchronized (vector) {
            Enumeration enumeration = this.ListenerVector.elements();
            while (enumeration.hasMoreElements()) {
                ThingChangedLink thingChangedLink = (ThingChangedLink)enumeration.nextElement();
                if (!action.equals(thingChangedLink.getAction())) continue;
                ThingChangedLink thingChangedLink2 = thingChangedLink;
                Object var3_6 = null;
                return thingChangedLink2;
            }
        }
        return null;
    }

    public String getName() {
        return this.Name;
    }

    public void addThingChangedListener(ThingChangedListener thingChangedListener, long l) throws VisADException {
        if (!(thingChangedListener instanceof ActionImpl)) {
            throw new RemoteVisADException("ThingReferenceImpl.addThingChangedListener: Action must be local");
        }
        Object object = this;
        synchronized (object) {
            if (this.ListenerVector == null) {
                this.ListenerVector = new Vector();
            }
        }
        object = this.ListenerVector;
        synchronized (object) {
            if (this.findThingChangedLink((ActionImpl)thingChangedListener) != null) {
                throw new ReferenceException("ThingReferenceImpl.addThingChangedListener: link to Action already exists");
            }
            this.ListenerVector.addElement(new ThingChangedLink((ActionImpl)thingChangedListener, l));
        }
    }

    void adaptedAddThingChangedListener(RemoteAction remoteAction, long l) throws VisADException {
        Object object = this;
        synchronized (object) {
            if (this.ListenerVector == null) {
                this.ListenerVector = new Vector();
            }
        }
        object = this.ListenerVector;
        synchronized (object) {
            if (this.findThingChangedLink(remoteAction) != null) {
                throw new ReferenceException("ThingReferenceImpl.addThingChangedListener: link to Action already exists");
            }
            this.ListenerVector.addElement(new ThingChangedLink(remoteAction, l));
        }
    }

    public void removeThingChangedListener(ThingChangedListener thingChangedListener) throws VisADException {
        if (!(thingChangedListener instanceof ActionImpl)) {
            throw new RemoteVisADException("ThingReferenceImpl.removeThingChangedListener: Action must be local");
        }
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                ThingChangedLink thingChangedLink = this.findThingChangedLink((ActionImpl)thingChangedListener);
                if (thingChangedLink != null) {
                    this.ListenerVector.removeElement(thingChangedLink);
                }
            }
        }
    }

    void adaptedRemoveThingChangedListener(RemoteAction remoteAction) throws VisADException {
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                ThingChangedLink thingChangedLink = this.findThingChangedLink(remoteAction);
                if (thingChangedLink != null) {
                    this.ListenerVector.removeElement(thingChangedLink);
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ThingReference)) {
            return false;
        }
        return object == this;
    }

    public String toString() {
        return "ThingReference " + this.Name;
    }

    public ThingReferenceImpl(String string) throws VisADException {
        if (string == null) {
            throw new VisADException("ThingReference: name cannot be null");
        }
        this.Name = string;
        this.Tick = -9223372036854775807L;
    }
}

