/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.ReferenceException;
import visad.RemoteThing;
import visad.RemoteThingReference;
import visad.RemoteVisADException;
import visad.Thing;
import visad.ThingReference;
import visad.ThingReferenceImpl;
import visad.VisADException;

public class ThingImpl
implements Thing,
Serializable {
    private transient Vector references = new Vector();

    public void addReference(ThingReference thingReference) throws VisADException {
        if (!(thingReference instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ThingImpl.addReference: must use ThingReferenceImpl");
        }
        ThingImpl thingImpl = this;
        synchronized (thingImpl) {
            if (this.references == null) {
                this.references = new Vector();
            }
        }
        this.references.addElement(thingReference);
    }

    void adaptedAddReference(RemoteThingReference remoteThingReference, RemoteThing remoteThing) throws VisADException {
        RemotePair remotePair;
        try {
            remotePair = new RemotePair(remoteThingReference, remoteThing);
        }
        catch (ReferenceException referenceException) {
            throw new ReferenceException("ThingImpl.adaptedAddReference: " + referenceException.getMessage());
        }
        ThingImpl thingImpl = this;
        synchronized (thingImpl) {
            if (this.references == null) {
                this.references = new Vector();
            }
        }
        this.references.addElement(remotePair);
    }

    public void removeReference(ThingReference thingReference) throws VisADException {
        if (this.references == null) {
            throw new ReferenceException("ThingImpl.removeReference: already clear");
        }
        if (!(thingReference instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ThingImpl.removeReference: must use RemoteThing for RemoteThingReference");
        }
        if (!this.references.removeElement(thingReference)) {
            throw new ReferenceException("ThingImpl.removeReference: not found");
        }
    }

    void adaptedRemoveReference(RemoteThingReference remoteThingReference, RemoteThing remoteThing) throws VisADException {
        RemotePair remotePair;
        if (this.references == null) {
            throw new ReferenceException("ThingImpl.removeReference: already clear");
        }
        try {
            remotePair = new RemotePair(remoteThingReference, remoteThing);
        }
        catch (ReferenceException referenceException) {
            throw new ReferenceException("ThingImpl.adaptedRemoveReference: " + referenceException.getMessage());
        }
        if (!this.references.removeElement(remotePair)) {
            throw new ReferenceException("ThingImpl.adaptedRemoveReference:  not found");
        }
    }

    public void notifyReferences() throws VisADException, RemoteException {
        if (this.references != null) {
            Vector vector = this.references;
            synchronized (vector) {
                Enumeration enumeration = this.references.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e instanceof ThingReferenceImpl) {
                        ((ThingReferenceImpl)e).incTick();
                        continue;
                    }
                    RemoteThing remoteThing = ((RemotePair)e).data;
                    remoteThing.incTick();
                }
            }
        }
    }

    class RemotePair {
        RemoteThingReference ref;
        RemoteThing data;

        public boolean equals(Object object) {
            if (!(object instanceof RemotePair)) {
                return false;
            }
            RemotePair remotePair = (RemotePair)object;
            return this.ref.equals(((RemotePair)object).ref) && this.data.equals(((RemotePair)object).data);
        }

        RemotePair(RemoteThingReference remoteThingReference, RemoteThing remoteThing) throws ReferenceException {
            if (remoteThingReference == null) {
                throw new ReferenceException("Cannot create RemotePair from null RemoteThingReference");
            }
            if (remoteThing == null) {
                throw new ReferenceException("Cannot create RemotePair from null RemoteThing");
            }
            this.ref = remoteThingReference;
            this.data = remoteThing;
        }
    }
}

