/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.MathType;
import visad.RealType;
import visad.ScalarType;
import visad.ShadowType;
import visad.Text;
import visad.TypeException;
import visad.UnimplementedException;
import visad.VisADException;

public class TextType
extends ScalarType {
    public static final TextType Generic = new TextType("GENERIC_TEXT", true);

    public boolean equals(Object object) {
        if (!(object instanceof TextType)) {
            return false;
        }
        return this.getName().equals(((TextType)object).getName());
    }

    public boolean equalsExceptName(MathType mathType) {
        return mathType instanceof TextType;
    }

    public boolean equalsExceptNameButUnits(MathType mathType) throws VisADException {
        throw new UnimplementedException("TextType: equalsExceptNameButUnits");
    }

    public MathType cloneDerivative(RealType realType) throws VisADException {
        throw new UnimplementedException("TexType: cloneDerivative");
    }

    public MathType binary(MathType mathType, int n, Vector vector) throws VisADException {
        if (mathType == null) {
            throw new TypeException("TextType.binary: type may not be null");
        }
        if (mathType instanceof TextType) {
            return this;
        }
        throw new TypeException("TextType.binary: types don't match");
    }

    public MathType unary(int n, Vector vector) throws VisADException {
        throw new UnimplementedException("TextType: unary");
    }

    public static TextType getTextType(String string) {
        try {
            return new TextType(string);
        }
        catch (TypeException typeException) {
            return TextType.getTextTypeByName(string);
        }
        catch (VisADException visADException) {
            return null;
        }
    }

    public static TextType getTextTypeByName(String string) {
        ScalarType scalarType = ScalarType.getScalarTypeByName(string);
        if (!(scalarType instanceof TextType)) {
            return null;
        }
        return (TextType)scalarType;
    }

    public String prettyString(int n) {
        return this.getName() + "(Text)";
    }

    public Data missingData() throws VisADException {
        return new Text(this);
    }

    public ShadowType buildShadowType(DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return dataDisplayLink.getRenderer().makeShadowTextType(this, dataDisplayLink, shadowType);
    }

    public TextType(String string) throws VisADException {
        super(string);
    }

    TextType(String string, boolean bl) {
        super(string, bl);
    }
}

