/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.UnimplementedException;
import visad.VisADException;
import visad.util.HersheyFont;
import visad.util.Util;

public class TextControl
extends Control {
    private Object font = null;
    private double size = 1.0;
    private boolean sphere = false;
    private NumberFormat format = null;
    private double rotation = 0.0;
    private boolean autoSize = false;
    private ProjectionControlListener pcl = null;
    private Justification justification = Justification.LEFT;

    public void setAutoSize(boolean bl) throws VisADException {
        if (bl == this.autoSize) {
            return;
        }
        DisplayImpl displayImpl = this.getDisplay();
        DisplayRenderer displayRenderer = displayImpl.getDisplayRenderer();
        MouseBehavior mouseBehavior = displayRenderer.getMouseBehavior();
        ProjectionControl projectionControl = displayImpl.getProjectionControl();
        if (bl) {
            this.pcl = new ProjectionControlListener(mouseBehavior, this, projectionControl);
            projectionControl.addControlListener(this.pcl);
        } else {
            projectionControl.removeControlListener(this.pcl);
        }
        this.autoSize = bl;
        try {
            this.changeControl(true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void nullControl() {
        try {
            this.setAutoSize(false);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        super.nullControl();
    }

    public void setFont(Object object) throws VisADException, RemoteException {
        if (!(object instanceof Font) && !(object instanceof HersheyFont)) {
            throw new VisADException("Font must be java.awt.Font or HersheyFont");
        }
        this.font = object;
        this.changeControl(true);
    }

    public Font getFont() {
        if (this.font instanceof Font) {
            return (Font)this.font;
        }
        return null;
    }

    public HersheyFont getHersheyFont() {
        if (this.font instanceof HersheyFont) {
            return (HersheyFont)this.font;
        }
        return null;
    }

    public void setCenter(boolean bl) throws VisADException, RemoteException {
        this.justification = Justification.CENTER;
        this.changeControl(true);
    }

    public boolean getCenter() {
        return this.justification == Justification.CENTER;
    }

    public void setJustification(Justification justification) throws VisADException, RemoteException {
        this.justification = justification;
        this.changeControl(true);
    }

    public Justification getJustification() {
        return this.justification;
    }

    public void setSize(double d) throws VisADException, RemoteException {
        this.size = d;
        this.changeControl(true);
    }

    public double getSize() {
        return this.size;
    }

    public void setSphere(boolean bl) throws VisADException, RemoteException {
        this.sphere = bl;
        this.changeControl(true);
    }

    public boolean getSphere() {
        return this.sphere;
    }

    public void setNumberFormat(NumberFormat numberFormat) throws VisADException, RemoteException {
        this.format = numberFormat;
        this.changeControl(true);
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    private boolean fontEquals(Object object) {
        if (this.font == null) {
            if (object != null) {
                return false;
            }
        } else {
            if (object == null) {
                return false;
            }
            if (!this.font.equals(object)) {
                return false;
            }
        }
        return true;
    }

    private boolean formatEquals(NumberFormat numberFormat) {
        if (this.format == null) {
            if (numberFormat != null) {
                return false;
            }
        } else {
            if (numberFormat == null) {
                return false;
            }
            if (!this.format.equals(numberFormat)) {
                return false;
            }
        }
        return true;
    }

    public void setRotation(double d) throws VisADException, RemoteException {
        this.rotation = d;
        this.changeControl(true);
    }

    public double getRotation() {
        return this.rotation;
    }

    public String getSaveString() {
        return null;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof TextControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        TextControl textControl = (TextControl)control;
        boolean bl = false;
        if (!this.fontEquals(textControl.font)) {
            bl = true;
            this.font = textControl.font;
        }
        if (this.justification != textControl.justification) {
            bl = true;
            this.justification = textControl.justification;
        }
        if (!Util.isApproximatelyEqual(this.size, textControl.size)) {
            bl = true;
            this.size = textControl.size;
        }
        if (this.sphere != textControl.sphere) {
            bl = true;
            this.sphere = textControl.sphere;
        }
        if (!this.formatEquals(textControl.format)) {
            bl = true;
            this.format = textControl.format;
        }
        if (!Util.isApproximatelyEqual(this.rotation, textControl.rotation)) {
            bl = true;
            this.rotation = textControl.rotation;
        }
        if (this.autoSize != textControl.autoSize) {
            this.setAutoSize(textControl.autoSize);
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        TextControl textControl = (TextControl)object;
        if (!this.fontEquals(this.font)) {
            return false;
        }
        if (this.justification != textControl.justification) {
            return false;
        }
        if (this.sphere != textControl.sphere) {
            return false;
        }
        if (!this.formatEquals(textControl.format)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.rotation, textControl.rotation)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.size, textControl.size)) {
            return false;
        }
        return this.autoSize == textControl.autoSize;
    }

    public TextControl(DisplayImpl displayImpl) {
        super(displayImpl);
    }

    public static class Justification {
        public static final Justification LEFT = new Justification("Left");
        public static final Justification CENTER = new Justification("Center");
        public static final Justification RIGHT = new Justification("Right");
        String name;

        public Justification(String string) {
            this.name = string;
        }
    }

    class ProjectionControlListener
    implements ControlListener {
        private boolean pfirst = true;
        private MouseBehavior mouse;
        private ProjectionControl pcontrol;
        private TextControl text_control;
        private double base_scale = 1.0;
        private float last_cscale = 1.0f;
        private double base_size = 1.0;

        public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
            double[] dArray = this.pcontrol.getMatrix();
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[3];
            this.mouse.instance_unmake_matrix(dArray2, dArray3, dArray4, dArray);
            if (this.pfirst) {
                this.pfirst = false;
                this.base_scale = dArray3[0];
                this.last_cscale = 1.0f;
                this.base_size = this.text_control.getSize();
            } else {
                float f = (float)(this.base_scale / dArray3[0]);
                float f2 = f / this.last_cscale;
                if (f2 < 0.95f || 1.05f < f2) {
                    this.last_cscale = f;
                    this.text_control.setSize(this.base_size * (double)f);
                }
            }
        }

        ProjectionControlListener(MouseBehavior mouseBehavior, TextControl textControl2, ProjectionControl projectionControl) {
            this.mouse = mouseBehavior;
            this.text_control = textControl2;
            this.pcontrol = projectionControl;
        }
    }
}

