/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.DisplayImpl;
import visad.RemoteSlaveDisplay;
import visad.SocketSlaveDisplay;
import visad.browser.Convert;

public class SocketSlaveDisplay
implements RemoteSlaveDisplay {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_PORT = 4567;
    private static final Class[] supportedControls = new Class[]{class$Lvisad$GraphicsModeControl != null ? class$Lvisad$GraphicsModeControl : (class$Lvisad$GraphicsModeControl = SocketSlaveDisplay.class$("visad.GraphicsModeControl")), class$Lvisad$ContourControl != null ? class$Lvisad$ContourControl : (class$Lvisad$ContourControl = SocketSlaveDisplay.class$("visad.ContourControl"))};
    private int port;
    private DisplayImpl display;
    private boolean flag;
    private byte[] pix;
    private int h;
    private int w;
    private ServerSocket serverSocket;
    private Vector clientSockets = new Vector();
    private Vector clientInputs = new Vector();
    private Vector clientOutputs = new Vector();
    private Vector clientIds = new Vector();
    private Thread connectThread = null;
    private Thread commThread = null;
    private boolean alive = true;
    private int clientID = 0;
    private final SocketSlaveDisplay socketSlave = this;
    private Runnable connect = new 1(this);
    private Runnable comm = new 2(this);
    private static /* synthetic */ Class class$Lvisad$GraphicsModeControl;
    private static /* synthetic */ Class class$Lvisad$ContourControl;

    public int getPort() {
        return this.port;
    }

    private void updateClient(Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        block3: {
            if (this.pix == null) break block3;
            try {
                dataOutputStream.writeInt(this.w);
                dataOutputStream.writeInt(this.h);
                dataOutputStream.writeInt(this.pix.length);
                dataOutputStream.write(this.pix);
            }
            catch (SocketException socketException) {
                this.killSocket(socket, dataInputStream, dataOutputStream);
            }
            catch (IOException iOException) {}
        }
    }

    private void updateClient(String string, Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(-1);
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        }
        catch (SocketException socketException) {
            this.killSocket(socket, dataInputStream, dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendImage(int[] nArray, int n, int n2, int n3) throws RemoteException {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        this.pix = Convert.intToBytes(nArray);
        this.w = n;
        this.h = n2;
        Vector vector = this.clientSockets;
        synchronized (vector) {
            objectArray3 = this.clientSockets.toArray();
            objectArray2 = this.clientInputs.toArray();
            objectArray = this.clientOutputs.toArray();
        }
        int n4 = 0;
        while (n4 < objectArray3.length) {
            this.updateClient((Socket)objectArray3[n4], (DataInputStream)objectArray2[n4], (DataOutputStream)objectArray[n4]);
            ++n4;
        }
    }

    public synchronized void sendMessage(String string) throws RemoteException {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3;
        Vector vector = this.clientSockets;
        synchronized (vector) {
            objectArray3 = this.clientSockets.toArray();
            objectArray2 = this.clientInputs.toArray();
            objectArray = this.clientOutputs.toArray();
        }
        int n = 0;
        while (n < objectArray3.length) {
            this.updateClient(string, (Socket)objectArray3[n], (DataInputStream)objectArray2[n], (DataOutputStream)objectArray[n]);
            ++n;
        }
    }

    private void killSocket(Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Vector vector = this.clientSockets;
        synchronized (vector) {
            int n = this.clientSockets.indexOf(socket);
            this.clientSockets.removeElementAt(n);
            this.clientInputs.removeElementAt(n);
            this.clientOutputs.removeElementAt(n);
            this.clientIds.removeElementAt(n);
        }
    }

    public void killServer() {
        this.alive = false;
        while (true) {
            Socket socket = null;
            DataInputStream dataInputStream = null;
            DataOutputStream dataOutputStream = null;
            Vector vector = this.clientSockets;
            synchronized (vector) {
                if (this.clientSockets.size() > 0) {
                    socket = (Socket)this.clientSockets.elementAt(0);
                    dataInputStream = (DataInputStream)this.clientInputs.elementAt(0);
                    dataOutputStream = (DataOutputStream)this.clientOutputs.elementAt(0);
                }
            }
            if (socket == null) break;
            this.killSocket(socket, dataInputStream, dataOutputStream);
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ boolean access$0(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.alive;
    }

    static /* synthetic */ boolean access$1() {
        return DEBUG;
    }

    static /* synthetic */ ServerSocket access$2(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.serverSocket;
    }

    static /* synthetic */ Vector access$3(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.clientSockets;
    }

    static /* synthetic */ Vector access$4(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.clientInputs;
    }

    static /* synthetic */ Vector access$5(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.clientOutputs;
    }

    static /* synthetic */ int access$6(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.clientID;
    }

    static /* synthetic */ void access$7(SocketSlaveDisplay socketSlaveDisplay, int n) {
        socketSlaveDisplay.clientID = n;
    }

    static /* synthetic */ Vector access$8(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.clientIds;
    }

    static /* synthetic */ void access$9(SocketSlaveDisplay socketSlaveDisplay, Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        socketSlaveDisplay.killSocket(socket, dataInputStream, dataOutputStream);
    }

    static /* synthetic */ void access$10(SocketSlaveDisplay socketSlaveDisplay, Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        socketSlaveDisplay.updateClient(socket, dataInputStream, dataOutputStream);
    }

    static /* synthetic */ Class[] access$11() {
        return supportedControls;
    }

    static /* synthetic */ DisplayImpl access$12(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.display;
    }

    static /* synthetic */ void access$13(SocketSlaveDisplay socketSlaveDisplay, String string, Socket socket, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        socketSlaveDisplay.updateClient(string, socket, dataInputStream, dataOutputStream);
    }

    static /* synthetic */ SocketSlaveDisplay access$14(SocketSlaveDisplay socketSlaveDisplay) {
        return socketSlaveDisplay.socketSlave;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SocketSlaveDisplay(DisplayImpl displayImpl) throws IOException {
        this(displayImpl, 4567);
    }

    public SocketSlaveDisplay(DisplayImpl displayImpl, int n) throws IOException {
        this.display = displayImpl;
        this.port = n;
        this.serverSocket = new ServerSocket(n);
        this.connectThread = new Thread(this.connect, "SocketSlaveDisplay-Connect-" + this.display.getName());
        this.connectThread.start();
        this.commThread = new Thread(this.comm, "SocketSlaveDisplay-Comm-" + this.display.getName());
        this.commThread.start();
        this.display.addSlave(this);
    }
}

