/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class SingletonSet
extends SampledSet {
    private RealTuple data;

    public boolean isMissing() {
        return false;
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(nArray));
    }

    public double[][] indexToDouble(int[] nArray) throws VisADException {
        int n = nArray.length;
        double[][] dArray = new double[this.DomainDimension][n];
        double[] dArray2 = new double[this.DomainDimension];
        int n2 = 0;
        while (n2 < this.DomainDimension) {
            try {
                dArray2[n2] = ((Real)this.data.getComponent(n2)).getValue();
            }
            catch (RemoteException remoteException) {
                dArray2[n2] = Double.NaN;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3;
            if (nArray[n2] < 0 || nArray[n2] >= this.Length) {
                n3 = 0;
                while (n3 < this.DomainDimension) {
                    dArray[n3][n2] = Double.NaN;
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < this.DomainDimension) {
                    dArray[n3][n2] = dArray2[n3];
                    ++n3;
                }
            }
            ++n2;
        }
        return dArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(fArray));
    }

    public int[] doubleToIndex(double[][] dArray) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("SingletonSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 0;
            ++n2;
        }
        return nArray;
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("SingletonSet.valueToInterp: bad dimension");
        }
        int n = fArray[0].length;
        if (nArray.length != n || fArray2.length != n) {
            throw new SetException("SingletonSet.valueToInterp: lengths don't match");
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = new int[1];
            fArray2[n2] = new float[1];
            nArray[n2][0] = 0;
            fArray2[n2][0] = 1.0f;
            ++n2;
        }
    }

    public void doubleToInterp(double[][] dArray, int[][] nArray, double[][] dArray2) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("SingletonSet.doubleToInterp: bad dimension");
        }
        int n = dArray[0].length;
        if (nArray.length != n || dArray2.length != n) {
            throw new SetException("SingletonSet.doubleToInterp: lengths don't match");
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = new int[1];
            dArray2[n2] = new double[1];
            nArray[n2][0] = 0;
            dArray2[n2][0] = 1.0;
            ++n2;
        }
    }

    public double[][] getDoubles(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToDouble(nArray);
    }

    public RealTuple getData() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SingletonSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        if (this.DomainDimension != ((SingletonSet)object).getDimension()) {
            return false;
        }
        return this.data.equals(((SingletonSet)object).getData());
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.DomainDimension ^ this.data.hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object clone() {
        try {
            return new SingletonSet(this.data, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("SingletonSet.clone: " + visADException.toString());
        }
        catch (RemoteException remoteException) {
            throw new VisADError("SingletonSet.clone: " + remoteException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        try {
            return new SingletonSet(this.data, mathType, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (RemoteException remoteException) {
            throw new VisADError("SingletonSet.cloneButType: " + remoteException.toString());
        }
    }

    public String longString(String string) throws VisADException {
        return string + "SingletonSet: " + this.data;
    }

    public SingletonSet(RealTuple realTuple) throws VisADException, RemoteException {
        this(realTuple, realTuple.getType(), null, realTuple.getTupleUnits(), null);
    }

    public SingletonSet(RealTuple realTuple, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException, RemoteException {
        this(realTuple, realTuple.getType(), coordinateSystem, unitArray, errorEstimateArray);
    }

    private SingletonSet(RealTuple realTuple, MathType mathType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException, RemoteException {
        super(mathType, 0, coordinateSystem, unitArray, errorEstimateArray);
        int n = realTuple.getDimension();
        float[][] fArray = new float[n][1];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2][0] = (float)((Real)realTuple.getComponent(n2)).getValue();
            ++n2;
        }
        this.init_samples(fArray);
        this.data = realTuple;
        this.Length = 1;
        n2 = 0;
        while (n2 < this.DomainDimension) {
            if (this.SetErrors[n2] != null) {
                this.SetErrors[n2] = new ErrorEstimate(this.SetErrors[n2].getErrorValue(), ((Real)this.data.getComponent(n2)).getValue(), 1L, this.SetErrors[n2].getUnit());
            }
            ++n2;
        }
    }
}

