/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.DataShadow;
import visad.Display;
import visad.ErrorEstimate;
import visad.MathType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowSetType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.SimpleSetIface;
import visad.Unit;
import visad.VisADException;

public abstract class SimpleSet
extends Set
implements SimpleSetIface {
    int ManifoldDimension;

    public int getManifoldDimension() {
        return this.ManifoldDimension;
    }

    void setAnimationSampling(ShadowType shadowType, DataShadow dataShadow, boolean bl) throws VisADException {
        Object object;
        ShadowRealType shadowRealType;
        if (dataShadow.isAnimationSampling(bl)) {
            return;
        }
        if (this.DomainDimension != 1) {
            return;
        }
        if (shadowType instanceof ShadowRealType) {
            shadowRealType = (ShadowRealType)shadowType;
        } else if (shadowType instanceof ShadowSetType) {
            object = ((ShadowSetType)shadowType).getDomain();
            if (((ShadowTupleType)object).getDimension() != 1) {
                return;
            }
            shadowRealType = (ShadowRealType)((ShadowTupleType)object).getComponent(0);
        } else if (shadowType instanceof ShadowRealTupleType) {
            if (((ShadowRealTupleType)shadowType).getDimension() != 1) {
                return;
            }
            shadowRealType = (ShadowRealType)((ShadowRealTupleType)shadowType).getComponent(0);
        } else {
            return;
        }
        object = shadowRealType.getSelectedMapVector().elements();
        while (object.hasMoreElements()) {
            ScalarMap scalarMap = (ScalarMap)object.nextElement();
            if (!scalarMap.getDisplayScalar().equals(Display.Animation)) continue;
            dataShadow.setAnimationSampling(this, bl);
            return;
        }
    }

    public abstract void valueToInterp(float[][] var1, int[][] var2, float[][] var3) throws VisADException;

    public abstract boolean isMissing() throws VisADException, RemoteException;

    public SimpleSet(MathType mathType, int n) throws VisADException {
        this(mathType, n, null, null, null);
    }

    public SimpleSet(MathType mathType, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, coordinateSystem, unitArray, errorEstimateArray);
        this.ManifoldDimension = n;
        if (this.ManifoldDimension > this.DomainDimension || this.ManifoldDimension < 0) {
            throw new SetException("SimpleSet: bad ManifoldDimension" + this.ManifoldDimension);
        }
    }

    public SimpleSet(MathType mathType) throws VisADException {
        this(mathType, null, null, null);
    }

    public SimpleSet(MathType mathType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, coordinateSystem, unitArray, errorEstimateArray);
        this.ManifoldDimension = this.DomainDimension;
    }
}

