/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.SimpleSet;
import visad.UnimplementedException;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.util.Util;

public class ShapeControl
extends Control {
    private SimpleSet shapeSet = null;
    private VisADGeometryArray[] shapes = null;
    private float scale = 1.0f;
    private boolean autoScale = false;
    private ProjectionControlListener pcl = null;

    public synchronized void setShapeSet(SimpleSet simpleSet) throws VisADException, RemoteException {
        if (simpleSet == null) {
            this.shapeSet = null;
            this.shapes = null;
            return;
        }
        if (simpleSet.getDimension() != 1) {
            throw new DisplayException("ShapeControl.setShapeSet: domain dimension must be 1");
        }
        this.shapeSet = simpleSet;
        this.shapes = new VisADGeometryArray[this.shapeSet.getLength()];
        this.changeControl(true);
    }

    public synchronized void setShape(int n, VisADGeometryArray visADGeometryArray) throws VisADException, RemoteException {
        if (this.shapes == null) {
            return;
        }
        if (n >= 0 && n < this.shapes.length) {
            this.shapes[n] = visADGeometryArray;
        }
        this.changeControl(true);
    }

    public synchronized void setShapes(VisADGeometryArray[] visADGeometryArrayArray) throws VisADException, RemoteException {
        if (this.shapeSet == null) {
            return;
        }
        if (visADGeometryArrayArray != null && visADGeometryArrayArray.length > 0) {
            int n = Math.max(visADGeometryArrayArray.length, this.shapes.length);
            int n2 = 0;
            while (n2 < n) {
                this.shapes[n2] = visADGeometryArrayArray[n2];
                ++n2;
            }
        }
        this.changeControl(true);
    }

    public synchronized VisADGeometryArray[] getShapes(float[] fArray) throws VisADException {
        int n;
        if (fArray == null || fArray.length < 1) {
            return null;
        }
        VisADGeometryArray[] visADGeometryArrayArray = new VisADGeometryArray[fArray.length];
        if (this.shapeSet == null) {
            return visADGeometryArrayArray;
        }
        float[][] fArray2 = new float[][]{fArray};
        int[] nArray = null;
        if (this.shapeSet.getLength() < 2) {
            nArray = new int[fArray.length];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = 0;
                ++n;
            }
        } else {
            nArray = this.shapeSet.valueToIndex(fArray2);
        }
        if (this.shapes == null) {
            n = 0;
            while (n < nArray.length) {
                visADGeometryArrayArray[n] = null;
                ++n;
            }
        } else {
            n = 0;
            while (n < nArray.length) {
                visADGeometryArrayArray[n] = nArray[n] >= 0 && nArray[n] < this.shapes.length && this.shapes[nArray[n]] != null ? (VisADGeometryArray)this.shapes[nArray[n]].clone() : null;
                ++n;
            }
        }
        return visADGeometryArrayArray;
    }

    public void setScale(float f) throws VisADException, RemoteException {
        if (f == f) {
            this.scale = f;
            this.changeControl(true);
        }
    }

    public float getScale() {
        return this.scale;
    }

    private boolean shapeSetEquals(SimpleSet simpleSet) {
        if (this.shapeSet == null) {
            if (simpleSet != null) {
                return false;
            }
        } else {
            if (simpleSet == null) {
                return false;
            }
            if (!this.shapeSet.equals(simpleSet)) {
                return false;
            }
        }
        return true;
    }

    private boolean shapesEquals(VisADGeometryArray[] visADGeometryArrayArray) {
        if (this.shapes == null) {
            if (visADGeometryArrayArray != null) {
                return false;
            }
        } else {
            if (visADGeometryArrayArray == null) {
                return false;
            }
            if (this.shapes.length != visADGeometryArrayArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.shapes.length) {
                if (this.shapes[n] == null) {
                    if (visADGeometryArrayArray[n] != null) {
                        return false;
                    }
                } else {
                    if (visADGeometryArrayArray[n] == null) {
                        return false;
                    }
                    if (!this.shapes[n].equals(visADGeometryArrayArray[n])) {
                        return false;
                    }
                }
                ++n;
            }
        }
        return true;
    }

    public String getSaveString() {
        return null;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof ShapeControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        ShapeControl shapeControl = (ShapeControl)control;
        boolean bl = false;
        if (!this.shapeSetEquals(shapeControl.shapeSet)) {
            bl = true;
            this.shapeSet = shapeControl.shapeSet;
        }
        if (!this.shapesEquals(shapeControl.shapes)) {
            bl = true;
            this.shapes = shapeControl.shapes;
        }
        if (!Util.isApproximatelyEqual(this.scale, shapeControl.scale)) {
            bl = true;
            this.scale = shapeControl.scale;
        }
        if (this.autoScale != shapeControl.autoScale) {
            this.setAutoScale(shapeControl.autoScale);
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public void setAutoScale(boolean bl) throws VisADException {
        if (bl == this.autoScale) {
            return;
        }
        DisplayImpl displayImpl = this.getDisplay();
        DisplayRenderer displayRenderer = displayImpl.getDisplayRenderer();
        MouseBehavior mouseBehavior = displayRenderer.getMouseBehavior();
        ProjectionControl projectionControl = displayImpl.getProjectionControl();
        if (bl) {
            this.pcl = new ProjectionControlListener(mouseBehavior, this, projectionControl);
            projectionControl.addControlListener(this.pcl);
        } else {
            projectionControl.removeControlListener(this.pcl);
        }
        this.autoScale = bl;
        try {
            this.changeControl(true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void nullControl() {
        try {
            this.setAutoScale(false);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        super.nullControl();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ShapeControl shapeControl = (ShapeControl)object;
        if (!this.shapeSetEquals(shapeControl.shapeSet) || !this.shapesEquals(shapeControl.shapes)) {
            return false;
        }
        return Util.isApproximatelyEqual(this.scale, shapeControl.scale);
    }

    public Object clone() {
        ShapeControl shapeControl = (ShapeControl)super.clone();
        if (this.shapes != null) {
            shapeControl.shapes = (VisADGeometryArray[])this.shapes.clone();
        }
        shapeControl.scale = this.scale;
        return shapeControl;
    }

    public ShapeControl(DisplayImpl displayImpl) {
        super(displayImpl);
    }

    class ProjectionControlListener
    implements ControlListener {
        private boolean pfirst = true;
        private MouseBehavior mouse;
        private ProjectionControl pcontrol;
        private ShapeControl shapeControl;
        private double base_scale = 1.0;
        private float last_cscale = 1.0f;
        private double base_size = 1.0;

        public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
            double[] dArray = this.pcontrol.getMatrix();
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[1];
            double[] dArray4 = new double[3];
            this.mouse.instance_unmake_matrix(dArray2, dArray3, dArray4, dArray);
            if (this.pfirst) {
                this.pfirst = false;
                this.base_scale = dArray3[0];
                this.last_cscale = 1.0f;
                this.base_size = this.shapeControl.getScale();
            } else {
                float f = (float)(this.base_scale / dArray3[0]);
                float f2 = f / this.last_cscale;
                if (f2 < 0.95f || 1.05f < f2) {
                    this.last_cscale = f;
                    this.shapeControl.setScale((float)this.base_size * f);
                }
            }
        }

        ProjectionControlListener(MouseBehavior mouseBehavior, ShapeControl shapeControl2, ProjectionControl projectionControl) {
            this.mouse = mouseBehavior;
            this.shapeControl = shapeControl2;
            this.pcontrol = projectionControl;
        }
    }
}

