/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.ColorAlphaControl;
import visad.ColorControl;
import visad.CommonUnit;
import visad.ContourControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.EarthVectorType;
import visad.FlowControl;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.Integer2DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.PlotText;
import visad.RangeControl;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowTupleType;
import visad.ShapeControl;
import visad.SingletonSet;
import visad.Stream2D;
import visad.TextControl;
import visad.TupleType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.util.HersheyFont;

public abstract class ShadowType
implements Serializable {
    public static final int NOTHING_MAPPED = 6;
    public static final int SIMPLE_TUPLE = 5;
    public static final int SIMPLE_ANIMATE_FIELD = 4;
    public static final int SIMPLE_FIELD = 3;
    public static final int NESTED = 2;
    public static final int LEGAL = 1;
    static final int D0 = 0;
    static final int D1 = 1;
    static final int D2 = 2;
    static final int D3 = 3;
    static final int D4 = 4;
    static final int Dbad = 5;
    static final int R0 = 0;
    static final int R1 = 1;
    static final int R2 = 2;
    static final int R3 = 3;
    static final int R4 = 4;
    static final int Rbad = 5;
    public static final float METERS_PER_DEGREE = 111137.0f;
    private static final float BACK_SCALE = -0.15f;
    private static final float PERP_SCALE = 0.15f;
    private static final double FONT_SCALE = 0.07;
    MathType Type;
    transient DataDisplayLink Link;
    transient DisplayImpl display;
    private transient Data data;
    private ShadowType Parent;
    int[] DisplayIndices;
    int[] ValueIndices;
    boolean MultipleSpatialDisplayScalar;
    boolean MultipleDisplayScalar;
    boolean MappedDisplayScalar;
    boolean isTerminal;
    int LevelOfDifficulty;
    boolean isTextureMap;
    boolean curvedTexture;
    boolean isTexture3D;
    boolean isLinearContour3D;
    int Dtype;
    int Rtype;
    DisplayTupleType spatialTuple = null;
    int spatialDimension;
    boolean anyContour;
    boolean anyFlow;
    boolean anyShape;
    boolean anyText;
    boolean streamline1;
    boolean streamline2;
    float streamlineDensity1;
    float streamlineDensity2;
    float arrowScale1;
    float arrowScale2;
    float stepFactor1;
    float stepFactor2;
    int[] refToComponent;
    ShadowRealTupleType[] componentWithRef;
    int[] componentIndex;

    public DataDisplayLink getLink() {
        return this.Link;
    }

    public int getLevelOfDifficulty() {
        return this.LevelOfDifficulty;
    }

    public boolean getIsTerminal() {
        return this.isTerminal;
    }

    public boolean getIsTextureMap() {
        return this.isTextureMap;
    }

    public boolean getCurvedTexture() {
        return this.curvedTexture;
    }

    public boolean getIsTexture3D() {
        return this.isTexture3D;
    }

    public boolean getIsLinearContour3D() {
        return this.isLinearContour3D;
    }

    public int[] getRefToComponent() {
        return this.refToComponent;
    }

    public ShadowRealTupleType[] getComponentWithRef() {
        return this.componentWithRef;
    }

    public int[] getComponentIndex() {
        return this.componentIndex;
    }

    public ShadowRealType[] getComponents(ShadowType shadowType, boolean bl) throws VisADException {
        ShadowRealType[] shadowRealTypeArray;
        if (shadowType == null) {
            return null;
        }
        if (bl) {
            this.refToComponent = null;
            this.componentWithRef = null;
            this.componentIndex = null;
        }
        if (shadowType instanceof ShadowRealType) {
            ShadowRealType[] shadowRealTypeArray2 = new ShadowRealType[]{(ShadowRealType)shadowType};
            return shadowRealTypeArray2;
        }
        if (shadowType instanceof ShadowRealTupleType) {
            ShadowRealTupleType shadowRealTupleType;
            int n = ((ShadowRealTupleType)shadowType).getDimension();
            shadowRealTypeArray = new ShadowRealType[n];
            int n2 = 0;
            while (n2 < n) {
                shadowRealTypeArray[n2] = (ShadowRealType)((ShadowRealTupleType)shadowType).getComponent(n2);
                ++n2;
            }
            if (bl && (shadowRealTupleType = ((ShadowRealTupleType)shadowType).getReference()) != null && shadowRealTupleType.getMappedDisplayScalar()) {
                this.refToComponent = new int[1];
                this.componentWithRef = new ShadowRealTupleType[1];
                this.componentIndex = new int[1];
                this.refToComponent[0] = 0;
                this.componentWithRef[0] = (ShadowRealTupleType)shadowType;
                this.componentIndex[0] = 0;
            }
        } else if (shadowType instanceof ShadowTupleType) {
            int n = ((ShadowTupleType)shadowType).getDimension();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                ShadowType shadowType2 = ((ShadowTupleType)shadowType).getComponent(n5);
                if (shadowType2 instanceof ShadowRealType) {
                    ++n3;
                } else if (shadowType2 instanceof ShadowRealTupleType) {
                    ShadowRealTupleType shadowRealTupleType;
                    n3 += this.getComponents(shadowType2, false).length;
                    if (bl && (shadowRealTupleType = ((ShadowRealTupleType)shadowType2).getReference()) != null && shadowRealTupleType.getMappedDisplayScalar()) {
                        ++n4;
                    }
                }
                ++n5;
            }
            shadowRealTypeArray = new ShadowRealType[n3];
            n5 = 0;
            if (n4 == 0) {
                bl = false;
            }
            if (bl) {
                this.refToComponent = new int[n4];
                this.componentWithRef = new ShadowRealTupleType[n4];
                this.componentIndex = new int[n4];
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < n) {
                ShadowType shadowType3 = ((ShadowTupleType)shadowType).getComponent(n7);
                if (shadowType3 instanceof ShadowRealType || shadowType3 instanceof ShadowRealTupleType) {
                    Object object;
                    if (bl && shadowType3 instanceof ShadowRealTupleType && (object = ((ShadowRealTupleType)shadowType3).getReference()) != null && ((ShadowRealTupleType)object).getMappedDisplayScalar()) {
                        this.refToComponent[n6] = n5;
                        this.componentWithRef[n6] = (ShadowRealTupleType)shadowType3;
                        this.componentIndex[n6] = n7;
                        ++n6;
                    }
                    object = this.getComponents(shadowType3, false);
                    int n8 = 0;
                    while (n8 < ((Object)object).length) {
                        shadowRealTypeArray[n5] = object[n8];
                        ++n5;
                        ++n8;
                    }
                }
                ++n7;
            }
        } else {
            shadowRealTypeArray = null;
        }
        return shadowRealTypeArray;
    }

    public Data getData() {
        return this.data;
    }

    public ShadowType getAdaptedShadowType() {
        return this;
    }

    static int[] zeroIndices(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 0;
            ++n2;
        }
        return nArray;
    }

    static int[] copyIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n];
            ++n;
        }
        return nArray2;
    }

    static int[] addIndices(int[] nArray, int[] nArray2) throws VisADException {
        if (nArray.length != nArray2.length) {
            throw new DisplayException("ShadowType.addIndices: lengths don't match");
        }
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray3[n] = nArray[n] + nArray2[n];
            ++n;
        }
        return nArray3;
    }

    public boolean getAnyContour() {
        return this.anyContour;
    }

    public boolean getAnyFlow() {
        return this.anyFlow;
    }

    public boolean getAnyShape() {
        return this.anyShape;
    }

    public boolean getAnyText() {
        return this.anyText;
    }

    boolean checkNested(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(displayTupleType) || displayTupleType != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow1Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow2Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.Animation) || displayRealType.equals(Display.SelectValue) || displayRealType.equals(Display.SelectRange) || displayRealType.equals(Display.Shape) || displayRealType.equals(Display.ShapeScale) || displayRealType.equals(Display.Text))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkR4(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(displayTupleType) || displayTupleType != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow1Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow2Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.SelectRange) || displayRealType.equals(Display.Shape) || displayRealType.equals(Display.ShapeScale) || displayRealType.equals(Display.Text) || displayRealType.equals(Display.IsoContour))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkR3(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow1Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow2Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.SelectRange) || displayRealType.equals(Display.Shape) || displayRealType.equals(Display.ShapeScale) || displayRealType.equals(Display.Text) || displayRealType.equals(Display.IsoContour))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkR1D3(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow1Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow2Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.Shape) || displayRealType.equals(Display.ShapeScale) || displayRealType.equals(Display.Text) || displayRealType.equals(Display.SelectRange))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkColorRange(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.SelectRange))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkColorAlphaRange(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.SelectRange))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkContourColorAlphaRange(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != 0) {
                DisplayRealType displayRealType = this.display.getDisplayScalar(n);
                DisplayTupleType displayTupleType = displayRealType.getTuple();
                if (!(displayRealType.equals(Display.IsoContour) || displayTupleType != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.SelectRange))) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    boolean checkR2D2(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(displayTupleType) || displayTupleType != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow1Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow2Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.Shape) || displayRealType.equals(Display.ShapeScale) || displayRealType.equals(Display.Text) || displayRealType.equals(Display.SelectRange))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkSpatialOffsetColorAlphaRange(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(displayTupleType) || displayTupleType != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.SelectRange))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkSpatialColorAlphaRange(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || displayTupleType != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.Alpha) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.SelectRange))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkSpatialRange(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || displayRealType.equals(Display.SelectRange))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    int checkAnimationOrValue(int[] nArray) throws RemoteException {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            DisplayRealType displayRealType;
            if (nArray[n2] != 0 && ((displayRealType = this.display.getDisplayScalar(n2)).equals(Display.Animation) || displayRealType.equals(Display.SelectValue))) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    boolean anyRange(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            if (nArray[n] != 0 && (displayRealType = this.display.getDisplayScalar(n)).equals(Display.SelectRange)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean checkContour(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            if (nArray[n] != 0 && (displayRealType = this.display.getDisplayScalar(n)).equals(Display.IsoContour)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean checkFlow(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != 0) {
                DisplayRealType displayRealType = this.display.getDisplayScalar(n);
                DisplayTupleType displayTupleType = displayRealType.getTuple();
                if (displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow1Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple))) {
                    return true;
                }
                if (displayTupleType != null && (displayTupleType.equals(Display.DisplayFlow2Tuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple))) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    boolean checkShape(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            if (nArray[n] != 0 && (displayRealType = this.display.getDisplayScalar(n)).equals(Display.Shape)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean checkText(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            if (nArray[n] != 0 && (displayRealType = this.display.getDisplayScalar(n)).equals(Display.Text)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean checkColor(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkColorOrAlpha(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType;
            if (!(nArray[n] == 0 || (displayTupleType = (displayRealType = this.display.getDisplayScalar(n)).getTuple()) != null && (displayTupleType.equals(Display.DisplayRGBTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY) || displayRealType.equals(Display.Alpha))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean checkAny(int[] nArray) throws RemoteException {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    int testIndices(int[] nArray, int[] nArray2, int n) throws VisADException, RemoteException {
        DisplayRealType displayRealType;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] > 1) {
                ScalarType scalarType = this.display.getScalar(n2);
                throw new BadMappingException("RealType " + scalarType.getName() + " occurs more than once: " + "ShadowType.testIndices");
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray2.length) {
            displayRealType = this.display.getDisplayScalar(n2);
            if (nArray2[n2] > 0) {
                this.isTerminal = true;
            }
            if (nArray2[n2] > 1 && displayRealType.isSingle()) {
                throw new BadMappingException("Single DisplayRealType " + displayRealType.getName() + " occurs more than once: " + "ShadowType.testIndices");
            }
            ++n2;
        }
        this.spatialTuple = null;
        this.spatialDimension = 0;
        n2 = 0;
        while (n2 < nArray2.length) {
            DisplayTupleType displayTupleType;
            if (nArray2[n2] > 0 && (displayTupleType = (displayRealType = this.display.getDisplayScalar(n2)).getTuple()) != null && (displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                if (this.spatialTuple != null && !this.spatialTuple.equals(displayTupleType)) {
                    throw new BadMappingException("DisplayRealType-s occur from multiple spatial DisplayTupleType-s: ShadowType.testIndices");
                }
                this.spatialTuple = displayTupleType;
                ++this.spatialDimension;
            }
            ++n2;
        }
        this.LevelOfDifficulty = this.isTerminal ? (n == 1 ? 1 : 2) : 6;
        return this.LevelOfDifficulty;
    }

    public int checkIndices(int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray, int n) throws VisADException, RemoteException {
        this.LevelOfDifficulty = this.testIndices(nArray, nArray2, n);
        return this.LevelOfDifficulty;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public MathType getType() {
        return this.Type;
    }

    public boolean getMultipleDisplayScalar() {
        return this.MultipleDisplayScalar;
    }

    public boolean getMultipleSpatialDisplayScalar() {
        return this.MultipleSpatialDisplayScalar;
    }

    public boolean getMappedDisplayScalar() {
        return this.MappedDisplayScalar;
    }

    public int[] getDisplayIndices() {
        int[] nArray = new int[this.DisplayIndices.length];
        int n = 0;
        while (n < this.DisplayIndices.length) {
            nArray[n] = this.DisplayIndices[n];
            ++n;
        }
        return nArray;
    }

    public int[] getValueIndices() {
        int[] nArray = new int[this.ValueIndices.length];
        int n = 0;
        while (n < this.ValueIndices.length) {
            nArray[n] = this.ValueIndices[n];
            ++n;
        }
        return nArray;
    }

    boolean testTransform() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.DisplayIndices.length) {
            DisplayRealType displayRealType;
            if (this.DisplayIndices[n2] != 0 && ((displayRealType = this.display.getDisplayScalar(n2)).equals(Display.Animation) || displayRealType.equals(Display.SelectValue) || displayRealType.equals(Display.SelectRange)) && ++n > 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void markTransform(boolean[] blArray) {
    }

    public static void mapValues(float[][] fArray, double[][] dArray, ShadowRealType[] shadowRealTypeArray) throws VisADException {
        int n = dArray.length;
        if (n != shadowRealTypeArray.length) {
            throw new DisplayException("lengths don't match " + n + " != " + shadowRealTypeArray.length + ": " + "ShadowType.mapValues");
        }
        int n2 = 0;
        while (n2 < n) {
            Enumeration enumeration = shadowRealTypeArray[n2].getSelectedMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                int n3 = scalarMap.getValueIndex();
                fArray[n3] = scalarMap.scaleValues(dArray[n2]);
            }
            ++n2;
        }
    }

    public static void mapValues(float[][] fArray, float[][] fArray2, ShadowRealType[] shadowRealTypeArray) throws VisADException {
        int n = fArray2.length;
        if (n != shadowRealTypeArray.length) {
            throw new DisplayException("lengths don't match: ShadowType.mapValues");
        }
        int n2 = 0;
        while (n2 < n) {
            Enumeration enumeration = shadowRealTypeArray[n2].getSelectedMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                int n3 = scalarMap.getValueIndex();
                fArray[n3] = scalarMap.scaleValues(fArray2[n2]);
            }
            ++n2;
        }
    }

    private static void adjustLongitudes(ScalarMap scalarMap, int n, float[][] fArray) {
        if (fArray[n] == null) {
            return;
        }
        float[] fArray2 = fArray[n];
        double[] dArray = scalarMap.getRange();
        if (dArray[0] == dArray[0] && dArray[1] == dArray[1]) {
            float f = (float)dArray[0];
            float f2 = (float)dArray[1];
            int n2 = 0;
            while (n2 < fArray2.length) {
                if (fArray2[n2] < f) {
                    int n3 = n2;
                    fArray2[n3] = fArray2[n3] + 360.0f;
                } else if (fArray2[n2] > f2) {
                    int n4 = n2;
                    fArray2[n4] = fArray2[n4] - 360.0f;
                }
                ++n2;
            }
        }
    }

    private static void adjustLongitudes(ScalarMap scalarMap, int n, double[][] dArray) {
        if (dArray[n] == null) {
            return;
        }
        double[] dArray2 = dArray[n];
        double[] dArray3 = scalarMap.getRange();
        if (dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1]) {
            double d = dArray3[0];
            double d2 = dArray3[1];
            int n2 = 0;
            while (n2 < dArray2.length) {
                if (dArray2[n2] < d) {
                    int n3 = n2;
                    dArray2[n3] = dArray2[n3] + 360.0;
                } else if (dArray2[n2] > d2) {
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] - 360.0;
                }
                ++n2;
            }
        }
    }

    public static VisADGeometryArray makePointGeometry(float[][] fArray, byte[][] byArray) throws VisADException {
        return ShadowType.makePointGeometry(fArray, byArray, false);
    }

    public static VisADGeometryArray makePointGeometry(float[][] fArray, byte[][] byArray, boolean bl) throws VisADException {
        if (fArray == null) {
            throw new DisplayException("bad spatial_values: ShadowType.makePointGeometry: bad");
        }
        VisADPointArray visADPointArray = new VisADPointArray();
        if (bl) {
            int n = fArray.length;
            int n2 = byArray == null ? 0 : byArray.length;
            float[] fArray2 = fArray[0];
            int n3 = fArray2.length;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                if (fArray2[n5] != fArray2[n5]) {
                    ++n4;
                }
                ++n5;
            }
            if (n4 > 0) {
                float[][] fArray3 = new float[n][n3 - n4];
                byte[][] byArray2 = byArray;
                if (n2 > 0) {
                    byArray2 = new byte[n2][n3 - n4];
                }
                int n6 = 0;
                int n7 = 0;
                while (n7 < n3) {
                    if (fArray2[n7] == fArray2[n7]) {
                        int n8 = 0;
                        while (n8 < n) {
                            fArray3[n8][n6] = fArray[n8][n7];
                            ++n8;
                        }
                        n8 = 0;
                        while (n8 < n2) {
                            byArray2[n8][n6] = byArray[n8][n7];
                            ++n8;
                        }
                        ++n6;
                    }
                    ++n7;
                }
                fArray = fArray3;
                byArray = byArray2;
            }
        }
        SampledSet.setGeometryArray(visADPointArray, fArray, 3, byArray);
        return visADPointArray;
    }

    public VisADGeometryArray[] assembleShape(float[][] fArray, int n, int[] nArray, Vector vector, int[] nArray2, DisplayImpl displayImpl, float[] fArray2, int[] nArray3, float[][] fArray3, byte[][] byArray, boolean[][] blArray, int n2, ShadowType shadowType) throws VisADException, RemoteException {
        if (fArray3[0] == null) {
            return null;
        }
        int n3 = 0;
        Vector<VisADGeometryArray[]> vector2 = new Vector<VisADGeometryArray[]>();
        float f = fArray3[0][0];
        float f2 = fArray3[1][0];
        float f3 = fArray3[2][0];
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        int n4 = 0;
        if (byArray != null) {
            n4 = byArray.length;
            by = byArray[0][0];
            by2 = byArray[1][0];
            by3 = byArray[2][0];
            if (n4 > 3) {
                by4 = byArray[3][0];
            }
        }
        float[] fArray4 = null;
        int n5 = 0;
        while (n5 < n) {
            int n6;
            DisplayRealType displayRealType;
            if (fArray[n5] != null && (displayRealType = displayImpl.getDisplayScalar(n6 = nArray2[n5])).equals(Display.ShapeScale)) {
                if (n2 < 0) {
                    fArray4 = fArray[n5];
                    fArray[n5] = null;
                } else {
                    fArray4 = fArray[n5].length == 1 ? new float[]{fArray[n5][0]} : new float[]{fArray[n5][n2]};
                }
            }
            ++n5;
        }
        if (fArray4 == null) {
            n5 = displayImpl.getDisplayScalarIndex(Display.ShapeScale);
            float f4 = fArray2[n5];
            fArray4 = new float[]{f4};
        }
        float[] fArray5 = null;
        ShapeControl shapeControl = null;
        int n7 = 0;
        while (n7 < n) {
            int n8;
            DisplayRealType displayRealType;
            if (fArray[n7] != null && (displayRealType = displayImpl.getDisplayScalar(n8 = nArray2[n7])).equals(Display.Shape)) {
                if (n2 < 0) {
                    fArray5 = fArray[n7];
                    fArray[n7] = null;
                } else {
                    fArray5 = fArray[n7].length == 1 ? new float[]{fArray[n7][0]} : new float[]{fArray[n7][n2]};
                }
                shapeControl = (ShapeControl)((ScalarMap)vector.elementAt(nArray[n7])).getControl();
                if (fArray5 != null && shapeControl != null) {
                    int n9 = fArray5.length;
                    if (byArray != null && byArray[0].length > n9) {
                        n9 = byArray[0].length;
                    }
                    if (fArray3[0].length > n9) {
                        n9 = fArray3[0].length;
                    }
                    if (fArray4.length > n9) {
                        n9 = fArray4.length;
                    }
                    if (fArray5.length < n9) {
                        float[] fArray6 = new float[n9];
                        int n10 = 0;
                        while (n10 < n9) {
                            fArray6[n10] = fArray5[0];
                            ++n10;
                        }
                        fArray5 = fArray6;
                    }
                    float f5 = shapeControl.getScale();
                    VisADGeometryArray[] visADGeometryArrayArray = shapeControl.getShapes(fArray5);
                    int n11 = 0;
                    while (n11 < visADGeometryArrayArray.length) {
                        VisADGeometryArray visADGeometryArray;
                        if (blArray[0] != null) {
                            if (blArray[0].length == 1) {
                                if (!blArray[0][0]) {
                                    visADGeometryArrayArray[n11] = null;
                                }
                            } else if (!blArray[0][n11]) {
                                visADGeometryArrayArray[n11] = null;
                            }
                        }
                        if ((visADGeometryArray = visADGeometryArrayArray[n11]) != null) {
                            if (fArray3[0].length > 1) {
                                f = fArray3[0][n11];
                                f2 = fArray3[1][n11];
                                f3 = fArray3[2][n11];
                            }
                            int n12 = visADGeometryArray.coordinates.length / 3;
                            float f6 = fArray4.length == 1 ? fArray4[0] : fArray4[n11];
                            f6 *= f5;
                            int n13 = 0;
                            while (n13 < visADGeometryArray.coordinates.length) {
                                visADGeometryArray.coordinates[n13] = f + f6 * visADGeometryArray.coordinates[n13];
                                visADGeometryArray.coordinates[n13 + 1] = f2 + f6 * visADGeometryArray.coordinates[n13 + 1];
                                visADGeometryArray.coordinates[n13 + 2] = f3 + f6 * visADGeometryArray.coordinates[n13 + 2];
                                n13 += 3;
                            }
                            if (visADGeometryArray.colors == null && byArray != null) {
                                visADGeometryArray.colors = new byte[n4 * n12];
                                if (byArray[0].length > 1) {
                                    by = byArray[0][n11];
                                    by2 = byArray[1][n11];
                                    by3 = byArray[2][n11];
                                    if (n4 > 3) {
                                        by4 = byArray[3][n11];
                                    }
                                }
                                n13 = 0;
                                while (n13 < visADGeometryArray.colors.length) {
                                    visADGeometryArray.colors[n13] = by;
                                    visADGeometryArray.colors[n13 + 1] = by2;
                                    visADGeometryArray.colors[n13 + 2] = by3;
                                    if (n4 > 3) {
                                        visADGeometryArray.colors[n13 + 3] = by4;
                                    }
                                    n13 += n4;
                                }
                            }
                        }
                        ++n11;
                    }
                    n3 += visADGeometryArrayArray.length;
                    vector2.addElement(visADGeometryArrayArray);
                }
            }
            ++n7;
        }
        if (n3 == 0) {
            return null;
        }
        VisADGeometryArray[] visADGeometryArrayArray = new VisADGeometryArray[n3];
        Enumeration enumeration = vector2.elements();
        int n14 = 0;
        while (enumeration.hasMoreElements()) {
            VisADGeometryArray[] visADGeometryArrayArray2 = (VisADGeometryArray[])enumeration.nextElement();
            System.arraycopy(visADGeometryArrayArray2, 0, visADGeometryArrayArray, n14, visADGeometryArrayArray2.length);
            n14 += visADGeometryArrayArray2.length;
        }
        return visADGeometryArrayArray;
    }

    public Set assembleSpatial(float[][] fArray, float[][] fArray2, int n, int[] nArray, DisplayImpl displayImpl, float[] fArray3, int[] nArray2, Set set, boolean bl, boolean bl2, int[] nArray3, boolean[][] blArray, float[][] fArray4, float[][] fArray5, float[] fArray6, boolean[] blArray2, DataRenderer dataRenderer, ShadowType shadowType) throws VisADException, RemoteException {
        int n2;
        int n3;
        MathType mathType;
        DisplayTupleType displayTupleType = null;
        int n4 = 1;
        int n5 = 0;
        int[] nArray4 = new int[3];
        nArray3[0] = 0;
        nArray3[1] = 0;
        float[][] fArray7 = new float[3][];
        boolean[] blArray3 = new boolean[]{false, false, false};
        Unit[] unitArray = new Unit[]{null, null, null};
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        int[] nArray5 = displayImpl.getValueToMap();
        Vector vector = displayImpl.getMapVector();
        int[] nArray6 = new int[]{-1, -1, -1};
        int n6 = 0;
        while (n6 < n) {
            int n7;
            DisplayTupleType displayTupleType2;
            if (fArray2[n6] != null && (displayTupleType2 = (mathType = displayImpl.getDisplayScalar(n7 = nArray[n6])).getTuple()) != null && (displayTupleType2.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType2.getCoordinateSystem() != null && displayTupleType2.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                if (displayTupleType != null && !displayTupleType.equals(displayTupleType2)) {
                    throw new DisplayException("multiple spatial display tuples: ShadowType.assembleSpatial");
                }
                displayTupleType = displayTupleType2;
                n3 = mathType.getTupleIndex();
                nArray6[n3] = n6;
                fArray[n3] = fArray2[n6];
                n4 = Math.max(n4, fArray2[n6].length);
                fArray2[n6] = null;
                nArray3[0] = nArray3[0] + 1;
                if (nArray2[n6] == 0) {
                    nArray4[n5] = n3;
                    ++n5;
                }
                ScalarMap scalarMap = (ScalarMap)vector.elementAt(nArray5[n6]);
                double[] dArray2 = scalarMap.getRange();
                dArray[n3] = dArray2[1] - dArray2[0];
                unitArray[n3] = ((RealType)scalarMap.getScalar()).getDefaultUnit();
            }
            ++n6;
        }
        if (displayTupleType == null) {
            displayTupleType = Display.DisplaySpatialCartesianTuple;
        }
        if (n5 == 0) {
            nArray3[1] = 0;
        } else if (set == null) {
            nArray3[1] = n5;
        } else if (!bl) {
            nArray3[1] = n5;
            if (bl2) {
                RealType[] realTypeArray = new RealType[n5];
                float[][] fArray8 = new float[n5][];
                int n8 = 0;
                while (n8 < n5) {
                    realTypeArray[n8] = RealType.Generic;
                    fArray8[n8] = fArray[nArray4[n8]];
                    ++n8;
                }
                mathType = new RealTupleType(realTypeArray);
                try {
                    switch (n5) {
                        case 1: {
                            set = new Irregular1DSet(mathType, fArray8, null, null, null, false);
                            break;
                        }
                        case 2: {
                            set = new Irregular2DSet(mathType, fArray8, null, null, null, null, false);
                            break;
                        }
                        case 3: {
                            set = new Irregular3DSet(mathType, fArray8, null, null, null, null, false);
                            break;
                        }
                    }
                }
                catch (VisADException visADException) {
                    set = null;
                }
            } else {
                set = null;
            }
        } else {
            nArray3[1] = set.getManifoldDimension();
        }
        n6 = set == null || !bl2 && nArray3[1] >= 3 ? 0 : 1;
        boolean[] blArray4 = new boolean[]{false, false, false};
        int n9 = 0;
        while (n9 < 3) {
            if (fArray[n9] == null) {
                fArray[n9] = new float[n4];
                int n10 = displayImpl.getDisplayScalarIndex((DisplayRealType)displayTupleType.getComponent(n9));
                float f = fArray3[n10];
                int n11 = 0;
                while (n11 < n4) {
                    fArray[n9][n11] = f;
                    ++n11;
                }
                blArray4[n9] = true;
            } else if (fArray[n9].length == 1) {
                float f = fArray[n9][0];
                blArray4[n9] = true;
                if (f != f || Float.isInfinite(f)) {
                    blArray[0] = new boolean[1];
                    blArray[0][0] = false;
                    return null;
                }
                if (n4 > 1) {
                    fArray[n9] = new float[n4];
                    n3 = 0;
                    while (n3 < n4) {
                        fArray[n9][n3] = f;
                        ++n3;
                    }
                }
            }
            ++n9;
        }
        n9 = 0;
        int[] nArray7 = new int[]{0, 0};
        float[][][] fArray9 = new float[][][]{fArray4, fArray5};
        int n12 = 0;
        while (n12 < 2) {
            int n13 = 0;
            while (n13 < 3) {
                if (fArray9[n12][n13] != null) {
                    n9 = 1;
                    nArray7[n12] = Math.max(nArray7[n12], fArray9[n12][n13].length);
                }
                ++n13;
            }
            ++n12;
        }
        n4 = Math.max(n4, Math.max(nArray7[0], nArray7[1]));
        ShadowType.fillOut(fArray, n4);
        if (nArray7[0] > 0) {
            ShadowType.fillOut(fArray4, n4);
        }
        if (nArray7[1] > 0) {
            ShadowType.fillOut(fArray5, n4);
        }
        n12 = n9;
        int n14 = 0;
        while (n14 < 3) {
            if (dArray[n14] == dArray[n14]) {
                if (unitArray[n14] == null) {
                    n12 = 0;
                    break;
                }
                int n15 = 0;
                while (n15 < 3) {
                    if (dArray[n15] == dArray[n15]) {
                        if (unitArray[n15] == null) {
                            n12 = 0;
                            break;
                        }
                        if (!Unit.canConvert(unitArray[n14], unitArray[n15])) {
                            n12 = 0;
                            break;
                        }
                    }
                    ++n15;
                }
            }
            ++n14;
        }
        if (n12 != 0) {
            double d = -1.0;
            n2 = 0;
            while (n2 < 3) {
                double d2;
                if (dArray[n2] == dArray[n2] && (d2 = Math.abs(dArray[n2])) > d) {
                    d = d2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < 3) {
                dArray[n2] = dArray[n2] == dArray[n2] ? dArray[n2] / d : 1.0;
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                if (!(dataRenderer.getRealVectorTypes(n2) instanceof EarthVectorType || fArray9[n2][0] == null && fArray9[n2][1] == null && fArray9[n2][2] == null)) {
                    int n16 = 0;
                    while (n16 < n4) {
                        float f = 0.0f;
                        float f2 = 0.0f;
                        int n17 = 0;
                        while (n17 < 3) {
                            if (fArray9[n2][n17] != null) {
                                f += fArray9[n2][n17][n16] * fArray9[n2][n17][n16];
                                float[] fArray10 = fArray9[n2][n17];
                                int n18 = n16;
                                fArray10[n18] = (float)((double)fArray10[n18] * dArray[n17]);
                                f2 += fArray9[n2][n17][n16] * fArray9[n2][n17][n16];
                            }
                            ++n17;
                        }
                        float f3 = (float)Math.sqrt(f / f2);
                        int n19 = 0;
                        while (n19 < 3) {
                            if (fArray9[n2][n19] != null) {
                                float[] fArray11 = fArray9[n2][n19];
                                int n20 = n16;
                                fArray11[n20] = fArray11[n20] * f3;
                            }
                            ++n19;
                        }
                        ++n16;
                    }
                }
                ++n2;
            }
        }
        if (displayTupleType.equals(Display.DisplaySpatialCartesianTuple)) {
            dataRenderer.setEarthSpatialDisplay(null, displayTupleType, displayImpl, nArray6, fArray3, dArray);
        } else {
            CoordinateSystem coordinateSystem = displayTupleType.getCoordinateSystem();
            float[][][] fArray12 = new float[2][][];
            dataRenderer.setEarthSpatialDisplay(coordinateSystem, displayTupleType, displayImpl, nArray6, fArray3, dArray);
            if (n12 != 0 && n9 != 0) {
                n2 = 0;
                while (n2 < 2) {
                    if (!(dataRenderer.getRealVectorTypes(n2) instanceof EarthVectorType) && nArray7[n2] > 0) {
                        fArray12[n2] = new float[3][n4];
                        int n21 = 0;
                        while (n21 < 3) {
                            int n22;
                            if (fArray9[n2][n21] != null) {
                                n22 = 0;
                                while (n22 < n4) {
                                    fArray12[n2][n21][n22] = fArray[n21][n22] + fArray6[n2] * fArray9[n2][n21][n22];
                                    ++n22;
                                }
                            } else {
                                n22 = 0;
                                while (n22 < n4) {
                                    fArray12[n2][n21][n22] = fArray[n21][n22];
                                    ++n22;
                                }
                            }
                            ++n21;
                        }
                        fArray12[n2] = coordinateSystem.toReference(fArray12[n2]);
                    }
                    ++n2;
                }
            }
            float[][] fArray13 = coordinateSystem.toReference(fArray);
            int n23 = 0;
            while (n23 < 3) {
                fArray[n23] = fArray13[n23];
                ++n23;
            }
            if (n12 != 0 && n9 != 0) {
                n23 = 0;
                while (n23 < 2) {
                    if (!(dataRenderer.getRealVectorTypes(n23) instanceof EarthVectorType) && nArray7[n23] > 0) {
                        int n24 = 0;
                        while (n24 < 3) {
                            int n25 = 0;
                            while (n25 < n4) {
                                fArray12[n23][n24][n25] = (fArray12[n23][n24][n25] - fArray[n24][n25]) / fArray6[n23];
                                ++n25;
                            }
                            fArray9[n23][n24] = fArray12[n23][n24];
                            ++n24;
                        }
                    }
                    ++n23;
                }
            }
            blArray4 = new boolean[]{false, false, false};
        }
        blArray2[0] = false;
        if (bl && nArray3[1] == 2 && n4 > 1) {
            float f = 0.0f;
            float f4 = -1.0f;
            int n26 = -1;
            int n27 = 0;
            while (n27 < 3) {
                float f5 = fArray[n27][1] - fArray[n27][0];
                float f6 = Math.abs(f5);
                if (f6 > f4) {
                    f = f5;
                    f4 = f6;
                    n26 = n27;
                }
                ++n27;
            }
            n27 = n4 - 1;
            if (set != null && set instanceof Gridded2DSet && (n27 = ((Gridded2DSet)set).getLength(0)) > n4 - 1) {
                n27 = n4 - 1;
            }
            float f7 = 0.0f;
            f4 = -1.0f;
            int n28 = -1;
            int n29 = 0;
            while (n29 < 3) {
                float f8;
                float f9;
                if (n29 != n26 && (f9 = Math.abs(f8 = fArray[n29][n27] - fArray[n29][0])) > f4) {
                    f7 = f8;
                    f4 = f9;
                    n28 = n29;
                }
                ++n29;
            }
            if (n26 == 0) {
                blArray2[0] = true;
                blArray2[1] = f < 0.0f;
                blArray2[2] = f7 < 0.0f;
            } else if (n26 == 1) {
                blArray2[2] = f7 < 0.0f;
                blArray2[1] = f < 0.0f;
            } else if (n28 == 1) {
                blArray2[0] = true;
                blArray2[1] = f < 0.0f;
                blArray2[2] = f7 < 0.0f;
            } else {
                blArray2[2] = f7 < 0.0f;
                blArray2[1] = f < 0.0f;
            }
        }
        int n30 = n4;
        int n31 = 0;
        while (n31 < n) {
            int n32;
            DisplayRealType displayRealType;
            DisplayTupleType displayTupleType3;
            if (fArray2[n31] != null && Display.DisplaySpatialOffsetTuple.equals(displayTupleType3 = (displayRealType = displayImpl.getDisplayScalar(n32 = nArray[n31])).getTuple())) {
                int n33 = displayRealType.getTupleIndex();
                if (fArray7[n33] == null) {
                    fArray7[n33] = fArray2[n31];
                } else {
                    int n34;
                    int n35 = fArray7[n33].length;
                    int n36 = fArray2[n31].length;
                    if (n35 > n36) {
                        float[] fArray14;
                        if (blArray3[n33]) {
                            fArray14 = fArray7[n33];
                        } else {
                            fArray14 = new float[n35];
                            blArray3[n33] = true;
                        }
                        n34 = 0;
                        while (n34 < n35) {
                            fArray14[n34] = fArray7[n33][n34] + fArray2[n31][0];
                            ++n34;
                        }
                        fArray7[n33] = fArray14;
                        fArray14 = null;
                    } else if (n35 < n36) {
                        float[] fArray15 = new float[n36];
                        n34 = 0;
                        while (n34 < n36) {
                            fArray15[n34] = fArray7[n33][0] + fArray2[n31][n34];
                            ++n34;
                        }
                        fArray7[n33] = fArray15;
                        fArray15 = null;
                        blArray3[n33] = true;
                    } else {
                        float[] fArray16;
                        if (blArray3[n33]) {
                            fArray16 = fArray7[n33];
                        } else {
                            fArray16 = new float[n35];
                            blArray3[n33] = true;
                        }
                        n34 = 0;
                        while (n34 < n35) {
                            fArray16[n34] = fArray7[n33][n34] + fArray2[n31][n34];
                            ++n34;
                        }
                        fArray7[n33] = fArray16;
                        fArray16 = null;
                    }
                }
                fArray2[n31] = null;
                n30 = Math.max(n30, fArray7[n33].length);
            }
            ++n31;
        }
        boolean[] blArray5 = new boolean[]{false, false, false};
        int n37 = 0;
        while (n37 < 3) {
            if (fArray7[n37] == null) {
                blArray5[n37] = true;
            } else if (fArray7[n37].length == 1) {
                blArray5[n37] = true;
                if (fArray7[n37][0] != fArray7[n37][0] || Float.isInfinite(fArray7[n37][0])) {
                    blArray[0] = new boolean[1];
                    blArray[0][0] = false;
                    return null;
                }
            }
            ++n37;
        }
        if (n30 > n4) {
            n37 = 0;
            while (n37 < 3) {
                float[] fArray17 = new float[n30];
                int n38 = 0;
                while (n38 < n30) {
                    fArray17[n38] = fArray[n37][0];
                    ++n38;
                }
                fArray[n37] = fArray17;
                fArray17 = null;
                ++n37;
            }
            n4 = n30;
        }
        n37 = 0;
        while (n37 < 3) {
            if (fArray7[n37] != null) {
                int n39;
                int n40 = fArray7[n37].length;
                if (n40 < n4) {
                    n39 = 0;
                    while (n39 < n30) {
                        float[] fArray18 = fArray[n37];
                        int n41 = n39++;
                        fArray18[n41] = fArray18[n41] + fArray7[n37][0];
                    }
                } else {
                    n39 = 0;
                    while (n39 < n30) {
                        float[] fArray19 = fArray[n37];
                        int n42 = n39;
                        fArray19[n42] = fArray19[n42] + fArray7[n37][n39];
                        ++n39;
                    }
                }
                fArray7[n37] = null;
                boolean bl3 = blArray4[n37] = blArray4[n37] && blArray5[n37];
            }
            if (!blArray4[n37]) {
                int n43 = 0;
                while (n43 < n4) {
                    if (fArray[n37][n43] != fArray[n37][n43] || Float.isInfinite(fArray[n37][n43])) {
                        if (blArray[0] == null) {
                            blArray[0] = new boolean[n4];
                            int n44 = 0;
                            while (n44 < n4) {
                                blArray[0][n44] = true;
                                ++n44;
                            }
                        } else if (blArray[0].length < n4) {
                            boolean[] blArray6 = new boolean[n4];
                            int n45 = 0;
                            while (n45 < n4) {
                                blArray6[n45] = blArray[0][0];
                                ++n45;
                            }
                            blArray[0] = blArray6;
                        }
                        blArray[0][n43] = false;
                        fArray[n37][n43] = Float.NaN;
                    }
                    ++n43;
                }
            }
            ++n37;
        }
        if (n6 != 0) {
            try {
                if (n5 == 0) {
                    double[] dArray3 = new double[3];
                    int n46 = 0;
                    while (n46 < 3) {
                        dArray3[n46] = fArray[n46][0];
                        ++n46;
                    }
                    RealTuple realTuple = new RealTuple(Display.DisplaySpatialCartesianTuple, dArray3);
                    return new SingletonSet(realTuple);
                }
                SetType setType = new SetType(Display.DisplaySpatialCartesianTuple);
                return shadowType.makeSpatialSet(set, setType, fArray);
            }
            catch (VisADException visADException) {
                return null;
            }
        }
        return null;
    }

    public Set makeSpatialSet(Set set, SetType setType, float[][] fArray) throws VisADException {
        return set.makeSpatial(setType, fArray);
    }

    private static void fillOut(float[][] fArray, int n) {
        int n2 = 0;
        while (n2 < fArray.length) {
            int n3;
            if (fArray[n2] != null && (n3 = fArray[n2].length) < n) {
                float[] fArray2 = new float[n];
                float f = fArray[n2][0];
                int n4 = 0;
                while (n4 < n) {
                    fArray2[n4] = f;
                    ++n4;
                }
                fArray[n2] = fArray2;
            }
            ++n2;
        }
    }

    public void assembleFlow(float[][] fArray, float[][] fArray2, float[] fArray3, float[][] fArray4, int n, int[] nArray, DisplayImpl displayImpl, float[] fArray5, boolean[][] blArray, DataRenderer dataRenderer, ShadowType shadowType) throws VisADException, RemoteException {
        int[] nArray2 = displayImpl.getValueToMap();
        Vector vector = displayImpl.getMapVector();
        int[] nArray3 = new int[]{0, 0};
        float[][][] fArray6 = new float[][][]{fArray, fArray2};
        DisplayTupleType[] displayTupleTypeArray = new DisplayTupleType[]{Display.DisplayFlow1Tuple, Display.DisplayFlow2Tuple};
        DisplayTupleType[] displayTupleTypeArray2 = new DisplayTupleType[]{null, null};
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (fArray4[n2] != null) {
                int n3 = nArray[n2];
                DisplayRealType displayRealType = displayImpl.getDisplayScalar(n3);
                DisplayTupleType displayTupleType = displayRealType.getTuple();
                int n4 = 0;
                while (n4 < 2) {
                    if (displayTupleType != null && (displayTupleType.equals(displayTupleTypeArray[n4]) || displayTupleType.getCoordinateSystem() != null && displayTupleType.getCoordinateSystem().getReference().equals(displayTupleTypeArray[n4]))) {
                        if (displayTupleTypeArray2[n4] != null && !displayTupleTypeArray2[n4].equals(displayTupleType)) {
                            throw new DisplayException("multiple flow " + n4 + " display tuples: " + "ShadowType.assembleFlow");
                        }
                        displayTupleTypeArray2[n4] = displayTupleType;
                        ScalarMap scalarMap = (ScalarMap)vector.elementAt(nArray2[n2]);
                        FlowControl flowControl = (FlowControl)scalarMap.getControl();
                        fArray3[n4] = flowControl.getFlowScale();
                        int n5 = displayRealType.getTupleIndex();
                        fArray6[n4][n5] = fArray4[n2];
                        nArray3[n4] = Math.max(nArray3[n4], fArray4[n2].length);
                        fArray4[n2] = null;
                        bl = true;
                        if (n4 == 0) {
                            this.streamline1 = flowControl.streamlinesEnabled();
                            this.streamlineDensity1 = flowControl.getStreamlineDensity();
                            this.arrowScale1 = flowControl.getArrowScale();
                            this.stepFactor1 = flowControl.getStepFactor();
                        }
                        if (n4 == 1) {
                            this.streamline2 = flowControl.streamlinesEnabled();
                            this.streamlineDensity2 = flowControl.getStreamlineDensity();
                            this.arrowScale2 = flowControl.getArrowScale();
                            this.stepFactor2 = flowControl.getStepFactor();
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 2) {
            boolean[] blArray2 = new boolean[]{false, false, false};
            if (nArray3[n2] > 0) {
                int n6 = 0;
                while (n6 < 3) {
                    if (fArray6[n2][n6] == null) {
                        fArray6[n2][n6] = new float[nArray3[n2]];
                        int n7 = displayImpl.getDisplayScalarIndex((DisplayRealType)displayTupleTypeArray[n2].getComponent(n6));
                        float f = fArray5[n7];
                        int n8 = 0;
                        while (n8 < nArray3[n2]) {
                            fArray6[n2][n6][n8] = f;
                            ++n8;
                        }
                        blArray2[n6] = true;
                    } else if (fArray6[n2][n6].length == 1) {
                        float f = fArray6[n2][n6][0];
                        blArray2[n6] = true;
                        if (f != f) {
                            blArray[0] = new boolean[1];
                            blArray[0][0] = false;
                            return;
                        }
                        if (nArray3[n2] > 1) {
                            fArray6[n2][n6] = new float[nArray3[n2]];
                            int n9 = 0;
                            while (n9 < nArray3[n2]) {
                                fArray6[n2][n6][n9] = f;
                                ++n9;
                            }
                        }
                    }
                    ++n6;
                }
            }
            if (displayTupleTypeArray2[n2] != null && !displayTupleTypeArray2[n2].equals(displayTupleTypeArray[n2])) {
                blArray2 = new boolean[]{false, false, false};
                CoordinateSystem coordinateSystem = displayTupleTypeArray2[n2].getCoordinateSystem();
                float[][] fArray7 = coordinateSystem.toReference(fArray6[n2]);
                int n10 = 0;
                while (n10 < 3) {
                    fArray6[n2][n10] = fArray7[n10];
                    ++n10;
                }
            }
            if (nArray3[n2] > 0) {
                int n11 = 0;
                while (n11 < 3) {
                    if (!blArray2[n11]) {
                        int n12 = 0;
                        while (n12 < nArray3[n2]) {
                            if (fArray6[n2][n11][n12] != fArray6[n2][n11][n12]) {
                                if (blArray[0] == null) {
                                    blArray[0] = new boolean[nArray3[n2]];
                                    int n13 = 0;
                                    while (n13 < nArray3[n2]) {
                                        blArray[0][n13] = true;
                                        ++n13;
                                    }
                                } else if (blArray[0].length < nArray3[n2]) {
                                    boolean[] blArray3 = new boolean[nArray3[n2]];
                                    int n14 = 0;
                                    while (n14 < nArray3[n2]) {
                                        blArray3[n14] = blArray[0][0];
                                        ++n14;
                                    }
                                    blArray[0] = blArray3;
                                }
                                blArray[0][n12] = false;
                                fArray6[n2][n11][n12] = 0.0f;
                            }
                            ++n12;
                        }
                    }
                    ++n11;
                }
            }
            ++n2;
        }
    }

    public static float[][] adjustFlowToEarth(int n, float[][] fArray, float[][] fArray2, float f, DataRenderer dataRenderer) throws VisADException {
        int n2;
        float f2;
        float f3;
        float[][] fArray3;
        float[][] fArray4;
        if (!(dataRenderer.getRealVectorTypes(n) instanceof EarthVectorType)) {
            return fArray;
        }
        int n3 = fArray[0].length;
        float f4 = 0.0f;
        int n4 = 0;
        while (n4 < n3) {
            if (Math.abs(fArray[0][n4]) > f4) {
                f4 = Math.abs(fArray[0][n4]);
            }
            if (Math.abs(fArray[1][n4]) > f4) {
                f4 = Math.abs(fArray[1][n4]);
            }
            if (Math.abs(fArray[2][n4]) > f4) {
                f4 = Math.abs(fArray[2][n4]);
            }
            ++n4;
        }
        float f5 = 1.0f / f4;
        if (f5 != f5) {
            f5 = 1.0f;
        }
        if ((fArray4 = dataRenderer.spatialToEarth(fArray2, fArray3 = new float[3][])) == null) {
            return fArray;
        }
        int n5 = fArray4.length;
        boolean bl = false;
        Unit[] unitArray = dataRenderer.getEarthUnits();
        if (unitArray != null) {
            if (Unit.canConvert(unitArray[0], CommonUnit.radian)) {
                fArray4[0] = CommonUnit.radian.toThis(fArray4[0], unitArray[0]);
            }
            if (Unit.canConvert(unitArray[1], CommonUnit.radian)) {
                fArray4[1] = CommonUnit.radian.toThis(fArray4[1], unitArray[1]);
            }
            if (n5 == 3 && unitArray.length == 3 && Unit.canConvert(unitArray[2], CommonUnit.meter)) {
                bl = true;
                fArray4[2] = CommonUnit.meter.toThis(fArray4[2], unitArray[2]);
            }
        }
        if (n5 == 3) {
            f3 = (float)((double)(f5 * 1000.0f) * (Math.PI / 180) / 111137.0);
            f2 = f5 * 1000.0f;
            n2 = 0;
            while (n2 < n3) {
                float[] fArray5 = fArray4[2];
                int n6 = n2;
                fArray5[n6] = fArray5[n6] + f2 * fArray[2][n2];
                float[] fArray6 = fArray4[1];
                int n7 = n2;
                fArray6[n7] = fArray6[n7] + f3 * fArray[0][n2] / (float)Math.cos(fArray4[0][n2]);
                float[] fArray7 = fArray4[0];
                int n8 = n2;
                fArray7[n8] = fArray7[n8] + f3 * fArray[1][n2];
                ++n2;
            }
        } else {
            f3 = 1.0E-5f * f5 * (0.5f * dataRenderer.getLatLonRange());
            int n9 = 0;
            while (n9 < n3) {
                float[] fArray8 = fArray4[1];
                int n10 = n9;
                fArray8[n10] = fArray8[n10] + f3 * fArray[0][n9] / (float)Math.cos(fArray4[0][n9]);
                float[] fArray9 = fArray4[0];
                int n11 = n9;
                fArray9[n11] = fArray9[n11] + f3 * fArray[1][n9];
                ++n9;
            }
        }
        if (unitArray != null) {
            if (Unit.canConvert(unitArray[0], CommonUnit.radian)) {
                fArray4[0] = CommonUnit.radian.toThat(fArray4[0], unitArray[0]);
            }
            if (Unit.canConvert(unitArray[1], CommonUnit.radian)) {
                fArray4[1] = CommonUnit.radian.toThat(fArray4[1], unitArray[1]);
            }
            if (n5 == 3 && unitArray.length == 3 && Unit.canConvert(unitArray[2], CommonUnit.meter)) {
                fArray4[2] = CommonUnit.meter.toThat(fArray4[2], unitArray[2]);
            }
        }
        if (n5 == 3) {
            fArray4 = dataRenderer.earthToSpatial(fArray4, null, fArray3);
        } else {
            f3 = 1.0E-5f * f5;
            float[] fArray10 = new float[n3];
            n2 = 0;
            while (n2 < n3) {
                fArray10[n2] = f3 * fArray[2][n2];
                ++n2;
            }
            fArray4 = dataRenderer.earthToSpatial(fArray4, fArray10);
            n2 = 0;
            while (n2 < fArray4.length) {
                if (fArray4[n2] == null) {
                    fArray4[n2] = new float[n3];
                    int n12 = 0;
                    while (n12 < n3) {
                        fArray4[n2][n12] = fArray2[n2][n12];
                        ++n12;
                    }
                }
                ++n2;
            }
        }
        int n13 = 0;
        while (n13 < 3) {
            int n14 = 0;
            while (n14 < n3) {
                float[] fArray11 = fArray4[n13];
                int n15 = n14;
                fArray11[n15] = fArray11[n15] - fArray2[n13][n14];
                ++n14;
            }
            ++n13;
        }
        n13 = 0;
        while (n13 < n3) {
            f2 = (float)Math.sqrt(fArray[0][n13] * fArray[0][n13] + fArray[1][n13] * fArray[1][n13] + fArray[2][n13] * fArray[2][n13]);
            float f6 = (float)Math.sqrt(fArray4[0][n13] * fArray4[0][n13] + fArray4[1][n13] * fArray4[1][n13] + fArray4[2][n13] * fArray4[2][n13]);
            float f7 = f2 / f6;
            fArray[0][n13] = f7 * fArray4[0][n13];
            fArray[1][n13] = f7 * fArray4[1][n13];
            fArray[2][n13] = f7 * fArray4[2][n13];
            ++n13;
        }
        return fArray;
    }

    public VisADGeometryArray[] makeStreamline(int n, float[][] fArray, float f, float[][] fArray2, Set set, int n2, byte[][] byArray, boolean[][] blArray) throws VisADException {
        if (fArray[0] == null) {
            return null;
        }
        if (set == null) {
            return null;
        }
        if (n == 0 && !this.streamline1) {
            return null;
        }
        if (n == 1 && !this.streamline2) {
            return null;
        }
        if (!(set instanceof Gridded3DSet)) {
            return null;
        }
        if (blArray[0] != null) {
            if (blArray[0].length == 1 && !blArray[0][0]) {
                return null;
            }
            int n3 = 0;
            while (n3 < blArray[0].length) {
                if (!blArray[0][n3]) {
                    fArray[0][n3] = Float.NaN;
                    fArray[1][n3] = Float.NaN;
                }
                ++n3;
            }
        }
        DataRenderer dataRenderer = this.getLink().getRenderer();
        fArray = ShadowType.adjustFlowToEarth(n, fArray, fArray2, f, dataRenderer);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 2.0f;
        int[] nArray = new int[1];
        int[][] nArray2 = new int[1][];
        float[][][] fArray3 = new float[1][][];
        float[][][] fArray4 = new float[1][][];
        if (n == 0) {
            f2 = this.streamlineDensity1;
        }
        if (n == 1) {
            f2 = this.streamlineDensity2;
        }
        if (n == 0) {
            f3 = this.arrowScale1;
        }
        if (n == 1) {
            f3 = this.arrowScale2;
        }
        if (n == 0) {
            f4 = this.stepFactor1;
        }
        if (n == 1) {
            f4 = this.stepFactor2;
        }
        if (n2 != 2) {
            throw new VisADException("only manifoldDimension==2 supported for streamlimes");
        }
        int n4 = ((Gridded3DSet)set).LengthX;
        int n5 = ((Gridded3DSet)set).LengthY;
        VisADGeometryArray[] visADGeometryArrayArray = new Gridded2DSet((MathType)RealTupleType.Generic2D, new float[][]{fArray2[0], fArray2[1]}, n4, n5);
        Stream2D.stream(fArray[0], fArray[1], n5, n4, f2, f4, f3, fArray3, fArray4, nArray2, nArray, (Gridded2DSet)visADGeometryArrayArray);
        visADGeometryArrayArray = new VisADLineArray[nArray[0]];
        Integer2DSet integer2DSet = new Integer2DSet(n4, n5);
        int n6 = 0;
        while (n6 < visADGeometryArrayArray.length) {
            visADGeometryArrayArray[n6] = new VisADLineArray();
            float[][] fArray5 = new float[2][nArray2[0][n6]];
            System.arraycopy(fArray3[0][n6], 0, fArray5[1], 0, nArray2[0][n6]);
            System.arraycopy(fArray4[0][n6], 0, fArray5[0], 0, nArray2[0][n6]);
            float[][] fArray6 = ((Gridded3DSet)set).gridToValue(fArray5);
            byte[][] byArray2 = new byte[3][nArray2[0][n6]];
            int[] nArray3 = integer2DSet.valueToIndex(fArray5);
            int n7 = 0;
            while (n7 < nArray2[0][n6]) {
                byArray2[0][n7] = byArray[0][nArray3[n7]];
                byArray2[1][n7] = byArray[1][nArray3[n7]];
                byArray2[2][n7] = byArray[2][nArray3[n7]];
                ++n7;
            }
            Gridded3DSet cfr_ignored_0 = (Gridded3DSet)set;
            SampledSet.setGeometryArray(visADGeometryArrayArray[n6], fArray6, 3, byArray2);
            ++n6;
        }
        return visADGeometryArrayArray;
    }

    public VisADGeometryArray[] makeFlow(int n, float[][] fArray, float f, float[][] fArray2, byte[][] byArray, boolean[][] blArray) throws VisADException {
        if (fArray[0] == null) {
            return null;
        }
        if (fArray2[0] == null) {
            return null;
        }
        VisADLineArray visADLineArray = new VisADLineArray();
        int n2 = fArray2[0].length;
        int n3 = fArray[0].length;
        int n4 = 0;
        if (blArray[0] == null) {
            n4 = n2;
        } else {
            int n5 = 0;
            while (n5 < blArray[0].length) {
                if (blArray[0][n5]) {
                    ++n4;
                }
                ++n5;
            }
        }
        if (n4 == 0) {
            return null;
        }
        DataRenderer dataRenderer = this.getLink().getRenderer();
        fArray = ShadowType.adjustFlowToEarth(n, fArray, fArray2, f, dataRenderer);
        visADLineArray.vertexCount = 6 * n4;
        float[] fArray3 = new float[18 * n4];
        int n6 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n7 = 0;
        while (n7 < n2) {
            if (blArray[0] == null || blArray[0][n7]) {
                if (n3 == 1) {
                    f2 = f * fArray[0][0];
                    f3 = f * fArray[1][0];
                    f4 = f * fArray[2][0];
                } else {
                    f2 = f * fArray[0][n7];
                    f3 = f * fArray[1][n7];
                    f4 = f * fArray[2][n7];
                }
                int n8 = n6;
                fArray3[n6++] = fArray2[0][n7];
                fArray3[n6++] = fArray2[1][n7];
                fArray3[n6++] = fArray2[2][n7];
                int n9 = n6;
                fArray3[n6++] = fArray3[n8++] + f2;
                fArray3[n6++] = fArray3[n8++] + f3;
                fArray3[n6++] = fArray3[n8++] + f4;
                n8 = n9;
                fArray3[n6++] = fArray3[n9++];
                fArray3[n6++] = fArray3[n9++];
                fArray3[n6++] = fArray3[n9++];
                boolean bl = this.display.getDisplayRenderer().getMode2D();
                f8 = f5 = -0.15f * f2;
                f9 = f6 = -0.15f * f3;
                f10 = f7 = -0.15f * f4;
                if (bl || f4 <= f2 && f4 <= f3) {
                    f5 += 0.15f * f3;
                    f6 -= 0.15f * f2;
                    f8 -= 0.15f * f3;
                    f9 += 0.15f * f2;
                } else if (f3 <= f2) {
                    f5 += 0.15f * f4;
                    f7 -= 0.15f * f2;
                    f8 -= 0.15f * f4;
                    f10 += 0.15f * f2;
                } else {
                    f6 += 0.15f * f4;
                    f7 -= 0.15f * f3;
                    f9 -= 0.15f * f4;
                    f10 += 0.15f * f3;
                }
                n8 = n9;
                fArray3[n6++] = fArray3[n9++] + f5;
                fArray3[n6++] = fArray3[n9++] + f6;
                fArray3[n6++] = fArray3[n9++] + f7;
                n9 = n8;
                fArray3[n6++] = fArray3[n8++];
                fArray3[n6++] = fArray3[n8++];
                fArray3[n6++] = fArray3[n8++];
                fArray3[n6++] = fArray3[n9++] + f8;
                fArray3[n6++] = fArray3[n9++] + f9;
                fArray3[n6++] = fArray3[n9++] + f10;
            }
            ++n7;
        }
        visADLineArray.coordinates = fArray3;
        if (byArray != null) {
            byte[] byArray2 = new byte[18 * n4];
            n6 = 0;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            int n10 = 0;
            while (n10 < n2) {
                if (blArray[0] == null || blArray[0][n10]) {
                    int n11 = n6;
                    int n12 = n6;
                    int n13 = n6;
                    int n14 = n6;
                    int n15 = n6;
                    byArray2[n6++] = byArray[0][n10];
                    byArray2[n6++] = byArray[1][n10];
                    byArray2[n6++] = byArray[2][n10];
                    byArray2[n6++] = byArray2[n11++];
                    byArray2[n6++] = byArray2[n11++];
                    byArray2[n6++] = byArray2[n11++];
                    byArray2[n6++] = byArray2[n12++];
                    byArray2[n6++] = byArray2[n12++];
                    byArray2[n6++] = byArray2[n12++];
                    byArray2[n6++] = byArray2[n13++];
                    byArray2[n6++] = byArray2[n13++];
                    byArray2[n6++] = byArray2[n13++];
                    byArray2[n6++] = byArray2[n14++];
                    byArray2[n6++] = byArray2[n14++];
                    byArray2[n6++] = byArray2[n14++];
                    byArray2[n6++] = byArray2[n15++];
                    byArray2[n6++] = byArray2[n15++];
                    byArray2[n6++] = byArray2[n15++];
                }
                ++n10;
            }
            visADLineArray.colors = byArray2;
        }
        return new VisADGeometryArray[]{visADLineArray};
    }

    static void rotateVectors(double[] dArray, double[] dArray2, double d) {
        double d2 = Math.PI / 180 * d;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        if (d == 0.0) {
            return;
        }
        int n = 0;
        while (n < 3) {
            dArray3[n] = d4 * dArray[n] - d3 * dArray2[n];
            dArray4[n] = d3 * dArray[n] + d4 * dArray2[n];
            ++n;
        }
        System.arraycopy(dArray3, 0, dArray, 0, 3);
        System.arraycopy(dArray4, 0, dArray2, 0, 3);
    }

    public VisADGeometryArray makeText(String[] stringArray, TextControl textControl, float[][] fArray, byte[][] byArray, boolean[][] blArray) throws VisADException {
        int n;
        if (stringArray == null || stringArray.length == 0 || textControl == null) {
            return null;
        }
        if (fArray[0] == null) {
            return null;
        }
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        if (byArray != null) {
            by = byArray[0][0];
            by2 = byArray[1][0];
            by3 = byArray[2][0];
        }
        if ((n = stringArray.length) > fArray[0].length) {
            n = fArray[0].length;
        }
        VisADGeometryArray[] visADGeometryArrayArray = new VisADGeometryArray[n];
        TextControl.Justification justification = textControl.getJustification();
        double d = textControl.getSize();
        Font font = textControl.getFont();
        HersheyFont hersheyFont = textControl.getHersheyFont();
        boolean bl = textControl.getSphere();
        float[][] fArray2 = null;
        if (bl) {
            fArray2 = Display.DisplaySphericalCoordSys.fromReference(fArray);
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[]{d * 0.07, 0.0, 0.0};
        double[] dArray3 = new double[]{0.0, d * 0.07, 0.0};
        ShadowType.rotateVectors(dArray2, dArray3, textControl.getRotation());
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (blArray[0] == null || blArray[0].length == 1 || blArray[0][n3]) {
                int n4;
                if (bl) {
                    int n5;
                    double d2 = d * 0.07 / (double)fArray2[2][n3];
                    double d3 = d2 * 57.29577951308232;
                    double d4 = d3 / Math.cos(Math.PI / 180 * (double)fArray2[0][n3]);
                    dArray = new double[]{fArray2[0][n3], fArray2[1][n3], fArray2[2][n3]};
                    dArray2 = new double[]{0.0, d4, 0.0};
                    dArray3 = new double[]{d3, 0.0, 0.0};
                    ShadowType.rotateVectors(dArray2, dArray3, textControl.getRotation());
                    visADGeometryArrayArray[n2] = font != null ? PlotText.render_font(stringArray[n3], font, dArray, dArray2, dArray3, justification) : (hersheyFont != null ? PlotText.render_font(stringArray[n3], hersheyFont, dArray, dArray2, dArray3, justification) : PlotText.render_label(stringArray[n3], dArray, dArray2, dArray3, justification));
                    int n6 = n5 = visADGeometryArrayArray[n2] == null ? 0 : visADGeometryArrayArray[n2].coordinates.length;
                    if (n5 > 0) {
                        float[] fArray3 = visADGeometryArrayArray[n2].coordinates;
                        float[][] fArray4 = new float[3][n5 / 3];
                        int n7 = 0;
                        int n8 = 0;
                        while (n8 < n5 / 3) {
                            fArray4[0][n8] = fArray3[n7++];
                            fArray4[1][n8] = fArray3[n7++];
                            fArray4[2][n8] = fArray3[n7++];
                            ++n8;
                        }
                        fArray4 = Display.DisplaySphericalCoordSys.toReference(fArray4);
                        n7 = 0;
                        n8 = 0;
                        while (n8 < n5 / 3) {
                            fArray3[n7++] = fArray4[0][n8];
                            fArray3[n7++] = fArray4[1][n8];
                            fArray3[n7++] = fArray4[2][n8];
                            ++n8;
                        }
                        visADGeometryArrayArray[n2].coordinates = fArray3;
                        if (font != null) {
                            float[] fArray5 = visADGeometryArrayArray[n2].normals;
                            int n9 = 0;
                            while (n9 < n5) {
                                float f = (float)Math.sqrt(fArray3[n9] * fArray3[n9] + fArray3[n9 + 1] * fArray3[n9 + 1] + fArray3[n9 + 2] * fArray3[n9 + 2]);
                                float f2 = f == 0.0f ? 1.0f : 1.0f / f;
                                fArray5[n9] = f2 * fArray3[n9];
                                fArray5[n9 + 1] = f2 * fArray3[n9 + 1];
                                fArray5[n9 + 2] = f2 * fArray3[n9 + 2];
                                n9 += 3;
                            }
                            visADGeometryArrayArray[n2].normals = fArray5;
                        }
                    }
                } else {
                    dArray = new double[]{fArray[0][n3], fArray[1][n3], fArray[2][n3]};
                    visADGeometryArrayArray[n2] = font != null ? PlotText.render_font(stringArray[n3], font, dArray, dArray2, dArray3, justification) : (hersheyFont != null ? PlotText.render_font(stringArray[n3], hersheyFont, dArray, dArray2, dArray3, justification) : PlotText.render_label(stringArray[n3], dArray, dArray2, dArray3, justification));
                }
                int n10 = n4 = visADGeometryArrayArray[n2] == null ? 0 : visADGeometryArrayArray[n2].coordinates.length;
                if (n4 > 0 && byArray != null) {
                    if (byArray[0].length > 1) {
                        by = byArray[0][n2];
                        by2 = byArray[1][n2];
                        by3 = byArray[2][n2];
                    }
                    byte[] byArray2 = new byte[n4];
                    int n11 = 0;
                    while (n11 < n4) {
                        byArray2[n11] = by;
                        byArray2[n11 + 1] = by2;
                        byArray2[n11 + 2] = by3;
                        n11 += 3;
                    }
                    visADGeometryArrayArray[n2].colors = byArray2;
                }
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        VisADGeometryArray[] visADGeometryArrayArray2 = new VisADGeometryArray[n2];
        System.arraycopy(visADGeometryArrayArray, 0, visADGeometryArrayArray2, 0, n2);
        VisADGeometryArray visADGeometryArray = null;
        int n12 = 0;
        while (n12 < n2) {
            if (visADGeometryArrayArray2[n12] != null) {
                visADGeometryArray = (VisADGeometryArray)visADGeometryArrayArray2[n12].clone();
                break;
            }
            ++n12;
        }
        if (visADGeometryArray != null) {
            VisADGeometryArray.merge(visADGeometryArrayArray2, visADGeometryArray);
        }
        return visADGeometryArray;
    }

    public byte[][] assembleColor(float[][] fArray, int n, int[] nArray, DisplayImpl displayImpl, float[] fArray2, boolean[][] blArray, boolean[] blArray2, ShadowType shadowType) throws VisADException, RemoteException {
        MathType mathType;
        int n2;
        int n3;
        Object object;
        float[][] fArray3 = new float[4][];
        float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] fArray5 = new float[4];
        float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[][] fArray7 = new float[3][];
        float[] fArray8 = new float[]{0.0f, 0.0f, 0.0f};
        float[] fArray9 = new float[3];
        float[] fArray10 = new float[]{0.0f, 0.0f, 0.0f};
        boolean[] blArray3 = new boolean[n];
        int n4 = 0;
        while (n4 < n) {
            blArray3[n4] = false;
            ++n4;
        }
        while (true) {
            object = null;
            int n5 = 0;
            while (n5 < n) {
                float[] fArray11 = fArray[n5];
                if (fArray11 != null && !blArray3[n5]) {
                    n3 = fArray11.length;
                    n2 = nArray[n5];
                    DisplayRealType displayRealType = displayImpl.getDisplayScalar(n2);
                    mathType = displayRealType.getTuple();
                    if (mathType != null && (((TupleType)mathType).equals(Display.DisplayRGBTuple) || ((RealTupleType)mathType).getCoordinateSystem() != null && ((RealTupleType)mathType).getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) && (object == null || object.equals(mathType))) {
                        int n6;
                        if (object == null) {
                            object = mathType;
                            n6 = 0;
                            while (n6 < 3) {
                                fArray9[n6] = 0.0f;
                                fArray10[n6] = 0.0f;
                                fArray7[n6] = null;
                                fArray8[n6] = 0.0f;
                                ++n6;
                            }
                        }
                        n6 = displayRealType.getTupleIndex();
                        if (n3 == 1) {
                            int n7 = n6;
                            fArray9[n7] = fArray9[n7] + fArray11[0];
                            int n8 = n6;
                            fArray10[n8] = fArray10[n8] + 1.0f;
                        } else {
                            ShadowType.singleComposite(n6, fArray7, fArray8, fArray11);
                        }
                        fArray[n5] = null;
                        blArray3[n5] = true;
                    }
                }
                ++n5;
            }
            if (object == null) break;
            ShadowType.colorSum(3, fArray7, fArray8, fArray9, fArray10, displayImpl, (DisplayTupleType)object, fArray2);
            if (!object.equals(Display.DisplayRGBTuple)) {
                ShadowType.equalizeAndDefault(fArray7, displayImpl, (DisplayTupleType)object, fArray2);
                CoordinateSystem coordinateSystem = object.getCoordinateSystem();
                fArray7 = coordinateSystem.toReference(fArray7);
            }
            ShadowType.colorComposite(fArray3, fArray4, fArray7);
        }
        object = displayImpl.getValueToMap();
        Vector vector = displayImpl.getMapVector();
        int n9 = 0;
        while (n9 < n) {
            float[] fArray12 = fArray[n9];
            if (fArray12 != null && !blArray3[n9]) {
                int n10;
                float[][] fArray13;
                n2 = fArray12.length;
                int n11 = nArray[n9];
                mathType = displayImpl.getDisplayScalar(n11);
                if (((RealType)mathType).equals(Display.RGB) || ((RealType)mathType).equals(Display.HSV) || ((RealType)mathType).equals(Display.CMY)) {
                    ColorControl colorControl = (ColorControl)((ScalarMap)vector.elementAt(object[n9])).getControl();
                    fArray13 = colorControl.lookupValues(fArray12);
                    if (((RealType)mathType).equals(Display.HSV)) {
                        fArray13 = Display.DisplayHSVCoordSys.toReference(fArray13);
                    } else if (((RealType)mathType).equals(Display.CMY)) {
                        fArray13 = Display.DisplayCMYCoordSys.toReference(fArray13);
                    } else if (!((RealType)mathType).equals(Display.RGB)) {
                        throw new DisplayException("unrecognized color CoordinateSsystem: ShadowType.assembleColor");
                    }
                    if (n2 == 1) {
                        n10 = 0;
                        while (n10 < 3) {
                            int n12 = n10;
                            fArray5[n12] = fArray5[n12] + fArray13[n10][0];
                            int n13 = n10++;
                            fArray6[n13] = fArray6[n13] + 1.0f;
                        }
                    } else {
                        ShadowType.colorComposite(fArray3, fArray4, fArray13);
                    }
                    fArray[n9] = null;
                }
                if (((RealType)mathType).equals(Display.RGBA)) {
                    ColorAlphaControl colorAlphaControl = (ColorAlphaControl)((ScalarMap)vector.elementAt(object[n9])).getControl();
                    fArray13 = colorAlphaControl.lookupValues(fArray12);
                    if (n2 == 1) {
                        n10 = 0;
                        while (n10 < 4) {
                            int n14 = n10;
                            fArray5[n14] = fArray5[n14] + fArray13[n10][0];
                            int n15 = n10++;
                            fArray6[n15] = fArray6[n15] + 1.0f;
                        }
                    } else {
                        ShadowType.colorComposite(fArray3, fArray4, fArray13);
                        n10 = 0;
                        while (n10 < 4) {
                            ShadowType.singleComposite(n10, fArray3, fArray4, fArray13[n10]);
                            fArray13[n10] = null;
                            ++n10;
                        }
                    }
                    fArray[n9] = null;
                }
                if (((RealType)mathType).equals(Display.Alpha)) {
                    if (n2 == 1) {
                        fArray5[3] = fArray5[3] + fArray12[0];
                        fArray6[3] = fArray6[3] + 1.0f;
                    } else {
                        ShadowType.singleComposite(3, fArray3, fArray4, fArray12);
                    }
                    fArray[n9] = null;
                }
            }
            ++n9;
        }
        if (fArray3[0] == null && fArray3[1] == null && fArray3[2] == null && fArray3[3] == null) {
            n9 = 0;
            while (n9 < 4) {
                fArray3[n9] = new float[1];
                if (fArray6[n9] > 0.0f) {
                    fArray3[n9][0] = fArray5[n9] / fArray6[n9];
                } else {
                    n3 = ShadowType.getDefaultColorIndex(displayImpl, n9);
                    fArray3[n9][0] = fArray2[n3];
                }
                ++n9;
            }
        } else {
            ShadowType.colorSum(4, fArray3, fArray4, fArray5, fArray6, displayImpl, Display.DisplayRGBTuple, fArray2);
            ShadowType.equalizeAndDefault(fArray3, displayImpl, Display.DisplayRGBTuple, fArray2);
        }
        n9 = fArray3[0].length;
        n3 = 0;
        while (n3 < 4) {
            n2 = fArray3[n3].length;
            int n16 = 0;
            while (n16 < n2) {
                if (fArray3[n3][n16] != fArray3[n3][n16]) {
                    int n17;
                    if (blArray[0] == null) {
                        blArray[0] = new boolean[n9];
                        n17 = 0;
                        while (n17 < n9) {
                            blArray[0][n17] = true;
                            ++n17;
                        }
                    }
                    if (n2 > 1) {
                        blArray[0][n16] = false;
                        fArray3[n3][n16] = 0.0f;
                    } else {
                        n17 = 0;
                        while (n17 < n9) {
                            blArray[0][n17] = false;
                            ++n17;
                        }
                        fArray3[n3][n16] = 0.0f;
                        blArray2[n3] = true;
                    }
                }
                ++n16;
            }
            ++n3;
        }
        byte[][] byArray = new byte[fArray3.length][];
        n2 = 0;
        while (n2 < fArray3.length) {
            if (fArray3[n2] != null) {
                int n18 = fArray3[n2].length;
                byArray[n2] = new byte[n18];
                int n19 = 0;
                while (n19 < n18) {
                    int n20 = (int)((double)fArray3[n2][n19] * 255.0);
                    n20 = n20 < 0 ? 0 : (n20 > 255 ? 255 : n20);
                    byArray[n2][n19] = (byte)(n20 < 128 ? n20 : n20 - 256);
                    ++n19;
                }
            }
            ++n2;
        }
        return byArray;
    }

    public static final float byteToFloat(byte by) {
        return by < 0 ? ((float)by + 256.0f) / 255.0f : (float)by / 255.0f;
    }

    public static final byte floatToByte(float f) {
        int n = (int)((double)f * 255.0);
        return (byte)(n < 0 ? 0 : (n > 255 ? -1 : (n < 128 ? n : n - 256)));
    }

    static void colorSum(int n, float[][] fArray, float[] fArray2, float[] fArray3, float[] fArray4, DisplayImpl displayImpl, DisplayTupleType displayTupleType, float[] fArray5) throws VisADException {
        int n2 = n - 1;
        while (n2 >= 0) {
            if (fArray[n2] == null) {
                if (fArray4[n2] > 0.0f) {
                    fArray[n2] = new float[1];
                    fArray[n2][0] = fArray3[n2];
                    fArray2[n2] = fArray4[n2];
                }
            } else {
                float f = 1.0f / (fArray2[n2] + fArray4[n2]);
                int n3 = 0;
                while (n3 < fArray[n2].length) {
                    fArray[n2][n3] = f * (fArray[n2][n3] + fArray3[n2]);
                    ++n3;
                }
            }
            --n2;
        }
    }

    public static int getDefaultColorIndex(DisplayImpl displayImpl, int n) {
        return n == 0 ? displayImpl.getDisplayScalarIndex(Display.Red) : (n == 1 ? displayImpl.getDisplayScalarIndex(Display.Green) : (n == 2 ? displayImpl.getDisplayScalarIndex(Display.Blue) : displayImpl.getDisplayScalarIndex(Display.Alpha)));
    }

    static void equalizeAndDefault(float[][] fArray, DisplayImpl displayImpl, DisplayTupleType displayTupleType, float[] fArray2) throws VisADException {
        int n;
        int n2 = fArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (fArray[n3] == null) {
                fArray[n3] = new float[1];
                n = n3 < 3 ? displayImpl.getDisplayScalarIndex((DisplayRealType)displayTupleType.getComponent(n3)) : displayImpl.getDisplayScalarIndex(Display.Alpha);
                fArray[n3][0] = fArray2[n];
            }
            ++n3;
        }
        n3 = 1;
        n = 0;
        while (n < n2) {
            n3 = Math.max(n3, fArray[n].length);
            ++n;
        }
        n = 0;
        while (n < 3) {
            int n4 = fArray[n].length;
            if (n3 > n4) {
                if (n4 != 1) {
                    throw new DisplayException("bad length: ShadowType.equalizeAndDefault");
                }
                float[] fArray3 = new float[n3];
                float f = fArray[n][0];
                int n5 = 0;
                while (n5 < n3) {
                    fArray3[n5] = f;
                    ++n5;
                }
                fArray[n] = fArray3;
            }
            ++n;
        }
    }

    static void colorComposite(float[][] fArray, float[] fArray2, float[][] fArray3) throws VisADException {
        int n = 0;
        while (n < 3) {
            ShadowType.singleComposite(n, fArray, fArray2, fArray3[n]);
            fArray3[n] = null;
            ++n;
        }
    }

    static void singleComposite(int n, float[][] fArray, float[] fArray2, float[] fArray3) throws VisADException {
        if (fArray3 == null) {
            return;
        }
        if (fArray[n] == null) {
            fArray[n] = fArray3;
            fArray2[n] = 1.0f;
        } else {
            int n2 = n;
            fArray2[n2] = fArray2[n2] + 1.0f;
            int n3 = fArray[n].length;
            int n4 = fArray3.length;
            if (n3 == n4) {
                int n5 = 0;
                while (n5 < n3) {
                    float[] fArray4 = fArray[n];
                    int n6 = n5;
                    fArray4[n6] = fArray4[n6] + fArray3[n5];
                    ++n5;
                }
            } else if (n4 == 1) {
                int n7 = 0;
                while (n7 < n3) {
                    float[] fArray5 = fArray[n];
                    int n8 = n7++;
                    fArray5[n8] = fArray5[n8] + fArray3[0];
                }
            } else if (n3 == 1) {
                int n9 = 0;
                while (n9 < n3) {
                    int n10 = n9++;
                    fArray3[n10] = fArray3[n10] + fArray[n][0];
                }
                fArray[n] = fArray3;
            } else {
                throw new DisplayException("bad length: ShadowType.singleComposite");
            }
        }
    }

    public boolean[][] assembleSelect(float[][] fArray, int n, int n2, int[] nArray, DisplayImpl displayImpl, ShadowType shadowType) throws VisADException {
        int[] nArray2 = displayImpl.getValueToMap();
        Vector vector = displayImpl.getMapVector();
        boolean[][] blArray = new boolean[1][];
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            DisplayRealType displayRealType;
            float[] fArray2 = fArray[n3];
            if (fArray2 != null && (displayRealType = displayImpl.getDisplayScalar(n4 = nArray[n3])).equals(Display.SelectRange)) {
                int n5;
                if (blArray[0] == null) {
                    blArray[0] = new boolean[n];
                    int n6 = 0;
                    while (n6 < n) {
                        blArray[0][n6] = true;
                        ++n6;
                    }
                }
                RangeControl rangeControl = (RangeControl)((ScalarMap)vector.elementAt(nArray2[n3])).getControl();
                float[] fArray3 = rangeControl.getRange();
                if (fArray2.length == 1) {
                    if (fArray2[0] < fArray3[0] || fArray3[1] < fArray2[0]) {
                        n5 = 0;
                        while (n5 < n) {
                            blArray[0][n5] = false;
                            ++n5;
                        }
                        bl = true;
                    }
                } else {
                    n5 = 0;
                    while (n5 < fArray2.length) {
                        if (fArray2[n5] < fArray3[0] || fArray3[1] < fArray2[n5]) {
                            blArray[0][n5] = false;
                            bl = true;
                        }
                        ++n5;
                    }
                }
                fArray[n3] = null;
            }
            ++n3;
        }
        if (blArray[0] != null && !bl) {
            blArray[0] = null;
        }
        return blArray;
    }

    public boolean terminalTupleOrScalar(Object object, float[][] fArray, String string, TextControl textControl, int n, int[] nArray, float[] fArray2, int[] nArray2, DataRenderer dataRenderer, ShadowType shadowType) throws VisADException, RemoteException {
        GraphicsModeControl graphicsModeControl = (GraphicsModeControl)this.display.getGraphicsModeControl().clone();
        float f = fArray2[this.display.getDisplayScalarIndex(Display.PointSize)];
        graphicsModeControl.setPointSize(f, true);
        float f2 = fArray2[this.display.getDisplayScalarIndex(Display.LineWidth)];
        graphicsModeControl.setLineWidth(f2, true);
        float[][] fArray3 = new float[3][];
        float[][] fArray4 = new float[3][];
        float[] fArray5 = new float[2];
        boolean[][] blArray = new boolean[1][];
        shadowType.assembleFlow(fArray3, fArray4, fArray5, fArray, n, nArray, this.display, fArray2, blArray, dataRenderer, shadowType);
        if (blArray[0] != null && !blArray[0][0]) {
            return false;
        }
        boolean[] blArray2 = new boolean[]{false, false, false};
        int[] nArray3 = new int[2];
        float[][] fArray6 = new float[3][];
        shadowType.assembleSpatial(fArray6, fArray, n, nArray, this.display, fArray2, nArray2, null, false, false, nArray3, blArray, fArray3, fArray4, fArray5, blArray2, dataRenderer, shadowType);
        if (blArray[0] != null && !blArray[0][0]) {
            return false;
        }
        boolean[] blArray3 = new boolean[]{false, false, false, false};
        byte[][] byArray = shadowType.assembleColor(fArray, n, nArray, this.display, fArray2, blArray, blArray3, shadowType);
        if (blArray[0] != null && !blArray[0][0]) {
            return false;
        }
        int n2 = this.getLevelOfDifficulty();
        if (n2 == 5) {
            int n3;
            VisADGeometryArray visADGeometryArray;
            int n4;
            Vector vector;
            if (blArray3[0] || blArray3[1] || blArray3[2]) {
                return false;
            }
            float[] fArray7 = new float[]{ShadowType.byteToFloat(byArray[0][0]), ShadowType.byteToFloat(byArray[1][0]), ShadowType.byteToFloat(byArray[2][0])};
            float f3 = Float.NaN;
            boolean bl = false;
            int[] nArray4 = this.display.getValueToMap();
            VisADGeometryArray[] visADGeometryArrayArray = shadowType.assembleShape(fArray, n, nArray4, vector = this.display.getMapVector(), nArray, this.display, fArray2, nArray2, fArray6, byArray, blArray, -1, shadowType);
            if (visADGeometryArrayArray != null) {
                n4 = 0;
                while (n4 < visADGeometryArrayArray.length) {
                    visADGeometryArray = visADGeometryArrayArray[n4];
                    if (visADGeometryArray != null) {
                        shadowType.addToGroup(object, visADGeometryArray, graphicsModeControl, f3, fArray7);
                    }
                    ++n4;
                }
                bl = true;
            }
            n4 = 0;
            if (string != null && textControl != null) {
                String[] stringArray = new String[]{string};
                visADGeometryArray = shadowType.makeText(stringArray, textControl, fArray6, byArray, blArray);
                shadowType.addTextToGroup(object, visADGeometryArray, graphicsModeControl, f3, fArray7);
                n4 = 1;
            }
            boolean bl2 = false;
            visADGeometryArrayArray = shadowType.makeFlow(0, fArray3, fArray5[0], fArray6, byArray, blArray);
            if (visADGeometryArrayArray != null) {
                n3 = 0;
                while (n3 < visADGeometryArrayArray.length) {
                    if (visADGeometryArrayArray[n3] != null) {
                        shadowType.addToGroup(object, visADGeometryArrayArray[n3], graphicsModeControl, f3, fArray7);
                    }
                    ++n3;
                }
                bl2 = true;
            }
            if ((visADGeometryArrayArray = shadowType.makeFlow(1, fArray4, fArray5[1], fArray6, byArray, blArray)) != null) {
                n3 = 0;
                while (n3 < visADGeometryArrayArray.length) {
                    if (visADGeometryArrayArray[n3] != null) {
                        shadowType.addToGroup(object, visADGeometryArrayArray[n3], graphicsModeControl, f3, fArray7);
                    }
                    ++n3;
                }
                bl2 = true;
            }
            if (!bl2 && n4 == 0 && !bl && (visADGeometryArray = ShadowType.makePointGeometry(fArray6, null)) != null && visADGeometryArray.vertexCount > 0) {
                shadowType.addToGroup(object, visADGeometryArray, graphicsModeControl, f3, fArray7);
            }
            if (dataRenderer.getIsDirectManipulation()) {
                dataRenderer.setSpatialValues(fArray6);
            }
            return false;
        }
        throw new UnimplementedException("terminal LEGAL unimplemented: ShadowType.terminalTupleOrReal");
    }

    public boolean makeContour(int n, int[] nArray, float[][] fArray, int[] nArray2, Vector vector, int[] nArray3, int n2, boolean[][] blArray, int n3, Set set, byte[][] byArray, boolean bl, Object object, GraphicsModeControl graphicsModeControl, boolean[] blArray2, float f, float[] fArray2, ShadowType shadowType) throws VisADException {
        Object object2;
        Serializable serializable;
        Serializable serializable2;
        ScalarType scalarType;
        int n4;
        Serializable[] serializableArray;
        boolean bl2 = false;
        DataRenderer dataRenderer = this.getLink().getRenderer();
        boolean bl3 = this.getIsLinearContour3D() && set instanceof Linear3DSet;
        ScalarMap[] scalarMapArray = new ScalarMap[]{null, null, null};
        int[] nArray4 = new int[]{-1, -1, -1};
        if (bl3) {
            serializableArray = ((SetType)set.getType()).getDomain().getRealComponents();
            n4 = 0;
            while (n4 < n) {
                ScalarMap scalarMap = (ScalarMap)vector.elementAt(nArray3[n4]);
                scalarType = scalarMap.getScalar();
                serializable2 = scalarType instanceof RealType ? (RealType)scalarType : null;
                serializable = scalarMap.getDisplayScalar();
                object2 = ((DisplayRealType)serializable).getTuple();
                if (object2 != null && ((TupleType)object2).equals(Display.DisplaySpatialCartesianTuple)) {
                    int n5 = ((DisplayRealType)serializable).getTupleIndex();
                    int n6 = 0;
                    while (n6 < serializableArray.length) {
                        if (((RealType)serializable2).equals(serializableArray[n6])) {
                            nArray4[n6] = n5;
                            scalarMapArray[n6] = scalarMap;
                            break;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
        }
        serializableArray = null;
        n4 = 0;
        while (n4 < n) {
            int n7 = nArray[n4];
            scalarType = this.display.getDisplayScalar(n7);
            if (scalarType.equals(Display.IsoContour) && fArray[n4] != null && fArray[n4].length == n2 && nArray2[n4] == 0) {
                serializable2 = null;
                serializable = (ContourControl)((ScalarMap)vector.elementAt(nArray3[n4])).getControl();
                object2 = new boolean[2];
                float[] fArray3 = new float[5];
                ((ContourControl)serializable).getMainContours((boolean[])object2, fArray3);
                if (object2[0] != false) {
                    int n8;
                    float[] fArray4;
                    if (blArray[0] != null) {
                        int n9 = blArray[0].length;
                        if (n9 == 1 || fArray[n4].length == 1) break;
                        int n10 = fArray[n4].length;
                        fArray4 = fArray[n4];
                        fArray[n4] = new float[n10];
                        System.arraycopy(fArray4, 0, fArray[n4], 0, n10);
                        n8 = 0;
                        while (n8 < n9) {
                            if (!blArray[0][n8]) {
                                fArray[n4][n8] = Float.NaN;
                            }
                            ++n8;
                        }
                    }
                    if (n3 == 3) {
                        if (fArray3[0] == fArray3[0] && set != null) {
                            serializable2 = bl3 ? ((Linear3DSet)set).makeLinearIsoSurface(fArray3[0], fArray[n4], byArray, bl, scalarMapArray, nArray4) : set.makeIsoSurface(fArray3[0], fArray[n4], byArray, bl);
                            if (serializable2 != null) {
                                try {
                                    serializable2 = ((VisADGeometryArray)serializable2).adjustLongitude(dataRenderer);
                                    serializable2 = ((VisADGeometryArray)serializable2).adjustSeam(dataRenderer);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            shadowType.addToGroup(object, (VisADGeometryArray)serializable2, graphicsModeControl, f, fArray2);
                            serializable2 = null;
                        }
                        bl2 = true;
                    } else if (n3 == 2) {
                        if (set != null) {
                            float[] fArray5 = new float[3];
                            boolean[] blArray3 = new boolean[]{false};
                            fArray4 = ((ContourControl)serializable).getLevels(fArray5, blArray3);
                            serializableArray = set.makeIsoLines(fArray4, fArray5[0], fArray5[1], fArray5[2], fArray[n4], byArray, blArray2, blArray3[0]);
                            if (serializableArray != null) {
                                n8 = 0;
                                while (n8 < serializableArray.length) {
                                    if (serializableArray[n8] != null) {
                                        try {
                                            serializableArray[n8] = ((VisADGeometryArray)serializableArray[n8]).adjustLongitude(dataRenderer);
                                            serializableArray[n8] = ((VisADGeometryArray)serializableArray[n8]).adjustSeam(dataRenderer);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    ++n8;
                                }
                            }
                            if (serializableArray != null && serializableArray.length > 0 && serializableArray[0] != null && ((VisADGeometryArray)serializableArray[0]).vertexCount > 0) {
                                shadowType.addToGroup(object, (VisADGeometryArray)serializableArray[0], graphicsModeControl, f, fArray2);
                                serializableArray[0] = null;
                                if (object2[1] != false && serializableArray[2] != null) {
                                    serializable2 = serializableArray[2];
                                    serializableArray = null;
                                } else if (object2[1] == false && serializableArray[1] != null) {
                                    serializable2 = serializableArray[1];
                                    serializableArray = null;
                                } else {
                                    serializable2 = null;
                                }
                                if (serializable2 != null) {
                                    shadowType.addToGroup(object, (VisADGeometryArray)serializable2, graphicsModeControl, f, fArray2);
                                    serializable2 = null;
                                }
                            }
                        }
                        bl2 = true;
                    }
                }
            }
            ++n4;
        }
        return bl2;
    }

    public int textureWidth(int n) {
        return n;
    }

    public int textureHeight(int n) {
        return n;
    }

    public int textureDepth(int n) {
        return n;
    }

    public void adjustZ(float[] fArray) {
    }

    public void setTexCoords(float[] fArray, float f, float f2) {
    }

    public float[] setTex3DCoords(int n, int n2, float f, float f2, float f3) {
        return null;
    }

    public float[] setTexStackCoords(int n, int n2, float f, float f2, float f3) {
        return null;
    }

    public Vector getTextMaps(int n, int[] nArray) {
        return new Vector();
    }

    public boolean addToGroup(Object object, VisADGeometryArray visADGeometryArray, GraphicsModeControl graphicsModeControl, float f, float[] fArray) throws VisADException {
        return false;
    }

    public boolean addTextToGroup(Object object, VisADGeometryArray visADGeometryArray, GraphicsModeControl graphicsModeControl, float f, float[] fArray) throws VisADException {
        return this.addToGroup(object, visADGeometryArray, graphicsModeControl, f, fArray);
    }

    public void textureToGroup(Object object, VisADGeometryArray visADGeometryArray, BufferedImage bufferedImage, GraphicsModeControl graphicsModeControl, float f, float[] fArray, int n, int n2) throws VisADException {
    }

    public void texture3DToGroup(Object object, VisADGeometryArray visADGeometryArray, VisADGeometryArray visADGeometryArray2, VisADGeometryArray visADGeometryArray3, VisADGeometryArray visADGeometryArray4, VisADGeometryArray visADGeometryArray5, VisADGeometryArray visADGeometryArray6, BufferedImage[] bufferedImageArray, GraphicsModeControl graphicsModeControl, float f, float[] fArray, int n, int n2, int n3, DataRenderer dataRenderer) throws VisADException {
    }

    public void textureStackToGroup(Object object, VisADGeometryArray visADGeometryArray, VisADGeometryArray visADGeometryArray2, VisADGeometryArray visADGeometryArray3, VisADGeometryArray visADGeometryArray4, VisADGeometryArray visADGeometryArray5, VisADGeometryArray visADGeometryArray6, BufferedImage[] bufferedImageArray, BufferedImage[] bufferedImageArray2, BufferedImage[] bufferedImageArray3, GraphicsModeControl graphicsModeControl, float f, float[] fArray, int n, int n2, int n3, DataRenderer dataRenderer) throws VisADException {
    }

    public Object makeSwitch() {
        return null;
    }

    public Object makeBranch() {
        return null;
    }

    public void addToGroup(Object object, Object object2) throws VisADException {
    }

    public void addToSwitch(Object object, Object object2) throws VisADException {
    }

    public void addSwitch(Object object, Object object2, Control control, Set set, DataRenderer dataRenderer) throws VisADException {
    }

    public boolean recurseRange(Object object, Data data, float[] fArray, float[] fArray2, DataRenderer dataRenderer) throws VisADException, RemoteException {
        return false;
    }

    public boolean recurseComponent(int n, Object object, Data data, float[] fArray, float[] fArray2, DataRenderer dataRenderer) throws VisADException, RemoteException {
        return false;
    }

    public boolean wantIndexed() {
        return false;
    }

    public TextControl getParentTextControl() {
        return null;
    }

    public String getParentText() {
        return null;
    }

    public void setText(String string, TextControl textControl) {
    }

    public boolean allowCurvedTexture() {
        return true;
    }

    public boolean allowConstantColorSurfaces() {
        return true;
    }

    public boolean allowLinearContour() {
        return true;
    }

    public String toString() {
        return this.getClass() + " for \n  " + this.Type.toString();
    }

    public ShadowType(MathType mathType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        this.Type = mathType;
        this.Link = dataDisplayLink;
        this.display = dataDisplayLink.getDisplay();
        this.Parent = shadowType;
        this.data = dataDisplayLink.getData();
        this.DisplayIndices = ShadowType.zeroIndices(this.display.getDisplayScalarCount());
        this.ValueIndices = ShadowType.zeroIndices(this.display.getValueArrayLength());
        this.isTerminal = false;
        this.isTextureMap = false;
        this.curvedTexture = false;
        this.isTexture3D = false;
        this.isLinearContour3D = false;
        this.LevelOfDifficulty = 6;
        this.MultipleSpatialDisplayScalar = false;
        this.MultipleDisplayScalar = false;
        this.MappedDisplayScalar = false;
    }
}

