/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.Control;
import visad.CoordinateSystem;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.MathType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ShadowType;
import visad.VisADException;

public class ShadowScalarType
extends ShadowType {
    int Index;
    private Vector SelectedMapVector;
    private DisplayTupleType DisplaySpatialTuple = null;
    private int[] DisplaySpatialTupleIndex = new int[3];
    private int DisplaySpatialTupleIndexIndex;
    private int[] inherited_values;

    void incrementIndices(int[] nArray) {
        if (this.MappedDisplayScalar && this.Index < nArray.length) {
            int n = this.Index;
            nArray[n] = nArray[n] + 1;
        }
    }

    public int checkIndices(int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray, int n) throws VisADException, RemoteException {
        int[] nArray4 = ShadowType.copyIndices(nArray);
        this.incrementIndices(nArray4);
        int[] nArray5 = ShadowType.addIndices(nArray2, this.DisplayIndices);
        int[] nArray6 = ShadowType.addIndices(nArray3, this.ValueIndices);
        this.markTransform(blArray);
        this.inherited_values = ShadowType.copyIndices(nArray3);
        if (n == 6 && this.checkAny(this.DisplayIndices)) {
            n = 2;
        }
        if (this.checkAnimationOrValue(this.DisplayIndices) > 0) {
            throw new BadMappingException("Animation and SelectValue may not occur in range: ShadowScalarType.checkIndices");
        }
        this.anyContour = this.checkContour(nArray5);
        this.anyFlow = this.checkFlow(nArray5);
        this.anyShape = this.checkShape(nArray5);
        this.anyText = this.checkText(nArray5);
        this.LevelOfDifficulty = this.testIndices(nArray4, nArray5, n);
        if (this.LevelOfDifficulty == 2) {
            this.LevelOfDifficulty = this.checkR2D2(this.DisplayIndices) ? 5 : 1;
        }
        return this.LevelOfDifficulty;
    }

    public int[] getInheritedValues() {
        return this.inherited_values;
    }

    public boolean getMappedDisplayScalar() {
        return this.MappedDisplayScalar;
    }

    public DisplayTupleType getDisplaySpatialTuple() {
        return this.DisplaySpatialTuple;
    }

    public int[] getDisplaySpatialTupleIndex() {
        return this.DisplaySpatialTupleIndex;
    }

    public int getIndex() {
        return this.Index;
    }

    public Vector getSelectedMapVector() {
        return (Vector)this.SelectedMapVector.clone();
    }

    void markTransform(boolean[] blArray) {
        Vector vector = this.SelectedMapVector;
        synchronized (vector) {
            Enumeration enumeration = this.SelectedMapVector.elements();
            while (enumeration.hasMoreElements()) {
                Control control;
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                DisplayRealType displayRealType = scalarMap.getDisplayScalar();
                if (!displayRealType.equals(Display.Animation) && !displayRealType.equals(Display.SelectValue) && !displayRealType.equals(Display.SelectRange) || (control = scalarMap.getControl()) == null) continue;
                blArray[control.getIndex()] = true;
            }
        }
    }

    public ShadowScalarType(MathType mathType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        super(mathType, dataDisplayLink, shadowType);
        int n = 0;
        while (n < 3) {
            this.DisplaySpatialTupleIndex[n] = -1;
            ++n;
        }
        this.DisplaySpatialTupleIndexIndex = 0;
        n = 0;
        this.Index = -1;
        this.SelectedMapVector = new Vector();
        Enumeration enumeration = this.display.getMapVector().elements();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
            if (!scalarMap.getScalar().equals(this.Type)) continue;
            this.Index = scalarMap.getScalarIndex();
            this.SelectedMapVector.addElement(scalarMap);
            this.Link.addSelectedMapVector(scalarMap);
            int n2 = scalarMap.getDisplayScalarIndex();
            this.DisplayIndices[n2] = this.DisplayIndices[n2] + 1;
            int n3 = scalarMap.getValueIndex();
            this.ValueIndices[n3] = this.ValueIndices[n3] + 1;
            DisplayTupleType displayTupleType = scalarMap.getDisplayScalar().getTuple();
            if (!(displayTupleType == null || displayTupleType.equals(Display.DisplaySpatialCartesianTuple) || (serializable = displayTupleType.getCoordinateSystem()) != null && ((CoordinateSystem)serializable).getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                displayTupleType = null;
            }
            if (displayTupleType == null) continue;
            ++n;
            if (this.DisplaySpatialTuple != null) {
                if (!displayTupleType.equals(this.DisplaySpatialTuple)) {
                    serializable = (ScalarType)this.Type;
                    throw new BadMappingException(((ScalarType)serializable).getName() + " mapped to multiple spatial DisplayTupleType-s: " + "ShadowScalarType");
                }
            } else {
                this.DisplaySpatialTuple = displayTupleType;
            }
            this.DisplaySpatialTupleIndex[this.DisplaySpatialTupleIndexIndex] = scalarMap.getDisplayScalar().getTupleIndex();
            ++this.DisplaySpatialTupleIndexIndex;
        }
        this.MultipleSpatialDisplayScalar = n > 1;
        this.MultipleDisplayScalar = this.SelectedMapVector.size() > 1;
        this.MappedDisplayScalar = this.SelectedMapVector.size() > 0;
    }
}

