/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.IntegerSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.SetIface;
import visad.SetType;
import visad.ShadowType;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADGeometryArray;

public abstract class Set
extends DataImpl
implements SetIface {
    int DomainDimension;
    int Length = 0;
    CoordinateSystem DomainCoordinateSystem;
    boolean hashCodeSet = false;
    int hashCode = 0;
    Unit[] SetUnits;
    ErrorEstimate[] SetErrors;

    static int getDimension(MathType mathType) throws VisADException {
        if (mathType instanceof SetType) {
            return ((SetType)mathType).getDomain().getDimension();
        }
        if (mathType instanceof RealTupleType) {
            return ((RealTupleType)mathType).getDimension();
        }
        if (mathType instanceof RealType) {
            return 1;
        }
        throw new TypeException("Set: Type must be SetType or RealTupleType, not " + mathType.getClass().getName());
    }

    static MathType adjustType(MathType mathType) throws VisADException {
        if (mathType instanceof SetType) {
            return mathType;
        }
        if (mathType instanceof RealTupleType) {
            return new SetType(mathType);
        }
        if (mathType instanceof RealType) {
            return new SetType(mathType);
        }
        throw new TypeException("Set: Type must be SetType, RealTupleType or RealType, not " + mathType.getClass().getName());
    }

    public Unit[] getSetUnits() {
        return Unit.copyUnitsArray(this.SetUnits);
    }

    public ErrorEstimate[] getSetErrors() {
        return ErrorEstimate.copyErrorsArray(this.SetErrors);
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.DomainCoordinateSystem;
    }

    public int getDimension() {
        return this.DomainDimension;
    }

    public int getManifoldDimension() {
        return this.DomainDimension;
    }

    public int getLength() throws VisADException {
        return this.Length;
    }

    public int __len__() throws VisADException {
        return this.Length;
    }

    public int[] getWedge() {
        int[] nArray = new int[this.Length];
        int n = 0;
        while (n < this.Length) {
            nArray[n] = n;
            ++n;
        }
        return nArray;
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToValue(nArray);
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean bl) throws VisADException {
        return Set.floatToDouble(this.getSamples(true));
    }

    public void cram_missing(boolean[] blArray) {
    }

    public abstract float[][] indexToValue(int[] var1) throws VisADException;

    public abstract int[] valueToIndex(float[][] var1) throws VisADException;

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException {
        return this.computeRanges(shadowType, dataShadow, null, false);
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow, double[][] dArray, boolean bl) throws VisADException {
        this.setAnimationSampling(shadowType, dataShadow, bl);
        return dataShadow;
    }

    void setAnimationSampling(ShadowType shadowType, DataShadow dataShadow, boolean bl) throws VisADException {
    }

    public Set merge1DSets(Set set) throws VisADException {
        Object object;
        if (this.DomainDimension != 1 || set.getDimension() != 1 || this.equals(set)) {
            return this;
        }
        int n = this.getLength();
        int[] nArray = this.getWedge();
        double[][] dArray = this.indexToDouble(nArray);
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[1];
        double[][] dArray2 = CoordinateSystem.transformCoordinates(((SetType)set.getType()).getDomain(), set.getCoordinateSystem(), set.getSetUnits(), null, ((SetType)this.Type).getDomain(), this.DomainCoordinateSystem, this.SetUnits, null, dArray);
        int n2 = set.getLength();
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        while (n3 < n2) {
            blArray[n3] = true;
            ++n3;
        }
        if (n2 > 1) {
            object = set.doubleToIndex(dArray2);
            try {
                int n4 = 0;
                while (n4 < n) {
                    if (object[n4] > -1) {
                        blArray[object[n4]] = false;
                    }
                    ++n4;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new VisADException("Cannot merge sets");
            }
        } else {
            object = set.getDoubles();
            double d = object[0][0];
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            int n5 = 0;
            while (n5 < n) {
                if (dArray2[0][n5] > d3) {
                    d3 = dArray2[0][n5];
                }
                if (dArray2[0][n5] < d2) {
                    d2 = dArray2[0][n5];
                }
                ++n5;
            }
            double d4 = (d3 - d2) / (double)n;
            if (d2 - d4 < d && d < d3 + d4) {
                blArray[0] = false;
            }
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            if (blArray[n7]) {
                ++n6;
            }
            ++n7;
        }
        if (n6 == 0) {
            return this;
        }
        int[] nArray2 = new int[n6];
        n6 = 0;
        int n8 = 0;
        while (n8 < n2) {
            if (blArray[n8]) {
                nArray2[n6] = n8;
                ++n6;
            }
            ++n8;
        }
        double[][] dArray3 = set.indexToDouble(nArray2);
        dArray3 = CoordinateSystem.transformCoordinates(((SetType)this.Type).getDomain(), this.DomainCoordinateSystem, this.SetUnits, null, ((SetType)set.getType()).getDomain(), set.getCoordinateSystem(), set.getSetUnits(), null, dArray3);
        double[][] dArray4 = new double[1][n + n6];
        int n9 = 0;
        while (n9 < n) {
            dArray4[0][n9] = dArray[0][n9];
            ++n9;
        }
        n9 = 0;
        while (n9 < n6) {
            dArray4[0][n + n9] = dArray3[0][n9];
            ++n9;
        }
        QuickSort.sort(dArray4[0]);
        return new Gridded1DDoubleSet(this.Type, dArray4, dArray4[0].length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, false);
    }

    public Set makeSpatial(SetType setType, float[][] fArray) throws VisADException {
        throw new SetException("Set.makeSpatial: not valid for this Set");
    }

    public VisADGeometryArray make1DGeometry(byte[][] byArray) throws VisADException {
        throw new SetException("Set.make1DGeometry: not valid for this Set");
    }

    public VisADGeometryArray make2DGeometry(byte[][] byArray, boolean bl) throws VisADException {
        throw new SetException("Set.make2DGeometry: not valid for this Set");
    }

    public VisADGeometryArray[] make3DGeometry(byte[][] byArray) throws VisADException {
        throw new SetException("Set.make3DGeometry: not valid for this Set");
    }

    public VisADGeometryArray makePointGeometry(byte[][] byArray) throws VisADException {
        throw new SetException("Set.makePointGeometry: not valid for this Set");
    }

    public VisADGeometryArray[] makeIsoLines(float[] fArray, float f, float f2, float f3, float[] fArray2, byte[][] byArray, boolean[] blArray, boolean bl) throws VisADException {
        throw new SetException("Set.makeIsoLines: not valid for this Set");
    }

    public VisADGeometryArray makeIsoSurface(float f, float[] fArray, byte[][] byArray, boolean bl) throws VisADException {
        throw new SetException("Set.makeIsoSurface: not valid for this Set");
    }

    public double[][] indexToDouble(int[] nArray) throws VisADException {
        return Set.floatToDouble(this.indexToValue(nArray));
    }

    public int[] doubleToIndex(double[][] dArray) throws VisADException {
        return this.valueToIndex(Set.doubleToFloat(dArray));
    }

    public static double[][] floatToDouble(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        double[][] dArray = new double[fArray.length][];
        int n = 0;
        while (n < fArray.length) {
            if (fArray[n] == null) {
                dArray[n] = null;
            } else {
                dArray[n] = new double[fArray[n].length];
                int n2 = 0;
                while (n2 < fArray[n].length) {
                    dArray[n][n2] = fArray[n][n2];
                    ++n2;
                }
            }
            ++n;
        }
        return dArray;
    }

    public static float[][] doubleToFloat(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        float[][] fArray = new float[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] == null) {
                fArray[n] = null;
            } else {
                fArray[n] = new float[dArray[n].length];
                int n2 = 0;
                while (n2 < dArray[n].length) {
                    fArray[n][n2] = (float)dArray[n][n2];
                    ++n2;
                }
            }
            ++n;
        }
        return fArray;
    }

    public static float[][] copyFloats(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[][] fArray2 = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = fArray[n2].length;
            fArray2[n2] = new float[n3];
            System.arraycopy(fArray[n2], 0, fArray2[n2], 0, n3);
            ++n2;
        }
        return fArray2;
    }

    public static double[][] copyDoubles(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[][] dArray2 = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dArray[n2].length;
            dArray2[n2] = new double[n3];
            System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n3);
            ++n2;
        }
        return dArray2;
    }

    public void getNeighbors(int[][] nArray) throws VisADException {
        throw new UnimplementedException("Set: getNeighbors()");
    }

    public void getNeighbors(int[][] nArray, float[][] fArray) throws VisADException {
        throw new UnimplementedException("Set: getNeighbors()");
    }

    public int[][] getNeighbors(int n) throws VisADException {
        throw new UnimplementedException("Set: getNeighbors()");
    }

    public boolean testNotEqualsCache(Set set) {
        return false;
    }

    public void addNotEqualsCache(Set set) {
    }

    public boolean testEqualsCache(Set set) {
        return false;
    }

    public void addEqualsCache(Set set) {
    }

    public boolean equalUnitAndCS(Set set) {
        if (this.DomainCoordinateSystem == null ? set.DomainCoordinateSystem != null : !this.DomainCoordinateSystem.equals(set.DomainCoordinateSystem)) {
            return false;
        }
        if (this.SetUnits != null || set.SetUnits != null) {
            if (this.SetUnits == null || set.SetUnits == null) {
                return false;
            }
            int n = this.SetUnits.length;
            if (n != set.SetUnits.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.SetUnits[n2] != null || set.SetUnits[n2] != null) {
                    if (this.SetUnits[n2] == null || set.SetUnits[n2] == null) {
                        return false;
                    }
                    if (!this.SetUnits[n2].equals(set.SetUnits[n2])) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    public int unitAndCSHashCode() {
        int n = 0;
        if (this.DomainCoordinateSystem != null) {
            n ^= this.DomainCoordinateSystem.hashCode();
        }
        if (this.SetUnits != null) {
            int n2 = 0;
            while (n2 < this.SetUnits.length) {
                if (this.SetUnits[n2] != null) {
                    n ^= this.SetUnits[n2].hashCode();
                }
                ++n2;
            }
        }
        return n;
    }

    public Data __getitem__(int n) throws VisADException, RemoteException {
        int[] nArray = new int[]{n};
        float[][] fArray = this.indexToValue(nArray);
        RealType[] realTypeArray = ((SetType)this.getType()).getDomain().getRealComponents();
        Real[] realArray = new Real[this.DomainDimension];
        int n2 = 0;
        while (n2 < this.DomainDimension) {
            realArray[n2] = new Real(realTypeArray[n2], fArray[n2][0], this.SetUnits[n2]);
            ++n2;
        }
        if (this.DomainDimension == 1) {
            return realArray[0];
        }
        RealTupleType realTupleType = ((SetType)this.getType()).getDomain();
        return new RealTuple(realTupleType, realArray, this.getCoordinateSystem());
    }

    public abstract boolean equals(Object var1);

    public abstract Object clone();

    public abstract Object cloneButType(MathType var1) throws VisADException;

    public String longString() throws VisADException {
        return this.longString("");
    }

    public String longString(String string) throws VisADException {
        throw new TypeException("Set.longString");
    }

    public static void main(String[] stringArray) throws VisADException {
        MathType mathType;
        RealType realType = new RealType("vis_radiance", null, null);
        RealType realType2 = new RealType("ir_radiance", null, null);
        RealType realType3 = new RealType("count", null, null);
        RealType[] realTypeArray = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        MathType[] mathTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType2 = new RealTupleType((RealType[])mathTypeArray);
        try {
            mathType = new TupleType(mathTypeArray);
        }
        catch (TypeException typeException) {
            typeException.printStackTrace();
        }
        try {
            mathType = new FunctionType(realTupleType, realTupleType2);
        }
        catch (TypeException typeException) {
            System.out.println(typeException);
        }
        try {
            mathType = new FunctionType(realTupleType, realType);
        }
        catch (TypeException typeException) {
            System.out.println(typeException);
        }
        mathType = new FunctionType(realTupleType, realTupleType2);
        FunctionType functionType = new FunctionType(realTupleType, realType);
        FunctionType functionType2 = new FunctionType(realTupleType, realType2);
        FunctionType functionType3 = new FunctionType(realType2, realType3);
        System.out.println(mathType);
        System.out.println(functionType3);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType, 0.0, 127.0, 128, 0.0, 127.0, 128);
        Linear1DSet linear1DSet = new Linear1DSet((MathType)realType2, 0.0, 255.0, 256);
        Integer2DSet integer2DSet = new Integer2DSet((MathType)realTupleType, 128, 128);
        Integer1DSet integer1DSet = new Integer1DSet((MathType)realType2, 256);
        FlatField flatField = new FlatField((FunctionType)mathType, linear2DSet);
        FlatField flatField2 = new FlatField(functionType, linear2DSet);
        FlatField flatField3 = new FlatField(functionType2, linear2DSet);
        FlatField flatField4 = new FlatField(functionType3, linear1DSet);
        System.out.println(flatField);
        System.out.println(flatField4);
        System.out.println(linear2DSet);
        System.out.println(linear1DSet);
        System.out.println(integer2DSet);
        System.out.println(integer1DSet);
        if (linear1DSet instanceof IntegerSet) {
            System.out.println(" set1d ");
        }
        if (linear2DSet instanceof IntegerSet) {
            System.out.println(" set2d ");
        }
        if (integer1DSet instanceof IntegerSet) {
            System.out.println(" iset1d ");
        }
        if (integer2DSet instanceof IntegerSet) {
            System.out.println(" iset2d ");
        }
        System.out.println("");
        int n = 14;
        int n2 = 12;
        int n3 = 10;
        Real real = new Real(1.0);
        Real real2 = new Real(12.0);
        Real real3 = new Real(12.0);
        Real real4 = new Real(n);
        Real real5 = new Real(n2);
        Real real6 = new Real(n3);
        System.out.println(real);
        System.out.println("" + real2 + " " + real3 + " " + real4 + " " + real5 + " " + real6);
    }

    public abstract boolean isMissing() throws VisADException, RemoteException;

    public Set(MathType mathType) throws VisADException {
        this(mathType, null, null, null);
    }

    public Set(MathType mathType, CoordinateSystem coordinateSystem) throws VisADException {
        this(mathType, coordinateSystem, null, null);
    }

    public Set(MathType mathType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(Set.adjustType(mathType));
        this.DomainDimension = Set.getDimension(mathType);
        RealTupleType realTupleType = ((SetType)this.Type).getDomain();
        CoordinateSystem coordinateSystem2 = realTupleType.getCoordinateSystem();
        if (coordinateSystem == null) {
            this.DomainCoordinateSystem = coordinateSystem2;
        } else {
            if (coordinateSystem2 == null || !coordinateSystem2.getReference().equals(coordinateSystem.getReference())) {
                throw new CoordinateSystemException("Set: coord_sys " + coordinateSystem.getReference() + " must match Type.DefaultCoordinateSystem " + (coordinateSystem2 == null ? null : coordinateSystem2.getReference()));
            }
            this.DomainCoordinateSystem = coordinateSystem;
        }
        if (this.DomainCoordinateSystem != null && !Unit.canConvertArray(this.DomainCoordinateSystem.getCoordinateSystemUnits(), realTupleType.getDefaultUnits())) {
            throw new UnitException("Set: CoordinateSystem Units must be convertable with DomainType default Units");
        }
        if (unitArray == null) {
            this.SetUnits = this.DomainCoordinateSystem == null ? realTupleType.getDefaultUnits() : this.DomainCoordinateSystem.getCoordinateSystemUnits();
        } else {
            if (unitArray.length != this.DomainDimension) {
                throw new UnitException("Set: units dimension " + unitArray.length + " does not match Domain dimension " + this.DomainDimension);
            }
            this.SetUnits = new Unit[this.DomainDimension];
            Unit[] unitArray2 = realTupleType.getDefaultUnits();
            int n = 0;
            while (n < this.DomainDimension) {
                this.SetUnits[n] = unitArray[n] == null && unitArray2[n] != null ? unitArray2[n] : (((RealType)realTupleType.getComponent(n)).isInterval() ? unitArray[n].getAbsoluteUnit() : unitArray[n]);
                ++n;
            }
        }
        if (!Unit.canConvertArray(this.SetUnits, realTupleType.getDefaultUnits())) {
            throw new UnitException("Set: Units " + this.SetUnits + " must be convertable with DomainType" + " default Units " + realTupleType.getDefaultUnits());
        }
        if (this.SetUnits == null) {
            this.SetUnits = new Unit[this.DomainDimension];
        }
        this.SetErrors = new ErrorEstimate[this.DomainDimension];
        if (errorEstimateArray != null) {
            if (errorEstimateArray.length != this.DomainDimension) {
                throw new SetException("Set: errors dimension " + errorEstimateArray.length + " does not match Domain dimension " + this.DomainDimension);
            }
            int n = 0;
            while (n < this.DomainDimension) {
                this.SetErrors[n] = errorEstimateArray[n];
                ++n;
            }
        }
    }
}

