/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.Unit;
import visad.UnitException;

public final class ScaledUnit
extends Unit
implements Serializable {
    final double amount;
    final DerivedUnit derivedUnit;

    public static ScaledUnit create(double d, Unit unit) throws UnitException {
        ScaledUnit scaledUnit;
        if (unit instanceof BaseUnit) {
            scaledUnit = new ScaledUnit(d, (BaseUnit)unit);
        } else if (unit instanceof DerivedUnit) {
            scaledUnit = new ScaledUnit(d, (DerivedUnit)unit);
        } else if (unit instanceof ScaledUnit) {
            scaledUnit = new ScaledUnit(d, (ScaledUnit)unit);
        } else {
            throw new UnitException("Can't create Scaled Unit from " + unit);
        }
        return scaledUnit;
    }

    protected Unit protectedClone(String string) {
        return new ScaledUnit(this.amount, this.derivedUnit, string);
    }

    public Unit pow(int n) {
        return new ScaledUnit(Math.pow(this.amount, n), (DerivedUnit)this.derivedUnit.pow(n));
    }

    public Unit root(int n) throws IllegalArgumentException {
        return new ScaledUnit(Math.pow(this.amount, 1.0 / (double)n), (DerivedUnit)this.derivedUnit.root(n));
    }

    public Unit pow(double d) throws IllegalArgumentException {
        return new ScaledUnit(Math.pow(this.amount, d), (DerivedUnit)this.derivedUnit.pow(d));
    }

    public String getDefinition() {
        String string;
        if (this.derivedUnit == null) {
            string = "<unconstructed ScaledUnit>";
        } else {
            String string2 = this.derivedUnit.toString();
            string = this.amount == 1.0 ? string2 : (string2.length() == 0 ? Double.toString(this.amount) : Double.toString(this.amount) + " " + string2);
        }
        return string;
    }

    public Unit multiply(Unit unit) throws UnitException {
        return ScaledUnit.create(this.amount, this.derivedUnit.multiply(unit));
    }

    public Unit divide(Unit unit) throws UnitException {
        return ScaledUnit.create(this.amount, this.derivedUnit.divide(unit));
    }

    protected Unit divideInto(Unit unit) throws UnitException {
        return ScaledUnit.create(1.0 / this.amount, this.derivedUnit.divideInto(unit));
    }

    public double[] toThis(double[] dArray, Unit unit) throws UnitException {
        double[] dArray2 = unit.toThat(dArray, (Unit)this.derivedUnit);
        int n = 0;
        while (n < dArray2.length) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] / this.amount;
        }
        return dArray2;
    }

    public float[] toThis(float[] fArray, Unit unit) throws UnitException {
        float[] fArray2 = unit.toThat(fArray, (Unit)this.derivedUnit);
        int n = 0;
        while (n < fArray2.length) {
            int n2 = n++;
            fArray2[n2] = (float)((double)fArray2[n2] / this.amount);
        }
        return fArray2;
    }

    public double[] toThat(double[] dArray, Unit unit) throws UnitException {
        double[] dArray2 = (double[])dArray.clone();
        int n = 0;
        while (n < dArray2.length) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] * this.amount;
        }
        return unit.toThis(dArray2, (Unit)this.derivedUnit);
    }

    public float[] toThat(float[] fArray, Unit unit) throws UnitException {
        float[] fArray2 = (float[])fArray.clone();
        int n = 0;
        while (n < fArray2.length) {
            int n2 = n++;
            fArray2[n2] = (float)((double)fArray2[n2] * this.amount);
        }
        return unit.toThis(fArray2, (Unit)this.derivedUnit);
    }

    public boolean isConvertible(Unit unit) {
        return unit == null ? false : this.derivedUnit.isConvertible(unit);
    }

    public static void main(String[] stringArray) throws UnitException {
        BaseUnit baseUnit = BaseUnit.addBaseUnit("Length", "meter");
        BaseUnit baseUnit2 = BaseUnit.addBaseUnit("Time", "second");
        DerivedUnit derivedUnit = new DerivedUnit(new BaseUnit[]{baseUnit, baseUnit2}, new int[]{1, -1});
        ScaledUnit scaledUnit = new ScaledUnit(0.44704, derivedUnit);
        Unit unit = ((Unit)scaledUnit).pow(2);
        BaseUnit baseUnit3 = BaseUnit.addBaseUnit("Mass", "kilogram");
        DerivedUnit derivedUnit2 = new DerivedUnit(new BaseUnit[]{baseUnit3, baseUnit2}, new int[]{1, -1});
        ScaledUnit scaledUnit2 = new ScaledUnit(0.453592, derivedUnit2);
        System.out.println("milePerHour=\"" + scaledUnit + "\"");
        System.out.println("milePerHour.pow(2)=\"" + ((Unit)scaledUnit).pow(2) + "\"");
        System.out.println("milePerHour2.root(2)=\"" + unit.root(2) + "\"");
        System.out.println("poundPerSec=\"" + scaledUnit2 + "\"");
        System.out.println("milePerHour*poundPerSec=\"" + ((Unit)scaledUnit).multiply(scaledUnit2) + "\"");
        System.out.println("poundPerSec*milePerHour=\"" + ((Unit)scaledUnit2).multiply(scaledUnit) + "\"");
        System.out.println("milePerHour/poundPerSec=\"" + ((Unit)scaledUnit).divide(scaledUnit2) + "\"");
        System.out.println("poundPerSec/milePerHour=\"" + ((Unit)scaledUnit2).divide(scaledUnit) + "\"");
        System.out.println("milePerHour.toThis(1,meterPerSec)=" + scaledUnit.toThis(1.0, (Unit)derivedUnit));
        System.out.println("milePerHour.toThat(1,meterPerSec)=" + scaledUnit.toThat(1.0, (Unit)derivedUnit));
        double[] dArray = ((Unit)scaledUnit).toThis(new double[]{1.0, 2.0}, (Unit)derivedUnit);
        System.out.println("milePerHour.toThis({1,2},meterPerSec)=" + dArray[0] + "," + dArray[1]);
        dArray = ((Unit)scaledUnit).toThat(new double[]{1.0, 2.0}, (Unit)derivedUnit);
        System.out.println("milePerHour.toThat({1,2},meterPerSec)=" + dArray[0] + "," + dArray[1]);
        System.out.println("Checking exceptions:");
        try {
            scaledUnit.toThis(5.0, (Unit)scaledUnit2);
            System.err.println("ERROR: poundPerSec -> milePerHour");
            System.exit(1);
        }
        catch (UnitException unitException) {
            System.out.println(unitException.getMessage());
        }
    }

    public boolean equals(Unit unit) {
        if (unit == null) {
            return false;
        }
        if (unit instanceof BaseUnit) {
            return this.equals(new ScaledUnit(1.0, (BaseUnit)unit));
        }
        if (unit instanceof DerivedUnit) {
            return this.equals(new ScaledUnit(1.0, (DerivedUnit)unit));
        }
        if (!(unit instanceof ScaledUnit)) {
            return unit.equals(this);
        }
        return this.derivedUnit.equals(((ScaledUnit)unit).derivedUnit) && this.amount == ((ScaledUnit)unit).amount;
    }

    public ScaledUnit(double d) {
        this(d, "");
    }

    public ScaledUnit(double d, String string) {
        super(string);
        this.amount = d;
        this.derivedUnit = new DerivedUnit();
    }

    public ScaledUnit(double d, BaseUnit baseUnit) {
        this(d, baseUnit, d == 1.0 ? baseUnit.getIdentifier() : null);
    }

    public ScaledUnit(double d, BaseUnit baseUnit, String string) {
        super(string);
        this.amount = d;
        this.derivedUnit = new DerivedUnit(baseUnit);
    }

    public ScaledUnit(double d, DerivedUnit derivedUnit) {
        this(d, derivedUnit, d == 1.0 ? derivedUnit.getIdentifier() : null);
    }

    public ScaledUnit(double d, DerivedUnit derivedUnit, String string) {
        super(string);
        this.amount = d;
        this.derivedUnit = derivedUnit;
    }

    public ScaledUnit(double d, ScaledUnit scaledUnit) {
        this(d, scaledUnit, d == 1.0 && scaledUnit.amount == 1.0 ? scaledUnit.getIdentifier() : null);
    }

    public ScaledUnit(double d, ScaledUnit scaledUnit, String string) {
        super(string);
        this.amount = d * scaledUnit.amount;
        this.derivedUnit = scaledUnit.derivedUnit;
    }
}

