/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InvalidObjectException;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import visad.MathType;
import visad.TypeException;
import visad.VisADException;
import visad.util.WeakMapValue;

public abstract class ScalarType
extends MathType
implements Comparable {
    private static Map ScalarHash = new HashMap();
    private static Map Translations = new HashMap();
    private static Map ReverseTranslations = new HashMap();
    private static final ReferenceQueue queue = new ReferenceQueue();
    String Name;

    public int compareTo(Object object) {
        return this.getName().compareTo(((ScalarType)object).getName());
    }

    public boolean equals(Object object) {
        return object instanceof ScalarType && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void alias(String string) throws TypeException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.Name.equals(Translations.get(string))) {
                ScalarType.validateName(string, "alias");
                Translations.put(string, this.Name);
            }
            ReverseTranslations.put(this.Name, string);
        }
    }

    public String getName() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            String string = (String)ReverseTranslations.get(this.Name);
            if (string != null) {
                String string2 = string;
                Object var2_4 = null;
                return string2;
            }
        }
        return this.Name;
    }

    public String getNameWithBlanks() {
        return this.getName().replace('_', ' ');
    }

    public static synchronized ScalarType getScalarTypeByName(String string) {
        Object v;
        if (string == null) {
            return null;
        }
        ScalarType.checkQueue();
        if (Translations.containsKey(string)) {
            string = (String)Translations.get(string);
        }
        ScalarType scalarType = (v = ScalarHash.get(string)) == null ? null : (ScalarType)((WeakMapValue)v).getValue();
        return scalarType;
    }

    public static synchronized void validateName(String string, String string2) throws TypeException {
        if (string == null) {
            throw new TypeException("ScalarType: " + string2 + " cannot be null");
        }
        if (string.indexOf(".") > -1 || string.indexOf(" ") > -1 || string.indexOf("(") > -1 || string.indexOf(")") > -1) {
            throw new TypeException("ScalarType: " + string2 + " cannot contain " + "space . ( or ) " + string);
        }
        if (ScalarType.getScalarTypeByName(string) != null) {
            throw new TypeException("ScalarType: " + string2 + " already used");
        }
        if (Translations.containsKey(string)) {
            throw new TypeException("ScalarType: " + string2 + " already used" + " as an alias");
        }
    }

    protected final Object readResolve() throws InvalidObjectException {
        ScalarType scalarType;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            scalarType = ScalarType.getScalarTypeByName(this.Name);
            if (scalarType == null) {
                ScalarHash.put(this.Name, new WeakMapValue(this.Name, this, queue));
                scalarType = this;
            } else if (!this.equals(scalarType)) {
                throw new InvalidObjectException(this.toString());
            }
        }
        return scalarType;
    }

    private static synchronized void checkQueue() {
        WeakMapValue weakMapValue;
        while ((weakMapValue = (WeakMapValue)queue.poll()) != null) {
            Object object = weakMapValue.getKey();
            ScalarHash.remove(object);
            Object v = ReverseTranslations.remove(object);
            if (v == null) continue;
            Translations.remove(v);
        }
    }

    public ScalarType(String string) throws VisADException {
        this.Name = string;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ScalarType.checkQueue();
            ScalarType.validateName(string, "name");
            ScalarHash.put(string, new WeakMapValue(this.Name, this, queue));
        }
    }

    ScalarType(String string, boolean bl) {
        super(bl);
        this.Name = string;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ScalarType.checkQueue();
            ScalarHash.put(string, new WeakMapValue(this.Name, this, queue));
        }
    }
}

