/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AnimationControl;
import visad.AxisScale;
import visad.ConstantMap;
import visad.ContourControl;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.ProjectionControl;
import visad.RealType;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ScalarType;
import visad.Set;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class ScalarMap
implements Cloneable,
Serializable,
Comparable {
    private static final double SCALE = 0.06;
    private static final double OFFSET = 1.05;
    private Unit overrideUnit = null;
    private double override_scale;
    private double override_offset;
    private ScalarType Scalar;
    private DisplayRealType DisplayScalar;
    private int ScalarIndex;
    private int DisplayScalarIndex;
    int ValueIndex;
    private transient Control control;
    private transient DisplayImpl display;
    private boolean isManual;
    boolean isScaled;
    double[] displayRange = new double[2];
    private double[] dataRange = new double[2];
    private double scale;
    private double offset;
    private long NewTick;
    private long OldTick;
    private boolean tickFlag;
    private String scalarName = null;
    private boolean scale_flag = false;
    private boolean back_scale_flag = false;
    private boolean scale_on = true;
    private boolean underscore_to_blank = false;
    private transient Vector ListenerVector = new Vector();
    private AxisScale axisScale = null;

    public void resetAutoScale() {
        this.isManual = false;
    }

    public boolean doInitialize() {
        return this.isScaled && !this.isManual;
    }

    public void setOverrideUnit(Unit unit) throws VisADException {
        if (!(this.Scalar instanceof RealType)) {
            throw new UnitException("Scalar is not RealType");
        }
        Unit unit2 = ((RealType)this.Scalar).getDefaultUnit();
        if (!Unit.canConvert(unit, unit2)) {
            throw new UnitException("unit not convertable with RealType default");
        }
        if (unit != null) {
            this.overrideUnit = unit;
            this.override_offset = this.overrideUnit.toThis(0.0, unit2);
            this.override_scale = this.overrideUnit.toThis(1.0, unit2) - this.override_offset;
        }
    }

    public Unit getOverrideUnit() {
        return this.overrideUnit;
    }

    public String getScalarName() {
        return this.scalarName;
    }

    public void setScalarName(String string) {
        this.scalarName = string;
        if (this.axisScale != null) {
            this.axisScale.setTitle(this.scalarName);
        }
    }

    public long incTick() {
        ++this.NewTick;
        if (this.NewTick == Long.MAX_VALUE) {
            this.NewTick = -9223372036854775807L;
        }
        if (this.display != null) {
            this.display.controlChanged();
        }
        return this.NewTick;
    }

    public synchronized void setTicks() {
        this.tickFlag = this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
        this.OldTick = this.NewTick;
        if (this.control != null) {
            this.control.setTicks();
        }
    }

    public synchronized boolean peekTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        if (this.control == null) {
            return this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
        }
        return this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick || this.control.peekTicks(dataRenderer, dataDisplayLink);
    }

    public synchronized boolean checkTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        if (this.control == null) {
            return this.tickFlag;
        }
        return this.tickFlag || this.control.checkTicks(dataRenderer, dataDisplayLink);
    }

    synchronized void resetTicks() {
        this.tickFlag = false;
        if (this.control != null) {
            this.control.resetTicks();
        }
    }

    public ScalarType getScalar() {
        return this.Scalar;
    }

    public DisplayRealType getDisplayScalar() {
        return this.DisplayScalar;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    synchronized void nullDisplay() throws RemoteException, VisADException {
        if (this.control != null) {
            this.control.nullControl();
            ScalarMapControlEvent scalarMapControlEvent = new ScalarMapControlEvent(this, 4, this.control);
            this.notifyCtlListeners(scalarMapControlEvent);
        }
        this.control = null;
        this.display = null;
        this.ScalarIndex = -1;
        this.DisplayScalarIndex = -1;
        this.scale_flag = this.back_scale_flag;
        if (this.axisScale != null) {
            this.axisScale.setAxisOrdinal(-1);
        }
    }

    synchronized void setDisplay(DisplayImpl displayImpl) throws VisADException {
        if (displayImpl.equals(this.display)) {
            return;
        }
        if (this.display != null) {
            throw new DisplayException("ScalarMap.setDisplay: ScalarMap cannot belong to two Displays");
        }
        this.display = displayImpl;
        if (this.scale_flag) {
            this.makeScale();
        }
        if (!(this instanceof ConstantMap)) {
            ProjectionControl projectionControl = this.display.getProjectionControl();
            try {
                this.setAspectCartesian(projectionControl.getAspectCartesian());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    synchronized void setControl() throws VisADException, RemoteException {
        Control control;
        int n;
        if (this.control != null) {
            n = 5;
            control = this.control;
        } else {
            n = 3;
            control = null;
        }
        if (this.display == null) {
            throw new DisplayException("ScalarMap.setControl: not part of any Display");
        }
        this.control = this.display.getDisplayRenderer().makeControl(this);
        if (this.control != null) {
            this.display.addControl(this.control);
            if (control == null) {
                control = this.control;
            }
        }
        if (this.control != null || control != null) {
            this.notifyCtlListeners(new ScalarMapControlEvent(this, n, control));
        }
    }

    public boolean getScale(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.overrideUnit != null) {
            dArray[0] = this.scale * this.override_scale;
            dArray[1] = this.scale * this.override_offset + this.offset;
        } else {
            dArray[0] = this.scale;
            dArray[1] = this.offset;
        }
        dArray2[0] = this.dataRange[0];
        dArray2[1] = this.dataRange[1];
        dArray3[0] = this.displayRange[0];
        dArray3[1] = this.displayRange[1];
        return this.isScaled;
    }

    public double[] getRange() {
        double[] dArray = new double[]{this.dataRange[0], this.dataRange[1]};
        return dArray;
    }

    public void setRangeByUnits() throws VisADException, RemoteException {
        this.isManual = true;
        this.setRange(null, 0.0, 0.0, true);
        if (this.scale == this.scale && this.offset == this.offset) {
            this.incTick();
        } else {
            this.isManual = false;
        }
    }

    public void setRange(double d, double d2) throws VisADException, RemoteException {
        this.setRange(d, d2, 0);
    }

    public void setRange(double d, double d2, int n) throws VisADException, RemoteException {
        this.isManual = true;
        this.setRange(null, d, d2, false, n);
        if (this.scale == this.scale && this.offset == this.offset) {
            this.incTick();
        } else {
            this.isManual = false;
        }
    }

    public void setRange(DataShadow dataShadow) throws VisADException, RemoteException {
        if (!this.isManual) {
            this.setRange(dataShadow, 0.0, 0.0, false, 0);
        }
    }

    private synchronized void setRange(DataShadow dataShadow, double d, double d2, boolean bl) throws VisADException, RemoteException {
        this.setRange(dataShadow, d, d2, bl, 0);
    }

    private synchronized void setRange(DataShadow dataShadow, double d, double d2, boolean bl, int n) throws VisADException, RemoteException {
        Object object;
        Object object2;
        int n2 = this.ScalarIndex;
        if (dataShadow != null) {
            if (this.DisplayScalar.equals(Display.Latitude) || this.DisplayScalar.equals(Display.Longitude)) {
                object2 = this.Scalar instanceof RealType ? ((RealType)this.Scalar).getDefaultUnit() : null;
                object = this.DisplayScalar.getDefaultUnit();
                if (object2 != null && object != null && Unit.canConvert((Unit)object2, (Unit)object)) {
                    this.dataRange[0] = ((Unit)object2).toThis(this.displayRange[0], (Unit)object);
                    this.dataRange[1] = ((Unit)object2).toThis(this.displayRange[1], (Unit)object);
                } else {
                    if (n2 < 0 || n2 >= dataShadow.ranges[0].length) {
                        return;
                    }
                    this.dataRange[0] = dataShadow.ranges[0][n2];
                    this.dataRange[1] = dataShadow.ranges[1][n2];
                }
            } else {
                if (n2 < 0 || n2 >= dataShadow.ranges[0].length) {
                    return;
                }
                this.dataRange[0] = dataShadow.ranges[0][n2];
                this.dataRange[1] = dataShadow.ranges[1][n2];
            }
        } else if (bl) {
            object2 = this.Scalar instanceof RealType ? ((RealType)this.Scalar).getDefaultUnit() : null;
            object = this.DisplayScalar.getDefaultUnit();
            if (object2 == null || object == null) {
                throw new UnitException("ScalarMap.setRangeByUnits: null Unit");
            }
            this.dataRange[0] = ((Unit)object2).toThis(this.displayRange[0], (Unit)object);
            this.dataRange[1] = ((Unit)object2).toThis(this.displayRange[1], (Unit)object);
        } else {
            this.dataRange[0] = d;
            this.dataRange[1] = d2;
            if (this.overrideUnit != null) {
                this.dataRange[0] = (this.dataRange[0] - this.override_offset) / this.override_scale;
                this.dataRange[1] = (this.dataRange[1] - this.override_offset) / this.override_scale;
            }
        }
        if (this.isScaled) {
            this.computeScaleAndOffset();
        } else {
            if (this.dataRange[0] == Double.MAX_VALUE || this.dataRange[1] == -1.7976931348623157E308) {
                this.dataRange[0] = Double.NaN;
                this.dataRange[1] = Double.NaN;
            }
            if (this.overrideUnit != null) {
                this.dataRange[0] = this.dataRange[0] * this.override_scale + this.override_offset;
                this.dataRange[1] = this.dataRange[1] * this.override_scale + this.override_offset;
            }
        }
        if (this.DisplayScalar.equals(Display.Animation) && dataShadow != null) {
            if (this.control != null) {
                object2 = dataShadow.animationSampling;
                if (object2 == null) {
                    return;
                }
                ((AnimationControl)((Object)this.control)).setSet((Set)object2, true);
            }
        } else if (this.DisplayScalar.equals(Display.IsoContour)) {
            if (this.control != null) {
                float f;
                object2 = new boolean[2];
                object = new float[5];
                ((ContourControl)this.control).getMainContours((boolean[])object2, (float[])object);
                if (dataShadow == null) {
                    object[0] = (float)this.dataRange[0];
                }
                if ((f = (float)(this.dataRange[1] - this.dataRange[0]) / 10.0f) != 0.0f) {
                    object[1] = f;
                }
                object[2] = (float)this.dataRange[0];
                object[3] = (float)this.dataRange[1];
                object[4] = (float)this.dataRange[0];
                ((ContourControl)this.control).setMainContours((boolean[])object2, (float[])object, true);
            }
        } else if ((this.DisplayScalar.equals(Display.XAxis) || this.DisplayScalar.equals(Display.YAxis) || this.DisplayScalar.equals(Display.ZAxis)) && this.dataRange[0] != Double.MAX_VALUE && this.dataRange[1] != -1.7976931348623157E308 && this.dataRange[0] == this.dataRange[0] && this.dataRange[1] == this.dataRange[1] && this.dataRange[0] != this.dataRange[1] && this.scale == this.scale && this.offset == this.offset) {
            if (this.display != null) {
                this.makeScale();
            } else {
                this.scale_flag = true;
            }
            this.back_scale_flag = true;
        }
        if (this.dataRange[0] == this.dataRange[0] && this.dataRange[1] == this.dataRange[1] && this.ListenerVector != null) {
            object2 = new ScalarMapEvent(this, dataShadow == null ? 2 : 1, n);
            object = null;
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                object = (Vector)this.ListenerVector.clone();
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                ScalarMapListener scalarMapListener = (ScalarMapListener)enumeration.nextElement();
                scalarMapListener.mapChanged((ScalarMapEvent)object2);
            }
        }
    }

    private void computeScaleAndOffset() {
        if (this.dataRange[0] == Double.MAX_VALUE || this.dataRange[1] == -1.7976931348623157E308) {
            this.dataRange[0] = Double.NaN;
            this.dataRange[1] = Double.NaN;
            this.scale = Double.NaN;
            this.offset = Double.NaN;
        } else {
            if (this.dataRange[0] == this.dataRange[1]) {
                double d = this.dataRange[0] / 2000.0;
                if (d < 0.5) {
                    d = 0.5;
                }
                this.dataRange[0] = this.dataRange[0] - d;
                this.dataRange[1] = this.dataRange[1] + d;
            }
            if (this.overrideUnit != null) {
                this.dataRange[0] = this.dataRange[0] * this.override_scale + this.override_offset;
                this.dataRange[1] = this.dataRange[1] * this.override_scale + this.override_offset;
            }
            this.scale = (this.displayRange[1] - this.displayRange[0]) / (this.dataRange[1] - this.dataRange[0]);
            this.offset = this.displayRange[0] - this.scale * this.dataRange[0];
        }
        if (Double.isInfinite(this.scale) || Double.isInfinite(this.offset) || this.scale != this.scale || this.offset != this.offset) {
            this.dataRange[0] = Double.NaN;
            this.dataRange[1] = Double.NaN;
            this.scale = Double.NaN;
            this.offset = Double.NaN;
        }
    }

    public void addScalarMapListener(ScalarMapListener scalarMapListener) {
        if (this.ListenerVector == null) {
            this.ListenerVector = new Vector();
        }
        this.ListenerVector.addElement(scalarMapListener);
        if (this.dataRange[0] == this.dataRange[0] && this.dataRange[1] == this.dataRange[1]) {
            try {
                scalarMapListener.mapChanged(new ScalarMapEvent(this, 2));
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void removeScalarMapListener(ScalarMapListener scalarMapListener) {
        if (scalarMapListener != null && this.ListenerVector != null) {
            this.ListenerVector.removeElement(scalarMapListener);
        }
    }

    private void notifyCtlListeners(ScalarMapControlEvent scalarMapControlEvent) throws RemoteException, VisADException {
        if (this.ListenerVector != null) {
            Vector vector = null;
            Vector vector2 = this.ListenerVector;
            synchronized (vector2) {
                vector = (Vector)this.ListenerVector.clone();
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ScalarMapListener scalarMapListener = (ScalarMapListener)enumeration.nextElement();
                scalarMapListener.controlChanged(scalarMapControlEvent);
            }
        }
    }

    public void setUnderscoreToBlank(boolean bl) {
        this.underscore_to_blank = bl;
        if (this.Scalar != null) {
            this.scalarName = this.Scalar.getName();
            if (this.underscore_to_blank) {
                this.scalarName = this.scalarName.replace('_', ' ');
            }
            if (this.axisScale != null) {
                this.axisScale.setTitle(this.scalarName);
            }
        }
    }

    public void makeScale() throws VisADException {
        if (this.axisScale != null) {
            DisplayRenderer displayRenderer = null;
            if (this.display == null) {
                return;
            }
            displayRenderer = this.display.getDisplayRenderer();
            if (displayRenderer == null) {
                return;
            }
            boolean bl = this.axisScale.makeScale();
            if (bl) {
                if (this.scale_on) {
                    displayRenderer.setScale(this.axisScale);
                } else {
                    displayRenderer.clearScale(this.axisScale);
                }
                this.scale_flag = false;
            }
        }
    }

    public void setScaleEnable(boolean bl) {
        this.scale_on = bl;
        if (this.axisScale != null) {
            this.axisScale.setVisible(bl);
        }
    }

    public boolean getScaleEnable() {
        return this.scale_on;
    }

    public void setScaleColor(float[] fArray) throws VisADException {
        if (!(this.DisplayScalar.equals(Display.XAxis) || this.DisplayScalar.equals(Display.YAxis) || this.DisplayScalar.equals(Display.ZAxis))) {
            throw new DisplayException("ScalarMap.setScaleColor: DisplayScalar must be XAxis, YAxis or ZAxis");
        }
        if (fArray == null || fArray.length != 3) {
            throw new DisplayException("ScalarMap.setScaleColor: color is null or wrong length");
        }
        this.axisScale.setColor(fArray);
    }

    public boolean badRange() {
        return this.isScaled && (this.scale != this.scale || this.offset != this.offset);
    }

    public float[] scaleValues(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        float[] fArray = new float[dArray.length];
        if (this.badRange()) {
            int n = 0;
            while (n < dArray.length) {
                fArray[n] = Float.NaN;
                ++n;
            }
        } else {
            if (this.overrideUnit != null) {
                try {
                    dArray = this.overrideUnit.toThis(dArray, ((RealType)this.Scalar).getDefaultUnit());
                }
                catch (UnitException unitException) {
                    // empty catch block
                }
            }
            if (this.isScaled) {
                int n = 0;
                while (n < dArray.length) {
                    fArray[n] = (float)(this.offset + this.scale * dArray[n]);
                    ++n;
                }
            } else {
                int n = 0;
                while (n < dArray.length) {
                    fArray[n] = (float)dArray[n];
                    ++n;
                }
            }
        }
        return fArray;
    }

    public float[] scaleValues(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = null;
        if (this.badRange()) {
            fArray2 = new float[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray2[n] = Float.NaN;
                ++n;
            }
        } else {
            if (this.overrideUnit != null) {
                try {
                    fArray = this.overrideUnit.toThis(fArray, ((RealType)this.Scalar).getDefaultUnit());
                }
                catch (UnitException unitException) {
                    // empty catch block
                }
            }
            if (this.isScaled) {
                fArray2 = new float[fArray.length];
                int n = 0;
                while (n < fArray.length) {
                    fArray2[n] = (float)(this.offset + this.scale * (double)fArray[n]);
                    ++n;
                }
            } else {
                fArray2 = fArray;
            }
        }
        return fArray2;
    }

    public float[] inverseScaleValues(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        if (this.isScaled) {
            int n = 0;
            while (n < fArray.length) {
                fArray2[n] = (float)(((double)fArray[n] - this.offset) / this.scale);
                ++n;
            }
        } else {
            int n = 0;
            while (n < fArray.length) {
                fArray2[n] = fArray[n];
                ++n;
            }
        }
        if (this.overrideUnit != null) {
            try {
                fArray2 = this.overrideUnit.toThat(fArray2, ((RealType)this.Scalar).getDefaultUnit());
            }
            catch (UnitException unitException) {
                // empty catch block
            }
        }
        return fArray2;
    }

    public static void equalizeFlow(Vector vector, DisplayTupleType displayTupleType) throws VisADException, RemoteException {
        DisplayTupleType displayTupleType2;
        DisplayRealType displayRealType;
        ScalarMap scalarMap;
        double[] dArray = new double[2];
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            scalarMap = (ScalarMap)enumeration.nextElement();
            displayRealType = scalarMap.getDisplayScalar();
            displayTupleType2 = displayRealType.getTuple();
            if (!displayTupleType.equals(displayTupleType2) || scalarMap.isManual || scalarMap.badRange()) continue;
            bl = true;
            d = Math.min(d, scalarMap.dataRange[0]);
            d2 = Math.max(d2, scalarMap.dataRange[1]);
        }
        if (!bl) {
            return;
        }
        d2 = Math.max(d2, -d);
        d = -d2;
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            scalarMap = (ScalarMap)enumeration.nextElement();
            displayRealType = scalarMap.getDisplayScalar();
            displayTupleType2 = displayRealType.getTuple();
            if (!displayTupleType.equals(displayTupleType2) || scalarMap.isManual || scalarMap.badRange()) continue;
            scalarMap.setRange(null, d, d2, false);
        }
    }

    int getDisplayScalarIndex() {
        return this.DisplayScalarIndex;
    }

    int getScalarIndex() {
        return this.ScalarIndex;
    }

    void setScalarIndex(int n) {
        this.ScalarIndex = n;
    }

    void setDisplayScalarIndex(int n) {
        this.DisplayScalarIndex = n;
    }

    public void setValueIndex(int n) {
        this.ValueIndex = n;
    }

    public int getValueIndex() {
        return this.ValueIndex;
    }

    public int compareTo(Object object) {
        return -((ScalarMap)object).compareTo(this);
    }

    protected int compareTo(ScalarMap scalarMap) {
        int n = this.getScalar().compareTo(scalarMap.getScalar());
        if (n == 0) {
            n = this.getDisplayScalar().compareTo(scalarMap.getDisplayScalar());
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof ScalarMap && this.compareTo(object) == 0;
    }

    public int hashCode() {
        ScalarType scalarType = this.getScalar();
        DisplayRealType displayRealType = this.getDisplayScalar();
        int n = 0;
        if (scalarType != null) {
            n = displayRealType != null ? scalarType.hashCode() ^ displayRealType.hashCode() : scalarType.hashCode();
        } else if (displayRealType != null) {
            n = displayRealType.hashCode();
        }
        return n;
    }

    public Object clone() {
        try {
            ScalarMap scalarMap = new ScalarMap(this.Scalar, this.DisplayScalar);
            this.copy(scalarMap);
            return scalarMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void copy(ScalarMap scalarMap) throws VisADException, RemoteException {
        scalarMap.isScaled = this.isScaled;
        scalarMap.isManual = this.isManual;
        scalarMap.dataRange[0] = this.dataRange[0];
        scalarMap.dataRange[1] = this.dataRange[1];
        scalarMap.displayRange[0] = this.displayRange[0];
        scalarMap.displayRange[1] = this.displayRange[1];
        scalarMap.scale = this.scale;
        scalarMap.offset = this.offset;
        scalarMap.axisScale = this.axisScale != null ? this.axisScale.clone(scalarMap) : null;
        scalarMap.scale_flag = this.scale_flag;
        scalarMap.back_scale_flag = this.back_scale_flag;
        if (scalarMap.display != null) {
            scalarMap.setControl();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        return string + "ScalarMap: " + this.Scalar.toString() + " -> " + this.DisplayScalar.toString() + "\n";
    }

    public AxisScale getAxisScale() {
        return this.axisScale;
    }

    void setAspectCartesian(double[] dArray) throws VisADException, RemoteException {
        double d = Double.NaN;
        if (this.DisplayScalar.equals(Display.XAxis)) {
            d = dArray[0];
        }
        if (this.DisplayScalar.equals(Display.YAxis)) {
            d = dArray[1];
        }
        if (this.DisplayScalar.equals(Display.ZAxis)) {
            d = dArray[2];
        }
        if (d == d) {
            this.isScaled = this.DisplayScalar.getRange(this.displayRange);
            this.displayRange[0] = this.displayRange[0] * d;
            this.displayRange[1] = this.displayRange[1] * d;
            this.computeScaleAndOffset();
            this.makeScale();
        }
    }

    public ScalarMap(ScalarType scalarType, DisplayRealType displayRealType) throws VisADException {
        this(scalarType, displayRealType, true);
    }

    ScalarMap(ScalarType scalarType, DisplayRealType displayRealType, boolean bl) throws VisADException {
        if (scalarType == null && bl) {
            throw new DisplayException("ScalarMap: scalar is null");
        }
        if (displayRealType == null) {
            throw new DisplayException("ScalarMap: display_scalar is null");
        }
        if (displayRealType.equals(Display.List)) {
            throw new DisplayException("ScalarMap: display_scalar may not be List");
        }
        boolean bl2 = displayRealType.getText();
        if (scalarType != null && !bl2 && !(scalarType instanceof RealType)) {
            throw new DisplayException("ScalarMap: TextType scalar cannot be used with RealType display_scalar");
        }
        this.control = null;
        this.Scalar = scalarType;
        this.DisplayScalar = displayRealType;
        this.display = null;
        this.ScalarIndex = -1;
        this.DisplayScalarIndex = -1;
        this.isScaled = this.DisplayScalar.getRange(this.displayRange);
        this.isManual = false;
        this.dataRange[0] = Double.NaN;
        this.dataRange[1] = Double.NaN;
        this.OldTick = Long.MIN_VALUE;
        this.NewTick = -9223372036854775807L;
        this.tickFlag = false;
        if (this.Scalar != null) {
            this.scalarName = this.Scalar.getName();
        }
        if (this.DisplayScalar.equals(Display.XAxis) || this.DisplayScalar.equals(Display.YAxis) || this.DisplayScalar.equals(Display.ZAxis)) {
            this.axisScale = new AxisScale(this);
        }
    }
}

