/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.MathType;
import visad.RealType;
import visad.SampledSetIface;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowSetType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;

public abstract class SampledSet
extends SimpleSet
implements SampledSetIface {
    float[][] Samples;
    float[] Low;
    float[] Hi;

    void init_samples(float[][] fArray) throws VisADException {
        this.init_samples(fArray, true);
    }

    void init_samples(float[][] fArray, boolean bl) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("SampledSet.init_samples: sample dimension " + fArray.length + " doesn't match expected length " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = fArray[0].length;
        } else if (this.Length != fArray[0].length) {
            throw new SetException("SampledSet.init_samples: sample#0 length " + fArray[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = bl ? new float[this.DomainDimension][this.Length] : fArray;
        int n = 0;
        while (n < this.DomainDimension) {
            if (fArray[n].length != this.Length) {
                throw new SetException("SampledSet.init_samples: sample#" + n + " length " + fArray[n].length + " doesn't match expected length " + this.Length);
            }
            float[] fArray2 = fArray[n];
            float[] fArray3 = this.Samples[n];
            if (bl) {
                System.arraycopy(fArray2, 0, fArray3, 0, this.Length);
            }
            this.Low[n] = Float.POSITIVE_INFINITY;
            this.Hi[n] = Float.NEGATIVE_INFINITY;
            float f = 0.0f;
            int n2 = 0;
            while (n2 < this.Length) {
                if (fArray3[n2] == fArray3[n2] && !Float.isInfinite(fArray3[n2])) {
                    if (fArray3[n2] < this.Low[n]) {
                        this.Low[n] = fArray3[n2];
                    }
                    if (fArray3[n2] > this.Hi[n]) {
                        this.Hi[n] = fArray3[n2];
                    }
                } else {
                    fArray3[n2] = Float.NaN;
                }
                f += fArray3[n2];
                ++n2;
            }
            if (this.SetErrors[n] != null) {
                this.SetErrors[n] = new ErrorEstimate(this.SetErrors[n].getErrorValue(), f / (float)this.Length, this.Length, this.SetErrors[n].getUnit());
            }
            ++n;
        }
    }

    public void cram_missing(boolean[] blArray) {
        int n = Math.min(blArray.length, this.Samples[0].length);
        int n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                this.Samples[0][n2] = Float.NaN;
            }
            ++n2;
        }
    }

    void cram_samples(float[][] fArray) {
        this.Samples = fArray;
    }

    public void getNeighbors(int[][] nArray, float[][] fArray) throws VisADException {
        this.getNeighbors(nArray);
        float f = 4.0f;
        float f2 = (float)(Math.PI * Math.PI);
        float[][] fArray2 = this.Samples != null ? this.Samples : this.getSamples();
        int n = 0;
        while (n < this.Length) {
            int n2 = nArray[n].length;
            fArray[n] = new float[n2];
            int n3 = 0;
            while (n3 < n2) {
                float f3 = 0.0f;
                int n4 = 0;
                while (n4 < this.DomainDimension) {
                    float f4 = fArray2[n4][n] - fArray2[n4][nArray[n][n3]];
                    f3 += f4 * f4;
                    ++n4;
                }
                float f5 = f3 * f / f2;
                fArray[n][n3] = (float)Math.exp(-1.0f * (f3 / f5));
                ++n3;
            }
            ++n;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        return bl ? Set.copyFloats(this.Samples) : this.Samples;
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException {
        int n = this.getDimension();
        double[][] dArray = new double[2][n];
        return this.computeRanges(shadowType, dataShadow, dArray, false);
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow, double[][] dArray, boolean bl) throws VisADException {
        ShadowRealTupleType shadowRealTupleType;
        if (this.isMissing()) {
            return dataShadow;
        }
        this.setAnimationSampling(shadowType, dataShadow, bl);
        int[] nArray = new int[this.DomainDimension];
        int n = 0;
        while (n < this.DomainDimension) {
            ShadowRealType shadowRealType = null;
            if (shadowType instanceof ShadowSetType) {
                shadowRealType = (ShadowRealType)((ShadowSetType)shadowType).getDomain().getComponent(n);
            } else if (shadowType instanceof ShadowRealTupleType) {
                shadowRealType = (ShadowRealType)((ShadowRealTupleType)shadowType).getComponent(n);
            } else {
                throw new TypeException("SampledSet.computeRanges: bad ShadowType " + shadowType.getClass().getName());
            }
            nArray[n] = shadowRealType.getIndex();
            ++n;
        }
        n = 0;
        while (n < this.DomainDimension) {
            int n2 = nArray[n];
            double d = this.Low[n];
            double d2 = this.Hi[n];
            Unit unit = ((RealType)((SetType)this.Type).getDomain().getComponent(n)).getDefaultUnit();
            if (unit != null && !unit.equals(this.SetUnits[n])) {
                d = unit.toThis(d, this.SetUnits[n]);
                d2 = unit.toThis(d2, this.SetUnits[n]);
            }
            if (dArray != null) {
                dArray[0][n] = d;
                dArray[1][n] = d2;
            }
            if (n2 >= 0 && n2 < dataShadow.ranges[0].length) {
                dataShadow.ranges[0][n2] = Math.min(dataShadow.ranges[0][n2], d);
                dataShadow.ranges[1][n2] = Math.max(dataShadow.ranges[1][n2], d2);
            }
            ++n;
        }
        ShadowRealTupleType shadowRealTupleType2 = null;
        if (shadowType instanceof ShadowRealTupleType) {
            shadowRealTupleType2 = (ShadowRealTupleType)shadowType;
        } else if (shadowType instanceof ShadowSetType) {
            shadowRealTupleType2 = ((ShadowSetType)shadowType).getDomain();
        }
        if (shadowRealTupleType2 != null && dArray != null && (shadowRealTupleType = shadowRealTupleType2.getReference()) != null) {
            dataShadow = this.computeReferenceRanges(shadowRealTupleType2, this.DomainCoordinateSystem, ((SetType)this.Type).getDomain().getDefaultUnits(), dataShadow, shadowRealTupleType, dArray);
        }
        return dataShadow;
    }

    public VisADGeometryArray make1DGeometry(byte[][] byArray) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("SampledSet.make1DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 1) {
            throw new SetException("SampledSet.make1DGeometry: ManifoldDimension must be 1, not " + this.ManifoldDimension);
        }
        VisADGeometryArray visADGeometryArray = null;
        if (this.Length == 0) {
            return null;
        }
        if (this.Length == 1) {
            visADGeometryArray = new VisADPointArray();
        } else {
            visADGeometryArray = new VisADLineStripArray();
            ((VisADLineStripArray)visADGeometryArray).stripVertexCounts = new int[1];
            ((VisADLineStripArray)visADGeometryArray).stripVertexCounts[0] = this.Length;
        }
        this.setGeometryArray(visADGeometryArray, 3, byArray);
        return visADGeometryArray;
    }

    public VisADGeometryArray[] make3DGeometry(byte[][] byArray) throws VisADException {
        if (this.ManifoldDimension != 3) {
            throw new SetException("SampledSet.make3DGeometry: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        VisADGeometryArray visADGeometryArray = this.makePointGeometry(byArray);
        return new VisADGeometryArray[]{visADGeometryArray, visADGeometryArray, visADGeometryArray};
    }

    public VisADGeometryArray makePointGeometry(byte[][] byArray) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("SampledSet.makePointGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        VisADPointArray visADPointArray = new VisADPointArray();
        this.setGeometryArray(visADPointArray, 3, byArray);
        return visADPointArray;
    }

    public void setGeometryArray(VisADGeometryArray visADGeometryArray, int n, byte[][] byArray) throws VisADException {
        SampledSet.setGeometryArray(visADGeometryArray, this.getSamples(false), n, byArray);
    }

    public static void setGeometryArray(VisADGeometryArray visADGeometryArray, float[][] fArray, int n, byte[][] byArray) throws VisADException {
        int n2;
        if (fArray == null) {
            throw new SetException("SampledSet.setGeometryArray: Null samples array");
        }
        if (fArray.length != 3) {
            throw new SetException("SampledSet.setGeometryArray: Expected 3 dimensions in samples array, not " + fArray.length);
        }
        visADGeometryArray.vertexCount = n2 = fArray[0].length;
        float[] fArray2 = new float[3 * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            fArray2[n3++] = fArray[0][n4];
            fArray2[n3++] = fArray[1][n4];
            fArray2[n3++] = fArray[2][n4];
            ++n4;
        }
        visADGeometryArray.coordinates = fArray2;
        if (byArray != null) {
            n = Math.min(n, byArray.length);
            byte[] byArray2 = new byte[n * n2];
            n3 = 0;
            if (n == 4) {
                int n5 = 0;
                while (n5 < n2) {
                    byArray2[n3++] = byArray[0][n5];
                    byArray2[n3++] = byArray[1][n5];
                    byArray2[n3++] = byArray[2][n5];
                    byArray2[n3++] = byArray[3][n5];
                    ++n5;
                }
            } else if (n == 3) {
                int n6 = 0;
                while (n6 < n2) {
                    byArray2[n3++] = byArray[0][n6];
                    byArray2[n3++] = byArray[1][n6];
                    byArray2[n3++] = byArray[2][n6];
                    ++n6;
                }
            } else {
                throw new SetException("SampledSet.setGeometryArray: color_length must be 3 or 4, not " + n);
            }
            visADGeometryArray.colors = byArray2;
        }
    }

    public float[] getLow() {
        float[] fArray = new float[this.Low.length];
        int n = 0;
        while (n < this.Low.length) {
            fArray[n] = this.Low[n];
            ++n;
        }
        return fArray;
    }

    public float[] getHi() {
        float[] fArray = new float[this.Hi.length];
        int n = 0;
        while (n < this.Hi.length) {
            fArray[n] = this.Hi[n];
            ++n;
        }
        return fArray;
    }

    public SampledSet(MathType mathType, int n) throws VisADException {
        super(mathType, n);
    }

    public SampledSet(MathType mathType, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, n, coordinateSystem, unitArray, errorEstimateArray);
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
    }

    public SampledSet(MathType mathType) throws VisADException {
        this(mathType, null, null, null);
    }

    public SampledSet(MathType mathType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, coordinateSystem, unitArray, errorEstimateArray);
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
    }
}

