/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.Control;
import visad.DisplayImpl;
import visad.ScalarMap;
import visad.UnimplementedException;
import visad.VisADException;
import visad.util.Util;

public class RendererControl
extends Control {
    private float[] backgroundColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] boxColor = new float[]{1.0f, 1.0f, 1.0f};
    private float[] cursorColor = new float[]{1.0f, 1.0f, 1.0f};
    private float[] foregroundColor = new float[]{1.0f, 1.0f, 1.0f};
    private boolean boxOn = false;

    public float[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(float f, float f2, float f3) throws RemoteException, VisADException {
        this.backgroundColor[0] = f;
        this.backgroundColor[1] = f2;
        this.backgroundColor[2] = f3;
        this.changeControl(true);
    }

    public float[] getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(float f, float f2, float f3) throws RemoteException, VisADException {
        DisplayImpl displayImpl;
        this.setCursorColor(f, f2, f3);
        this.setBoxColor(f, f2, f3);
        this.foregroundColor[0] = f;
        this.foregroundColor[1] = f2;
        this.foregroundColor[2] = f3;
        if (this.getDisplayRenderer() != null && (displayImpl = this.getDisplayRenderer().getDisplay()) != null) {
            Enumeration enumeration = this.display.getMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                if (scalarMap.getAxisScale() == null) continue;
                scalarMap.setScaleColor(this.foregroundColor);
            }
        }
    }

    public float[] getBoxColor() {
        return this.boxColor;
    }

    public boolean getBoxOn() {
        return this.boxOn;
    }

    public void setBoxColor(float f, float f2, float f3) throws RemoteException, VisADException {
        this.boxColor[0] = f;
        this.boxColor[1] = f2;
        this.boxColor[2] = f3;
        this.changeControl(true);
    }

    public void setBoxOn(boolean bl) throws RemoteException, VisADException {
        this.boxOn = bl;
        this.changeControl(true);
    }

    public float[] getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(float f, float f2, float f3) throws RemoteException, VisADException {
        this.cursorColor[0] = f;
        this.cursorColor[1] = f2;
        this.cursorColor[2] = f3;
        this.changeControl(true);
    }

    private static boolean floatArrayEquals(float[] fArray, float[] fArray2) {
        if (fArray == null) {
            if (fArray2 != null) {
                return false;
            }
        } else {
            if (fArray2 == null) {
                return false;
            }
            if (fArray.length != fArray2.length) {
                return false;
            }
            int n = 0;
            while (n < fArray.length) {
                if (!Util.isApproximatelyEqual(fArray[n], fArray2[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public String getSaveString() {
        return null;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof RendererControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        RendererControl rendererControl = (RendererControl)control;
        boolean bl = false;
        if (!RendererControl.floatArrayEquals(this.backgroundColor, rendererControl.backgroundColor)) {
            bl = true;
            this.backgroundColor = rendererControl.backgroundColor;
        }
        if (!RendererControl.floatArrayEquals(this.foregroundColor, rendererControl.foregroundColor)) {
            bl = true;
            this.foregroundColor = rendererControl.foregroundColor;
        }
        if (!RendererControl.floatArrayEquals(this.boxColor, rendererControl.boxColor)) {
            bl = true;
            this.boxColor = rendererControl.boxColor;
        }
        if (!RendererControl.floatArrayEquals(this.cursorColor, rendererControl.cursorColor)) {
            bl = true;
            this.cursorColor = rendererControl.cursorColor;
        }
        if (this.boxOn != rendererControl.boxOn) {
            bl = true;
            this.boxOn = rendererControl.boxOn;
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        RendererControl rendererControl = (RendererControl)object;
        if (!RendererControl.floatArrayEquals(this.backgroundColor, rendererControl.backgroundColor)) {
            return false;
        }
        if (!RendererControl.floatArrayEquals(this.foregroundColor, rendererControl.foregroundColor)) {
            return false;
        }
        if (!RendererControl.floatArrayEquals(this.boxColor, rendererControl.boxColor)) {
            return false;
        }
        if (!RendererControl.floatArrayEquals(this.cursorColor, rendererControl.cursorColor)) {
            return false;
        }
        return this.boxOn == rendererControl.boxOn;
    }

    public Object clone() {
        RendererControl rendererControl = (RendererControl)super.clone();
        if (this.backgroundColor != null) {
            rendererControl.backgroundColor = (float[])this.backgroundColor.clone();
        }
        if (this.foregroundColor != null) {
            rendererControl.foregroundColor = (float[])this.foregroundColor.clone();
        }
        if (this.boxColor != null) {
            rendererControl.boxColor = (float[])this.boxColor.clone();
        }
        if (this.cursorColor != null) {
            rendererControl.cursorColor = (float[])this.cursorColor.clone();
        }
        return rendererControl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RendererControl[");
        stringBuffer.append("bg=");
        stringBuffer.append(this.backgroundColor[0]);
        stringBuffer.append('/');
        stringBuffer.append(this.backgroundColor[1]);
        stringBuffer.append('/');
        stringBuffer.append(this.backgroundColor[2]);
        stringBuffer.append("fg=");
        stringBuffer.append(this.foregroundColor[0]);
        stringBuffer.append('/');
        stringBuffer.append(this.foregroundColor[1]);
        stringBuffer.append('/');
        stringBuffer.append(this.foregroundColor[2]);
        stringBuffer.append(",cursor=");
        stringBuffer.append(this.cursorColor[0]);
        stringBuffer.append('/');
        stringBuffer.append(this.cursorColor[1]);
        stringBuffer.append('/');
        stringBuffer.append(this.cursorColor[2]);
        stringBuffer.append(",box=");
        stringBuffer.append(this.boxColor[0]);
        stringBuffer.append('/');
        stringBuffer.append(this.boxColor[1]);
        stringBuffer.append('/');
        stringBuffer.append(this.boxColor[2]);
        stringBuffer.append(',');
        if (!this.boxOn) {
            stringBuffer.append('!');
        }
        stringBuffer.append("boxOn");
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public RendererControl(DisplayImpl displayImpl) {
        super(displayImpl);
    }
}

