/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.RemoteDisplay;
import visad.RemoteSlaveDisplay;
import visad.VisADException;
import visad.browser.Convert;

public class RemoteSlaveDisplayImpl
extends UnicastRemoteObject
implements RemoteSlaveDisplay,
MouseListener,
MouseMotionListener {
    private RemoteDisplay display;
    private BufferedImage image;
    private JComponent component;
    private Vector listen = new Vector();

    public void unlink() throws VisADException, RemoteException {
        this.display.removeSlave(this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void addDisplayListener(DisplayListener displayListener) {
        Vector vector = this.listen;
        synchronized (vector) {
            this.listen.add(displayListener);
        }
    }

    public void removeDisplayListener(DisplayListener displayListener) {
        Vector vector = this.listen;
        synchronized (vector) {
            this.listen.remove(displayListener);
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void sendImage(int[] nArray, int n, int n2, int n3) throws RemoteException {
        int[] nArray2 = Convert.decodeRLE(nArray);
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        bufferedImage.setRGB(0, 0, n, n2, nArray2, 0, n);
        MediaTracker mediaTracker = new MediaTracker(this.component);
        mediaTracker.addImage(this.image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.image = bufferedImage;
        this.component.repaint();
        DisplayEvent displayEvent = new DisplayEvent(this.display, 3);
        Vector vector = this.listen;
        synchronized (vector) {
            int n4 = 0;
            while (n4 < this.listen.size()) {
                DisplayListener displayListener = (DisplayListener)this.listen.elementAt(n4);
                try {
                    displayListener.displayChanged(displayEvent);
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                }
                ++n4;
            }
        }
    }

    public void sendMessage(String string) throws RemoteException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Class<?> clazz = null;
        try {
            clazz = Class.forName(stringTokenizer.nextToken());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int n = Convert.getInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.sendMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.sendMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.sendMouseEvent(mouseEvent);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        DisplayEvent displayEvent = new DisplayEvent(this.display, 1, n, n2);
        DisplayEvent displayEvent2 = null;
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            displayEvent2 = new DisplayEvent(this.display, 5, n, n2);
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            displayEvent2 = new DisplayEvent(this.display, 4, n, n2);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            displayEvent2 = new DisplayEvent(this.display, 6, n, n2);
        }
        Vector vector = this.listen;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < this.listen.size()) {
                DisplayListener displayListener = (DisplayListener)this.listen.elementAt(n3);
                try {
                    displayListener.displayChanged(displayEvent);
                    if (displayEvent2 != null) {
                        displayListener.displayChanged(displayEvent2);
                    }
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                ++n3;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.sendMouseEvent(mouseEvent);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        DisplayEvent displayEvent = new DisplayEvent(this.display, 7, n, n2);
        DisplayEvent displayEvent2 = null;
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            displayEvent2 = new DisplayEvent(this.display, 9, n, n2);
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            displayEvent2 = new DisplayEvent(this.display, 8, n, n2);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            displayEvent2 = new DisplayEvent(this.display, 10, n, n2);
        }
        Vector vector = this.listen;
        synchronized (vector) {
            int n3 = 0;
            while (n3 < this.listen.size()) {
                DisplayListener displayListener = (DisplayListener)this.listen.elementAt(n3);
                try {
                    displayListener.displayChanged(displayEvent);
                    if (displayEvent2 != null) {
                        displayListener.displayChanged(displayEvent2);
                    }
                }
                catch (VisADException visADException) {
                    visADException.printStackTrace();
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                ++n3;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.sendMouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void sendMouseEvent(MouseEvent mouseEvent) {
        try {
            this.display.sendMouseEvent(mouseEvent);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static /* synthetic */ BufferedImage access$0(RemoteSlaveDisplayImpl remoteSlaveDisplayImpl) {
        return remoteSlaveDisplayImpl.image;
    }

    public RemoteSlaveDisplayImpl(RemoteDisplay remoteDisplay) throws VisADException, RemoteException {
        this.display = remoteDisplay;
        if (this.display != null) {
            this.display.addSlave(this);
        }
        this.component = new JComponent(this){
            private final /* synthetic */ RemoteSlaveDisplayImpl this$0;

            public void paint(Graphics graphics) {
                if (RemoteSlaveDisplayImpl.access$0(this.this$0) != null) {
                    graphics.drawImage(RemoteSlaveDisplayImpl.access$0(this.this$0), 0, 0, this);
                }
            }

            public Dimension getPreferredSize() {
                if (RemoteSlaveDisplayImpl.access$0(this.this$0) == null) {
                    return new Dimension(256, 256);
                }
                return new Dimension(RemoteSlaveDisplayImpl.access$0(this.this$0).getWidth(), RemoteSlaveDisplayImpl.access$0(this.this$0).getHeight());
            }
            {
                this.this$0 = remoteSlaveDisplayImpl;
                this.constructor$0(remoteSlaveDisplayImpl);
            }

            private final void constructor$0(RemoteSlaveDisplayImpl remoteSlaveDisplayImpl) {
            }
        };
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
    }
}

