/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteVisADException;
import visad.VisADException;

public class RemoteServerImpl
extends UnicastRemoteObject
implements RemoteServer {
    private RemoteDataReferenceImpl[] refs;
    private RemoteDisplayImpl[] dpys;

    public synchronized RemoteDataReference getDataReference(int n) throws RemoteException {
        if (this.refs != null && n >= 0 && n < this.refs.length) {
            return this.refs[n];
        }
        return null;
    }

    public synchronized RemoteDataReference getDataReference(String string) throws VisADException, RemoteException {
        if (string != null && this.refs != null) {
            int n = 0;
            while (n < this.refs.length) {
                if (string.equals(this.refs[n].getName())) {
                    return this.refs[n];
                }
                ++n;
            }
        }
        return null;
    }

    public synchronized RemoteDataReference[] getDataReferences() throws RemoteException {
        if (this.refs == null || this.refs.length == 0) {
            return null;
        }
        RemoteDataReference[] remoteDataReferenceArray = new RemoteDataReference[this.refs.length];
        int n = 0;
        while (n < this.refs.length) {
            remoteDataReferenceArray[n] = this.refs[n];
            ++n;
        }
        return remoteDataReferenceArray;
    }

    public synchronized void setDataReference(int n, RemoteDataReferenceImpl remoteDataReferenceImpl) throws VisADException {
        if (n < 0) {
            throw new RemoteVisADException("RemoteServerImpl.setDataReference: negative index");
        }
        if (this.refs == null || n >= this.refs.length) {
            RemoteDataReferenceImpl[] remoteDataReferenceImplArray = new RemoteDataReferenceImpl[n + 1];
            int n2 = 0;
            while (n2 < n) {
                remoteDataReferenceImplArray[n2] = this.refs != null && n2 < this.refs.length ? this.refs[n2] : null;
                ++n2;
            }
            this.refs = remoteDataReferenceImplArray;
        }
        this.refs[n] = remoteDataReferenceImpl;
    }

    public void addDataReference(DataReferenceImpl dataReferenceImpl) throws RemoteException {
        this.addDataReference(new RemoteDataReferenceImpl(dataReferenceImpl));
    }

    public synchronized void addDataReference(RemoteDataReferenceImpl remoteDataReferenceImpl) {
        if (remoteDataReferenceImpl == null) {
            return;
        }
        int n = this.refs == null || this.refs.length == 0 ? 0 : this.refs.length;
        RemoteDataReferenceImpl[] remoteDataReferenceImplArray = new RemoteDataReferenceImpl[n + 1];
        if (n > 0) {
            System.arraycopy(this.refs, 0, remoteDataReferenceImplArray, 0, n);
        }
        remoteDataReferenceImplArray[n] = remoteDataReferenceImpl;
        this.refs = remoteDataReferenceImplArray;
    }

    public synchronized void setDataReferences(RemoteDataReferenceImpl[] remoteDataReferenceImplArray) {
        if (remoteDataReferenceImplArray == null) {
            this.refs = null;
            return;
        }
        this.refs = new RemoteDataReferenceImpl[remoteDataReferenceImplArray.length];
        int n = 0;
        while (n < this.refs.length) {
            this.refs[n] = remoteDataReferenceImplArray[n];
            ++n;
        }
    }

    public synchronized void removeDataReference(RemoteDataReferenceImpl remoteDataReferenceImpl) {
        int n = this.refs == null || this.refs.length == 0 ? 0 : this.refs.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            if (this.refs[n3] == remoteDataReferenceImpl) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 < 0) {
            return;
        }
        RemoteDataReferenceImpl[] remoteDataReferenceImplArray = new RemoteDataReferenceImpl[n - 1];
        if (n2 > 0) {
            System.arraycopy(this.refs, 0, remoteDataReferenceImplArray, 0, n2);
        }
        if (n2 < n - 1) {
            System.arraycopy(this.refs, n2 + 1, remoteDataReferenceImplArray, n2, n - n2 - 1);
        }
        this.refs = remoteDataReferenceImplArray;
    }

    public RemoteDisplay[] getDisplays() throws RemoteException {
        if (this.dpys == null || this.dpys.length == 0) {
            return null;
        }
        RemoteDisplay[] remoteDisplayArray = new RemoteDisplay[this.dpys.length];
        int n = 0;
        while (n < this.dpys.length) {
            remoteDisplayArray[n] = this.dpys[n];
            ++n;
        }
        return remoteDisplayArray;
    }

    public RemoteDisplay getDisplay(int n) {
        if (this.dpys != null && n >= 0 && n < this.dpys.length) {
            return this.dpys[n];
        }
        return null;
    }

    public RemoteDisplay getDisplay(String string) throws VisADException, RemoteException {
        if (this.dpys == null) {
            throw new RemoteException("No displays associated with this server");
        }
        int n = 0;
        while (n < this.dpys.length) {
            if (this.dpys[n] != null && this.dpys[n].getName().equals(string)) {
                return this.dpys[n];
            }
            ++n;
        }
        throw new RemoteException("Display \"" + string + "\" not found");
    }

    public void addDisplay(DisplayImpl displayImpl) throws RemoteException {
        this.addDisplay(new RemoteDisplayImpl(displayImpl));
    }

    public synchronized void addDisplay(RemoteDisplayImpl remoteDisplayImpl) {
        if (remoteDisplayImpl == null) {
            return;
        }
        int n = this.dpys == null || this.dpys.length == 0 ? 0 : this.dpys.length;
        RemoteDisplayImpl[] remoteDisplayImplArray = new RemoteDisplayImpl[n + 1];
        if (n > 0) {
            System.arraycopy(this.dpys, 0, remoteDisplayImplArray, 0, n);
        }
        remoteDisplayImplArray[n] = remoteDisplayImpl;
        this.dpys = remoteDisplayImplArray;
    }

    public synchronized void setDisplays(RemoteDisplayImpl[] remoteDisplayImplArray) {
        if (remoteDisplayImplArray == null) {
            this.dpys = null;
            return;
        }
        this.dpys = new RemoteDisplayImpl[remoteDisplayImplArray.length];
        int n = 0;
        while (n < this.dpys.length) {
            this.dpys[n] = remoteDisplayImplArray[n];
            ++n;
        }
    }

    public synchronized void removeDisplay(RemoteDisplayImpl remoteDisplayImpl) {
        int n = this.dpys == null || this.dpys.length == 0 ? 0 : this.dpys.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            if (this.dpys[n3] == remoteDisplayImpl) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 < 0) {
            return;
        }
        RemoteDisplayImpl[] remoteDisplayImplArray = new RemoteDisplayImpl[n - 1];
        if (n2 > 0) {
            System.arraycopy(this.dpys, 0, remoteDisplayImplArray, 0, n2);
        }
        if (n2 < n - 1) {
            System.arraycopy(this.dpys, n2 + 1, remoteDisplayImplArray, n2, n - n2 - 1);
        }
        this.dpys = remoteDisplayImplArray;
    }

    public RemoteServerImpl() throws RemoteException {
        this(null, null);
    }

    public RemoteServerImpl(RemoteDataReferenceImpl[] remoteDataReferenceImplArray) throws RemoteException {
        this(remoteDataReferenceImplArray, null);
    }

    public RemoteServerImpl(RemoteDisplayImpl[] remoteDisplayImplArray) throws RemoteException {
        this(null, remoteDisplayImplArray);
    }

    public RemoteServerImpl(RemoteDataReferenceImpl[] remoteDataReferenceImplArray, RemoteDisplayImpl[] remoteDisplayImplArray) throws RemoteException {
        this.refs = remoteDataReferenceImplArray;
        this.dpys = remoteDisplayImplArray;
    }
}

