/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;
import visad.ConstantMap;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteReferenceLink;
import visad.VisADException;

public class RemoteReferenceLinkImpl
extends UnicastRemoteObject
implements RemoteReferenceLink {
    DataDisplayLink link;

    public String getRendererClassName() throws VisADException, RemoteException {
        if (this.link == null) {
            return null;
        }
        DataRenderer dataRenderer = this.link.getRenderer();
        if (dataRenderer == null) {
            return null;
        }
        return dataRenderer.getClass().getName();
    }

    public RemoteDataReference getReference() throws VisADException, RemoteException {
        DataReferenceImpl dataReferenceImpl = (DataReferenceImpl)this.link.getDataReference();
        return new RemoteDataReferenceImpl(dataReferenceImpl);
    }

    public Vector getConstantMapVector() throws VisADException, RemoteException {
        return this.link.getConstantMaps();
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof RemoteReferenceLink)) {
            return false;
        }
        if (object instanceof RemoteReferenceLinkImpl) {
            RemoteReferenceLinkImpl remoteReferenceLinkImpl = (RemoteReferenceLinkImpl)object;
            bl = this.link.equals(remoteReferenceLinkImpl.link);
        } else {
            RemoteReferenceLink remoteReferenceLink = (RemoteReferenceLink)object;
            try {
                bl = this.getReference().equals(remoteReferenceLink.getReference());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.link == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append(this.link.getDataReference().getName());
            }
            stringBuffer.append(" -> ");
            stringBuffer.append(this.getRendererClassName());
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (VisADException visADException) {
            return null;
        }
        try {
            Vector vector = this.getConstantMapVector();
            Enumeration enumeration = vector.elements();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append(':');
                while (enumeration.hasMoreElements()) {
                    ConstantMap constantMap = (ConstantMap)enumeration.nextElement();
                    stringBuffer.append(" [");
                    stringBuffer.append(constantMap.getConstant());
                    stringBuffer.append(" -> ");
                    stringBuffer.append(constantMap.getDisplayScalar());
                    stringBuffer.append(']');
                }
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public RemoteReferenceLinkImpl(DataDisplayLink dataDisplayLink) throws RemoteException {
        if (dataDisplayLink == null) {
            throw new RemoteException("Cannot link to null link");
        }
        DataReference dataReference = dataDisplayLink.getDataReference();
        if (!(dataReference instanceof DataReferenceImpl)) {
            throw new RemoteException("Cannot link to non-DataReferenceImpl (" + dataReference.getClass().getName() + ")");
        }
        this.link = dataDisplayLink;
    }
}

