/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.ConstantMap;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.MessageEvent;
import visad.MouseBehavior;
import visad.MouseHelper;
import visad.ReferenceException;
import visad.RemoteActionImpl;
import visad.RemoteDataReference;
import visad.RemoteDisplay;
import visad.RemoteReferenceLinkImpl;
import visad.RemoteSlaveDisplay;
import visad.RemoteVisADException;
import visad.ScalarMap;
import visad.ThingReference;
import visad.VisADException;
import visad.collab.DisplayMonitor;
import visad.collab.DisplayMonitorImpl;
import visad.collab.DisplaySync;
import visad.collab.DisplaySyncImpl;
import visad.collab.RemoteDisplayMonitor;
import visad.collab.RemoteDisplayMonitorImpl;
import visad.collab.RemoteDisplaySync;
import visad.collab.RemoteDisplaySyncImpl;

public class RemoteDisplayImpl
extends RemoteActionImpl
implements RemoteDisplay {
    public void addSlave(RemoteSlaveDisplay remoteSlaveDisplay) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.addSlave(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.addSlave(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl displayImpl = (DisplayImpl)this.AdaptedAction;
        ((DisplayImpl)this.AdaptedAction).addSlave(remoteSlaveDisplay);
    }

    public void removeSlave(RemoteSlaveDisplay remoteSlaveDisplay) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.removeSlave(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.removeSlave(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl displayImpl = (DisplayImpl)this.AdaptedAction;
        displayImpl.removeSlave(remoteSlaveDisplay);
    }

    public void removeAllSlaves() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.removeAllSlaves(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.removeAllSlaves(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl displayImpl = (DisplayImpl)this.AdaptedAction;
        displayImpl.removeAllSlaves();
    }

    public boolean hasSlaves() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.hasSlaves(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.removeAllSlaves(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl displayImpl = (DisplayImpl)this.AdaptedAction;
        return displayImpl.hasSlaves();
    }

    public void sendMouseEvent(MouseEvent mouseEvent) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): AdaptedAction is null");
        }
        if (!(this.AdaptedAction instanceof DisplayImpl)) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): AdaptedAction must be DisplayImpl");
        }
        DisplayImpl displayImpl = (DisplayImpl)this.AdaptedAction;
        MouseBehavior mouseBehavior = displayImpl.getMouseBehavior();
        if (mouseBehavior == null) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): MouseBehavior is null");
        }
        MouseHelper mouseHelper = mouseBehavior.getMouseHelper();
        if (mouseHelper == null) {
            throw new VisADException("RemoteDisplayImpl.sendMouseEvent(): MouseHelper is null");
        }
        Component component = displayImpl.getComponent();
        int n = mouseEvent.getID();
        long l = mouseEvent.getWhen();
        int n2 = mouseEvent.getModifiers();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = mouseEvent.getClickCount();
        boolean bl = mouseEvent.isPopupTrigger();
        MouseEvent mouseEvent2 = new MouseEvent(component, n, l, n2, n3, n4, n5, bl);
        mouseHelper.processEvent(mouseEvent2, -1);
    }

    public void addReference(ThingReference thingReference) throws VisADException, RemoteException {
        if (!(thingReference instanceof DataReference)) {
            throw new ReferenceException("RemoteDisplayImpl.addReference: ref must be DataReference");
        }
        this.addReference((DataReference)thingReference, null);
    }

    public void addReference(DataReference dataReference, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        if (!(dataReference instanceof RemoteDataReference)) {
            throw new RemoteVisADException("RemoteDisplayImpl.addReference: requires RemoteDataReference");
        }
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.addReference: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).adaptedAddReference((RemoteDataReference)dataReference, this, constantMapArray);
    }

    public void addReferences(DataRenderer dataRenderer, DataReference dataReference) throws VisADException, RemoteException {
        this.addReferences(dataRenderer, new DataReference[]{dataReference}, null);
    }

    public void addReferences(DataRenderer dataRenderer, DataReference dataReference, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        this.addReferences(dataRenderer, new DataReference[]{dataReference}, new ConstantMap[][]{constantMapArray});
    }

    public void addReferences(DataRenderer dataRenderer, DataReference[] dataReferenceArray) throws VisADException, RemoteException {
        this.addReferences(dataRenderer, dataReferenceArray, null);
    }

    public void addReferences(DataRenderer dataRenderer, DataReference[] dataReferenceArray, ConstantMap[][] constantMapArray) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.addReferences: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).adaptedAddReferences(dataRenderer, dataReferenceArray, this, constantMapArray);
    }

    public void removeReference(ThingReference thingReference) throws VisADException, RemoteException {
        if (!(thingReference instanceof DataReference)) {
            throw new ReferenceException("RemoteDisplayImpl.addReference: ref must be DataReference");
        }
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.removeReference: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).adaptedDisplayRemoveReference((DataReference)thingReference);
    }

    public void addMap(ScalarMap scalarMap) throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.addMap: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).addMap(scalarMap);
    }

    public void clearMaps() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.clearMaps: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).clearMaps();
    }

    public void destroy() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException("RemoteDisplayImpl.destroy: AdaptedAction is null");
        }
        ((DisplayImpl)this.AdaptedAction).destroy();
    }

    public String getDisplayClassName() throws RemoteException {
        return this.AdaptedAction.getClass().getName();
    }

    public int getDisplayAPI() throws RemoteException, VisADException {
        return ((DisplayImpl)this.AdaptedAction).getAPI();
    }

    public String getDisplayRendererClassName() throws RemoteException {
        DisplayRenderer displayRenderer = ((DisplayImpl)this.AdaptedAction).getDisplayRenderer();
        return displayRenderer.getClass().getName();
    }

    public Vector getMapVector() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException(this.getClass().getName() + ".getMapVector: " + "AdaptedAction is null");
        }
        return ((DisplayImpl)this.AdaptedAction).getMapVector();
    }

    public Vector getConstantMapVector() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException(this.getClass().getName() + ".getConstantMapVector: " + "AdaptedAction is null");
        }
        return ((DisplayImpl)this.AdaptedAction).getConstantMapVector();
    }

    public GraphicsModeControl getGraphicsModeControl() throws VisADException, RemoteException {
        if (this.AdaptedAction == null) {
            throw new RemoteVisADException(this.getClass().getName() + ".getGraphicsModeControl: " + "AdaptedAction is null");
        }
        return ((DisplayImpl)this.AdaptedAction).getGraphicsModeControl();
    }

    public Vector getReferenceLinks() throws VisADException, RemoteException {
        Vector<RemoteReferenceLinkImpl> vector = new Vector<RemoteReferenceLinkImpl>();
        Vector vector2 = ((DisplayImpl)this.AdaptedAction).getRenderers();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            DataRenderer dataRenderer = (DataRenderer)enumeration.nextElement();
            DataDisplayLink[] dataDisplayLinkArray = dataRenderer.getLinks();
            if (dataDisplayLinkArray == null) continue;
            int n = 0;
            while (n < dataDisplayLinkArray.length) {
                try {
                    vector.addElement(new RemoteReferenceLinkImpl(dataDisplayLinkArray[n]));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return vector;
    }

    public RemoteDisplayMonitor getRemoteDisplayMonitor() throws RemoteException {
        DisplayMonitor displayMonitor = ((DisplayImpl)this.AdaptedAction).getDisplayMonitor();
        return new RemoteDisplayMonitorImpl((DisplayMonitorImpl)displayMonitor);
    }

    public DisplaySync getDisplaySync() throws RemoteException {
        return ((DisplayImpl)this.AdaptedAction).getDisplaySync();
    }

    public RemoteDisplaySync getRemoteDisplaySync() throws RemoteException {
        DisplaySync displaySync = ((DisplayImpl)this.AdaptedAction).getDisplaySync();
        return new RemoteDisplaySyncImpl((DisplaySyncImpl)displaySync);
    }

    public void sendMessage(MessageEvent messageEvent) throws RemoteException {
        ((DisplayImpl)this.AdaptedAction).sendMessage(messageEvent);
    }

    public RemoteDisplayImpl(DisplayImpl displayImpl) throws RemoteException {
        super(displayImpl);
    }
}

