/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CommonUnit;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.SI;
import visad.ScalarType;
import visad.Set;
import visad.SetException;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class RealType
extends ScalarType {
    public static final int INTERVAL = 1;
    private static int count;
    public static final RealType XAxis;
    public static final RealType YAxis;
    public static final RealType ZAxis;
    public static final RealType Latitude;
    public static final RealType Longitude;
    public static final RealType Altitude;
    public static final RealType Radius;
    public static final RealType TimeInterval;
    public static final RealType Time;
    public static final RealType Declination;
    public static final RealType RightAscension;
    public static final RealType Generic;
    private Unit DefaultUnit;
    private Set DefaultSet;
    private boolean DefaultSetEverAccessed;
    private final int attrMask;

    public final int getAttributeMask() {
        return this.attrMask;
    }

    public final boolean isInterval() {
        return RealType.isSet(this.getAttributeMask(), 1);
    }

    private static boolean isSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public Unit getDefaultUnit() {
        return this.DefaultUnit;
    }

    public synchronized Set getDefaultSet() {
        this.DefaultSetEverAccessed = true;
        return this.DefaultSet;
    }

    public synchronized void setDefaultSet(Set set) throws VisADException {
        Unit[] unitArray;
        if (set.getDimension() != 1) {
            throw new SetException("RealType.setDefaultSet: default set dimension != 1");
        }
        if (this.DefaultSetEverAccessed) {
            throw new TypeException("RealType: DefaultSet already accessed so cannot change");
        }
        this.DefaultSet = set;
        if (this.DefaultUnit != null && this.DefaultSet != null && !Unit.canConvertArray(unitArray = new Unit[]{this.DefaultUnit}, this.DefaultSet.getSetUnits())) {
            throw new UnitException("RealType: default Unit must be convertable with Set default Unit");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof RealType)) {
            return false;
        }
        if (!this.Name.equals(((RealType)object).Name)) {
            return false;
        }
        if (this.DefaultUnit == null ? ((RealType)object).DefaultUnit != null : !Unit.canConvert(this.DefaultUnit, ((RealType)object).DefaultUnit)) {
            return false;
        }
        if (this.DefaultSet == null ? ((RealType)object).DefaultSet != null : !this.DefaultSet.equals(((RealType)object).DefaultSet)) {
            return false;
        }
        return this.attrMask == ((RealType)object).attrMask;
    }

    public boolean equalsExceptName(MathType mathType) {
        if (mathType instanceof RealTupleType) {
            try {
                return ((RealTupleType)mathType).getDimension() == 1 && ((RealTupleType)mathType).getComponent(0) instanceof RealType;
            }
            catch (VisADException visADException) {
                return false;
            }
        }
        return mathType instanceof RealType;
    }

    public boolean equalsExceptNameButUnits(MathType mathType) {
        try {
            if (mathType instanceof RealTupleType && ((RealTupleType)mathType).getDimension() == 1 && ((RealTupleType)mathType).getComponent(0) instanceof RealType) {
                RealType realType = (RealType)((RealTupleType)mathType).getComponent(0);
                return Unit.canConvert(this.getDefaultUnit(), realType.getDefaultUnit());
            }
        }
        catch (VisADException visADException) {
            return false;
        }
        if (!(mathType instanceof RealType)) {
            return false;
        }
        return Unit.canConvert(this.getDefaultUnit(), ((RealType)mathType).getDefaultUnit());
    }

    public MathType cloneDerivative(RealType realType) throws VisADException {
        String string = "d_" + this.getName() + "_" + "d_" + realType.getName();
        RealType realType2 = null;
        Unit unit = this.DefaultUnit;
        Unit unit2 = realType.getDefaultUnit();
        Unit unit3 = null;
        if (unit != null && unit2 != null) {
            unit3 = unit.divide(unit2);
        }
        realType2 = RealType.getRealType(string, unit3);
        return realType2;
    }

    public MathType binary(MathType mathType, int n, Vector vector) throws VisADException {
        MathType mathType2;
        block45: {
            block44: {
                if (mathType == null) {
                    throw new TypeException("TupleType.binary: type may not be null");
                }
                Unit unit = null;
                mathType2 = null;
                if (!(mathType instanceof RealType)) break block44;
                RealType realType = (RealType)mathType;
                Unit unit2 = ((RealType)mathType).getDefaultUnit();
                Unit unit3 = this.DefaultUnit;
                int n2 = 0;
                switch (n) {
                    case 2: 
                    case 3: {
                        if (this.isInterval() == realType.isInterval()) break;
                        n2 |= 1;
                        break;
                    }
                    case 1: 
                    case 9: 
                    case 10: {
                        if (!this.isInterval() || !realType.isInterval()) break;
                        n2 |= 1;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 15: 
                    case 16: {
                        if (this.isInterval() == realType.isInterval()) break;
                        n2 |= 1;
                        break;
                    }
                    case 7: {
                        n2 = this.getAttributeMask();
                        break;
                    }
                    case 8: {
                        n2 = realType.getAttributeMask();
                        break;
                    }
                }
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        String string;
                        if (unit3 == null) {
                            unit = null;
                            string = this.Name;
                        } else if (unit2 == null) {
                            unit = null;
                            string = realType.Name;
                        } else if (unit3.equals(CommonUnit.promiscuous)) {
                            unit = realType.DefaultUnit.getAbsoluteUnit();
                            string = realType.Name;
                        } else if (unit2.equals(CommonUnit.promiscuous) || Unit.canConvert(unit3, unit2)) {
                            unit = unit3.getAbsoluteUnit();
                            string = this.Name;
                        } else {
                            throw new UnitException();
                        }
                        mathType2 = RealType.getRealType(string, unit, n2);
                        if (mathType2 == null) {
                            mathType2 = RealType.getRealType(RealType.newName(), unit, n2);
                            break;
                        }
                        break block45;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        if (unit2 == null || unit3 == null) {
                            if (unit3 == null) {
                                mathType2 = this;
                                break;
                            }
                            if (unit2 == null) {
                                unit = null;
                            }
                        } else {
                            switch (n) {
                                case 4: {
                                    unit = unit3.multiply(unit2);
                                    break;
                                }
                                case 5: {
                                    unit = unit3.divide(unit2);
                                    break;
                                }
                                case 6: {
                                    unit = unit2.divide(unit3);
                                    break;
                                }
                            }
                        }
                        String string = RealType.newName();
                        mathType2 = RealType.getRealType(string, unit, n2);
                        break;
                    }
                    case 7: {
                        if (unit3 == null) {
                            mathType2 = this;
                            break;
                        }
                        unit = Unit.canConvert(CommonUnit.dimensionless, unit3) ? CommonUnit.dimensionless : null;
                        String string = RealType.newName();
                        mathType2 = RealType.getRealType(string, unit, n2);
                        break;
                    }
                    case 8: {
                        if (unit3 == null) {
                            mathType2 = this;
                            break;
                        }
                        unit = null;
                        String string = RealType.newName();
                        mathType2 = RealType.getRealType(string, unit, n2);
                        break;
                    }
                    case 11: {
                        unit = CommonUnit.radian;
                    }
                    case 13: {
                        unit = CommonUnit.radian;
                        String string = RealType.newName();
                        mathType2 = RealType.getRealType(string, unit, n2);
                        break;
                    }
                    case 12: {
                        unit = CommonUnit.degree;
                    }
                    case 14: {
                        unit = CommonUnit.degree;
                        String string = RealType.newName();
                        mathType2 = RealType.getRealType(string, unit, n2);
                        break;
                    }
                    case 15: {
                        mathType2 = this;
                        break;
                    }
                    case 16: {
                        if (unit3 == null) {
                            mathType2 = this;
                            break;
                        }
                        mathType2 = mathType;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("RealType.binary: illegal operation");
                    }
                }
                break block45;
            }
            if (mathType instanceof TextType) {
                throw new TypeException("RealType.binary: types don't match");
            }
            if (mathType instanceof TupleType) {
                return mathType.binary(this, DataImpl.invertOp(n), vector);
            }
            if (mathType instanceof FunctionType) {
                return mathType.binary(this, DataImpl.invertOp(n), vector);
            }
        }
        return mathType2;
    }

    private static String newName() {
        return "RealType_" + Integer.toString(++count);
    }

    private static String newName(String string, int n) {
        String string2 = "Interval";
        return !RealType.isSet(n, 1) || string.endsWith(string2) ? string : string + string2;
    }

    public MathType unary(int n, Vector vector) throws VisADException {
        RealType realType;
        int n2;
        switch (n) {
            case 21: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 41: 
            case 42: {
                n2 = this.getAttributeMask();
                break;
            }
            default: {
                n2 = 0;
            }
        }
        String string = RealType.newName(this.getName(), n2);
        switch (n) {
            case 21: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 41: 
            case 42: {
                realType = this;
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                Unit unit = CommonUnit.radian;
                string = RealType.getUniqueGenericName(vector, unit.toString());
                realType = RealType.getRealType(string, unit, n2);
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                Unit unit = CommonUnit.degree;
                string = RealType.getUniqueGenericName(vector, "deg");
                realType = RealType.getRealType(string, unit, n2);
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                if (this.DefaultUnit == null) {
                    realType = this;
                    break;
                }
                Unit unit = Unit.canConvert(CommonUnit.dimensionless, this.DefaultUnit) ? CommonUnit.dimensionless : null;
                String string2 = unit == null ? "nullUnit" : unit.toString();
                string = RealType.getUniqueGenericName(vector, string2);
                realType = RealType.getRealType(string, unit, n2);
                break;
            }
            case 38: {
                if (this.DefaultUnit == null) {
                    realType = this;
                    break;
                }
                Unit unit = Unit.canConvert(CommonUnit.dimensionless, this.DefaultUnit) ? CommonUnit.dimensionless : this.DefaultUnit.sqrt();
                String string3 = unit == null ? "nullUnit" : unit.toString();
                string = RealType.getUniqueGenericName(vector, string3);
                realType = RealType.getRealType(string, unit, n2);
                break;
            }
            default: {
                throw new ArithmeticException("RealType.unary: illegal operation");
            }
        }
        return realType;
    }

    private static String getUniqueGenericName(Vector vector, String string) {
        String string2 = null;
        if (string.indexOf(".") > -1) {
            string = string.replace('.', '_');
        }
        if (string.indexOf(" ") > -1) {
            string = string.replace(' ', '_');
        }
        if (string.indexOf("(") > -1) {
            string = string.replace('(', '_');
        }
        if (string.indexOf(")") > -1) {
            string = string.replace(')', '_');
        }
        int n = 1;
        while (true) {
            if (!vector.contains(string2 = "Generic_" + n + "_" + string)) break;
            ++n;
        }
        vector.addElement(string2);
        return string2;
    }

    public Data missingData() throws VisADException {
        return new Real(this);
    }

    public static final RealType getRealType(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        RealType realType = RealType.getRealTypeByName(string);
        if (realType == null) {
            try {
                realType = new RealType(string);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return realType;
    }

    public static final RealType getRealType(String string, Unit unit) {
        if (string == null) {
            throw new NullPointerException();
        }
        RealType realType = RealType.getRealTypeByName(string);
        if (realType != null) {
            if (!Unit.canConvert(unit, realType.DefaultUnit)) {
                realType = null;
            }
        } else {
            try {
                realType = new RealType(string, unit);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return realType;
    }

    public static RealType getRealType(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        RealType realType = RealType.getRealTypeByName(string);
        if (realType != null) {
            if (n != realType.attrMask) {
                realType = null;
            }
        } else {
            try {
                realType = new RealType(string, n);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return realType;
    }

    public static RealType getRealType(String string, Unit unit, Set set) {
        RealType realType;
        block7: {
            block5: {
                block6: {
                    if (string == null) {
                        throw new NullPointerException();
                    }
                    realType = RealType.getRealTypeByName(string);
                    if (realType == null) break block5;
                    if (!Unit.canConvert(unit, realType.DefaultUnit)) break block6;
                    boolean bl = set == null ? realType.DefaultSet != null : !set.equals(realType.DefaultSet);
                    if (!bl) break block7;
                }
                realType = null;
                break block7;
            }
            try {
                realType = new RealType(string, unit, set);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return realType;
    }

    public static final RealType getRealType(String string, Unit unit, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        RealType realType = RealType.getRealTypeByName(string);
        if (realType != null) {
            if (!Unit.canConvert(unit, realType.DefaultUnit) || realType.attrMask != n) {
                realType = null;
            }
        } else {
            try {
                realType = new RealType(string, unit, null, n);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return realType;
    }

    public static final RealType getRealType(String string, Unit unit, Set set, int n) {
        RealType realType;
        block7: {
            block5: {
                block6: {
                    if (string == null) {
                        throw new NullPointerException();
                    }
                    realType = RealType.getRealTypeByName(string);
                    if (realType == null) break block5;
                    if (!Unit.canConvert(unit, realType.DefaultUnit)) break block6;
                    boolean bl = set == null ? realType.DefaultSet != null : !set.equals(realType.DefaultSet);
                    if (!bl && realType.attrMask == n) break block7;
                }
                realType = null;
                break block7;
            }
            try {
                realType = new RealType(string, unit, set, n);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return realType;
    }

    public static RealType getRealTypeByName(String string) {
        ScalarType scalarType = ScalarType.getScalarTypeByName(string);
        if (!(scalarType instanceof RealType)) {
            return null;
        }
        return (RealType)scalarType;
    }

    public ShadowType buildShadowType(DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return dataDisplayLink.getRenderer().makeShadowRealType(this, dataDisplayLink, shadowType);
    }

    public String prettyString(int n) {
        return this.getName();
    }

    public static void main(String[] stringArray) throws VisADException {
        RealType realType = new RealType("Red_Brightness", null, null);
        RealType realType2 = new RealType("Green_Brightness", null, null);
        RealType realType3 = new RealType("Blue_Brightness", null, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2, realType3};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        MathType mathType = realTupleType.unary(29, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.unary(30, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.unary(21, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.unary(22, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.unary(23, new Vector());
        System.out.println(mathType.toString());
        RealType realType4 = new RealType("distance", (Unit)SI.meter, null);
        mathType = realType4.unary(31, new Vector());
        System.out.println(mathType.toString());
        realType4 = Generic;
        mathType = realTupleType.binary(realType4, 1, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.binary(realType4, 4, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.binary(realType4, 7, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.binary(realType4, 11, new Vector());
        System.out.println(mathType.toString());
        mathType = realTupleType.binary(realType4, 12, new Vector());
        System.out.println(mathType.toString());
        System.out.println("force a TypeException:");
        RealType realType5 = new RealType("a.b");
    }

    public RealType(String string) throws VisADException {
        this(string, 0);
    }

    public RealType(String string, int n) throws VisADException {
        this(string, null, null, n);
    }

    public RealType(String string, Unit unit, Set set) throws VisADException {
        this(string, unit, set, 0);
    }

    public RealType(String string, Unit unit) throws VisADException {
        this(string, unit, null, 0);
    }

    public RealType(String string, Unit unit, Set set, int n) throws VisADException {
        super(string);
        Unit[] unitArray;
        if (set != null && set.getDimension() != 1) {
            throw new SetException("RealType: default set dimension != 1");
        }
        this.DefaultUnit = unit != null && RealType.isSet(n, 1) ? unit.getAbsoluteUnit() : unit;
        this.DefaultSet = set;
        this.DefaultSetEverAccessed = false;
        if (this.DefaultUnit != null && this.DefaultSet != null && !Unit.canConvertArray(unitArray = new Unit[]{this.DefaultUnit}, this.DefaultSet.getSetUnits())) {
            throw new UnitException("RealType: default Unit must be convertable with Set default Unit");
        }
        this.attrMask = n;
    }

    protected RealType(String string, Unit unit, boolean bl) {
        this(string, unit, 0, bl);
    }

    protected RealType(String string, Unit unit, int n, boolean bl) {
        super(string, bl);
        this.DefaultUnit = unit != null && RealType.isSet(n, 1) ? unit.getAbsoluteUnit() : unit;
        this.DefaultSet = null;
        this.DefaultSetEverAccessed = false;
        this.attrMask = n;
    }

    static {
        XAxis = new RealType("XAxis", null, true);
        YAxis = new RealType("YAxis", null, true);
        ZAxis = new RealType("ZAxis", null, true);
        Latitude = new RealType("Latitude", CommonUnit.degree, true);
        Longitude = new RealType("Longitude", CommonUnit.degree, true);
        Altitude = new RealType("Altitude", CommonUnit.meter, true);
        Radius = new RealType("Radius", null, true);
        TimeInterval = new RealType("TimeInterval", CommonUnit.second, 1, true);
        Time = new RealType("Time", CommonUnit.secondsSinceTheEpoch, true);
        Declination = new RealType("Declination", CommonUnit.degree, true);
        RightAscension = new RealType("RightAscension", CommonUnit.degree, true);
        Generic = new RealType("GENERIC_REAL", CommonUnit.promiscuous, true);
    }
}

