/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.ShadowType;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class RealTupleType
extends TupleType {
    private static RealType[] components2c = new RealType[]{RealType.XAxis, RealType.YAxis};
    public static final RealTupleType SpatialCartesian2DTuple = new RealTupleType(components2c, true);
    private static RealType[] components3c = new RealType[]{RealType.XAxis, RealType.YAxis, RealType.ZAxis};
    public static final RealTupleType SpatialCartesian3DTuple = new RealTupleType(components3c, true);
    private static RealType[] components2e = new RealType[]{RealType.Longitude, RealType.Latitude};
    public static final RealTupleType SpatialEarth2DTuple = new RealTupleType(components2e, true);
    private static RealType[] componentsll = new RealType[]{RealType.Latitude, RealType.Longitude};
    public static final RealTupleType LatitudeLongitudeTuple = new RealTupleType(componentsll, true);
    private static RealType[] components3e = new RealType[]{RealType.Longitude, RealType.Latitude, RealType.Altitude};
    public static final RealTupleType SpatialEarth3DTuple = new RealTupleType(components3e, true);
    private static RealType[] componentslla = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Altitude};
    public static final RealTupleType LatitudeLongitudeAltitude = new RealTupleType(componentslla, true);
    private static RealType[] components1t = new RealType[]{RealType.Time};
    public static final RealTupleType Time1DTuple = new RealTupleType(components1t, true);
    private static RealType[] components2g = new RealType[]{RealType.Generic, RealType.Generic};
    public static final RealTupleType Generic2D = new RealTupleType(components2g, true);
    private static RealType[] components3g = new RealType[]{RealType.Generic, RealType.Generic, RealType.Generic};
    public static final RealTupleType Generic3D = new RealTupleType(components3g, true);
    private CoordinateSystem DefaultCoordinateSystem;
    private Unit[] DefaultUnits;
    private Set DefaultSet;
    private boolean DefaultSetEverAccessed;

    public MathType binary(MathType mathType, int n, Vector vector) throws TypeException, VisADException {
        if (mathType == null) {
            throw new TypeException("RealTupleType.binary: type may not be null");
        }
        if (mathType instanceof RealTupleType) {
            int n2 = this.getDimension();
            RealType[] realTypeArray = new RealType[n2];
            int n3 = 0;
            while (n3 < n2) {
                RealType realType = (RealType)((RealTupleType)mathType).getComponent(n3);
                realTypeArray[n3] = (RealType)this.getComponent(n3).binary(realType, n, vector);
                ++n3;
            }
            return new RealTupleType(realTypeArray);
        }
        if (mathType instanceof RealType) {
            int n4 = this.getDimension();
            RealType[] realTypeArray = new RealType[n4];
            int n5 = 0;
            while (n5 < n4) {
                realTypeArray[n5] = (RealType)this.getComponent(n5).binary(mathType, n, vector);
                ++n5;
            }
            return new RealTupleType(realTypeArray);
        }
        if (mathType instanceof FunctionType && ((FunctionType)mathType).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)mathType).getDomain(), ((FunctionType)mathType).getRange().binary(this, DataImpl.invertOp(n), vector));
        }
        throw new TypeException("RealTupleType.binary: types don't match");
    }

    public MathType unary(int n, Vector vector) throws VisADException {
        int n2 = this.getDimension();
        RealType[] realTypeArray = new RealType[n2];
        int n3 = 0;
        while (n3 < n2) {
            realTypeArray[n3] = (RealType)this.getComponent(n3).unary(n, vector);
            ++n3;
        }
        return new RealTupleType(realTypeArray, this.DefaultCoordinateSystem, null);
    }

    public static RealType[] makeArray(RealType realType) {
        RealType[] realTypeArray = new RealType[]{realType};
        return realTypeArray;
    }

    public static RealType[] makeArray(RealType realType, RealType realType2) {
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        return realTypeArray;
    }

    public static RealType[] makeArray(RealType realType, RealType realType2, RealType realType3) {
        RealType[] realTypeArray = new RealType[]{realType, realType2, realType3};
        return realTypeArray;
    }

    public static RealType[] makeArray(RealType realType, RealType realType2, RealType realType3, RealType realType4) {
        RealType[] realTypeArray = new RealType[]{realType, realType2, realType3, realType4};
        return realTypeArray;
    }

    private void setDefaultUnits(RealType[] realTypeArray) {
        int n = realTypeArray.length;
        this.DefaultUnits = new Unit[n];
        int n2 = 0;
        while (n2 < n) {
            this.DefaultUnits[n2] = realTypeArray[n2].getDefaultUnit();
            ++n2;
        }
    }

    public Unit[] getDefaultUnits() {
        return Unit.copyUnitsArray(this.DefaultUnits);
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.DefaultCoordinateSystem;
    }

    public synchronized void setDefaultSet(Set set) throws VisADException {
        if (set.getDimension() != this.getDimension()) {
            throw new SetException("RealTupleType.setDefaultSet: dimensions don't match");
        }
        if (this.DefaultSetEverAccessed) {
            throw new TypeException("RealTupleType: DefaultSet already accessed so cannot change");
        }
        this.DefaultSet = set;
        if (this.DefaultSet != null && !Unit.canConvertArray(this.DefaultSet.getSetUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: default Set Units must be convertable with default Units");
        }
        if (this.DefaultCoordinateSystem != null && this.DefaultSet != null) {
            CoordinateSystem coordinateSystem = this.DefaultSet.getCoordinateSystem();
            if (coordinateSystem != null && !coordinateSystem.getReference().equals(this.DefaultCoordinateSystem.getReference())) {
                throw new CoordinateSystemException("RealTupleType: Default coordinate system " + this.DefaultCoordinateSystem.getReference() + " must match" + " default set CoordinateSystem " + (coordinateSystem == null ? null : coordinateSystem.getReference()));
            }
            if (!Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultSet.getSetUnits())) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Set Units");
            }
        }
    }

    public synchronized Set getDefaultSet() {
        this.DefaultSetEverAccessed = true;
        return this.DefaultSet;
    }

    public boolean equalsExceptName(MathType mathType) {
        int n = this.getDimension();
        try {
            if (mathType instanceof RealType) {
                return n == 1 && this.getComponent(0) instanceof RealType;
            }
            if (!(mathType instanceof RealTupleType)) {
                return false;
            }
            if (n != ((TupleType)mathType).getDimension()) {
                return false;
            }
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                bl = bl && this.getComponent(n2).equalsExceptName(((TupleType)mathType).getComponent(n2));
                ++n2;
            }
            return bl;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public boolean equalsExceptNameButUnits(MathType mathType) {
        int n = this.getDimension();
        try {
            if (mathType instanceof RealType) {
                return mathType.equalsExceptNameButUnits(this);
            }
            if (!(mathType instanceof RealTupleType)) {
                return false;
            }
            if (n != ((RealTupleType)mathType).getDimension()) {
                return false;
            }
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                bl = bl && this.getComponent(n2).equalsExceptNameButUnits(((RealTupleType)mathType).getComponent(n2));
                ++n2;
            }
            return bl;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public String prettyString(int n) {
        try {
            if (this.getDimension() == 1) {
                return ((RealType)this.getComponent(0)).toString();
            }
        }
        catch (VisADException visADException) {
            return super.prettyString(0);
        }
        return super.prettyString(0);
    }

    public Data missingData() {
        return new RealTuple(this);
    }

    public ShadowType buildShadowType(DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return dataDisplayLink.getRenderer().makeShadowRealTupleType(this, dataDisplayLink, shadowType);
    }

    public RealTupleType(RealType[] realTypeArray) throws VisADException {
        this(realTypeArray, null, null);
    }

    public RealTupleType(RealType realType) throws VisADException {
        this(RealTupleType.makeArray(realType), null, null);
    }

    public RealTupleType(RealType realType, RealType realType2) throws VisADException {
        this(RealTupleType.makeArray(realType, realType2), null, null);
    }

    public RealTupleType(RealType realType, RealType realType2, RealType realType3) throws VisADException {
        this(RealTupleType.makeArray(realType, realType2, realType3), null, null);
    }

    public RealTupleType(RealType realType, RealType realType2, RealType realType3, RealType realType4) throws VisADException {
        this(RealTupleType.makeArray(realType, realType2, realType3, realType4), null, null);
    }

    public RealTupleType(RealType[] realTypeArray, CoordinateSystem coordinateSystem, Set set) throws VisADException {
        super(realTypeArray);
        if (coordinateSystem != null && realTypeArray.length != coordinateSystem.getDimension()) {
            throw new CoordinateSystemException("RealTupleType: bad CoordinateSystem dimension");
        }
        this.DefaultCoordinateSystem = coordinateSystem;
        this.DefaultSet = set;
        this.DefaultSetEverAccessed = false;
        this.setDefaultUnits(realTypeArray);
        if (this.DefaultCoordinateSystem != null && !Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Units");
        }
        if (this.DefaultSet != null && !Unit.canConvertArray(this.DefaultSet.getSetUnits(), this.DefaultUnits)) {
            throw new UnitException("RealTupleType: default Set Units must be convertable with default Units");
        }
        if (this.DefaultCoordinateSystem != null && this.DefaultSet != null) {
            CoordinateSystem coordinateSystem2 = this.DefaultSet.getCoordinateSystem();
            if (coordinateSystem2 != null && !coordinateSystem2.getReference().equals(this.DefaultCoordinateSystem.getReference())) {
                throw new CoordinateSystemException("RealTupleType: Default coordinate system " + (coordinateSystem == null ? null : coordinateSystem.getReference()) + " must match" + " default set CoordinateSystem " + (coordinateSystem2 == null ? null : coordinateSystem2.getReference()));
            }
            if (!Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultSet.getSetUnits())) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must be convertable with default Set Units");
            }
        }
    }

    public RealTupleType(RealType realType, CoordinateSystem coordinateSystem, Set set) throws VisADException {
        this(RealTupleType.makeArray(realType), coordinateSystem, set);
    }

    public RealTupleType(RealType realType, RealType realType2, CoordinateSystem coordinateSystem, Set set) throws VisADException {
        this(RealTupleType.makeArray(realType, realType2), coordinateSystem, set);
    }

    public RealTupleType(RealType realType, RealType realType2, RealType realType3, CoordinateSystem coordinateSystem, Set set) throws VisADException {
        this(RealTupleType.makeArray(realType, realType2, realType3), coordinateSystem, set);
    }

    public RealTupleType(RealType realType, RealType realType2, RealType realType3, RealType realType4, CoordinateSystem coordinateSystem, Set set) throws VisADException {
        this(RealTupleType.makeArray(realType, realType2, realType3, realType4), coordinateSystem, set);
    }

    RealTupleType(RealType[] realTypeArray, boolean bl) {
        this(realTypeArray, null, bl);
    }

    RealTupleType(RealType[] realTypeArray, CoordinateSystem coordinateSystem, boolean bl) {
        super(realTypeArray, bl);
        this.DefaultCoordinateSystem = coordinateSystem;
        this.DefaultSet = null;
        this.DefaultSetEverAccessed = false;
        this.setDefaultUnits(realTypeArray);
        if (this.DefaultCoordinateSystem != null && !Unit.canConvertArray(this.DefaultCoordinateSystem.getCoordinateSystemUnits(), this.DefaultUnits)) {
            throw new VisADError("RealTupleType (trusted): CoordinateSystem Units must be convertable with default Units");
        }
    }
}

