/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.ErrorEstimate;
import visad.Field;
import visad.MathType;
import visad.Real;
import visad.RealTupleIface;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowRealTupleType;
import visad.ShadowType;
import visad.Tuple;
import visad.TupleIface;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class RealTuple
extends Tuple
implements RealTupleIface {
    private CoordinateSystem TupleCoordinateSystem;
    private Unit[] TupleUnits;

    private void init_coord_sys(CoordinateSystem coordinateSystem) throws VisADException {
        CoordinateSystem coordinateSystem2 = ((RealTupleType)this.Type).getCoordinateSystem();
        if (coordinateSystem == null) {
            this.TupleCoordinateSystem = coordinateSystem2;
        } else {
            if (coordinateSystem2 == null || !coordinateSystem2.getReference().equals(coordinateSystem.getReference())) {
                throw new CoordinateSystemException("RealTuple: coord_sys " + coordinateSystem.getReference() + " must match" + " Type.DefaultCoordinateSystem " + (coordinateSystem2 == null ? null : coordinateSystem2.getReference()));
            }
            this.TupleCoordinateSystem = coordinateSystem;
        }
        if (this.TupleCoordinateSystem != null && !Unit.canConvertArray(this.TupleCoordinateSystem.getCoordinateSystemUnits(), ((RealTupleType)this.Type).getDefaultUnits())) {
            throw new UnitException("RealTuple: CoordinateSystem Units must be convertable with Type default Units");
        }
        int n = this.tupleComponents.length;
        this.TupleUnits = new Unit[n];
        int n2 = 0;
        while (n2 < n) {
            this.TupleUnits[n2] = ((Real)this.tupleComponents[n2]).getUnit();
            ++n2;
        }
        if (!Unit.canConvertArray(this.TupleUnits, ((RealTupleType)this.Type).getDefaultUnits())) {
            throw new UnitException("Tuple: Units must be convertable with Type default Units");
        }
        if (this.TupleCoordinateSystem != null && !Unit.canConvertArray(this.TupleCoordinateSystem.getCoordinateSystemUnits(), this.TupleUnits)) {
            throw new UnitException("Tuple: Units must be convertable with CoordinateSystem Units");
        }
    }

    private static Real[] buildRealArray(RealTupleType realTupleType, double[] dArray) throws VisADException {
        Real[] realArray = new Real[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            realArray[n] = new Real((RealType)realTupleType.getComponent(n), dArray[n]);
            ++n;
        }
        return realArray;
    }

    public double[] getValues() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = ((Real)this.tupleComponents[n2]).getValue();
            ++n2;
        }
        return dArray;
    }

    public Unit[] getTupleUnits() {
        return Unit.copyUnitsArray(this.TupleUnits);
    }

    public ErrorEstimate[] getErrors() throws VisADException, RemoteException {
        int n = this.getDimension();
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[n];
        int n2 = 0;
        while (n2 < n) {
            errorEstimateArray[n2] = ((Real)this.getComponent(n2)).getError();
            ++n2;
        }
        return errorEstimateArray;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.TupleCoordinateSystem;
    }

    public Data binary(Data data, int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof RealTuple) {
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("RealTuple.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(mathType)) {
                throw new TypeException("RealTuple.binary: new_type doesn't match return type");
            }
            if (this.isMissing() || data.isMissing()) {
                return new RealTuple((RealTupleType)mathType);
            }
            double[][] dArray = new double[this.tupleComponents.length][1];
            int n4 = 0;
            while (n4 < this.tupleComponents.length) {
                dArray[n4][0] = ((Real)((RealTuple)data).getComponent(n4)).getValue();
                ++n4;
            }
            ErrorEstimate[] errorEstimateArray = new ErrorEstimate[this.tupleComponents.length];
            dArray = CoordinateSystem.transformCoordinates((RealTupleType)this.Type, this.TupleCoordinateSystem, this.TupleUnits, errorEstimateArray, (RealTupleType)data.getType(), ((RealTuple)data).getCoordinateSystem(), ((RealTuple)data).getTupleUnits(), ((RealTuple)data).getErrors(), dArray);
            Real[] realArray = new Real[this.tupleComponents.length];
            int n5 = 0;
            while (n5 < this.tupleComponents.length) {
                Real real = new Real((RealType)((RealTupleType)this.Type).getComponent(n5), dArray[n5][0], this.TupleUnits[n5], errorEstimateArray[n5]);
                MathType mathType2 = ((RealTupleType)mathType).getComponent(n5);
                realArray[n5] = (Real)this.tupleComponents[n5].binary(real, n, mathType2, n2, n3);
                ++n5;
            }
            return new RealTuple((RealTupleType)mathType, realArray, null);
        }
        if (data instanceof TupleIface) {
            throw new TypeException("RealTuple.binary: types don't match");
        }
        if (data instanceof Real) {
            if (this.isMissing() || data.isMissing()) {
                return new RealTuple((RealTupleType)this.Type);
            }
            Real[] realArray = new Real[this.tupleComponents.length];
            int n6 = 0;
            while (n6 < this.tupleComponents.length) {
                MathType mathType3 = ((RealTupleType)mathType).getComponent(n6);
                realArray[n6] = (Real)this.tupleComponents[n6].binary(data, n, mathType3, n2, n3);
                ++n6;
            }
            return new RealTuple((RealTupleType)mathType, realArray, null);
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(mathType)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(n), mathType, n2, n3);
        }
        throw new TypeException("RealTuple.binary");
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(mathType)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        RealTupleType realTupleType = (RealTupleType)mathType;
        if (this.isMissing()) {
            return new RealTuple((RealTupleType)this.Type);
        }
        Real[] realArray = new Real[this.tupleComponents.length];
        int n4 = 0;
        while (n4 < this.tupleComponents.length) {
            realArray[n4] = (Real)this.tupleComponents[n4].unary(n, realTupleType.getComponent(n4), n2, n3);
            ++n4;
        }
        return new RealTuple((RealTupleType)mathType, realArray, this.TupleCoordinateSystem);
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        dataShadow = super.computeRanges(shadowType, dataShadow);
        ShadowRealTupleType shadowRealTupleType = ((ShadowRealTupleType)shadowType).getReference();
        if (this.isMissing() || shadowRealTupleType == null) {
            return dataShadow;
        }
        int n = this.tupleComponents.length;
        double[][] dArray = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = ((Real)this.tupleComponents[n2]).getValue();
            Unit unit = ((RealType)((RealTupleType)this.Type).getComponent(n2)).getDefaultUnit();
            if (unit != null && !unit.equals(this.TupleUnits[n2])) {
                d = unit.toThis(d, this.TupleUnits[n2]);
            }
            if (d != d) {
                return dataShadow;
            }
            dArray[0][n2] = d;
            dArray[1][n2] = d;
            ++n2;
        }
        return this.computeReferenceRanges((ShadowRealTupleType)shadowType, this.TupleCoordinateSystem, ((RealTupleType)this.Type).getDefaultUnits(), dataShadow, shadowRealTupleType, dArray);
    }

    public Object clone() {
        RealTuple realTuple;
        try {
            Real[] realArray = new Real[this.tupleComponents.length];
            int n = 0;
            while (n < this.tupleComponents.length) {
                realArray[n] = (Real)this.tupleComponents[n];
                ++n;
            }
            realTuple = new RealTuple((RealTupleType)this.Type, realArray, this.TupleCoordinateSystem);
        }
        catch (VisADException visADException) {
            throw new VisADError("RealTuple.clone: VisADException occurred");
        }
        catch (RemoteException remoteException) {
            throw new VisADError("RealTuple.clone: RemoteException occurred");
        }
        return realTuple;
    }

    public String toString() {
        if (this.isMissing()) {
            return "missing";
        }
        String string = "(" + this.tupleComponents[0];
        int n = 1;
        while (n < this.tupleComponents.length) {
            string = string + ", " + this.tupleComponents[n];
            ++n;
        }
        return string + ")";
    }

    public String longString(String string) throws VisADException, RemoteException {
        String string2 = string + "RealTuple\n" + string + "  Type: " + this.Type.toString() + "\n";
        if (this.isMissing()) {
            return string2 + "  missing\n";
        }
        int n = 0;
        while (n < this.tupleComponents.length) {
            string2 = string2 + string + "  Tuple Component " + n + ": Value = " + ((Real)this.tupleComponents[n]).getValue() + "  (TypeName = " + ((RealType)this.tupleComponents[n].getType()).getName() + ")\n";
            ++n;
        }
        return string2;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        int n = 10;
        Real real = new Real(n);
        Real[] realArray = new Real[]{new Real(1.0), new Real(2.0), new Real(3.0)};
        RealTuple realTuple = new RealTuple(realArray);
        Real[] realArray2 = new Real[]{new Real(6.0), new Real(5.0), new Real(4.0)};
        RealTuple realTuple2 = new RealTuple(realArray2);
        System.out.println("rt1 = " + realTuple + "\nrt2 = " + realTuple2);
        System.out.println("rt1 + rt2 = " + realTuple.add(realTuple2));
        System.out.println("rt1 - rt2 = " + realTuple.subtract(realTuple2));
        System.out.println("rt1 * rt2 = " + realTuple.multiply(realTuple2));
        System.out.println("rt1 / rt2 = " + realTuple.divide(realTuple2));
        System.out.println("sqrt(rt1) = " + realTuple.sqrt());
        System.out.println("rt1 + w = " + realTuple.add(real));
        System.out.println("rt1 - w = " + realTuple.subtract(real));
        System.out.println("rt1 * w = " + realTuple.multiply(real));
        System.out.println("rt1 / w = " + realTuple.divide(real));
        System.out.println("w + rt2 = " + real.add(realTuple2));
        System.out.println("w - rt2 = " + real.subtract(realTuple2));
        System.out.println("w * rt2 = " + real.multiply(realTuple2));
        System.out.println("w / rt2 = " + real.divide(realTuple2));
    }

    public RealTuple(RealTupleType realTupleType) {
        super(realTupleType);
        this.TupleCoordinateSystem = realTupleType.getCoordinateSystem();
        if (this.tupleComponents != null) {
            int n = this.tupleComponents.length;
            this.TupleUnits = new Unit[n];
            int n2 = 0;
            while (n2 < n) {
                this.TupleUnits[n2] = null;
                ++n2;
            }
        }
    }

    public RealTuple(RealTupleType realTupleType, Real[] realArray, CoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        super(realTupleType, realArray);
        this.init_coord_sys(coordinateSystem);
    }

    public RealTuple(Real[] realArray) throws VisADException, RemoteException {
        super(realArray);
        this.init_coord_sys(null);
    }

    public RealTuple(RealTupleType realTupleType, double[] dArray) throws VisADException, RemoteException {
        this(realTupleType, RealTuple.buildRealArray(realTupleType, dArray), null);
    }
}

