/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.Field;
import visad.MathType;
import visad.OffsetUnit;
import visad.RealIface;
import visad.RealType;
import visad.SI;
import visad.Scalar;
import visad.ScaledUnit;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.Text;
import visad.TupleIface;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class Real
extends Scalar
implements RealIface {
    private final double Value;
    private final Unit unit;
    private final ErrorEstimate Error;

    public final double getValue() {
        return this.Value;
    }

    public final double getValue(Unit unit) throws VisADException {
        if (unit == null) {
            if (this.unit != null) {
                throw new UnitException("Real.getValue: illegal Unit conversion");
            }
            return this.Value;
        }
        if (((RealType)this.getType()).isInterval()) {
            unit = unit.getAbsoluteUnit();
        }
        return unit.toThis(this.Value, this.unit);
    }

    public boolean isMissing() {
        return Double.isNaN(this.Value);
    }

    public Data binary(Data data, int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof Real) {
            double d;
            Unit unit;
            Unit unit2;
            if (!(mathType instanceof RealType)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            Unit unit3 = ((Real)data).getUnit();
            Unit unit4 = this.unit == null ? null : (unit2 = Unit.canConvert(CommonUnit.dimensionless, this.unit) ? CommonUnit.dimensionless : this.unit.getAbsoluteUnit());
            Unit unit5 = unit3 == null ? null : (Unit.canConvert(CommonUnit.dimensionless, unit3) ? CommonUnit.dimensionless : unit3.getAbsoluteUnit());
            double d2 = ((Real)data).getValue(unit5);
            double d3 = this.getValue(unit2);
            ErrorEstimate errorEstimate = ((Real)data).getError();
            block1 : switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    if (unit2 == null || unit5 == null) {
                        unit = null;
                    } else if (unit2 == CommonUnit.promiscuous) {
                        unit = unit5;
                    } else if (unit5 == CommonUnit.promiscuous) {
                        unit = unit2;
                    } else {
                        try {
                            unit = unit2;
                            d2 = unit.toThis(d2, unit5);
                            if (n3 != 202 && errorEstimate != null) {
                                Unit unit6 = errorEstimate.getUnit();
                                if (unit6 == null) {
                                    unit6 = unit5;
                                }
                                double d4 = unit.toThis(errorEstimate.getErrorValue(), unit6);
                                errorEstimate = new ErrorEstimate(d2, d4, unit);
                            }
                        }
                        catch (UnitException unitException) {
                            unit = null;
                        }
                    }
                    switch (n) {
                        case 1: {
                            d = d3 + d2;
                            break block1;
                        }
                        case 2: {
                            d = d3 - d2;
                            break block1;
                        }
                        case 3: {
                            d = d2 - d3;
                            break block1;
                        }
                        case 9: {
                            d = Math.max(d3, d2);
                            break block1;
                        }
                    }
                    d = Math.min(d3, d2);
                    break;
                }
                case 4: {
                    d = d3 * d2;
                    if (unit2 == null || unit5 == null) {
                        unit = null;
                        break;
                    }
                    unit = unit2.multiply(unit5);
                    break;
                }
                case 5: {
                    d = d3 / d2;
                    if (unit2 == null || unit5 == null) {
                        unit = null;
                        break;
                    }
                    unit = unit2.divide(unit5);
                    break;
                }
                case 6: {
                    d = d2 / d3;
                    if (unit2 == null || unit5 == null) {
                        unit = null;
                        break;
                    }
                    unit = unit5.divide(unit2);
                    break;
                }
                case 7: {
                    d = Math.pow(d3, d2);
                    unit = CommonUnit.dimensionless.equals(unit2) ? CommonUnit.dimensionless : null;
                    break;
                }
                case 8: {
                    d = Math.pow(d2, d3);
                    unit = null;
                    break;
                }
                case 11: {
                    d = Math.atan2(d3, d2);
                    unit = CommonUnit.radian;
                    break;
                }
                case 12: {
                    d = 57.29577951308232 * Math.atan2(d3, d2);
                    unit = CommonUnit.degree;
                    break;
                }
                case 13: {
                    d = Math.atan2(d2, d3);
                    unit = CommonUnit.radian;
                    break;
                }
                case 14: {
                    d = 57.29577951308232 * Math.atan2(d2, d3);
                    unit = CommonUnit.degree;
                    break;
                }
                case 15: {
                    d = d3 % d2;
                    unit = unit2;
                    break;
                }
                case 16: {
                    d = d2 % d3;
                    unit = unit5;
                    break;
                }
                default: {
                    throw new ArithmeticException("Real.binary: illegal operation");
                }
            }
            if (n3 == 202 || this.Error == null || errorEstimate == null) {
                return new Real((RealType)mathType, d, unit, null);
            }
            return new Real((RealType)mathType, d, unit, new ErrorEstimate(d, unit, n, this.Error, errorEstimate, n3));
        }
        if (data instanceof Text) {
            throw new TypeException("Real.binary: types don't match");
        }
        if (data instanceof TupleIface) {
            if (!data.getType().equalsExceptName(mathType)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(n), mathType, n2, n3);
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(mathType)) {
                throw new TypeException();
            }
            return data.binary(this, DataImpl.invertOp(n), mathType, n2, n3);
        }
        throw new TypeException("Real.binary");
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException {
        Unit unit;
        double d;
        double d2;
        Unit unit2;
        if (this.unit == null) {
            unit2 = null;
            d2 = this.Value;
        } else {
            unit2 = Unit.canConvert(CommonUnit.dimensionless, this.unit) ? CommonUnit.dimensionless : this.unit.getAbsoluteUnit();
            d2 = unit2.toThis(this.Value, this.unit);
        }
        if (mathType == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        switch (n) {
            case 21: {
                d = Math.abs(d2);
                unit = unit2;
                break;
            }
            case 22: {
                d = Math.acos(d2);
                unit = CommonUnit.radian;
                break;
            }
            case 23: {
                d = 57.29577951308232 * Math.acos(d2);
                unit = CommonUnit.degree;
                break;
            }
            case 24: {
                d = Math.asin(d2);
                unit = CommonUnit.radian;
                break;
            }
            case 25: {
                d = 57.29577951308232 * Math.asin(d2);
                unit = CommonUnit.degree;
                break;
            }
            case 26: {
                d = Math.atan(d2);
                unit = CommonUnit.radian;
                break;
            }
            case 27: {
                d = 57.29577951308232 * Math.atan(d2);
                unit = CommonUnit.degree;
                break;
            }
            case 28: {
                d = Math.ceil(d2);
                unit = unit2;
                break;
            }
            case 29: {
                d = CommonUnit.degree.equals(unit2) ? Math.cos(Math.PI / 180 * d2) : Math.cos(d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 30: {
                d = CommonUnit.radian.equals(unit2) ? Math.cos(d2) : Math.cos(Math.PI / 180 * d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 31: {
                d = Math.exp(d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 32: {
                d = Math.floor(d2);
                unit = unit2;
                break;
            }
            case 33: {
                d = Math.log(d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 34: {
                d = Math.rint(d2);
                unit = unit2;
                break;
            }
            case 35: {
                d = Math.round(d2);
                unit = unit2;
                break;
            }
            case 36: {
                d = CommonUnit.degree.equals(unit2) ? Math.sin(Math.PI / 180 * d2) : Math.sin(d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 37: {
                d = CommonUnit.radian.equals(unit2) ? Math.sin(d2) : Math.sin(Math.PI / 180 * d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 38: {
                d = Math.sqrt(d2);
                if (unit2 == null) {
                    unit = null;
                    break;
                }
                try {
                    unit = unit2.sqrt();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    unit = null;
                }
                catch (UnitException unitException) {
                    unit = null;
                }
                break;
            }
            case 39: {
                d = CommonUnit.degree.equals(unit2) ? Math.tan(Math.PI / 180 * d2) : Math.tan(d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 40: {
                d = CommonUnit.radian.equals(unit2) ? Math.tan(d2) : Math.tan(Math.PI / 180 * d2);
                unit = CommonUnit.dimensionless.equals(unit2) ? unit2 : null;
                break;
            }
            case 41: {
                d = -d2;
                unit = unit2;
                break;
            }
            case 42: {
                d = d2;
                unit = unit2;
                break;
            }
            default: {
                throw new ArithmeticException("Real.unary: illegal operation");
            }
        }
        if (n3 == 202 || this.Error == null) {
            return new Real((RealType)mathType, d, unit, null);
        }
        return new Real((RealType)mathType, d, unit, new ErrorEstimate(d, unit, n, this.Error, n3));
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        Unit unit;
        double d;
        if (Double.isNaN(this.Value)) {
            return dataShadow;
        }
        int n = ((ShadowRealType)shadowType).getIndex();
        if (n >= 0 && (d = (unit = ((RealType)this.Type).getDefaultUnit()) != null && !unit.equals(this.unit) ? unit.toThis(this.Value, this.unit) : this.Value) == d) {
            dataShadow.ranges[0][n] = Math.min(dataShadow.ranges[0][n], d);
            dataShadow.ranges[1][n] = Math.max(dataShadow.ranges[1][n], d);
        }
        return dataShadow;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public ErrorEstimate getError() {
        return this.Error;
    }

    public Data adjustSamplingError(Data data, int n) throws VisADException, RemoteException {
        if (this.isMissing() || this.Error == null || data == null || data.isMissing()) {
            return this;
        }
        double d = ((Real)data).getValue();
        double d2 = this.Error.getErrorValue();
        double d3 = n == 200 ? Math.sqrt(d * d + d2 * d2) : Math.abs(d) + Math.abs(d2);
        return new Real((RealType)this.Type, this.Value, this.unit, new ErrorEstimate(this.Value, d3, this.unit));
    }

    public Real cloneButValue(double d) throws VisADException {
        return new Real((RealType)this.Type, d, this.unit, this.Error);
    }

    public Real cloneButUnit(Unit unit) throws VisADException {
        return new Real((RealType)this.Type, this.Value, unit, this.Error);
    }

    public Object clone() {
        return new Real((RealType)this.Type, this.Value, this.unit, this.Error, true);
    }

    public String toString() {
        try {
            if (Double.isNaN(this.Value)) {
                return "missing";
            }
            return Unit.canConvert(this.getUnit(), CommonUnit.secondsSinceTheEpoch) && !this.getUnit().getAbsoluteUnit().equals(this.getUnit()) ? new DateTime(this).toString() : Double.toString(this.Value);
        }
        catch (VisADException visADException) {
            return visADException.toString();
        }
    }

    public String toValueString() {
        String string;
        try {
            if (Double.isNaN(this.Value)) {
                string = "missing";
            } else if (Unit.canConvert(this.getUnit(), CommonUnit.secondsSinceTheEpoch) && !this.getUnit().getAbsoluteUnit().equals(this.getUnit())) {
                string = new DateTime(this).toValueString();
            } else {
                Unit unit = this.unit != null ? this.unit : ((RealType)this.getType()).getDefaultUnit();
                string = Float.toString((float)this.Value) + (unit == null ? "" : " " + unit);
            }
        }
        catch (VisADException visADException) {
            string = visADException.toString();
        }
        return string;
    }

    public String longString(String string) throws VisADException {
        if (Double.isNaN(this.Value)) {
            return string + "missing\n";
        }
        if (Unit.canConvert(this.getUnit(), CommonUnit.secondsSinceTheEpoch) && !this.getUnit().getAbsoluteUnit().equals(this.getUnit())) {
            return string + "Real.Time: Value = " + new DateTime(this).toString() + "\n";
        }
        return string + "Real: Value = " + this.Value + "  (TypeName: " + ((RealType)this.Type).getName() + ")\n";
    }

    public int compareTo(Object object) {
        int n;
        Real real = (Real)object;
        try {
            Unit unit = ((RealType)this.getType()).getDefaultUnit();
            n = new Double(this.getValue(unit)).compareTo(new Double(real.getValue(unit)));
            if (n == 0) {
                n = this.Error == null ? (real.Error == null ? 0 : -1) : (real.Error == null ? 1 : this.Error.compareTo(real.Error));
            }
        }
        catch (VisADException visADException) {
            n = 1;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Real && this.getType().equals(((Real)object).getType()) && this.compareTo(object) == 0;
    }

    public int hashCode() {
        RealType realType = (RealType)this.getType();
        int n = realType.hashCode();
        try {
            n ^= new Double(this.getValue(realType.getDefaultUnit())).hashCode();
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        if (this.Error != null) {
            n ^= this.Error.hashCode();
        }
        return n;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        int n = 10;
        Real real = new Real(n);
        int n2 = 14;
        int n3 = 12;
        Real real2 = new Real(1.0);
        Real real3 = new Real(12.0);
        Real real4 = new Real(12.0);
        Real real5 = new Real(n2);
        Real real6 = new Real(n3);
        System.out.println("x = " + real3 + "\nw = " + real);
        System.out.println("x + w = " + real3.add(real));
        System.out.println("x - w = " + real3.subtract(real));
        System.out.println("x * w = " + real3.multiply(real));
        System.out.println("x / w = " + real3.divide(real));
        System.out.println("sqrt(x) = " + real3.sqrt());
        System.out.println("");
        Real real7 = new Real(new RealType("FahrenheitTemperature", (Unit)new OffsetUnit(459.67, new ScaledUnit(0.5555555555555556, SI.kelvin, "degR"), "degF"), null), 32.0);
        Real real8 = new Real(new RealType("Temperature", (Unit)SI.kelvin, null), 300.0);
        System.out.println("300 kelvin + 32 fahrenheit = " + ((Real)real8.add(real7)).toValueString());
        System.out.println("300 kelvin - 32 fahrenheit = " + ((Real)real8.subtract(real7)).toValueString());
        System.out.println("max(300 kelvin, 32 fahrenheit) = " + ((Real)real8.max(real7)).toValueString());
        System.out.println("min(300 kelvin, 32 fahrenheit) = " + ((Real)real8.min(real7)).toValueString());
        System.out.println("");
        System.out.println("32 fahrenheit + 300 kelvin = " + ((Real)real7.add(real8)).toValueString());
        System.out.println("32 fahrenheit - 300 kelvin = " + ((Real)real7.subtract(real8)).toValueString());
        System.out.println("max(32 fahrenheit, 300 kelvin) = " + ((Real)real7.max(real8)).toValueString());
        System.out.println("min(32 fahrenheit, 300 kelvin) = " + ((Real)real7.min(real8)).toValueString());
        System.out.println("");
        Real real9 = new Real(new RealType("DeltaFahrenheitTemperature", (Unit)new OffsetUnit(459.67, new ScaledUnit(0.5555555555555556, SI.kelvin, "degR"), "degF"), null, 1), 32.0);
        System.out.println("300 kelvin + 32 deltaF = " + ((Real)real8.add(real9)).toValueString());
        System.out.println("300 kelvin - 32 deltaF = " + ((Real)real8.subtract(real9)).toValueString());
        System.out.println("max(300 kelvin, 32 deltaF) = " + ((Real)real8.max(real9)).toValueString());
        System.out.println("min(300 kelvin, 32 deltaF) = " + ((Real)real8.min(real9)).toValueString());
        System.out.println("");
        System.out.println("32 deltaF + 300 kelvin = " + ((Real)real9.add(real8)).toValueString());
        System.out.println("32 deltaF - 300 kelvin = " + ((Real)real9.subtract(real8)).toValueString());
        System.out.println("max(32 deltaF, 300 kelvin) = " + ((Real)real9.max(real8)).toValueString());
        System.out.println("min(32 deltaF, 300 kelvin) = " + ((Real)real9.min(real8)).toValueString());
        System.out.println("");
        Real real10 = new Real(new RealType("DeltaTemperature", (Unit)SI.kelvin, null, 1), 100.0);
        System.out.println("300 kelvin + 100 deltaK = " + ((Real)real8.add(real10)).toValueString());
        System.out.println("300 kelvin - 100 deltaK = " + ((Real)real8.subtract(real10)).toValueString());
        System.out.println("max(300 kelvin, 100 deltaK) = " + ((Real)real8.max(real10)).toValueString());
        System.out.println("min(300 kelvin, 100 deltaK) = " + ((Real)real8.min(real10)).toValueString());
        System.out.println("");
        System.out.println("100 deltaK + 300 kelvin = " + ((Real)real10.add(real8)).toValueString());
        System.out.println("100 deltaK - 300 kelvin = " + ((Real)real10.subtract(real8)).toValueString());
        System.out.println("max(100 deltaK, 300 kelvin) = " + ((Real)real10.max(real8)).toValueString());
        System.out.println("min(100 deltaK, 300 kelvin) = " + ((Real)real10.min(real8)).toValueString());
        System.out.println("");
        System.out.println("100 deltaK + 32 deltaF = " + ((Real)real10.add(real9)).toValueString());
        System.out.println("100 deltaK - 32 deltaF = " + ((Real)real10.subtract(real9)).toValueString());
        System.out.println("max(100 deltaK, 32 deltaF) = " + ((Real)real10.max(real9)).toValueString());
        System.out.println("min(100 deltaK, 32 deltaF) = " + ((Real)real10.min(real9)).toValueString());
        System.out.println("");
        System.out.println("32 deltaF + 100 deltaK = " + ((Real)real9.add(real10)).toValueString());
        System.out.println("32 deltaF - 100 deltaK = " + ((Real)real9.subtract(real10)).toValueString());
        System.out.println("max(32 deltaF, 100 deltaK) = " + ((Real)real9.max(real10)).toValueString());
        System.out.println("min(32 deltaF, 100 deltaK) = " + ((Real)real9.min(real10)).toValueString());
        System.out.println("");
        System.out.println("300 kelvin + -(32 fahrenheit) = " + ((Real)real8.add(real7.negate())).toValueString());
        System.out.println("32 fahrenheit + -(300 kelvin) = " + ((Real)real7.add(real8.negate())).toValueString());
        System.out.println("");
        ScaledUnit scaledUnit = new ScaledUnit(3.048, SI.meter);
        ScaledUnit scaledUnit2 = new ScaledUnit(3.0, scaledUnit);
        System.out.println("log(1 yard / 3 feet) = " + ((Real)new Real(new RealType("OneYard", (Unit)SI.meter, null), 1.0, scaledUnit2).divide(new Real(new RealType("ThreeFeet", (Unit)SI.meter, null), 3.0, scaledUnit)).log()).toValueString());
    }

    public Real(RealType realType, double d, Unit unit, ErrorEstimate errorEstimate) throws VisADException {
        super(realType);
        if (!Unit.canConvert(unit, realType.getDefaultUnit())) {
            throw new UnitException("Real: Unit \"" + unit + "\" must be convertable" + " with Type default Unit \"" + realType.getDefaultUnit() + "\"");
        }
        this.unit = unit != null && realType.isInterval() ? unit.getAbsoluteUnit() : unit;
        this.Value = d;
        this.Error = Double.isNaN(d) ? null : errorEstimate;
    }

    public Real(RealType realType, double d, Unit unit, double d2) throws VisADException {
        this(realType, d, unit, new ErrorEstimate(d, Math.abs(d2), unit != null && realType.isInterval() ? unit.getAbsoluteUnit() : unit));
    }

    public Real(RealType realType, double d, Unit unit) throws VisADException {
        this(realType, d, unit, null);
    }

    public Real(RealType realType, double d) {
        this(realType, d, realType.getDefaultUnit(), null, true);
    }

    public Real(RealType realType) {
        this(realType, Double.NaN, realType.getDefaultUnit(), null, true);
    }

    public Real(double d, double d2) {
        this(RealType.Generic, d, RealType.Generic.getDefaultUnit(), new ErrorEstimate(d, Math.abs(d2), RealType.Generic.getDefaultUnit()), true);
    }

    public Real(double d) {
        this(RealType.Generic, d, RealType.Generic.getDefaultUnit(), new ErrorEstimate(d, 0.0, RealType.Generic.getDefaultUnit()), true);
    }

    private Real(RealType realType, double d, Unit unit, ErrorEstimate errorEstimate, boolean bl) {
        super(realType);
        this.unit = unit != null && realType.isInterval() ? unit.getAbsoluteUnit() : unit;
        this.Value = d;
        this.Error = Double.isNaN(d) ? null : errorEstimate;
    }
}

