/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public class RangeControl
extends Control {
    private boolean initialized = false;
    private double RangeLow = Double.NaN;
    private double RangeHi = Double.NaN;

    public void initializeRange(float[] fArray) throws VisADException, RemoteException {
        this.initializeRange(new double[]{fArray[0], fArray[1]});
    }

    public void initializeRange(double[] dArray) throws VisADException, RemoteException {
        this.changeRange(dArray, this.initialized);
    }

    public void setRange(float[] fArray) throws VisADException, RemoteException {
        this.setRange(new double[]{fArray[0], fArray[1]});
    }

    public void setRange(double[] dArray) throws VisADException, RemoteException {
        if (this.RangeLow != this.RangeLow || !Util.isApproximatelyEqual(this.RangeLow, dArray[0]) || this.RangeHi != this.RangeHi || !Util.isApproximatelyEqual(this.RangeHi, dArray[1])) {
            this.changeRange(dArray, true);
        }
    }

    private void changeRange(double[] dArray, boolean bl) throws VisADException, RemoteException {
        this.RangeLow = dArray[0];
        this.RangeHi = dArray[1];
        boolean bl2 = this.initialized = this.RangeLow == this.RangeLow && this.RangeHi == this.RangeHi;
        if (bl) {
            this.changeControl(true);
        }
    }

    public float[] getRange() {
        float[] fArray = new float[]{(float)this.RangeLow, (float)this.RangeHi};
        return fArray;
    }

    public double[] getDoubleRange() {
        double[] dArray = new double[]{this.RangeLow, this.RangeHi};
        return dArray;
    }

    public String getSaveString() {
        return this.RangeLow + " " + this.RangeHi;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            throw new VisADException("Invalid save string");
        }
        double[] dArray = new double[2];
        int n = 0;
        while (n < 2) {
            dArray[n] = Convert.getDouble(stringTokenizer.nextToken());
            ++n;
        }
        this.initializeRange(dArray);
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof RangeControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        RangeControl rangeControl = (RangeControl)control;
        boolean bl = false;
        if (!Util.isApproximatelyEqual(this.RangeLow, rangeControl.RangeLow)) {
            bl = true;
            this.RangeLow = rangeControl.RangeLow;
        }
        if (!Util.isApproximatelyEqual(this.RangeHi, rangeControl.RangeHi)) {
            bl = true;
            this.RangeHi = rangeControl.RangeHi;
        }
        boolean bl2 = this.initialized = this.RangeLow == this.RangeLow && this.RangeHi == this.RangeHi;
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        RangeControl rangeControl = (RangeControl)object;
        if (!Util.isApproximatelyEqual(this.RangeLow, rangeControl.RangeLow)) {
            return false;
        }
        return Util.isApproximatelyEqual(this.RangeHi, rangeControl.RangeHi);
    }

    public String toString() {
        return "RangeControl[" + this.RangeLow + "," + this.RangeHi + "]";
    }

    public RangeControl(DisplayImpl displayImpl) {
        super(displayImpl);
    }
}

