/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.BaseQuantity;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.OffsetUnit;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class QuantityDimension
implements Serializable,
Comparable {
    private byte[] exponents;

    private void initialize(int n) {
        this.exponents = new byte[n];
    }

    private void initialize(DerivedUnit derivedUnit) throws UnitException {
        this.initialize(BaseQuantity.size());
        int n = 0;
        while (n < derivedUnit.factors.length) {
            String string = derivedUnit.factors[n].baseUnit.quantityName();
            BaseQuantity baseQuantity = BaseQuantity.get(string);
            if (baseQuantity == null) {
                throw new UnitException("No base quantity for \"" + string + "\"");
            }
            this.exponents[baseQuantity.getIndex()] = (byte)derivedUnit.factors[n].power;
            ++n;
        }
    }

    public int compareTo(Object object) {
        QuantityDimension quantityDimension = (QuantityDimension)object;
        return this.isShorterThan(quantityDimension) ? QuantityDimension.compare(this, quantityDimension) : -QuantityDimension.compare(quantityDimension, this);
    }

    private boolean isShorterThan(QuantityDimension quantityDimension) {
        return this.exponents.length < quantityDimension.exponents.length;
    }

    private static int compare(QuantityDimension quantityDimension, QuantityDimension quantityDimension2) {
        int n = 0;
        int n2 = 0;
        while (n == 0 && n2 < quantityDimension.exponents.length) {
            n = quantityDimension.exponents[n2] - quantityDimension2.exponents[n2];
            ++n2;
        }
        n2 = quantityDimension.exponents.length;
        while (n == 0 && n2 < quantityDimension2.exponents.length) {
            n = -quantityDimension2.exponents[n2];
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public QuantityDimension raise(int n) {
        QuantityDimension quantityDimension = new QuantityDimension(this);
        int n2 = 0;
        while (n2 < quantityDimension.exponents.length) {
            int n3 = n2++;
            quantityDimension.exponents[n3] = (byte)(quantityDimension.exponents[n3] * n);
        }
        return quantityDimension;
    }

    public QuantityDimension multiply(QuantityDimension quantityDimension) {
        return this.isShorterThan(quantityDimension) ? QuantityDimension.multiply(this, quantityDimension) : QuantityDimension.multiply(quantityDimension, this);
    }

    private static QuantityDimension multiply(QuantityDimension quantityDimension, QuantityDimension quantityDimension2) {
        QuantityDimension quantityDimension3 = new QuantityDimension(quantityDimension2);
        int n = 0;
        while (n < quantityDimension.exponents.length) {
            int n2 = n;
            quantityDimension3.exponents[n2] = (byte)(quantityDimension3.exponents[n2] + quantityDimension.exponents[n]);
            ++n;
        }
        return quantityDimension3;
    }

    public QuantityDimension divide(QuantityDimension quantityDimension) {
        return this.multiply(quantityDimension.raise(-1));
    }

    public boolean isDimensionless() {
        int n = 0;
        while (n < this.exponents.length) {
            if (this.exponents[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        String string;
        if (this.isDimensionless()) {
            string = "1";
        } else {
            StringBuffer stringBuffer = new StringBuffer(128);
            int n = 0;
            while (n < this.exponents.length) {
                byte by = this.exponents[n];
                if (by != 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("(");
                    stringBuffer.append(BaseQuantity.get(n).getName());
                    stringBuffer.append(")");
                    if (by != 1) {
                        stringBuffer.append("^");
                        stringBuffer.append(by);
                    }
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        QuantityDimension quantityDimension = new QuantityDimension();
        quantityDimension.exponents[0] = -3;
        quantityDimension.exponents[1] = -2;
        quantityDimension.exponents[2] = -1;
        quantityDimension.exponents[3] = 0;
        quantityDimension.exponents[4] = 1;
        quantityDimension.exponents[5] = 2;
        quantityDimension.exponents[6] = 3;
        quantityDimension.exponents[7] = 4;
        System.out.println("dim1=(" + quantityDimension + ")");
        System.out.println("dim1.equals(dim1)=" + quantityDimension.equals(quantityDimension));
        System.out.println("dim1.compareTo(dim1)=" + quantityDimension.compareTo(quantityDimension));
        QuantityDimension quantityDimension2 = new QuantityDimension();
        quantityDimension2.exponents[0] = -3;
        quantityDimension2.exponents[1] = -2;
        quantityDimension2.exponents[2] = -1;
        quantityDimension2.exponents[3] = 1;
        quantityDimension2.exponents[4] = 1;
        quantityDimension2.exponents[5] = 2;
        quantityDimension2.exponents[6] = 3;
        quantityDimension2.exponents[7] = 4;
        System.out.println("dim2=(" + quantityDimension2 + ")");
        System.out.println("dim1.equals(dim2)=" + quantityDimension.equals(quantityDimension2));
        System.out.println("dim1.compareTo(dim2)=" + quantityDimension.compareTo(quantityDimension2));
    }

    public QuantityDimension() {
        this.initialize(0);
    }

    public QuantityDimension(QuantityDimension quantityDimension) {
        this.initialize(quantityDimension.exponents.length);
        System.arraycopy(quantityDimension.exponents, 0, this.exponents, 0, quantityDimension.exponents.length);
    }

    public QuantityDimension(Unit unit) throws UnitException {
        if (unit instanceof BaseUnit) {
            this.initialize(((BaseUnit)unit).derivedUnit);
        } else if (unit instanceof DerivedUnit) {
            this.initialize((DerivedUnit)unit);
        } else if (unit instanceof ScaledUnit) {
            this.initialize(((ScaledUnit)unit).derivedUnit);
        } else if (unit instanceof OffsetUnit) {
            this.initialize(((OffsetUnit)unit).scaledUnit.derivedUnit);
        } else {
            throw new UnitException("Can't construct " + this.getClass() + " from " + unit.getClass());
        }
    }
}

