/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public abstract class ProjectionControl
extends Control {
    public static final int MATRIX2D_LENGTH = 6;
    public static final int MATRIX2D_MAJOR = 3;
    public static final int MATRIX2D_MINOR = 2;
    public static final int MATRIX3D_LENGTH = 16;
    public static final int MATRIX3D_MAJOR = 4;
    public static final int MATRIX3D_MINOR = 4;
    public static final double SCALE2D = 0.65;
    public static final double INVSCALE2D = 1.5384615384615383;
    protected double[] matrix = null;
    private double[] savedProjectionMatrix = null;
    private double[] asp = new double[]{1.0, 1.0, 1.0};

    public double[] getMatrix() {
        double[] dArray = new double[this.matrix.length];
        System.arraycopy(this.matrix, 0, dArray, 0, this.matrix.length);
        return dArray;
    }

    public void setMatrix(double[] dArray) throws VisADException, RemoteException {
        if (dArray == null) {
            return;
        }
        if (dArray.length != this.matrix.length) {
            throw new DisplayException("setMatrix: input length must be " + this.matrix.length);
        }
        System.arraycopy(dArray, 0, this.matrix, 0, this.matrix.length);
    }

    public String getSaveString() {
        int n;
        int n2;
        int n3 = this.matrix.length;
        if (n3 == 6) {
            n2 = 3;
            n = 2;
        } else if (n3 == 16) {
            n2 = 4;
            n = 4;
        } else {
            n2 = n3;
            n = 1;
        }
        StringBuffer stringBuffer = new StringBuffer(25 * n3);
        stringBuffer.append(n2);
        if (n > 1) {
            stringBuffer.append(" x ");
            stringBuffer.append(n);
        }
        stringBuffer.append('\n');
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                if (n5 > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.matrix[n2 * n4 + n5]);
                ++n5;
            }
            stringBuffer.append('\n');
            ++n4;
        }
        return stringBuffer.toString();
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        int n;
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        int n2 = string.indexOf(10);
        if (n2 < 0) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(0, n2));
        int n3 = stringTokenizer.countTokens();
        int n4 = -1;
        if (n3 == 3) {
            int n5 = Convert.getInt(stringTokenizer.nextToken());
            if (n5 < 1) {
                throw new VisADException("First matrix dimension is not positive");
            }
            if (!stringTokenizer.nextToken().equalsIgnoreCase("x")) {
                throw new VisADException("Invalid save string");
            }
            n = Convert.getInt(stringTokenizer.nextToken());
            if (n < 1) {
                throw new VisADException("Second matrix dimension is not positive");
            }
            n4 = n5 * n;
        } else if (n3 == 1) {
            n4 = Convert.getInt(stringTokenizer.nextToken());
            if (n4 < 1) {
                throw new VisADException("Matrix size is not positive");
            }
        } else {
            throw new VisADException("Cannot determine matrix size");
        }
        stringTokenizer = new StringTokenizer(string.substring(n2 + 1));
        n3 = stringTokenizer.countTokens();
        if (n3 < n4) {
            throw new VisADException("Not enough matrix entries");
        }
        double[] dArray = new double[n4];
        n = 0;
        while (n < n4) {
            dArray[n] = Convert.getDouble(stringTokenizer.nextToken());
            ++n;
        }
        this.setMatrix(dArray);
    }

    public abstract void setAspect(double[] var1) throws VisADException, RemoteException;

    public void setAspectCartesian(double[] dArray) throws VisADException, RemoteException {
        if (dArray != null) {
            int n = 0;
            while (n < dArray.length) {
                if (dArray[n] <= 0.0) {
                    throw new DisplayException("aspect must be positive");
                }
                this.asp[n] = dArray[n];
                ++n;
            }
        }
        this.getDisplay().setAspectCartesian(this.asp);
    }

    public double[] getAspectCartesian() {
        return (double[])this.asp.clone();
    }

    public void saveProjection() {
        this.savedProjectionMatrix = this.getMatrix();
    }

    public double[] getSavedProjectionMatrix() {
        double[] dArray = new double[this.savedProjectionMatrix.length];
        System.arraycopy(this.savedProjectionMatrix, 0, dArray, 0, this.savedProjectionMatrix.length);
        return dArray;
    }

    public void resetProjection() throws VisADException, RemoteException {
        this.setMatrix(this.savedProjectionMatrix);
    }

    public static double[] matrix2DTo3D(double[] dArray) throws VisADException {
        if (dArray.length != 6) {
            throw new DisplayException("matrix2DTo3D: input length must be 6");
        }
        double[] dArray2 = new double[16];
        int n = 0;
        while (n < 16) {
            dArray2[n] = 0.0;
            ++n;
        }
        dArray2[0] = 0.65 * dArray[0];
        dArray2[1] = 0.65 * dArray[2];
        dArray2[3] = dArray[4];
        dArray2[4] = 0.65 * dArray[1];
        dArray2[5] = -0.65 * dArray[3];
        dArray2[7] = -dArray[5];
        dArray2[10] = 1.0;
        dArray2[15] = 1.0;
        return dArray2;
    }

    public static double[] matrix3DTo2D(double[] dArray) throws VisADException {
        if (dArray.length != 16) {
            throw new DisplayException("matrix3DTo2D: input length must be 16");
        }
        double[] dArray2 = new double[]{1.5384615384615383 * dArray[0], 1.5384615384615383 * dArray[4], 1.5384615384615383 * dArray[1], -1.5384615384615383 * dArray[5], dArray[3], -dArray[7]};
        return dArray2;
    }

    public static double[] matrixDConvert(double[] dArray) throws VisADException {
        if (dArray.length == 16) {
            return ProjectionControl.matrix3DTo2D(dArray);
        }
        if (dArray.length == 6) {
            return ProjectionControl.matrix2DTo3D(dArray);
        }
        throw new DisplayException("matrixDConvert: input length must be 16 or 6");
    }

    public void clearSwitches(DataRenderer dataRenderer) {
    }

    private boolean matrixEquals(double[] dArray) {
        if (this.matrix == null) {
            if (dArray != null) {
                return false;
            }
        } else {
            if (dArray == null) {
                return false;
            }
            if (this.matrix.length != dArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.matrix.length) {
                if (!Util.isApproximatelyEqual(this.matrix[n], dArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private boolean aspEquals(double[] dArray) {
        if (this.asp == null) {
            if (dArray != null) {
                return false;
            }
        } else {
            if (dArray == null) {
                return false;
            }
            if (this.asp.length != dArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.asp.length) {
                if (!Util.isApproximatelyEqual(this.asp[n], dArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof ProjectionControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        ProjectionControl projectionControl = (ProjectionControl)control;
        if (!this.matrixEquals(projectionControl.matrix)) {
            try {
                this.setMatrix(projectionControl.matrix);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not set matrix: " + remoteException.getMessage());
            }
        }
        if (!this.aspEquals(projectionControl.asp)) {
            try {
                this.setAspectCartesian(projectionControl.asp);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not setAspectCartesian: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ProjectionControl projectionControl = (ProjectionControl)object;
        if (!this.matrixEquals(projectionControl.matrix)) {
            return false;
        }
        return this.aspEquals(projectionControl.asp);
    }

    public Object clone() {
        ProjectionControl projectionControl = (ProjectionControl)super.clone();
        if (this.matrix != null) {
            projectionControl.matrix = (double[])this.matrix.clone();
        }
        if (this.asp != null) {
            projectionControl.asp = (double[])this.asp.clone();
        }
        return projectionControl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ProjectionControl[");
        if (this.matrix == null) {
            stringBuffer.append("null");
        } else {
            int n;
            int n2;
            if (this.matrix.length == 6) {
                n2 = 3;
                n = 2;
            } else if (this.matrix.length == 16) {
                n2 = 4;
                n = 4;
            } else {
                n2 = 1;
                n = this.matrix.length;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if (n4 > 0) {
                    stringBuffer.append(',');
                }
                int n5 = 0;
                while (n5 < n) {
                    stringBuffer.append(n5 == 0 ? (char)'(' : ',');
                    stringBuffer.append(this.matrix[n3 + n5]);
                    ++n5;
                }
                stringBuffer.append(')');
                n3 += n;
                ++n4;
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public ProjectionControl(DisplayImpl displayImpl) throws VisADException {
        super(displayImpl);
        if (displayImpl.getProjectionControl() != null) {
            throw new DisplayException("display already has a ProjectionControl");
        }
    }
}

