/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Irregular1DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class ProductSet
extends SampledSet {
    SampledSet[] Sets;

    public SampledSet[] getSets() {
        return this.Sets;
    }

    private static int find_manifold_dim(SampledSet[] sampledSetArray, Unit[] unitArray) throws VisADException {
        if (sampledSetArray == null || sampledSetArray[0] == null) {
            throw new SetException("ProductSet: Sets cannot be missing");
        }
        if (sampledSetArray.length < 2) {
            throw new SetException("ProductSet: must be at least 2 sets");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < sampledSetArray.length) {
            if (unitArray != null) {
                int n4 = sampledSetArray[n3].getDimension();
                if (n2 + n4 > unitArray.length) {
                    throw new SetException("ProductSet: Sets exceed ManifoldDimension " + unitArray.length);
                }
                Unit[] unitArray2 = sampledSetArray[n3].getSetUnits();
                if (unitArray2 == null) {
                    throw new SetException("ProductSet: Set#" + n3 + " is null");
                }
                int n5 = 0;
                while (n5 < n4) {
                    if (!(unitArray[n2 + n5] == null && unitArray2[n5] == null || unitArray[n2 + n5] != null && unitArray2[n5] != null && unitArray[n2 + n5].equals(unitArray2[n5]))) {
                        throw new SetException("ProductSet: Expected set " + n3 + ", element " + n5 + " units to be " + unitArray[n2 + n5] + " not " + unitArray2[n5]);
                    }
                    ++n5;
                }
            }
            n2 += sampledSetArray[n3].getDimension();
            n += sampledSetArray[n3].getManifoldDimension();
            ++n3;
        }
        return n;
    }

    static MathType makeType(SampledSet[] sampledSetArray) throws VisADException {
        int n = sampledSetArray.length;
        RealTupleType[] realTupleTypeArray = new RealTupleType[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            realTupleTypeArray[n3] = ((SetType)sampledSetArray[n3].getType()).getDomain();
            n2 += realTupleTypeArray[n3].getDimension();
            ++n3;
        }
        RealType[] realTypeArray = new RealType[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < realTupleTypeArray[n5].getDimension()) {
                realTypeArray[n4++] = (RealType)realTupleTypeArray[n5].getComponent(n6);
                ++n6;
            }
            ++n5;
        }
        return new SetType(new RealTupleType(realTypeArray));
    }

    public SampledSet product() throws VisADException {
        int n = this.Sets.length;
        SampledSet[] sampledSetArray = new SampledSet[n];
        int n2 = 0;
        while (n2 < n) {
            if (this.Sets[n2] instanceof GriddedSet || this.Sets[n2] instanceof IrregularSet) {
                sampledSetArray[n2] = this.Sets[n2];
            } else if (this.Sets[n2] instanceof ProductSet) {
                sampledSetArray[n2] = ((ProductSet)this.Sets[n2]).product();
            } else if (this.Sets[n2] instanceof UnionSet) {
                sampledSetArray[n2] = ((UnionSet)this.Sets[n2]).product();
            } else {
                throw new UnimplementedException("ProductSet.product: " + this.Sets[n2].getClass());
            }
            ++n2;
        }
        SampledSet sampledSet = sampledSetArray[0];
        int n3 = 1;
        while (n3 < n) {
            sampledSet = sampledSet instanceof ProductSet ? ((ProductSet)sampledSet).product(sampledSetArray[n3]) : (sampledSet instanceof UnionSet ? ((UnionSet)sampledSet).product(sampledSetArray[n3]) : (sampledSetArray[n3] instanceof ProductSet ? ((ProductSet)sampledSetArray[n3]).inverseProduct(sampledSet) : (sampledSetArray[n3] instanceof UnionSet ? ((UnionSet)sampledSetArray[n3]).inverseProduct(sampledSet) : new ProductSet(new SampledSet[]{sampledSet, sampledSetArray[n3]}))));
            ++n3;
        }
        return sampledSet;
    }

    public SampledSet product(SampledSet sampledSet) throws VisADException {
        int n = this.Sets.length;
        if (sampledSet instanceof ProductSet) {
            int n2 = ((ProductSet)sampledSet).Sets.length;
            SampledSet[] sampledSetArray = new SampledSet[n + n2];
            int n3 = 0;
            while (n3 < n) {
                sampledSetArray[n3] = this.Sets[n3];
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                sampledSetArray[n + n3] = ((ProductSet)sampledSet).Sets[n3];
                ++n3;
            }
            return new ProductSet(sampledSetArray);
        }
        if (sampledSet instanceof UnionSet) {
            int n4 = ((UnionSet)sampledSet).Sets.length;
            SampledSet[] sampledSetArray = new SampledSet[n4];
            int n5 = 0;
            while (n5 < n4) {
                sampledSetArray[n5] = this.product(((UnionSet)sampledSet).Sets[n5]);
                ++n5;
            }
            return new UnionSet(sampledSetArray);
        }
        SampledSet[] sampledSetArray = new SampledSet[n + 1];
        int n6 = 0;
        while (n6 < n) {
            sampledSetArray[n6] = this.Sets[n6];
            ++n6;
        }
        sampledSetArray[n] = sampledSet;
        return new ProductSet(sampledSetArray);
    }

    public SampledSet inverseProduct(SampledSet sampledSet) throws VisADException {
        int n = this.Sets.length;
        if (sampledSet instanceof ProductSet) {
            int n2 = ((ProductSet)sampledSet).Sets.length;
            SampledSet[] sampledSetArray = new SampledSet[n + n2];
            int n3 = 0;
            while (n3 < n2) {
                sampledSetArray[n3] = ((ProductSet)sampledSet).Sets[n3];
                ++n3;
            }
            n3 = 0;
            while (n3 < n) {
                sampledSetArray[n2 + n3] = this.Sets[n3];
                ++n3;
            }
            return new ProductSet(sampledSetArray);
        }
        if (sampledSet instanceof UnionSet) {
            int n4 = ((UnionSet)sampledSet).Sets.length;
            SampledSet[] sampledSetArray = new SampledSet[n4];
            int n5 = 0;
            while (n5 < n4) {
                sampledSetArray[n5] = this.inverseProduct(((UnionSet)sampledSet).Sets[n5]);
                ++n5;
            }
            return new UnionSet(sampledSetArray);
        }
        SampledSet[] sampledSetArray = new SampledSet[n + 1];
        sampledSetArray[0] = sampledSet;
        int n6 = 0;
        while (n6 < n) {
            sampledSetArray[n6 + 1] = this.Sets[n6];
            ++n6;
        }
        return new ProductSet(sampledSetArray);
    }

    public Set makeSpatial(SetType setType, float[][] fArray) throws VisADException {
        int n = this.Sets.length;
        int n2 = fArray.length;
        if (n2 != this.DomainDimension || n2 != 3) {
            throw new SetException("ProductSet.makeSpatial: samples bad dimension");
        }
        try {
            boolean bl = false;
            int n3 = 0;
            while (n3 < n) {
                if (this.Sets[n3] instanceof ProductSet || this.Sets[n3] instanceof UnionSet) {
                    bl = true;
                }
                ++n3;
            }
            if (bl) {
                return this.product().makeSpatial(setType, fArray);
            }
            n3 = 1;
            int[] nArray = new int[this.ManifoldDimension];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (!(this.Sets[n5] instanceof GriddedSet)) {
                    n3 = 0;
                    break;
                }
                int[] nArray2 = ((GriddedSet)this.Sets[n5]).getLengths();
                int n6 = 0;
                while (n6 < nArray2.length) {
                    nArray[n4++] = nArray2[n6];
                    ++n6;
                }
                ++n5;
            }
            if (n3 != 0) {
                return GriddedSet.create(setType, fArray, nArray);
            }
            throw new UnimplementedException("ProductSet.makeSpatial");
        }
        catch (VisADException visADException) {
            return new Irregular3DSet((MathType)setType, fArray, null, null, null, null, false);
        }
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToValue(nArray);
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n;
        int n2 = this.Sets.length;
        int n3 = nArray.length;
        int[][] nArray2 = new int[n2][n3];
        float[][] fArray = new float[this.DomainDimension][];
        int n4 = 0;
        while (n4 < n3) {
            n = nArray[n4];
            int n5 = 0;
            while (n5 < n2) {
                nArray2[n5][n4] = n % this.Sets[n5].Length;
                n /= this.Sets[n5].Length;
                ++n5;
            }
            ++n4;
        }
        n4 = 0;
        n = 0;
        while (n < n2) {
            float[][] fArray2 = this.Sets[n].indexToValue(nArray2[n]);
            int n6 = 0;
            while (n6 < fArray2.length) {
                fArray[n4++] = fArray2[n6];
                ++n6;
            }
            ++n;
        }
        return fArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        int n;
        int n2 = this.Sets.length;
        int n3 = fArray[0].length;
        int[] nArray = new int[n3];
        float[][][] fArray2 = new float[n2][][];
        int n4 = 0;
        int[][] nArray2 = new int[n2][];
        int n5 = 0;
        while (n5 < n2) {
            fArray2[n5] = new float[this.Sets[n5].DomainDimension][];
            n = 0;
            while (n < this.Sets[n5].DomainDimension) {
                fArray2[n5][n] = fArray[n4++];
                ++n;
            }
            nArray2[n5] = this.Sets[n5].valueToIndex(fArray2[n5]);
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n = 0;
            int n6 = 1;
            int n7 = 0;
            while (n7 < n2) {
                n += nArray2[n7][n5] * n6;
                n6 *= this.Sets[n7].Length;
                ++n7;
            }
            nArray[n5] = n;
            ++n5;
        }
        return nArray;
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n = this.Sets.length;
        int n2 = fArray[0].length;
        float[][][] fArray3 = new float[n][][];
        int n3 = 0;
        int[][][] nArray2 = new int[n][n2][];
        float[][][] fArray4 = new float[n][n2][];
        int n4 = 0;
        while (n4 < n) {
            fArray3[n4] = new float[this.Sets[n4].DomainDimension][];
            int n5 = 0;
            while (n5 < this.Sets[n4].DomainDimension) {
                fArray3[n4][n5] = fArray[n3++];
                ++n5;
            }
            this.Sets[n4].valueToInterp(fArray3[n4], nArray2[n4], fArray4[n4]);
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            int[] nArray3 = new int[n];
            int n6 = 1;
            int n7 = 0;
            while (n7 < n) {
                nArray3[n7] = 0;
                n6 *= nArray2[n7][n4].length;
                ++n7;
            }
            nArray[n4] = new int[n6];
            fArray2[n4] = new float[n6];
            n7 = 0;
            while (nArray3[0] < nArray2[0][n4].length) {
                int n8 = 0;
                float f = 1.0f;
                int n9 = 1;
                int n10 = 0;
                while (n10 < n) {
                    n8 += nArray2[n10][n4][nArray3[n10]] * n9;
                    f *= fArray4[n10][n4][nArray3[n10]];
                    n9 *= this.Sets[n10].Length;
                    ++n10;
                }
                nArray[n4][n7] = n8;
                fArray2[n4][n7] = f;
                ++n7;
                int n11 = n - 1;
                nArray3[n11] = nArray3[n11] + 1;
                n10 = n - 2;
                while (n10 >= 0) {
                    if (nArray3[n10 + 1] >= nArray2[n10 + 1][n4].length) {
                        nArray3[n10 + 1] = 0;
                        int n12 = n10;
                        nArray3[n12] = nArray3[n12] + 1;
                    } else {
                        n10 = 0;
                    }
                    --n10;
                }
            }
            ++n4;
        }
    }

    public Object clone() {
        try {
            return new ProductSet(this.Type, this.Sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("ProductSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new ProductSet(mathType, this.Sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProductSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ProductSet productSet = (ProductSet)object;
        if (productSet.DomainDimension != this.DomainDimension || productSet.ManifoldDimension != this.ManifoldDimension) {
            return false;
        }
        int n = 0;
        while (n < this.Sets.length) {
            if (!this.Sets[n].equals(productSet.Sets[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            int n = 0;
            while (n < this.Sets.length) {
                this.hashCode ^= this.Sets[n].hashCode();
                ++n;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public boolean isMissing() {
        int n = 0;
        while (n < this.Sets.length) {
            if (this.Sets[n].isMissing()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String longString(String string) throws VisADException {
        return string + "ProductSet: Dimension = " + this.DomainDimension + "\n";
    }

    public static void main(String[] stringArray) throws VisADException {
        RealType realType = new RealType("x", null, null);
        RealType realType2 = new RealType("y", null, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        float[][] fArray = new float[][]{{12.5f, 26.5f, 29.74f, 36.78f, 52.12f, 67.8f, 87.8f, 97.2f}, {34.2f, 36.2f, 37.2f, 32.6f, 70.87f, 73.49f, 80.32f, 77.24f}};
        Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)realTupleType, fArray, 4, 2);
        RealType[] realTypeArray2 = new RealType[]{realType};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        float[][] fArray2 = new float[][]{{-874.0f, 345.0f, -102.0f, 902.0f, -769.0f, 96.0f}};
        Irregular1DSet irregular1DSet = new Irregular1DSet((MathType)realTupleType2, fArray2);
        RealType[] realTypeArray3 = new RealType[]{realType, realType2, realType};
        RealTupleType realTupleType3 = new RealTupleType(realTypeArray3);
        SampledSet[] sampledSetArray = new SampledSet[]{gridded2DSet, irregular1DSet};
        ProductSet productSet = new ProductSet((MathType)realTupleType3, sampledSetArray);
        System.out.println("ProductSet created.");
        System.out.println("ManifoldDimension = " + productSet.getManifoldDimension());
        System.out.println("-----------------");
        System.out.println("indexToValue test:");
        int[] nArray = new int[]{0, 3, 6, 9, 12, 15, 18, 21};
        float[][] fArray3 = productSet.indexToValue(nArray);
        int n = 0;
        while (n < nArray.length) {
            System.out.print("index " + nArray[n] + " \t==> (" + fArray3[0][n]);
            int n2 = 1;
            while (n2 < fArray3.length) {
                System.out.print(", " + fArray3[n2][n]);
                ++n2;
            }
            System.out.println(")");
            ++n;
        }
        System.out.println("-----------------");
        System.out.println("valueToIndex test:");
        float[][] fArray4 = new float[][]{{10.0f, 40.0f, 90.0f, 25.0f, 50.0f, 100.0f, 30.0f, 70.0f}, {35.0f, 30.0f, 80.0f, 35.0f, 70.0f, 75.0f, 36.0f, 75.0f}, {-880.0f, -890.0f, -870.0f, 350.0f, 340.0f, 360.0f, -100.0f, -110.0f}};
        int[] nArray2 = productSet.valueToIndex(fArray4);
        int n3 = 0;
        while (n3 < nArray2.length) {
            System.out.print("(" + fArray4[0][n3]);
            int n4 = 1;
            while (n4 < fArray4.length) {
                System.out.print(", " + fArray4[n4][n3]);
                ++n4;
            }
            System.out.println(")\t==> index " + nArray2[n3]);
            ++n3;
        }
        System.out.println("------------------");
        System.out.println("valueToInterp test:");
        float[][] fArray5 = new float[][]{{15.0f, 50.0f, 80.0f, 25.0f, 50.0f, 100.0f, 30.0f, 70.0f}, {45.0f, 40.0f, 70.0f, 35.0f, 70.0f, 75.0f, 36.0f, 65.0f}, {-800.0f, -750.0f, -810.0f, 300.0f, 245.0f, 200.0f, -150.0f, -120.0f}};
        int[][] nArray3 = new int[fArray5[0].length][];
        float[][] fArray6 = new float[fArray5[0].length][];
        productSet.valueToInterp(fArray5, nArray3, fArray6);
        int n5 = 0;
        while (n5 < fArray5[0].length) {
            System.out.print("(" + fArray5[0][n5]);
            int n6 = 1;
            while (n6 < fArray5.length) {
                System.out.print(", " + fArray5[n6][n5]);
                ++n6;
            }
            System.out.print(")\t==> indices [" + nArray3[n5][0]);
            n6 = 1;
            while (n6 < nArray3[n5].length) {
                System.out.print(", " + nArray3[n5][n6]);
                ++n6;
            }
            System.out.print("], ");
            System.out.print(" weight total = ");
            float f = 0.0f;
            int n7 = 0;
            while (n7 < fArray6[n5].length) {
                f += fArray6[n5][n7];
                ++n7;
            }
            System.out.println(f);
            ++n5;
        }
        System.out.println();
    }

    public ProductSet(SampledSet[] sampledSetArray) throws VisADException {
        this(ProductSet.makeType(sampledSetArray), sampledSetArray, null, null, null, true);
    }

    public ProductSet(MathType mathType, SampledSet[] sampledSetArray) throws VisADException {
        this(mathType, sampledSetArray, null, null, null, true);
    }

    public ProductSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, sampledSetArray, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    ProductSet(MathType mathType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, ProductSet.find_manifold_dim(sampledSetArray, unitArray), coordinateSystem, unitArray, errorEstimateArray);
        int n = 0;
        int n2 = 0;
        while (n2 < sampledSetArray.length) {
            n += sampledSetArray[n2].DomainDimension;
            ++n2;
        }
        if (n != this.DomainDimension) {
            throw new SetException("ProductSet: DomainDimension does not match");
        }
        if (bl) {
            this.Sets = new SampledSet[sampledSetArray.length];
            n2 = 0;
            while (n2 < sampledSetArray.length) {
                this.Sets[n2] = (SampledSet)sampledSetArray[n2].clone();
                ++n2;
            }
        } else {
            this.Sets = sampledSetArray;
        }
        this.Length = 1;
        n2 = 0;
        while (n2 < sampledSetArray.length) {
            this.Length *= sampledSetArray[n2].Length;
            ++n2;
        }
        this.Low = new float[this.DomainDimension];
        this.Hi = new float[this.DomainDimension];
        n2 = 0;
        int n3 = 0;
        while (n3 < sampledSetArray.length) {
            float[] fArray = sampledSetArray[n3].getLow();
            float[] fArray2 = sampledSetArray[n3].getHi();
            int n4 = sampledSetArray[n3].getDimension();
            int n5 = 0;
            while (n5 < n4) {
                this.Low[n2 + n5] = fArray[n5];
                this.Hi[n2 + n5] = fArray2[n5];
                ++n5;
            }
            n2 += n4;
            ++n3;
        }
    }
}

