/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class PolarCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.degree, null};

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            if (dArray[1][n2] < 0.0) {
                dArray2[0][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
            } else {
                double d = Math.cos(Math.PI / 180 * dArray[0][n2]);
                double d2 = Math.sin(Math.PI / 180 * dArray[0][n2]);
                dArray2[0][n2] = dArray[1][n2] * d;
                dArray2[1][n2] = dArray[1][n2] * d2;
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[1][n2] = Math.sqrt(dArray[0][n2] * dArray[0][n2] + dArray[1][n2] * dArray[1][n2]);
            dArray2[0][n2] = 57.29577951308232 * Math.atan2(dArray[1][n2], dArray[0][n2]);
            if (dArray2[0][n2] < 0.0) {
                double[] dArray3 = dArray2[0];
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + 360.0;
            }
            ++n2;
        }
        return dArray2;
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[2][n];
        int n2 = 0;
        while (n2 < n) {
            if ((double)fArray[1][n2] < 0.0) {
                fArray2[0][n2] = Float.NaN;
                fArray2[1][n2] = Float.NaN;
            } else {
                float f = (float)Math.cos(Math.PI / 180 * (double)fArray[0][n2]);
                float f2 = (float)Math.sin(Math.PI / 180 * (double)fArray[0][n2]);
                fArray2[0][n2] = fArray[1][n2] * f;
                fArray2[1][n2] = fArray[1][n2] * f2;
            }
            ++n2;
        }
        return fArray2;
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[2][n];
        int n2 = 0;
        while (n2 < n) {
            fArray2[1][n2] = (float)Math.sqrt(fArray[0][n2] * fArray[0][n2] + fArray[1][n2] * fArray[1][n2]);
            fArray2[0][n2] = (float)(57.29577951308232 * Math.atan2(fArray[1][n2], fArray[0][n2]));
            if ((double)fArray2[0][n2] < 0.0) {
                float[] fArray3 = fArray2[0];
                int n3 = n2;
                fArray3[n3] = (float)((double)fArray3[n3] + 360.0);
            }
            ++n2;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof PolarCoordinateSystem;
    }

    public PolarCoordinateSystem(RealTupleType realTupleType) throws VisADException {
        super(realTupleType, coordinate_system_units);
    }
}

