/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Vector;
import visad.DelaunayCustom;
import visad.TextControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.browser.Convert;
import visad.util.HersheyFont;

public class PlotText {
    static final double XMIN = -1.0;
    static final double YMIN = -1.0;
    static final double ZMIN = -1.0;
    static final double WIDTH = 0.8;
    static double[] bx = new double[]{0.07, 0.0, 0.0};
    static double[] ux = new double[]{0.0, 0.07, 0.07};
    static double[] by = new double[]{0.0, 0.07, 0.0};
    static double[] uy = new double[]{-0.07, 0.0, -0.07};
    static double[] bz = new double[]{0.0, 0.0, -0.07};
    static double[] uz = new double[]{0.07, 0.07, 0.0};
    static float[][] charCodes = new float[][]{{100.0f, 0.0f}, {101.0f, 8.0f, 1.0f, 3.0f, 3.0f, 3.0f, 3.0f, 8.0f, 1.0f, 8.0f, 101.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 3.0f, 1.0f, 1.0f, 1.0f}, {101.0f, 8.0f, 0.0f, 5.0f, 104.0f, 8.0f, 3.0f, 5.0f}, {101.5f, 8.0f, 1.5f, 0.0f, 103.5f, 8.0f, 3.5f, 0.0f, 100.0f, 5.0f, 5.0f, 5.0f, 100.0f, 3.0f, 5.0f, 3.0f}, {101.5f, 8.0f, 1.5f, 0.0f, 102.5f, 8.0f, 2.5f, 0.0f, 104.0f, 5.5f, 3.0f, 7.0f, 1.0f, 7.0f, 0.0f, 5.5f, 0.0f, 4.5f, 4.0f, 3.5f, 4.0f, 2.5f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f, 2.5f}, {100.0f, 8.0f, 0.0f, 7.0f, 1.0f, 7.0f, 1.0f, 8.0f, 0.0f, 8.0f, 105.0f, 8.0f, 0.0f, 0.0f, 104.0f, 1.0f, 4.0f, 0.0f, 5.0f, 0.0f, 5.0f, 1.0f, 4.0f, 1.0f}, {105.0f, 0.0f, 0.0f, 5.0f, 0.0f, 7.0f, 1.0f, 8.0f, 3.0f, 8.0f, 4.0f, 7.0f, 4.0f, 5.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 4.0f}, {101.0f, 8.0f, 0.0f, 5.0f}, {104.0f, 8.0f, 2.0f, 6.0f, 2.0f, 2.0f, 4.0f, 0.0f}, {101.0f, 8.0f, 3.0f, 6.0f, 3.0f, 2.0f, 1.0f, 0.0f}, {100.0f, 7.0f, 5.0f, 1.0f, 102.5f, 7.0f, 2.5f, 1.0f, 100.0f, 1.0f, 5.0f, 7.0f, 105.0f, 4.0f, 0.0f, 4.0f}, {102.5f, 7.0f, 2.5f, 1.0f, 100.0f, 4.0f, 5.0f, 4.0f}, {103.0f, 0.0f, 2.0f, 0.0f, 2.0f, 1.0f, 3.0f, 1.0f, 3.0f, 0.0f, 2.1f, -2.0f}, {100.0f, 4.0f, 5.0f, 4.0f}, {102.0f, 0.0f, 3.0f, 0.0f, 3.0f, 1.0f, 2.0f, 1.0f, 2.0f, 0.0f}, {100.0f, 0.0f, 5.0f, 8.0f}, {102.0f, 8.0f, 0.0f, 6.0f, 0.0f, 2.0f, 2.0f, 0.0f, 3.0f, 0.0f, 5.0f, 2.0f, 5.0f, 6.0f, 3.0f, 8.0f, 2.0f, 8.0f}, {101.0f, 7.0f, 2.5f, 8.0f, 2.5f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 3.0f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f}, {103.0f, 8.0f, 0.0f, 4.0f, 5.0f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 0.0f, 5.0f, 0.0f, 8.0f, 5.0f, 8.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 0.0f, 4.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 3.0f, 0.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 4.0f, 4.0f, 5.0f, 5.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 101.0f, 4.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f}, {101.0f, 0.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 5.0f, 4.0f}, {102.0f, 7.0f, 2.0f, 5.0f, 3.0f, 5.0f, 3.0f, 7.0f, 2.0f, 7.0f, 102.0f, 3.0f, 2.0f, 1.0f, 3.0f, 1.0f, 3.0f, 3.0f, 2.0f, 3.0f}, {100.0f, 7.0f, 0.0f, 5.0f, 1.0f, 5.0f, 1.0f, 7.0f, 0.0f, 7.0f, 100.0f, 0.0f, 1.0f, 1.0f, 1.0f, 3.0f, 0.0f, 3.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {105.0f, 7.0f, 0.0f, 4.0f, 5.0f, 1.0f}, {100.0f, 5.0f, 5.0f, 5.0f, 100.0f, 3.0f, 5.0f, 3.0f}, {100.0f, 7.0f, 5.0f, 4.0f, 0.0f, 1.0f}, {100.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 2.5f, 4.0f, 2.5f, 2.0f, 102.5f, 1.0f, 2.5f, 0.0f}, {104.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 3.0f, 4.0f, 1.5f, 3.0f, 2.0f, 1.5f, 4.0f, 1.5f, 5.0f, 2.5f, 6.0f, 4.0f, 5.0f, 3.0f, 2.0f}, {100.0f, 0.0f, 0.0f, 7.0f, 1.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 0.0f, 5.0f, 4.0f, 0.0f, 4.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 5.0f, 5.0f, 5.0f, 7.0f, 4.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 4.0f, 4.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 0.0f, 8.0f}, {105.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 3.0f, 4.0f, 0.0f, 4.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {105.0f, 8.0f, 0.0f, 8.0f, 0.0f, 4.0f, 3.0f, 4.0f, 0.0f, 4.0f, 0.0f, 0.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 3.0f, 4.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 4.0f, 5.0f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 2.5f, 8.0f, 2.5f, 0.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {105.0f, 8.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 3.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 4.0f, 5.0f, 8.0f, 0.0f, 4.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 2.5f, 4.0f, 5.0f, 8.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 0.0f, 4.0f}, {101.0f, 8.0f, 0.0f, 7.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 103.0f, 3.0f, 5.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 8.0f, 4.0f, 8.0f, 5.0f, 7.0f, 5.0f, 5.0f, 4.0f, 4.0f, 0.0f, 4.0f, 3.0f, 4.0f, 5.0f, 0.0f}, {105.0f, 7.0f, 4.0f, 8.0f, 1.0f, 8.0f, 0.0f, 7.0f, 0.0f, 5.0f, 1.0f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 2.5f, 8.0f, 2.5f, 0.0f}, {100.0f, 8.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 2.5f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 2.5f, 4.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 5.0f, 0.0f, 100.0f, 0.0f, 5.0f, 8.0f}, {100.0f, 8.0f, 2.5f, 4.0f, 5.0f, 8.0f, 2.5f, 4.0f, 2.5f, 0.0f}, {100.0f, 8.0f, 5.0f, 8.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {104.0f, 8.0f, 2.0f, 8.0f, 2.0f, 0.0f, 4.0f, 0.0f}, {100.0f, 8.0f, 5.0f, 0.0f}, {101.0f, 8.0f, 3.0f, 8.0f, 3.0f, 0.0f, 1.0f, 0.0f}, {102.0f, 6.0f, 3.0f, 8.0f, 4.0f, 6.0f}, {100.0f, -2.0f, 5.0f, -2.0f}, {102.0f, 8.0f, 4.0f, 6.0f}, {104.0f, 5.0f, 4.0f, 1.0f, 3.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 4.0f, 4.0f, 4.0f, 1.0f, 5.0f, 0.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 0.0f, 3.0f}, {105.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f}, {105.0f, 3.0f, 3.0f, 5.0f, 1.0f, 5.0f, 0.0f, 4.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 0.0f, 5.0f, 8.0f}, {105.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 4.0f, 3.0f, 0.0f, 3.0f}, {103.0f, 0.0f, 3.0f, 7.0f, 4.0f, 8.0f, 5.0f, 8.0f, 5.0f, 7.0f, 101.0f, 4.0f, 4.0f, 4.0f}, {105.0f, 5.0f, 5.0f, -3.0f, 4.0f, -4.0f, 1.0f, -4.0f, 105.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 5.0f, 3.0f}, {100.0f, 8.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 0.0f}, {103.0f, 4.0f, 3.0f, 0.0f, 4.0f, 0.0f, 1.0f, 0.0f, 103.0f, 6.5f, 3.0f, 5.5f}, {104.0f, 4.0f, 4.0f, -3.0f, 3.0f, -4.0f, 1.0f, -4.0f, 0.0f, -3.0f, 0.0f, -1.0f, 1.0f, 0.0f, 104.0f, 6.5f, 4.0f, 5.5f}, {101.0f, 8.0f, 1.0f, 0.0f, 101.0f, 3.0f, 5.0f, 5.0f, 101.0f, 3.0f, 5.0f, 0.0f}, {102.0f, 8.0f, 3.0f, 8.0f, 3.0f, 0.0f}, {100.0f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 0.0f, 102.5f, 5.0f, 2.5f, 2.0f}, {100.0f, 0.0f, 0.0f, 5.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 3.0f, 5.0f, 0.0f}, {101.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f}, {100.0f, -4.0f, 0.0f, 1.0f, 1.0f, 0.0f, 4.0f, 0.0f, 5.0f, 1.0f, 5.0f, 4.0f, 4.0f, 5.0f, 3.0f, 5.0f, 0.0f, 3.0f, 0.0f, 1.0f, 0.0f, 5.0f}, {105.0f, -4.0f, 5.0f, 1.0f, 4.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 4.0f, 1.0f, 5.0f, 3.0f, 5.0f, 5.0f, 3.0f, 5.0f, 1.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 5.0f, 4.0f, 5.0f, 5.0f, 4.0f}, {105.0f, 4.0f, 3.0f, 5.0f, 2.0f, 5.0f, 0.0f, 4.0f, 0.0f, 3.0f, 5.0f, 2.0f, 5.0f, 1.0f, 3.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f}, {102.5f, 8.0f, 2.5f, 0.0f, 100.5f, 5.0f, 4.5f, 5.0f}, {100.0f, 5.0f, 0.0f, 1.0f, 1.0f, 0.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f, 5.0f, 0.0f}, {100.0f, 5.0f, 0.0f, 3.0f, 2.5f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 0.0f, 0.0f, 2.5f, 3.0f, 5.0f, 0.0f, 5.0f, 5.0f}, {100.0f, 5.0f, 5.0f, 0.0f, 105.0f, 5.0f, 0.0f, 0.0f}, {100.0f, 5.0f, 0.0f, 3.0f, 3.0f, 0.0f, 5.0f, 3.0f, 5.0f, 5.0f, 5.0f, -3.0f, 3.0f, -4.0f}, {100.0f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 5.0f, 0.0f}, {104.0f, 8.0f, 3.0f, 8.0f, 2.0f, 4.5f, 1.0f, 4.5f, 2.0f, 4.5f, 3.0f, 0.0f, 4.0f, 0.0f}, {103.5f, 8.0f, 3.5f, 0.0f}, {102.0f, 8.0f, 3.0f, 8.0f, 4.0f, 4.5f, 5.0f, 4.5f, 4.0f, 4.5f, 3.0f, 0.0f, 2.0f, 0.0f}, {100.0f, 4.0f, 1.0f, 5.0f, 3.0f, 4.0f, 4.0f, 5.0f}, {100.0f, 0.0f}};

    public static VisADLineArray render_label(int n, double d, String string, int n2, long l) {
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        double[] dArray = new double[]{0.07, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.07, 0.07};
        double[] dArray3 = new double[]{0.0, 0.07, 0.0};
        double[] dArray4 = new double[]{-0.07, 0.0, -0.07};
        double[] dArray5 = new double[]{0.0, 0.0, -0.07};
        double[] dArray6 = new double[]{0.07, 0.07, 0.0};
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = new double[3];
        if (n == 0) {
            dArray7 = dArray;
            dArray8 = dArray2;
            dArray9[0] = d;
            dArray9[1] = d3 * (1.1 + 0.07 * (double)n2);
            dArray9[2] = d4 * (1.1 + 0.07 * (double)n2);
        } else if (n == 1) {
            dArray7 = dArray3;
            dArray8 = dArray4;
            dArray9[0] = d2 * (1.1 + 0.07 * (double)n2);
            dArray9[1] = d;
            dArray9[2] = d4 * (1.1 + 0.07 * (double)n2);
        } else if (n == 2) {
            dArray7 = dArray5;
            dArray8 = dArray6;
            dArray9[0] = d2 * (1.1 + 0.07 * (double)n2);
            dArray9[1] = d3 * (1.1 + 0.07 * (double)n2);
            dArray9[2] = d;
        }
        return PlotText.render_label(string, dArray9, dArray7, dArray8, TextControl.Justification.CENTER);
    }

    public static VisADLineArray render_label(String string, double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        return PlotText.render_label(string, dArray, dArray2, dArray3, bl ? TextControl.Justification.CENTER : TextControl.Justification.LEFT);
    }

    public static VisADLineArray render_label(String string, double[] dArray, double[] dArray2, double[] dArray3, TextControl.Justification justification) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = dArray[0];
        double d6 = dArray[1];
        double d7 = dArray[2];
        int n = string.length();
        float[] fArray = new float[120 * n];
        if (justification == TextControl.Justification.CENTER) {
            d = 0.8 * (double)n;
            d5 -= d * dArray2[0] / 2.0;
            d6 -= d * dArray2[1] / 2.0;
            d7 -= d * dArray2[2] / 2.0;
        } else if (justification == TextControl.Justification.RIGHT) {
            d = 0.8 * (double)n;
            d5 -= d * dArray2[0];
            d6 -= d * dArray2[1];
            d7 -= d * dArray2[2];
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string.charAt(n3) - 32;
            if (n4 >= 0 && n4 <= 127) {
                int n5 = charCodes[n4].length / 2;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n5) {
                    double d8;
                    if (n5 == 1) break;
                    boolean bl = true;
                    if (n7 == n5 - 1) {
                        bl = false;
                    }
                    if ((d8 = (double)charCodes[n4][n6] * 0.1) > 9.0) {
                        if (n7 != 0) {
                            n2 -= 3;
                        }
                        d8 -= 10.0;
                        bl = false;
                    }
                    double d9 = (double)charCodes[n4][++n6] * 0.1;
                    ++n6;
                    fArray[n2] = (float)(d5 + d8 * dArray2[0] + d9 * dArray3[0]);
                    fArray[n2 + 1] = (float)(d6 + d8 * dArray2[1] + d9 * dArray3[1]);
                    fArray[n2 + 2] = (float)(d7 + d8 * dArray2[2] + d9 * dArray3[2]);
                    if (bl) {
                        fArray[n2 + 3] = fArray[n2];
                        fArray[n2 + 4] = fArray[n2 + 1];
                        fArray[n2 + 5] = fArray[n2 + 2];
                        n2 += 3;
                    }
                    n2 += 3;
                    ++n7;
                }
                d5 += 0.8 * dArray2[0];
                d6 += 0.8 * dArray2[1];
                d7 += 0.8 * dArray2[2];
            }
            ++n3;
        }
        if (n2 <= 0) {
            return null;
        }
        VisADLineArray visADLineArray = new VisADLineArray();
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        visADLineArray.coordinates = fArray2;
        visADLineArray.vertexCount = n2 / 3;
        return visADLineArray;
    }

    public static String shortString(double d) {
        return Convert.shortString(d);
    }

    public static VisADLineArray render_font(String string, HersheyFont hersheyFont, double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        return PlotText.render_font(string, hersheyFont, dArray, dArray2, dArray3, bl ? TextControl.Justification.CENTER : TextControl.Justification.LEFT);
    }

    public static VisADLineArray render_font(String string, HersheyFont hersheyFont, double[] dArray, double[] dArray2, double[] dArray3, TextControl.Justification justification) {
        int n;
        int n2 = hersheyFont.getCharactersInSet();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = dArray[0];
        double d6 = dArray[1];
        double d7 = dArray[2];
        int n3 = string.length();
        int n4 = hersheyFont.getMaxPoints();
        float[] fArray = new float[n4 * 6 * n3];
        int n5 = 0;
        int[] nArray = hersheyFont.getCharacterMinX();
        int[] nArray2 = hersheyFont.getCharacterMaxX();
        int n6 = hersheyFont.getCharacterSetMinY();
        int n7 = hersheyFont.getCharacterSetMaxY();
        int n8 = hersheyFont.getCharacterSetMinX();
        int n9 = hersheyFont.getCharacterSetMaxX();
        boolean bl = hersheyFont.getIsCursive();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n10 = 0;
        while (n10 < n3) {
            int n11 = string.charAt(n10) - 32;
            if (n11 >= 0 && n11 <= n2) {
                char[][] cArray = hersheyFont.getCharacterVector(n11);
                n = hersheyFont.getNumberOfPoints(n11);
                if (n10 > 0) {
                    d = 0.08;
                    if (bl) {
                        d = -0.08;
                    }
                    d5 += d * dArray2[0];
                    d6 += d * dArray2[1];
                    d7 += d * dArray2[2];
                }
                boolean bl2 = true;
                float f4 = 0.0f;
                int n12 = 1;
                while (n12 < n) {
                    if (cArray[0][n12] == ' ') {
                        bl2 = true;
                    } else {
                        float f5 = (float)(cArray[0][n12] - nArray[n11]) / (float)(nArray2[n11] - nArray[n11]);
                        if (f5 > f4) {
                            f4 = f5;
                        }
                        float f6 = (float)(n7 - cArray[1][n12]) / (float)(n7 - n6);
                        float f7 = (float)(d5 + (double)f5 * dArray2[0] + (double)f6 * dArray3[0]);
                        float f8 = (float)(d6 + (double)f5 * dArray2[1] + (double)f6 * dArray3[1]);
                        float f9 = (float)(d7 + (double)f5 * dArray2[2] + (double)f6 * dArray3[2]);
                        if (!bl2) {
                            fArray[n5] = f;
                            fArray[n5 + 1] = f2;
                            fArray[n5 + 2] = f3;
                            fArray[n5 + 3] = f7;
                            fArray[n5 + 4] = f8;
                            fArray[n5 + 5] = f9;
                            n5 += 6;
                        }
                        bl2 = false;
                        f = f7;
                        f2 = f8;
                        f3 = f9;
                    }
                    ++n12;
                }
                if (n == 1) {
                    f4 = 0.5f;
                }
                d5 += (d += (double)f4) * dArray2[0];
                d6 += d * dArray2[1];
                d7 += d * dArray2[2];
            }
            ++n10;
        }
        if (n5 <= 0) {
            return null;
        }
        float f10 = Float.NaN;
        float f11 = Float.NaN;
        float f12 = Float.NaN;
        if (justification == TextControl.Justification.CENTER) {
            f10 = (float)((d5 - dArray[0]) / 2.0);
            f11 = (float)((d6 - dArray[1]) / 2.0);
            f12 = (float)((d7 - dArray[2]) / 2.0);
        } else if (justification == TextControl.Justification.RIGHT) {
            f10 = (float)(d5 - dArray[0]);
            f11 = (float)(d6 - dArray[1]);
            f12 = (float)(d7 - dArray[2]);
        }
        if (f10 == f10) {
            n = 0;
            while (n < n5) {
                fArray[n] = fArray[n] - f10;
                fArray[n + 1] = fArray[n + 1] - f11;
                fArray[n + 2] = fArray[n + 2] - f12;
                n += 3;
            }
        }
        VisADLineArray visADLineArray = new VisADLineArray();
        float[] fArray2 = new float[n5];
        System.arraycopy(fArray, 0, fArray2, 0, n5);
        visADLineArray.coordinates = fArray2;
        visADLineArray.vertexCount = n5 / 3;
        return visADLineArray;
    }

    public static VisADTriangleArray render_font(String string, Font font, double[] dArray, double[] dArray2, double[] dArray3, boolean bl) {
        return PlotText.render_font(string, font, dArray, dArray2, dArray3, bl ? TextControl.Justification.CENTER : TextControl.Justification.LEFT);
    }

    public static VisADTriangleArray render_font(String string, Font font, double[] dArray, double[] dArray2, double[] dArray3, TextControl.Justification justification) {
        int n;
        Object[] objectArray;
        VisADTriangleArray visADTriangleArray = null;
        float f = font.getSize();
        float f2 = 1.0f / f;
        AffineTransform affineTransform = null;
        boolean bl = false;
        boolean bl2 = false;
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, bl, bl2);
        double d = 0.05;
        Vector<Object> vector = new Vector<Object>();
        int n2 = 1000;
        float[][] fArray = new float[2][n2];
        float[] fArray2 = new float[6];
        int n3 = string.length();
        float f3 = 0.0f;
        int n4 = 0;
        while (n4 < n3) {
            objectArray = new char[]{string.charAt(n4)};
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, (char[])objectArray);
            int n5 = glyphVector.getNumGlyphs();
            if (n5 != 0) {
                int n6 = 0;
                Vector<float[][]> vector2 = new Vector<float[][]>();
                float f4 = f2 * glyphVector.getGlyphMetrics(0).getAdvance();
                int n7 = 0;
                while (n7 < n5) {
                    Shape shape = glyphVector.getGlyphOutline(n7);
                    PathIterator pathIterator = shape.getPathIterator(affineTransform, d);
                    n = 0;
                    while (!pathIterator.isDone()) {
                        int n8 = pathIterator.currentSegment(fArray2);
                        switch (n8) {
                            case 0: {
                                float[][] fArray3;
                                if (n > 0) {
                                    fArray3 = new float[2][n];
                                    System.arraycopy(fArray[0], 0, fArray3[0], 0, n);
                                    System.arraycopy(fArray[1], 0, fArray3[1], 0, n);
                                    vector2.addElement(fArray3);
                                    n = 0;
                                    ++n6;
                                }
                            }
                            case 1: {
                                fArray[0][n] = f3 + f2 * fArray2[0];
                                fArray[1][n] = -f2 * fArray2[1];
                                if (++n < n2) break;
                                float[][] fArray3 = new float[2][2 * n2];
                                System.arraycopy(fArray[0], 0, fArray3[0], 0, n2);
                                System.arraycopy(fArray[1], 0, fArray3[1], 0, n2);
                                fArray = fArray3;
                                n2 = 2 * n2;
                                break;
                            }
                            case 4: {
                                if (n <= 0) break;
                                float[][] fArray3 = new float[2][n];
                                System.arraycopy(fArray[0], 0, fArray3[0], 0, n);
                                System.arraycopy(fArray[1], 0, fArray3[1], 0, n);
                                vector2.addElement(fArray3);
                                n = 0;
                                ++n6;
                                break;
                            }
                        }
                        pathIterator.next();
                    }
                    if (n > 0) {
                        float[][] fArray4 = new float[2][n];
                        System.arraycopy(fArray[0], 0, fArray4[0], 0, n);
                        System.arraycopy(fArray[1], 0, fArray4[1], 0, n);
                        vector2.addElement(fArray4);
                        n = 0;
                        ++n6;
                    }
                    ++n7;
                }
                if (n6 == 1) {
                    vector.addElement(vector2.elementAt(0));
                } else if (n6 > 1) {
                    float[][][] fArray5 = new float[n6][][];
                    int n9 = 0;
                    while (n9 < n6) {
                        fArray5[n9] = (float[][])vector2.elementAt(n9);
                        ++n9;
                    }
                    try {
                        if (n6 == 2 && !DelaunayCustom.inside(fArray5[0], fArray5[1][0][0], fArray5[1][1][0]) && !DelaunayCustom.inside(fArray5[1], fArray5[0][0][0], fArray5[0][1][0])) {
                            n9 = 0;
                            while (n9 < n6) {
                                vector.addElement(fArray5[n9]);
                                ++n9;
                            }
                        } else {
                            vector.addElement(DelaunayCustom.link(fArray5));
                        }
                    }
                    catch (VisADException visADException) {
                        System.out.println(visADException);
                    }
                }
                vector2.removeAllElements();
                f3 += f4;
            }
            ++n4;
        }
        f3 = justification == TextControl.Justification.LEFT ? 0.0f : (justification == TextControl.Justification.CENTER ? -0.5f * f3 : -1.0f * f3);
        n4 = vector.size();
        objectArray = new VisADTriangleArray[n4];
        int n10 = 0;
        while (n10 < n4) {
            float[][] fArray6 = (float[][])vector.elementAt(n10);
            int[][] nArray = null;
            try {
                nArray = DelaunayCustom.fillCheck(fArray6, false);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
            if (nArray != null && nArray.length != 0) {
                int n11 = nArray.length;
                float[] fArray7 = new float[9 * n11];
                int n12 = 0;
                while (n12 < n11) {
                    int n13 = 9 * n12;
                    int n14 = 0;
                    while (n14 < 3) {
                        n = n13 + 3 * n14;
                        fArray7[n] = (float)(dArray[0] + dArray2[0] * (double)(fArray6[0][nArray[n12][n14]] + f3) + dArray3[0] * (double)fArray6[1][nArray[n12][n14]]);
                        fArray7[n + 1] = (float)(dArray[1] + dArray2[1] * (double)(fArray6[0][nArray[n12][n14]] + f3) + dArray3[1] * (double)fArray6[1][nArray[n12][n14]]);
                        fArray7[n + 2] = (float)(dArray[2] + dArray2[2] * (double)(fArray6[0][nArray[n12][n14]] + f3) + dArray3[2] * (double)fArray6[1][nArray[n12][n14]]);
                        ++n14;
                    }
                    ++n12;
                }
                float[] fArray8 = new float[9 * n11];
                int n15 = 0;
                while (n15 < 3 * n11) {
                    int n16 = 3 * n15;
                    fArray8[n16] = 0.0f;
                    fArray8[n16 + 1] = 0.0f;
                    fArray8[n16 + 2] = 1.0f;
                    ++n15;
                }
                objectArray[n10] = (char)new VisADTriangleArray();
                objectArray[n10].vertexCount = 3 * n11;
                objectArray[n10].coordinates = fArray7;
                objectArray[n10].normals = fArray8;
            }
            ++n10;
        }
        visADTriangleArray = new VisADTriangleArray();
        try {
            VisADGeometryArray.merge((VisADGeometryArray[])objectArray, visADTriangleArray);
        }
        catch (VisADException visADException) {
            visADTriangleArray = new VisADTriangleArray();
        }
        if (visADTriangleArray.coordinates == null) {
            return null;
        }
        return visADTriangleArray;
    }
}

