/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class OffsetUnit
extends Unit
implements Serializable {
    private static SimpleDateFormat dateFormat;
    private static double offsetUnitOrigin;
    private static Unit millisecond;
    final ScaledUnit scaledUnit;
    final double offset;

    protected boolean isTime() {
        return SI.second.isConvertible(this.scaledUnit);
    }

    protected Unit protectedClone(String string) {
        return new OffsetUnit(0.0, this, string);
    }

    public Unit pow(int n) {
        return this.scaledUnit.pow(n);
    }

    public Unit root(int n) throws IllegalArgumentException {
        return this.scaledUnit.root(n);
    }

    public Unit pow(double d) {
        return this.scaledUnit.pow(d);
    }

    public String getDefinition() {
        String string;
        String string2 = this.scaledUnit.toString();
        if (string2.indexOf(32) != -1) {
            string2 = "(" + string2 + ")";
        }
        if (!this.isTime()) {
            string = string2 + " @ " + this.offset;
        } else {
            try {
                string = string2 + " since " + dateFormat.format(new Date((long)(millisecond.toThis(this.offset, (Unit)this.scaledUnit) + offsetUnitOrigin)));
            }
            catch (UnitException unitException) {
                string = unitException.toString();
            }
        }
        return string;
    }

    public Unit multiply(Unit unit) throws UnitException {
        return unit.multiply(this.scaledUnit);
    }

    public Unit divide(Unit unit) throws UnitException {
        return unit.divideInto(this.scaledUnit);
    }

    protected Unit divideInto(Unit unit) throws UnitException {
        return unit.divide(this.scaledUnit);
    }

    public double[] toThis(double[] dArray, Unit unit) throws UnitException {
        double[] dArray2 = unit.toThat(dArray, (Unit)this.scaledUnit);
        int n = 0;
        while (n < dArray2.length) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] - this.offset;
        }
        return dArray2;
    }

    public float[] toThis(float[] fArray, Unit unit) throws UnitException {
        float[] fArray2 = unit.toThat(fArray, (Unit)this.scaledUnit);
        int n = 0;
        while (n < fArray2.length) {
            int n2 = n++;
            fArray2[n2] = (float)((double)fArray2[n2] - this.offset);
        }
        return fArray2;
    }

    public double[] toThat(double[] dArray, Unit unit) throws UnitException {
        double[] dArray2 = (double[])dArray.clone();
        int n = 0;
        while (n < dArray2.length) {
            int n2 = n++;
            dArray2[n2] = dArray2[n2] + this.offset;
        }
        return unit.toThis(dArray2, (Unit)this.scaledUnit);
    }

    public float[] toThat(float[] fArray, Unit unit) throws UnitException {
        float[] fArray2 = (float[])fArray.clone();
        int n = 0;
        while (n < fArray2.length) {
            int n2 = n++;
            fArray2[n2] = (float)((double)fArray2[n2] + this.offset);
        }
        return unit.toThis(fArray2, (Unit)this.scaledUnit);
    }

    public Unit getAbsoluteUnit() {
        return this.scaledUnit.getAbsoluteUnit();
    }

    public boolean isConvertible(Unit unit) {
        return this.scaledUnit.isConvertible(unit);
    }

    public static void main(String[] stringArray) throws UnitException {
        BaseUnit baseUnit = SI.kelvin;
        OffsetUnit offsetUnit = new OffsetUnit(273.15, baseUnit);
        ScaledUnit scaledUnit = new ScaledUnit(0.5555555555555556, baseUnit);
        OffsetUnit offsetUnit2 = new OffsetUnit(459.67, scaledUnit);
        Unit unit = ((Unit)offsetUnit2).pow(2);
        System.out.println("degC=\"" + offsetUnit + "\"");
        System.out.println("degF=\"" + offsetUnit2 + "\"");
        System.out.println("degF.toThis(0,degC)=" + offsetUnit2.toThis(0.0, (Unit)offsetUnit));
        System.out.println("degF.toThat(32,degC)=" + offsetUnit2.toThat(32.0, (Unit)offsetUnit));
        double[] dArray = ((Unit)offsetUnit2).toThis(new double[]{0.0, 100.0}, (Unit)offsetUnit);
        System.out.println("degF.toThis({0,100},degC)=" + dArray[0] + "," + dArray[1]);
        dArray = ((Unit)offsetUnit2).toThat(new double[]{32.0, 212.0}, (Unit)offsetUnit);
        System.out.println("degF.toThat({32,212},degC)=" + dArray[0] + "," + dArray[1]);
        System.out.println("degF.pow(2)=" + ((Unit)offsetUnit2).pow(2));
        System.out.println("degF.multiply(degC)=" + ((Unit)offsetUnit2).multiply(offsetUnit));
        System.out.println("degC.multiply(degF)=" + ((Unit)offsetUnit).multiply(offsetUnit2));
        System.out.println("degF.divide(degC)=" + ((Unit)offsetUnit2).divide(offsetUnit));
        System.out.println("degC.divide(degF)=" + ((Unit)offsetUnit).divide(offsetUnit2));
        System.out.println("degF2.pow(0.5)=" + unit.pow(0.5));
        System.out.println("new OffsetUnit(0,SI.second).toString()=" + new OffsetUnit(0.0, SI.second).toString());
        System.out.println("new OffsetUnit(-1.8e9,SI.second).toString()=" + new OffsetUnit(-1.8E9, SI.second).toString());
    }

    public boolean equals(Unit unit) {
        return unit instanceof OffsetUnit && this.scaledUnit.equals(((OffsetUnit)unit).scaledUnit) && this.offset == ((OffsetUnit)unit).offset;
    }

    public OffsetUnit(double d) {
        this(d, "");
    }

    public OffsetUnit(double d, String string) {
        super(string);
        this.offset = d;
        this.scaledUnit = new ScaledUnit(1.0);
    }

    public OffsetUnit(double d, BaseUnit baseUnit) {
        this(d, baseUnit, d == 0.0 ? baseUnit.getIdentifier() : null);
    }

    public OffsetUnit(double d, BaseUnit baseUnit, String string) {
        super(string);
        this.offset = d;
        this.scaledUnit = new ScaledUnit(1.0, baseUnit);
    }

    public OffsetUnit(double d, DerivedUnit derivedUnit) {
        this(d, derivedUnit, d == 0.0 ? derivedUnit.getIdentifier() : null);
    }

    public OffsetUnit(double d, DerivedUnit derivedUnit, String string) {
        super(string);
        this.offset = d;
        this.scaledUnit = new ScaledUnit(1.0, derivedUnit);
    }

    public OffsetUnit(double d, ScaledUnit scaledUnit) {
        this(d, scaledUnit, d == 0.0 ? scaledUnit.getIdentifier() : null);
    }

    public OffsetUnit(double d, ScaledUnit scaledUnit, String string) {
        super(string);
        this.offset = d;
        this.scaledUnit = scaledUnit;
    }

    public OffsetUnit(double d, OffsetUnit offsetUnit) {
        this(d, offsetUnit, d == 0.0 ? offsetUnit.getIdentifier() : null);
    }

    public OffsetUnit(double d, OffsetUnit offsetUnit, String string) {
        super(string);
        this.offset = d + offsetUnit.offset;
        this.scaledUnit = offsetUnit.scaledUnit;
    }

    static {
        try {
            dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.SSS 'UTC'");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            gregorianCalendar.clear();
            gregorianCalendar.set(2001, 0, 1, 0, 0, 0);
            offsetUnitOrigin = gregorianCalendar.getTime().getTime();
            millisecond = SI.second.scale(0.001).clone("ms");
        }
        catch (Exception exception) {
            System.err.println("OffsetUnit.<clinit>: Couldn't initialize class: " + exception);
            System.exit(1);
        }
    }
}

