/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import visad.CommonUnit;
import visad.Data;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayRealType;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetType;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public abstract class MathType
implements Serializable {
    private static Vector timeAliases = MathType.makeTimeAliasVector();
    boolean SystemIntrinsic;

    public abstract boolean equals(Object var1);

    public abstract boolean equalsExceptName(MathType var1);

    public abstract boolean equalsExceptNameButUnits(MathType var1) throws VisADException;

    public abstract MathType cloneDerivative(RealType var1) throws VisADException;

    public abstract MathType binary(MathType var1, int var2, Vector var3) throws VisADException;

    public abstract MathType unary(int var1, Vector var2) throws VisADException;

    public abstract Data missingData() throws VisADException, RemoteException;

    public abstract ShadowType buildShadowType(DataDisplayLink var1, ShadowType var2) throws VisADException, RemoteException;

    public String toString() {
        return this.prettyString(0);
    }

    public String prettyString() {
        return this.prettyString(0);
    }

    public abstract String prettyString(int var1);

    public static MathType stringToType(String string) throws VisADException {
        Object object;
        int n = string.length();
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            object = string.substring(n2, n2 + 1);
            if (!(((String)object).equals(" ") || ((String)object).equals("\t") || ((String)object).equals("\n"))) {
                string2 = string2 + (String)object;
            }
            ++n2;
        }
        n = string2.length();
        if (n == 0) {
            throw new TypeException("MathType.stringToType: badly formed string");
        }
        int[] nArray = new int[]{n};
        object = MathType.stringToType(string2, nArray);
        if (n != nArray[0]) {
            throw new TypeException("MathType.stringToType: badly formed string");
        }
        return object;
    }

    private static MathType stringToType(String string, int[] nArray) throws VisADException {
        String string2 = string.substring(0, 1);
        if (string.startsWith("Set") || string.startsWith("SET") || string.startsWith("set")) {
            SetType setType;
            int[] nArray2;
            String string3 = string.substring(3);
            MathType mathType = MathType.stringToType(string3, nArray2 = new int[]{string3.length()});
            if (mathType instanceof RealType) {
                setType = new SetType((RealType)mathType);
            } else if (mathType instanceof RealTupleType) {
                setType = new SetType((RealTupleType)mathType);
            } else {
                throw new TypeException("MathType.stringToType: badly formed string");
            }
            nArray[0] = 3 + nArray2[0];
            return setType;
        }
        if (string2.equals("(")) {
            TupleType tupleType;
            MathType[] mathTypeArray;
            String string4 = string.substring(1);
            int[] nArray3 = new int[]{string4.length()};
            MathType mathType = MathType.stringToType(string4, nArray3);
            String string5 = string4.substring(nArray3[0]);
            if (mathType == null || string5 == null || string5.equals("")) {
                throw new TypeException("MathType.stringToType: badly formed string");
            }
            if (string5.startsWith("->")) {
                if (!(mathType instanceof RealType) && !(mathType instanceof RealTupleType)) {
                    throw new TypeException("MathType.stringToType: badly formed string");
                }
                String string6 = string5.substring(2);
                int[] nArray4 = new int[]{string6.length()};
                MathType mathType2 = MathType.stringToType(string6, nArray4);
                string5 = string6.substring(nArray4[0]);
                if (!string5.startsWith(")") || mathType2 == null) {
                    throw new TypeException("MathType.stringToType: badly formed string");
                }
                nArray[0] = 1 + nArray3[0] + 2 + nArray4[0] + 1;
                FunctionType functionType = new FunctionType(mathType, mathType2);
                return functionType;
            }
            Vector<MathType> vector = new Vector<MathType>();
            vector.addElement(mathType);
            int n = 1 + nArray3[0];
            while (string5.startsWith(",")) {
                int[] nArray5;
                mathTypeArray = string5.substring(1);
                MathType mathType3 = MathType.stringToType((String)mathTypeArray, nArray5 = new int[]{mathTypeArray.length()});
                if (mathType3 == null) {
                    throw new TypeException("MathType.stringToType: badly formed string");
                }
                vector.addElement(mathType3);
                n = n + 1 + nArray5[0];
                string5 = mathTypeArray.substring(nArray5[0]);
            }
            if (!string5.startsWith(")")) {
                throw new TypeException("MathType.stringToType: badly formed string");
            }
            nArray[0] = n + 1;
            mathTypeArray = new MathType[vector.size()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < vector.size()) {
                mathTypeArray[n2] = (MathType)vector.elementAt(n2);
                bl &= mathTypeArray[n2] instanceof RealType;
                ++n2;
            }
            if (bl) {
                RealType[] realTypeArray = new RealType[vector.size()];
                int n3 = 0;
                while (n3 < vector.size()) {
                    realTypeArray[n3] = (RealType)mathTypeArray[n3];
                    ++n3;
                }
                tupleType = new RealTupleType(realTypeArray);
            } else {
                tupleType = new TupleType(mathTypeArray);
            }
            return tupleType;
        }
        if (string2.compareTo("a") >= 0 && string2.compareTo("z") <= 0 || string2.compareTo("A") >= 0 && string2.compareTo("Z") <= 0) {
            ScalarType scalarType;
            int n = 1;
            while (n < nArray[0]) {
                string2 = string.substring(n, n + 1);
                if (!(string2.compareTo("a") >= 0 && string2.compareTo("z") <= 0 || string2.compareTo("A") >= 0 && string2.compareTo("Z") <= 0 || string2.compareTo("0") >= 0 && string2.compareTo("9") <= 0 || string2.equals("_"))) {
                    nArray[0] = n;
                    break;
                }
                ++n;
            }
            String string7 = string.substring(0, nArray[0]);
            String string8 = string.substring(nArray[0]);
            if (string8.startsWith("(Text)")) {
                scalarType = TextType.getTextType(string7);
                nArray[0] = nArray[0] + 6;
            } else {
                scalarType = RealType.getRealType(string7);
            }
            return scalarType;
        }
        throw new TypeException("MathType.stringToType: badly formed string");
    }

    private static Vector makeTimeAliasVector() {
        Vector<String> vector = new Vector<String>();
        vector.add("time");
        vector.add("Time");
        vector.add("TIME");
        return vector;
    }

    public static void addTimeAlias(String string) {
        Vector vector = timeAliases;
        synchronized (vector) {
            timeAliases.add(string);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ScalarMap[] guessMaps(boolean var1_1) {
        var2_2 = this;
        var4_3 = MathType.timeAliases;
        synchronized (var4_3) {
            var7_4 = MathType.timeAliases.size();
            var3_5 = new DataStruct[1][var7_4];
            var8_6 = 0;
            while (var8_6 < var7_4) {
                var9_8 = (String)MathType.timeAliases.elementAt(var8_6);
                var3_5[0][var8_6] = new DataStruct((String)var9_8);
                ++var8_6;
            }
        }
        this.findTimeFunction(var2_2, var3_5, null);
        var7_4 = -1;
        var8_6 = 0;
        while (var8_6 < var3_5[0].length) {
            if (var3_5[0][var8_6].fvalid && var3_5[0][var8_6].funcs.size() > 0) {
                var7_4 = var8_6;
                break;
            }
            ++var8_6;
        }
        var8_7 = new Vector<E>();
        var9_8 = new Vector<E>();
        var10_9 = new Vector<E>();
        if (var7_4 < 0) {
            this.buildTypeList(var2_2, var8_7, (Vector)var9_8, var10_9);
        } else {
            var11_10 = 0;
            while (var11_10 < var3_5[0][var7_4].funcs.size()) {
                var12_11 = (FunctionType)var3_5[0][var7_4].funcs.elementAt(var11_10);
                this.buildTypeList(var12_11.getRange(), var8_7, (Vector)var9_8, var10_9);
                ++var11_10;
            }
        }
        var11_10 = var8_7.size();
        var12_12 = var1_1 != false ? 0 : 4;
        while (var12_12 < 7) {
            var13_14 = 0;
            while (var13_14 < var11_10) {
                var14_16 = (FunctionType)var8_7.elementAt(var13_14);
                block48 : switch (var12_12) {
                    case 0: {
                        if (!var14_16.getFlat() || (var15_18 = var14_16.getDomain()).getDimension() != 3) break;
                        var16_20 = var14_16.getRange();
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var21_31 /* !! */  = var20_29 /* !! */ .getReference();
                            try {
                                var17_22 = (RealType)var21_31 /* !! */ .getComponent(0);
                                var18_26 = (RealType)var21_31 /* !! */ .getComponent(1);
                                var19_27 = (RealType)var21_31 /* !! */ .getComponent(2);
                            }
                            catch (VisADException var22_37) {
                                break;
                            }
                        }
                        try {
                            var17_22 = (RealType)var15_18.getComponent(0);
                            var18_26 = (RealType)var15_18.getComponent(1);
                            var19_27 = (RealType)var15_18.getComponent(2);
                        }
                        catch (VisADException var21_32) {
                            break;
                        }
                        if (var16_20 instanceof RealType) {
                            var21_31 /* !! */  = (RealType)var16_20;
                            try {
                                var22_36 = new ScalarMap[var7_4 < 0 ? 4 : 5];
                                if (RealType.Latitude.equals(var17_22)) {
                                    var22_36[0] = new ScalarMap(var17_22, Display.YAxis);
                                    var22_36[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                                } else {
                                    var22_36[0] = new ScalarMap(var17_22, Display.XAxis);
                                    var22_36[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                                }
                                var22_36[2] = new ScalarMap((ScalarType)var19_27, Display.ZAxis);
                                var22_36[3] = new ScalarMap((ScalarType)var21_31 /* !! */ , Display.IsoContour);
                                if (var7_4 >= 0) {
                                    var23_42 = var3_5[0][var7_4].funcs.elementAt(0);
                                    var24_53 = ((FunctionType)var23_42).getDomain();
                                    var25_85 = (RealType)var24_53.getComponent(0);
                                    var22_36[4] = new ScalarMap(var25_85, Display.Animation);
                                }
                                return var22_36;
                            }
                            catch (VisADException var22_38) {
                                break;
                            }
                        }
                        if (!(var16_20 instanceof TupleType)) break;
                        var22_36 = (TupleType)var16_20;
                        var23_43 = 0;
                        while (var23_43 < var22_36.getDimension()) {
                            try {
                                var24_54 = var22_36.getComponent(var23_43);
                            }
                            catch (VisADException var25_86) {
                                break block48;
                            }
                            if (var24_54 instanceof RealType) {
                                var21_31 /* !! */  = (RealType)var24_54;
                                try {
                                    var25_87 = new ScalarMap[var7_4 < 0 ? 4 : 5];
                                    if (RealType.Latitude.equals(var17_22)) {
                                        var25_87[0] = new ScalarMap(var17_22, Display.YAxis);
                                        var25_87[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                                    } else {
                                        var25_87[0] = new ScalarMap(var17_22, Display.XAxis);
                                        var25_87[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                                    }
                                    var25_87[2] = new ScalarMap((ScalarType)var19_27, Display.ZAxis);
                                    var25_87[3] = new ScalarMap((ScalarType)var21_31 /* !! */ , Display.IsoContour);
                                    if (var7_4 >= 0) {
                                        var26_107 = var3_5[0][var7_4].funcs.elementAt(0);
                                        var27_116 = ((FunctionType)var26_107).getDomain();
                                        var28_139 = (RealType)var27_116.getComponent(0);
                                        var25_87[4] = new ScalarMap((ScalarType)var28_139, Display.Animation);
                                    }
                                    return var25_87;
                                }
                                catch (VisADException var25_88) {
                                    break block48;
                                }
                            }
                            ++var23_43;
                        }
                        break;
                    }
                    case 1: {
                        var15_18 = var14_16.getDomain();
                        if (var15_18.getDimension() != 1) break;
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var22_36 = var20_29 /* !! */ .getReference();
                            try {
                                var19_27 = (RealType)var22_36.getComponent(0);
                            }
                            catch (VisADException var23_44) {
                                break;
                            }
                        }
                        try {
                            var19_27 = (RealType)var15_18.getComponent(0);
                        }
                        catch (VisADException var22_39) {
                            break;
                        }
                        var16_20 = var14_16.getRange();
                        var22_36 = null;
                        if (var16_20 instanceof FunctionType) {
                            var22_36 = (FunctionType)var16_20;
                            if (!var22_36.getFlat() || var22_36.getDomain().getDimension() != 2) {
                                break;
                            }
                        } else if (var16_20 instanceof TupleType) {
                            var23_45 = (TupleType)var16_20;
                            var24_55 = 0;
                            while (var24_55 < var23_45.getDimension()) {
                                try {
                                    var25_89 = var23_45.getComponent(var24_55);
                                }
                                catch (VisADException var26_108) {
                                    var22_36 = null;
                                    break;
                                }
                                if (var25_89 instanceof FunctionType) {
                                    var26_107 = (FunctionType)var25_89;
                                    if (!var26_107.getFlat() || var26_107.getDomain().getDimension() != 2) break;
                                    var22_36 = var26_107;
                                    break;
                                }
                                ++var24_55;
                            }
                        }
                        if (var22_36 == null) break;
                        var23_46 = var22_36.getDomain();
                        var20_29 /* !! */  = var23_46.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var24_56 = var20_29 /* !! */ .getReference();
                            try {
                                var17_22 = (RealType)var24_56.getComponent(0);
                                var18_26 = (RealType)var24_56.getComponent(1);
                            }
                            catch (VisADException var25_90) {
                                break;
                            }
                        }
                        try {
                            var17_22 = (RealType)var23_46.getComponent(0);
                            var18_26 = (RealType)var23_46.getComponent(1);
                        }
                        catch (VisADException var24_57) {
                            break;
                        }
                        var16_20 = var22_36.getRange();
                        var21_31 /* !! */  = null;
                        if (var16_20 instanceof RealType) {
                            var21_31 /* !! */  = (RealType)var16_20;
                        } else if (var16_20 instanceof TupleType) {
                            var24_58 = (TupleType)var16_20;
                            var25_91 = 0;
                            while (var25_91 < var24_58.getDimension()) {
                                try {
                                    var26_107 = var24_58.getComponent(var25_91);
                                }
                                catch (VisADException var27_117) {
                                    break;
                                }
                                if (var26_107 instanceof RealType) {
                                    var21_31 /* !! */  = (RealType)var26_107;
                                    break;
                                }
                                ++var25_91;
                            }
                        }
                        if (var21_31 /* !! */  == null) break;
                        try {
                            var24_59 = new ScalarMap[var7_4 < 0 ? 4 : 5];
                            if (RealType.Latitude.equals(var17_22)) {
                                var24_59[0] = new ScalarMap(var17_22, Display.YAxis);
                                var24_59[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                            } else {
                                var24_59[0] = new ScalarMap(var17_22, Display.XAxis);
                                var24_59[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                            }
                            var24_59[2] = new ScalarMap((ScalarType)var19_27, Display.ZAxis);
                            var24_59[3] = new ScalarMap((ScalarType)var21_31 /* !! */ , Display.IsoContour);
                            if (var7_4 >= 0) {
                                var25_92 = var3_5[0][var7_4].funcs.elementAt(0);
                                var26_107 = ((FunctionType)var25_92).getDomain();
                                var27_118 = (RealType)var26_107.getComponent(0);
                                var24_59[4] = new ScalarMap(var27_118, Display.Animation);
                            }
                            return var24_59;
                        }
                        catch (VisADException var24_60) {
                            // empty catch block
                        }
                    }
                    case 2: {
                        var15_18 = var14_16.getDomain();
                        if (var15_18.getDimension() != 2) break;
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var24_61 = var20_29 /* !! */ .getReference();
                            try {
                                var17_22 = (RealType)var24_61.getComponent(0);
                                var18_26 = (RealType)var24_61.getComponent(1);
                            }
                            catch (VisADException var25_93) {
                                break;
                            }
                        }
                        try {
                            var17_22 = (RealType)var15_18.getComponent(0);
                            var18_26 = (RealType)var15_18.getComponent(1);
                        }
                        catch (VisADException var24_62) {
                            break;
                        }
                        var16_20 = var14_16.getRange();
                        var22_36 = null;
                        if (var16_20 instanceof FunctionType) {
                            var22_36 = (FunctionType)var16_20;
                            if (!var22_36.getFlat() || var22_36.getDomain().getDimension() != 1) {
                                break;
                            }
                        } else if (var16_20 instanceof TupleType) {
                            var24_63 = (TupleType)var16_20;
                            var25_94 = 0;
                            while (var25_94 < var24_63.getDimension()) {
                                try {
                                    var26_107 = var24_63.getComponent(var25_94);
                                }
                                catch (VisADException var27_119) {
                                    var22_36 = null;
                                    break;
                                }
                                if (var26_107 instanceof FunctionType) {
                                    var27_120 = (FunctionType)var26_107;
                                    if (!var27_120.getFlat() || var27_120.getDomain().getDimension() != 1) break;
                                    var22_36 = var27_120;
                                    break;
                                }
                                ++var25_94;
                            }
                        }
                        if (var22_36 == null) break;
                        var23_47 = var22_36.getDomain();
                        var20_29 /* !! */  = var23_47.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var24_64 = var20_29 /* !! */ .getReference();
                            try {
                                var19_27 = (RealType)var24_64.getComponent(0);
                            }
                            catch (VisADException var25_95) {
                                break;
                            }
                        }
                        try {
                            var19_27 = (RealType)var23_47.getComponent(0);
                        }
                        catch (VisADException var24_65) {
                            break;
                        }
                        var16_20 = var22_36.getRange();
                        var21_31 /* !! */  = null;
                        if (var16_20 instanceof RealType) {
                            var21_31 /* !! */  = (RealType)var16_20;
                        } else if (var16_20 instanceof TupleType) {
                            var24_66 = (TupleType)var16_20;
                            var25_96 = 0;
                            while (var25_96 < var24_66.getDimension()) {
                                try {
                                    var26_107 = var24_66.getComponent(var25_96);
                                }
                                catch (VisADException var27_121) {
                                    break;
                                }
                                if (var26_107 instanceof RealType) {
                                    var21_31 /* !! */  = (RealType)var26_107;
                                    break;
                                }
                                ++var25_96;
                            }
                        }
                        if (var21_31 /* !! */  == null) break;
                        try {
                            var24_67 = new ScalarMap[var7_4 < 0 ? 4 : 5];
                            if (RealType.Latitude.equals(var17_22)) {
                                var24_67[0] = new ScalarMap(var17_22, Display.YAxis);
                                var24_67[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                            } else {
                                var24_67[0] = new ScalarMap(var17_22, Display.XAxis);
                                var24_67[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                            }
                            var24_67[2] = new ScalarMap((ScalarType)var19_27, Display.ZAxis);
                            var24_67[3] = new ScalarMap((ScalarType)var21_31 /* !! */ , Display.IsoContour);
                            if (var7_4 >= 0) {
                                var25_97 = var3_5[0][var7_4].funcs.elementAt(0);
                                var26_107 = ((FunctionType)var25_97).getDomain();
                                var27_122 = (RealType)var26_107.getComponent(0);
                                var24_67[4] = new ScalarMap(var27_122, Display.Animation);
                            }
                            return var24_67;
                        }
                        catch (VisADException var24_68) {
                            // empty catch block
                        }
                    }
                    case 3: {
                        var15_18 = var14_16.getDomain();
                        if (var15_18.getDimension() != 1) break;
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var24_69 = var20_29 /* !! */ .getReference();
                            try {
                                var17_22 = (RealType)var24_69.getComponent(0);
                            }
                            catch (VisADException var25_98) {
                                break;
                            }
                        }
                        try {
                            var17_22 = (RealType)var15_18.getComponent(0);
                        }
                        catch (VisADException var24_70) {
                            break;
                        }
                        var16_20 = var14_16.getRange();
                        var22_36 = null;
                        if (var16_20 instanceof FunctionType) {
                            var22_36 = (FunctionType)var16_20;
                            if (var22_36.getDomain().getDimension() != 1) {
                                break;
                            }
                        } else if (var16_20 instanceof TupleType) {
                            var24_71 = (TupleType)var16_20;
                            var25_99 = 0;
                            while (var25_99 < var24_71.getDimension()) {
                                try {
                                    var26_107 = var24_71.getComponent(var25_99);
                                }
                                catch (VisADException var27_123) {
                                    var22_36 = null;
                                    break;
                                }
                                if (var26_107 instanceof FunctionType) {
                                    var27_124 = (FunctionType)var26_107;
                                    if (var27_124.getDomain().getDimension() != 1) break;
                                    var22_36 = var27_124;
                                    break;
                                }
                                ++var25_99;
                            }
                        }
                        if (var22_36 == null) break;
                        var23_48 = var22_36.getDomain();
                        var20_29 /* !! */  = var23_48.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var24_72 = var20_29 /* !! */ .getReference();
                            try {
                                var18_26 = (RealType)var24_72.getComponent(0);
                            }
                            catch (VisADException var25_100) {
                                break;
                            }
                        }
                        try {
                            var18_26 = (RealType)var23_48.getComponent(0);
                        }
                        catch (VisADException var24_73) {
                            break;
                        }
                        var16_20 = var22_36.getRange();
                        var22_36 = null;
                        if (var16_20 instanceof FunctionType) {
                            var22_36 = (FunctionType)var16_20;
                            if (var22_36.getDomain().getDimension() != 1) {
                                break;
                            }
                        } else if (var16_20 instanceof TupleType) {
                            var24_74 = (TupleType)var16_20;
                            var25_101 = 0;
                            while (var25_101 < var24_74.getDimension()) {
                                try {
                                    var26_107 = var24_74.getComponent(var25_101);
                                }
                                catch (VisADException var27_125) {
                                    var22_36 = null;
                                    break;
                                }
                                if (var26_107 instanceof FunctionType) {
                                    var27_126 = (FunctionType)var26_107;
                                    if (var27_126.getDomain().getDimension() != 1) break;
                                    var22_36 = var27_126;
                                    break;
                                }
                                ++var25_101;
                            }
                        }
                        if (var22_36 == null) break;
                        var23_48 = var22_36.getDomain();
                        var20_29 /* !! */  = var23_48.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var24_75 = var20_29 /* !! */ .getReference();
                            try {
                                var19_27 = (RealType)var24_75.getComponent(0);
                            }
                            catch (VisADException var25_102) {
                                break;
                            }
                        }
                        try {
                            var19_27 = (RealType)var23_48.getComponent(0);
                        }
                        catch (VisADException var24_76) {
                            break;
                        }
                        var16_20 = var22_36.getRange();
                        var21_31 /* !! */  = null;
                        if (var16_20 instanceof RealType) {
                            var21_31 /* !! */  = (RealType)var16_20;
                        } else if (var16_20 instanceof TupleType) {
                            var24_77 = (TupleType)var16_20;
                            var25_103 = 0;
                            while (var25_103 < var24_77.getDimension()) {
                                try {
                                    var26_107 = var24_77.getComponent(var25_103);
                                }
                                catch (VisADException var27_127) {
                                    break;
                                }
                                if (var26_107 instanceof RealType) {
                                    var21_31 /* !! */  = (RealType)var26_107;
                                    break;
                                }
                                ++var25_103;
                            }
                        }
                        if (var21_31 /* !! */  == null) break;
                        try {
                            var24_78 = new ScalarMap[var7_4 < 0 ? 4 : 5];
                            if (RealType.Latitude.equals(var17_22)) {
                                var24_78[0] = new ScalarMap(var17_22, Display.YAxis);
                                var24_78[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                            } else {
                                var24_78[0] = new ScalarMap(var17_22, Display.XAxis);
                                var24_78[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                            }
                            var24_78[2] = new ScalarMap((ScalarType)var19_27, Display.ZAxis);
                            var24_78[3] = new ScalarMap((ScalarType)var21_31 /* !! */ , Display.IsoContour);
                            if (var7_4 >= 0) {
                                var25_104 = var3_5[0][var7_4].funcs.elementAt(0);
                                var26_107 = ((FunctionType)var25_104).getDomain();
                                var27_128 = (RealType)var26_107.getComponent(0);
                                var24_78[4] = new ScalarMap(var27_128, Display.Animation);
                            }
                            return var24_78;
                        }
                        catch (VisADException var24_79) {
                            // empty catch block
                        }
                    }
                    case 4: {
                        if (!var14_16.getFlat() || (var15_18 = var14_16.getDomain()).getDimension() != 2) break;
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var24_80 = var20_29 /* !! */ .getReference();
                            try {
                                var17_22 = (RealType)var24_80.getComponent(0);
                                var18_26 = (RealType)var24_80.getComponent(1);
                            }
                            catch (VisADException var25_105) {
                                break;
                            }
                        }
                        try {
                            var17_22 = (RealType)var15_18.getComponent(0);
                            var18_26 = (RealType)var15_18.getComponent(1);
                        }
                        catch (VisADException var24_81) {
                            break;
                        }
                        var16_20 = var14_16.getRange();
                        var24_82 = new RealType[3];
                        var25_106 = 0;
                        if (!(var16_20 instanceof TupleType)) ** GOTO lbl472
                        var26_107 = (TupleType)var16_20;
                        var27_129 = 0;
                        while (var27_129 < var26_107.getDimension()) {
                            try {
                                var28_139 = var26_107.getComponent(var27_129);
                            }
                            catch (VisADException var29_141) {
                                ** GOTO lbl474
                            }
                            if (var28_139 instanceof RealType && var25_106 < 3) {
                                var24_82[var25_106++] = (RealType)var28_139;
                            }
                            ++var27_129;
                        }
                        ** GOTO lbl474
lbl472:
                        // 1 sources

                        if (var16_20 instanceof RealType) {
                            var24_82[var25_106++] = (RealType)var16_20;
                        }
lbl474:
                        // 5 sources

                        if (var25_106 == 0) break;
                        if (var25_106 < 3) {
                            try {
                                var26_107 = new ScalarMap[var7_4 < 0 ? 3 : 4];
                                if (RealType.Latitude.equals(var17_22)) {
                                    var26_107[0] = new ScalarMap(var17_22, Display.YAxis);
                                    var26_107[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                                } else {
                                    var26_107[0] = new ScalarMap(var17_22, Display.XAxis);
                                    var26_107[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                                }
                                var26_107[2] = new ScalarMap(var24_82[0], Display.RGB);
                                if (var7_4 >= 0) {
                                    var27_130 = var3_5[0][var7_4].funcs.elementAt(0);
                                    var28_139 = ((FunctionType)var27_130).getDomain();
                                    var29_140 = (RealType)var28_139.getComponent(0);
                                    var26_107[3] = new ScalarMap(var29_140, Display.Animation);
                                }
                                return var26_107;
                            }
                            catch (VisADException var26_109) {
                                break;
                            }
                        }
                        try {
                            var26_107 = new ScalarMap[var7_4 < 0 ? 5 : 6];
                            if (RealType.Latitude.equals(var17_22)) {
                                var26_107[0] = new ScalarMap(var17_22, Display.YAxis);
                                var26_107[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                            } else {
                                var26_107[0] = new ScalarMap(var17_22, Display.XAxis);
                                var26_107[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                            }
                            var26_107[2] = new ScalarMap(var24_82[0], Display.Red);
                            var26_107[3] = new ScalarMap(var24_82[1], Display.Green);
                            var26_107[4] = new ScalarMap(var24_82[2], Display.Blue);
                            if (var7_4 >= 0) {
                                var27_131 = var3_5[0][var7_4].funcs.elementAt(0);
                                var28_139 = ((FunctionType)var27_131).getDomain();
                                var29_140 = (RealType)var28_139.getComponent(0);
                                var26_107[5] = new ScalarMap(var29_140, Display.Animation);
                            }
                            return var26_107;
                        }
                        catch (VisADException var26_110) {
                            break;
                        }
                    }
                    case 5: {
                        var15_18 = var14_16.getDomain();
                        if (var15_18.getDimension() != 1) break;
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var26_107 = var20_29 /* !! */ .getReference();
                            try {
                                var17_22 = (RealType)var26_107.getComponent(0);
                            }
                            catch (VisADException var27_132) {
                                break;
                            }
                        }
                        try {
                            var17_22 = (RealType)var15_18.getComponent(0);
                        }
                        catch (VisADException var26_111) {
                            break;
                        }
                        var16_20 = var14_16.getRange();
                        if (!(var16_20 instanceof FunctionType) || !(var14_16 = (FunctionType)var16_20).getFlat() || (var15_18 = var14_16.getDomain()).getDimension() != 1) break;
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var26_107 = var20_29 /* !! */ .getReference();
                            try {
                                var18_26 = (RealType)var26_107.getComponent(0);
                            }
                            catch (VisADException var27_133) {
                                break;
                            }
                        }
                        try {
                            var18_26 = (RealType)var15_18.getComponent(0);
                        }
                        catch (VisADException var26_112) {
                            break;
                        }
                        var16_20 = var14_16.getRange();
                        var21_31 /* !! */  = null;
                        if (var16_20 instanceof RealType) {
                            var21_31 /* !! */  = (RealType)var16_20;
                        } else if (var16_20 instanceof TupleType) {
                            var26_107 = (TupleType)var16_20;
                            var27_134 = 0;
                            while (var27_134 < var26_107.getDimension()) {
                                try {
                                    var28_139 = var26_107.getComponent(var27_134);
                                }
                                catch (VisADException var29_142) {
                                    break;
                                }
                                if (var28_139 instanceof RealType) {
                                    var21_31 /* !! */  = (RealType)var28_139;
                                    break;
                                }
                                ++var27_134;
                            }
                        }
                        if (var21_31 /* !! */  == null) break;
                        try {
                            var26_107 = new ScalarMap[var7_4 < 0 ? 3 : 4];
                            if (RealType.Latitude.equals(var17_22)) {
                                var26_107[0] = new ScalarMap(var17_22, Display.YAxis);
                                var26_107[1] = new ScalarMap((ScalarType)var18_26, Display.XAxis);
                            } else {
                                var26_107[0] = new ScalarMap(var17_22, Display.XAxis);
                                var26_107[1] = new ScalarMap((ScalarType)var18_26, Display.YAxis);
                            }
                            var26_107[2] = new ScalarMap((ScalarType)var21_31 /* !! */ , var1_1 != false ? Display.ZAxis : Display.RGB);
                            if (var7_4 >= 0) {
                                var27_135 = var3_5[0][var7_4].funcs.elementAt(0);
                                var28_139 = ((FunctionType)var27_135).getDomain();
                                var29_140 = (RealType)var28_139.getComponent(0);
                                var26_107[3] = new ScalarMap(var29_140, Display.Animation);
                            }
                            return var26_107;
                        }
                        catch (VisADException var26_113) {
                            // empty catch block
                        }
                    }
                    case 6: {
                        if (!var14_16.getFlat() || (var15_18 = var14_16.getDomain()).getDimension() != 1) break;
                        var20_29 /* !! */  = var15_18.getCoordinateSystem();
                        if (var20_29 /* !! */  != null) {
                            var26_107 = var20_29 /* !! */ .getReference();
                            try {
                                var17_22 = (RealType)var26_107.getComponent(0);
                            }
                            catch (VisADException var27_136) {
                                break;
                            }
                        }
                        try {
                            var17_22 = (RealType)var15_18.getComponent(0);
                        }
                        catch (VisADException var26_114) {
                            break;
                        }
                        var16_20 = var14_16.getRange();
                        var21_31 /* !! */  = null;
                        if (var16_20 instanceof RealType) {
                            var21_31 /* !! */  = (RealType)var16_20;
                        } else if (var16_20 instanceof TupleType) {
                            var26_107 = (TupleType)var16_20;
                            var27_137 = 0;
                            while (var27_137 < var26_107.getDimension()) {
                                try {
                                    var28_139 = var26_107.getComponent(var27_137);
                                }
                                catch (VisADException var29_143) {
                                    break;
                                }
                                if (var28_139 instanceof RealType) {
                                    var21_31 /* !! */  = (RealType)var28_139;
                                    break;
                                }
                                ++var27_137;
                            }
                        }
                        if (var21_31 /* !! */  == null) break;
                        try {
                            var26_107 = new ScalarMap[var7_4 < 0 ? 2 : 3];
                            if (RealType.Latitude.equals(var17_22)) {
                                var26_107[0] = new ScalarMap(var17_22, Display.YAxis);
                                var26_107[1] = new ScalarMap((ScalarType)var21_31 /* !! */ , Display.XAxis);
                            } else {
                                var26_107[0] = new ScalarMap(var17_22, Display.XAxis);
                                var26_107[1] = new ScalarMap((ScalarType)var21_31 /* !! */ , Display.YAxis);
                            }
                            if (var7_4 >= 0) {
                                var27_138 = var3_5[0][var7_4].funcs.elementAt(0);
                                var28_139 = ((FunctionType)var27_138).getDomain();
                                var29_140 = (RealType)var28_139.getComponent(0);
                                var26_107[2] = new ScalarMap(var29_140, Display.Animation);
                            }
                            return var26_107;
                        }
                        catch (VisADException var26_115) {
                            break;
                        }
                    }
                }
                ++var13_14;
            }
            ++var12_12;
        }
        var12_13 = new DisplayRealType[]{Display.XAxis, Display.YAxis, Display.ZAxis};
        var13_15 = new boolean[]{false, false, false};
        var14_17 = var1_1 != false ? 3 : 2;
        var15_19 = var9_8.size();
        var16_21 = var14_17;
        while (var16_21 >= 1) {
            var17_24 = 0;
            while (var17_24 < var15_19) {
                var18_26 = (SetType)var9_8.elementAt(var17_24);
                var19_27 = var18_26.getDomain();
                var20_29 /* !! */  = var19_27.getCoordinateSystem();
                if (var20_29 /* !! */  != null) {
                    var19_27 = var20_29 /* !! */ .getReference();
                }
                if (var19_27.getDimension() == var16_21) {
                    try {
                        var21_31 /* !! */  = new ScalarMap[var7_4 < 0 ? var16_21 : var16_21 + 1];
                        var22_40 = 0;
                        while (var22_40 < var16_21) {
                            var23_49 = (RealType)var19_27.getComponent(var22_40);
                            if (RealType.Latitude.equals(var23_49)) {
                                var21_31 /* !! */ [var22_40] = new ScalarMap(var23_49, var12_13[1]);
                                var13_15[1] = true;
                            } else if (RealType.Longitude.equals(var23_49)) {
                                var21_31 /* !! */ [var22_40] = new ScalarMap(var23_49, var12_13[0]);
                                var13_15[0] = true;
                            }
                            ++var22_40;
                        }
                        var22_40 = 0;
                        while (var22_40 < var16_21) {
                            var23_50 = (RealType)var19_27.getComponent(var22_40);
                            if (!RealType.Latitude.equals(var23_50) && !RealType.Longitude.equals(var23_50)) {
                                var24_83 = 0;
                                while (var24_83 < 3) {
                                    if (!var13_15[var24_83]) {
                                        var21_31 /* !! */ [var22_40] = new ScalarMap(var23_50, var12_13[var24_83]);
                                        var13_15[var24_83] = true;
                                    }
                                    ++var24_83;
                                }
                            }
                            ++var22_40;
                        }
                        if (var7_4 >= 0) {
                            var22_41 = var3_5[0][var7_4].funcs.elementAt(0);
                            var23_51 = ((FunctionType)var22_41).getDomain();
                            var24_84 = (RealType)var23_51.getComponent(0);
                            var21_31 /* !! */ [var16_21] = new ScalarMap(var24_84, Display.Animation);
                        }
                        return var21_31 /* !! */ ;
                    }
                    catch (VisADException var21_33) {
                        // empty catch block
                    }
                }
                ++var17_24;
            }
            --var16_21;
        }
        var16_21 = var10_9.size();
        if (var16_21 >= 1) {
            var17_25 = (RealTupleType)var10_9.elementAt(0);
            var18_26 = var17_25.getCoordinateSystem();
            if (var18_26 != null) {
                var17_25 = var18_26.getReference();
            }
            if ((var19_28 = var17_25.getDimension()) > var14_17) {
                var19_28 = var14_17;
            }
            try {
                var20_29 /* !! */  = new ScalarMap[var7_4 < 0 ? var19_28 : var19_28 + 1];
                var21_34 = 0;
                while (var21_34 < var19_28) {
                    var22_36 = (RealType)var17_25.getComponent(var21_34);
                    var20_29 /* !! */ [var21_34] = new ScalarMap((ScalarType)var22_36, var12_13[var21_34]);
                    ++var21_34;
                }
                if (var7_4 >= 0) {
                    var21_35 = var3_5[0][var7_4].funcs.elementAt(0);
                    var22_36 = ((FunctionType)var21_35).getDomain();
                    var23_52 = (RealType)var22_36.getComponent(0);
                    var20_29 /* !! */ [var19_28] = new ScalarMap(var23_52, Display.Animation);
                }
                return var20_29 /* !! */ ;
            }
            catch (VisADException var20_30) {
                // empty catch block
            }
        }
        return null;
    }

    private void buildTypeList(MathType mathType, Vector vector, Vector vector2, Vector vector3) {
        if (mathType instanceof TupleType) {
            TupleType tupleType = (TupleType)mathType;
            if (tupleType instanceof RealTupleType) {
                vector3.addElement(mathType);
            } else {
                int n = 0;
                while (n < tupleType.getDimension()) {
                    try {
                        this.buildTypeList(tupleType.getComponent(n), vector, vector2, vector3);
                    }
                    catch (VisADException visADException) {
                        // empty catch block
                    }
                    ++n;
                }
            }
        } else if (mathType instanceof SetType) {
            vector2.addElement(mathType);
        } else if (mathType instanceof FunctionType) {
            vector.addElement(mathType);
            FunctionType functionType = (FunctionType)mathType;
            this.buildTypeList(functionType.getRange(), vector, vector2, vector3);
        }
    }

    private void findTimeFunction(MathType mathType, DataStruct[][] dataStructArray, Hashtable hashtable) {
        MathType mathType2;
        MathType mathType3;
        boolean bl = false;
        if (hashtable == null) {
            hashtable = new Hashtable<String, MathType>();
            bl = true;
        }
        if (mathType instanceof TupleType) {
            mathType3 = (TupleType)mathType;
            int n = 0;
            while (n < ((TupleType)mathType3).getDimension()) {
                mathType2 = null;
                try {
                    mathType2 = ((TupleType)mathType3).getComponent(n);
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
                this.findTimeFunction(mathType2, dataStructArray, hashtable);
                ++n;
            }
        } else if (mathType instanceof SetType) {
            mathType3 = (SetType)mathType;
            this.findTimeFunction(((SetType)mathType3).getDomain(), dataStructArray, hashtable);
        } else if (mathType instanceof FunctionType) {
            mathType3 = (FunctionType)mathType;
            RealTupleType realTupleType = ((FunctionType)mathType3).getDomain();
            mathType2 = ((FunctionType)mathType3).getRange();
            RealType realType = null;
            try {
                realType = (RealType)realTupleType.getComponent(0);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
            boolean bl2 = false;
            if (realType != null && realTupleType.getDimension() == 1) {
                String string = realType.getName();
                int n = 0;
                while (n < dataStructArray[0].length) {
                    if (string.equals(dataStructArray[0][n].name)) {
                        dataStructArray[0][n].funcs.addElement(mathType3);
                        bl2 = true;
                    }
                    ++n;
                }
                Unit unit = realType.getDefaultUnit();
                if (SI.second.isConvertible(unit) || CommonUnit.secondsSinceTheEpoch.isConvertible(unit)) {
                    int n2 = dataStructArray[0].length;
                    DataStruct[] dataStructArray2 = new DataStruct[n2 + 1];
                    int n3 = 0;
                    while (n3 < n2) {
                        dataStructArray2[n3] = dataStructArray[0][n3];
                        ++n3;
                    }
                    dataStructArray2[n2] = new DataStruct(string);
                    dataStructArray2[n2].funcs.addElement(mathType3);
                    dataStructArray[0] = dataStructArray2;
                    bl2 = true;
                }
            }
            if (!bl2) {
                this.findTimeFunction(realTupleType, dataStructArray, hashtable);
            }
            this.findTimeFunction(mathType2, dataStructArray, hashtable);
        } else if (mathType instanceof RealType) {
            mathType3 = (RealType)mathType;
            String string = ((ScalarType)mathType3).getName();
            hashtable.put(string, mathType3);
        }
        if (bl) {
            int n = 0;
            while (n < dataStructArray[0].length) {
                if (hashtable.get(dataStructArray[0][n].name) != null) {
                    dataStructArray[0][n].fvalid = false;
                }
                ++n;
            }
        }
    }

    public static boolean findScalarType(MathType mathType, ScalarType scalarType) throws VisADException {
        if (mathType == null || scalarType == null) {
            return false;
        }
        if (mathType instanceof TupleType) {
            TupleType tupleType = (TupleType)mathType;
            int n = 0;
            while (n < tupleType.getDimension()) {
                MathType mathType2 = tupleType.getComponent(n);
                if (MathType.findScalarType(mathType2, scalarType)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (mathType instanceof SetType) {
            SetType setType = (SetType)mathType;
            return MathType.findScalarType(setType.getDomain(), scalarType);
        }
        if (mathType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)mathType;
            RealTupleType realTupleType = functionType.getDomain();
            MathType mathType3 = functionType.getRange();
            return MathType.findScalarType(realTupleType, scalarType) || MathType.findScalarType(mathType3, scalarType);
        }
        if (mathType instanceof ScalarType) {
            return mathType.equals(scalarType);
        }
        return false;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        Object object;
        RealType realType = new RealType("Xxxxxx", null, null);
        RealType realType2 = new RealType("Yyyyyy", null, null);
        RealType realType3 = new RealType("Zzzzzz", null, null);
        RealType realType4 = new RealType("Aaaaaa", null, null);
        RealType realType5 = new RealType("Bbbbbb", null, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType[] realTypeArray2 = new RealType[]{realType4, realType5};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realType4);
        FunctionType functionType2 = new FunctionType(realTupleType, realTupleType2);
        FunctionType functionType3 = new FunctionType(realTupleType, realType5);
        FunctionType functionType4 = new FunctionType(realType, functionType2);
        MathType[] mathTypeArray = new MathType[]{realTupleType2, functionType, functionType4};
        TupleType tupleType = new TupleType(mathTypeArray);
        FunctionType functionType5 = new FunctionType(realType, tupleType);
        SetType setType = new SetType(realTupleType);
        MathType[] mathTypeArray2 = new MathType[]{realTupleType2, functionType5, functionType, functionType2, functionType4, setType, functionType3};
        TupleType tupleType2 = new TupleType(mathTypeArray2);
        FunctionType functionType6 = new FunctionType(realTupleType2, tupleType2);
        System.out.println("prettyString for first MathType:");
        String string = functionType6.prettyString();
        System.out.println(string + "\n");
        MathType mathType = MathType.stringToType(string);
        System.out.println("stringToType for first MathType:");
        System.out.println(mathType.prettyString() + "\n");
        RealType realType6 = new RealType("time");
        RealTupleType realTupleType3 = new RealTupleType(new RealType[]{realType6});
        RealType realType7 = new RealType("Red");
        RealType realType8 = new RealType("Green");
        RealType realType9 = new RealType("Blue");
        RealTupleType realTupleType4 = new RealTupleType(new RealType[]{realType7, realType8, realType9});
        FunctionType functionType7 = new FunctionType(realTupleType, realTupleType4);
        functionType4 = new FunctionType(realTupleType3, functionType7);
        System.out.println("prettyString for second MathType:");
        String string2 = functionType4.prettyString();
        System.out.println(string2 + "\n");
        MathType mathType2 = MathType.stringToType(string2);
        System.out.println("stringToType for second MathType:");
        System.out.println(mathType2.prettyString() + "\n");
        System.out.println("Guessing at some good mappings for this MathType...");
        ScalarMap[] scalarMapArray = functionType4.guessMaps(true);
        if (scalarMapArray == null) {
            System.out.println("Could not identify a good set of mappings!");
        } else {
            int n = 0;
            while (n < scalarMapArray.length) {
                object = scalarMapArray[n].getScalar();
                DisplayRealType displayRealType = scalarMapArray[n].getDisplayScalar();
                System.out.println(((ScalarType)object).getName() + " -> " + displayRealType.getName());
                ++n;
            }
        }
        String string3 = "((Row, Col, Lev) -> Radiance)";
        object = MathType.stringToType(string3).prettyString();
        System.out.println("s3 = \n" + string3 + "\ns3s = \n" + (String)object);
    }

    public MathType() {
        this.SystemIntrinsic = false;
    }

    MathType(boolean bl) {
        this.SystemIntrinsic = true;
    }

    private class DataStruct {
        boolean fvalid = true;
        String name;
        Vector funcs = new Vector();

        DataStruct(String string) {
            this.name = string;
        }
    }
}

