/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.SimpleSet;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class List1DSet
extends SimpleSet {
    float[] data;

    public boolean isMissing() {
        return this.data == null;
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n = nArray.length;
        float[][] fArray = new float[1][n];
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] < 0 || nArray[n2] >= this.Length) {
                int n3 = 0;
                while (n3 < this.DomainDimension) {
                    fArray[n3][n2] = Float.NaN;
                    ++n3;
                }
            } else {
                fArray[0][n2] = this.data[nArray[n2]];
            }
            ++n2;
        }
        return fArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        throw new UnimplementedException("List1DSet.valueToIndex");
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        throw new UnimplementedException("List1DSet.valueToInterpx");
    }

    public boolean equals(Object object) {
        if (!(object instanceof List1DSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        if (this.Length != ((Set)object).Length) {
            return false;
        }
        int n = 0;
        while (n < this.Length) {
            if (this.data[n] != ((List1DSet)object).data[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.Length;
            int n = 0;
            while (n < this.Length) {
                this.hashCode ^= Float.floatToIntBits(this.data[n]);
                ++n;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object clone() {
        try {
            return new List1DSet(this.data, this.getType(), this.DomainCoordinateSystem, this.SetUnits);
        }
        catch (VisADException visADException) {
            throw new VisADError("List1DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new List1DSet(this.data, mathType, this.DomainCoordinateSystem, this.SetUnits);
    }

    public String longString(String string) throws VisADException {
        return string + "List1DSet";
    }

    public List1DSet(float[] fArray, MathType mathType, CoordinateSystem coordinateSystem, Unit[] unitArray) throws VisADException {
        super(mathType, coordinateSystem, unitArray, null);
        if (this.DomainDimension != 1) {
            throw new SetException("List1DSet: type must be 1-D");
        }
        this.data = fArray;
        this.Length = fArray.length;
    }
}

