/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class LinearNDSet
extends GriddedSet
implements LinearSet {
    Linear1DSet[] L;

    private static int[] get_lengths(Linear1DSet[] linear1DSetArray) throws VisADException {
        int[] nArray = new int[linear1DSetArray.length];
        int n = 0;
        while (n < linear1DSetArray.length) {
            nArray[n] = linear1DSetArray[n].getLength();
            ++n;
        }
        return nArray;
    }

    public static LinearSet create(MathType mathType, double[] dArray, double[] dArray2, int[] nArray) throws VisADException {
        return LinearNDSet.create(mathType, dArray, dArray2, nArray, null, null, null);
    }

    public static LinearSet create(MathType mathType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        switch (dArray.length) {
            case 1: {
                return new Linear1DSet(mathType, dArray[0], dArray2[0], nArray[0], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 2: {
                return new Linear2DSet(mathType, dArray[0], dArray2[0], nArray[0], dArray[1], dArray2[1], nArray[1], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 3: {
                return new Linear3DSet(mathType, dArray[0], dArray2[0], nArray[0], dArray[1], dArray2[1], nArray[1], dArray[2], dArray2[2], nArray[2], coordinateSystem, unitArray, errorEstimateArray);
            }
        }
        return new LinearNDSet(mathType, dArray, dArray2, nArray, coordinateSystem, unitArray, errorEstimateArray);
    }

    static Linear1DSet[] get_linear1d_array(MathType mathType, double[] dArray, double[] dArray2, int[] nArray) throws VisADException {
        mathType = Set.adjustType(mathType);
        int n = nArray.length;
        if (n != dArray.length || n != dArray2.length) {
            throw new SetException("LinearNDSet: array dimensions don't match");
        }
        Linear1DSet[] linear1DSetArray = new Linear1DSet[n];
        int n2 = 0;
        while (n2 < n) {
            RealType[] realTypeArray = new RealType[]{(RealType)((SetType)mathType).getDomain().getComponent(n2)};
            SetType setType = new SetType(new RealTupleType(realTypeArray));
            linear1DSetArray[n2] = new Linear1DSet((MathType)setType, dArray[n2], dArray2[n2], nArray[n2]);
            ++n2;
        }
        return linear1DSetArray;
    }

    static Linear1DSet[] get_linear1d_array(MathType mathType, double d, double d2, int n, double d3, double d4, int n2) throws VisADException {
        double[] dArray = new double[]{d, d3};
        double[] dArray2 = new double[]{d2, d4};
        int[] nArray = new int[]{n, n2};
        return LinearNDSet.get_linear1d_array(mathType, dArray, dArray2, nArray);
    }

    static Linear1DSet[] get_linear1d_array(MathType mathType, double d, double d2, int n, double d3, double d4, int n2, double d5, double d6, int n3) throws VisADException {
        double[] dArray = new double[]{d, d3, d5};
        double[] dArray2 = new double[]{d2, d4, d6};
        int[] nArray = new int[]{n, n2, n3};
        return LinearNDSet.get_linear1d_array(mathType, dArray, dArray2, nArray);
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n = this.getDimension();
        int n2 = nArray.length;
        int[][] nArray2 = new int[n][n2];
        float[][] fArray = new float[n][n2];
        int[] nArray3 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray3[n3] = this.L[n3].getLength();
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = nArray[n3];
            if (n5 >= 0 && n5 < this.Length) {
                n4 = 0;
                while (n4 < n - 1) {
                    nArray2[n4][n3] = n5 % nArray3[n4];
                    n5 /= nArray3[n4];
                    ++n4;
                }
                nArray2[n - 1][n3] = n5;
            } else {
                n4 = 0;
                while (n4 < n) {
                    nArray2[n4][n3] = -1;
                    ++n4;
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            float[][] fArray2 = this.L[n3].indexToValue(nArray2[n3]);
            fArray[n3] = fArray2[0];
            ++n3;
        }
        return fArray;
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("LinearNDSet.gridToValue: grid dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = 0;
        while (n < this.DomainDimension) {
            if (this.Lengths[n] < 2) {
                throw new SetException("LinearNDSet.gridToValue: requires all grid dimensions to be > 1");
            }
            ++n;
        }
        int n2 = fArray[0].length;
        float[][][] fArray2 = new float[this.DomainDimension][1][];
        float[][][] fArray3 = new float[this.DomainDimension][][];
        n = 0;
        while (n < this.DomainDimension) {
            fArray2[n][0] = fArray[n];
            fArray3[n] = this.L[n].gridToValue(fArray2[n]);
            ++n;
        }
        float[][] fArray4 = new float[this.DomainDimension][];
        n = 0;
        while (n < this.DomainDimension) {
            fArray4[n] = fArray3[n][0];
            ++n;
        }
        return fArray4;
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("LinearNDSet.valueToGrid: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = 0;
        while (n < this.DomainDimension) {
            if (this.Lengths[n] < 2) {
                throw new SetException("LinearNDSet.valueToGrid: requires all grid dimensions to be > 1");
            }
            ++n;
        }
        int n2 = fArray[0].length;
        float[][][] fArray2 = new float[this.DomainDimension][1][];
        float[][][] fArray3 = new float[this.DomainDimension][][];
        n = 0;
        while (n < this.DomainDimension) {
            fArray2[n][0] = fArray[n];
            fArray3[n] = this.L[n].valueToGrid(fArray2[n]);
            ++n;
        }
        float[][] fArray4 = new float[this.DomainDimension][];
        n = 0;
        while (n < this.DomainDimension) {
            fArray4[n] = fArray3[n][0];
            ++n;
        }
        return fArray4;
    }

    public boolean isMissing() {
        return false;
    }

    public double[] getFirsts() throws VisADException {
        double[] dArray = new double[this.L.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = this.L[n].getFirst();
            ++n;
        }
        return dArray;
    }

    public double[] getLasts() throws VisADException {
        double[] dArray = new double[this.L.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = this.L[n].getLast();
            ++n;
        }
        return dArray;
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToValue(nArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinearNDSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        if (this.DomainDimension != ((LinearNDSet)object).getDimension()) {
            return false;
        }
        int n = 0;
        while (n < this.DomainDimension) {
            if (!this.L[n].equals(((LinearNDSet)object).getLinear1DComponent(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            int n = 0;
            while (n < this.DomainDimension) {
                this.hashCode ^= this.L[n].hashCode();
                ++n;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int n) {
        return this.L[n];
    }

    public Object clone() {
        try {
            Linear1DSet[] linear1DSetArray = new Linear1DSet[this.DomainDimension];
            int n = 0;
            while (n < this.DomainDimension) {
                linear1DSetArray[n] = (Linear1DSet)this.L[n].clone();
                ++n;
            }
            return new LinearNDSet(this.Type, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("LinearNDSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[this.DomainDimension];
        int n = 0;
        while (n < this.DomainDimension) {
            linear1DSetArray[n] = (Linear1DSet)this.L[n].clone();
            ++n;
        }
        return new LinearNDSet(mathType, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String string) throws VisADException {
        String string2 = string + "LinearNDSet: Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
        int n = 0;
        while (n < this.DomainDimension) {
            string2 = string2 + string + "  Dimension " + n + ":" + " Length = " + this.L[n].getLength() + " Range = " + this.L[n].getFirst() + " to " + this.L[n].getLast() + "\n";
            ++n;
        }
        return string2;
    }

    public static void main(String[] stringArray) throws VisADException {
        RealTupleType realTupleType = new RealTupleType(RealType.Generic, RealType.Generic);
        double[] dArray = new double[]{0.0, 0.0};
        double[] dArray2 = new double[]{3.0, 3.0};
        int[] nArray = new int[]{4, 4};
        LinearNDSet linearNDSet = new LinearNDSet((MathType)realTupleType, dArray, dArray2, nArray);
        float[][] fArray = linearNDSet.getSamples();
        int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                System.out.println("values[" + n4 + "][" + n3 + "] = " + fArray[n4][n3]);
                ++n4;
            }
            ++n3;
        }
    }

    public LinearNDSet(MathType mathType, Linear1DSet[] linear1DSetArray) throws VisADException {
        this(mathType, linear1DSetArray, null, null, null);
    }

    public LinearNDSet(MathType mathType, double[] dArray, double[] dArray2, int[] nArray) throws VisADException {
        this(mathType, LinearNDSet.get_linear1d_array(mathType, dArray, dArray2, nArray), null, null, null);
    }

    public LinearNDSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, null, LinearNDSet.get_lengths(linear1DSetArray), coordinateSystem, unitArray, errorEstimateArray);
        if (this.DomainDimension != this.ManifoldDimension) {
            throw new SetException("LinearNDSet: DomainDimension != ManifoldDimension");
        }
        this.L = new Linear1DSet[this.DomainDimension];
        int n = 0;
        while (n < this.DomainDimension) {
            this.L[n] = linear1DSetArray[n];
            this.Low[n] = this.L[n].getLowX();
            this.Hi[n] = this.L[n].getHiX();
            if (this.SetErrors[n] != null) {
                this.SetErrors[n] = new ErrorEstimate(this.SetErrors[n].getErrorValue(), (double)(this.Low[n] + this.Hi[n]) / 2.0, this.Length, this.SetErrors[n].getUnit());
            }
            ++n;
        }
    }

    public LinearNDSet(MathType mathType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, LinearNDSet.get_linear1d_array(mathType, dArray, dArray2, nArray), coordinateSystem, unitArray, errorEstimateArray);
    }
}

