/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealType;
import visad.SI;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class LinearLatLonSet
extends Linear2DSet {
    private boolean LongitudeWrap;
    private double WrapStep;
    private double WrapFactor;
    private int latI;
    private int lonI;
    private double halfPiLat;
    private double halfPiLon;
    private double twoPiLon;
    private Linear1DSet lat;
    private Linear1DSet lon;

    private void setParameters() throws VisADException, UnitException {
        MathType mathType = ((SetType)this.getType()).getDomain().getComponent(0);
        int n = this.latI = RealType.Latitude.equals(mathType) ? 0 : 1;
        if (this.latI == 0) {
            this.lonI = 1;
            this.lat = this.X;
            this.lon = this.Y;
        } else {
            this.lonI = 0;
            this.lat = this.Y;
            this.lon = this.X;
        }
        Unit[] unitArray = this.getSetUnits();
        this.halfPiLat = SI.radian.toThat(1.5707963267948966, unitArray[this.latI]);
        this.halfPiLon = SI.radian.toThat(1.5707963267948966, unitArray[this.lonI]);
        this.twoPiLon = 4.0 * this.halfPiLon;
    }

    private void setLatLonUnits() {
    }

    void checkWrap() throws VisADException {
        Unit[] unitArray = this.getSetUnits();
        if ((double)this.Low[this.latI] < -this.halfPiLat || (double)this.Hi[this.latI] > this.halfPiLat || (double)this.Low[this.lonI] < -this.twoPiLon || (double)this.Hi[this.lonI] > this.twoPiLon || (double)(this.Hi[this.lonI] - this.Low[this.lonI]) > this.twoPiLon) {
            throw new SetException("LinearLatLonSet: out of bounds (note Lat and Lon in Radians)");
        }
        boolean bl = this.LongitudeWrap = (double)(this.Hi[this.lonI] - this.Low[this.lonI]) + 2.0 * Math.abs(this.lon.getStep()) >= this.twoPiLon && this.lon.getLength() > 1;
        if (this.LongitudeWrap) {
            this.WrapStep = this.twoPiLon - (double)(this.Hi[this.lonI] - this.Low[this.lonI]);
            this.WrapFactor = Math.abs(this.lon.getStep()) / this.WrapStep;
        }
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        if (fArray.length != 2) {
            throw new SetException("LinearLatLonSet.gridToValue: grid dimension should be 2, not " + fArray.length);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("LinearLatLonSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[][]{fArray[this.latI]};
        float[][] fArray3 = new float[][]{fArray[this.lonI]};
        if (this.LongitudeWrap) {
            float f = this.lon.getLength();
            float f2 = f - 0.5f;
            float f3 = f - 1.0f;
            int n2 = 0;
            while (n2 < n) {
                if (fArray3[0][n2] > f3) {
                    fArray3[0][n2] = (float)((double)f3 + (double)(fArray3[0][n2] - f3) / this.WrapFactor);
                    if (fArray3[0][n2] > f2) {
                        float[] fArray4 = fArray3[0];
                        int n3 = n2;
                        fArray4[n3] = fArray4[n3] - f;
                    }
                } else if ((double)fArray3[0][n2] < 0.0) {
                    fArray3[0][n2] = (float)((double)fArray3[0][n2] / this.WrapFactor);
                    if ((double)fArray3[0][n2] < -0.5) {
                        float[] fArray5 = fArray3[0];
                        int n4 = n2;
                        fArray5[n4] = fArray5[n4] + f;
                    }
                }
                ++n2;
            }
        }
        float[][] fArray6 = this.lat.gridToValue(fArray2);
        float[][] fArray7 = this.lon.gridToValue(fArray3);
        float[][] fArray8 = new float[2][];
        fArray8[this.latI] = fArray6[0];
        fArray8[this.lonI] = fArray7[0];
        return fArray8;
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        float f;
        if (fArray.length != 2) {
            throw new SetException("LinearLatLonSet.valueToGrid: value dimension should be 2, not " + fArray.length);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("LinearLatLonSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[][]{fArray[this.latI]};
        float[] fArray3 = fArray[this.lonI];
        float[][] fArray4 = this.lat.valueToGrid(fArray2);
        float[] fArray5 = new float[n];
        float f2 = (float)(this.lon.getFirst() - 0.5 * this.lon.getStep());
        float f3 = (float)(this.lon.getFirst() + ((double)this.lon.getLength() - 0.5) * this.lon.getStep());
        if (f3 < f2) {
            float f4 = f2;
            f2 = f3;
            f3 = f4;
        }
        if (this.LongitudeWrap) {
            f2 = (float)((double)f2 + 0.5 * Math.abs(this.lon.getStep()) - 0.5 * this.WrapStep);
            f3 = (float)((double)f2 + this.twoPiLon);
        }
        int n2 = 0;
        while (n2 < n) {
            f = (float)((double)fArray3[n2] % this.twoPiLon);
            if (f <= f2) {
                f = (float)((double)f + this.twoPiLon);
            } else if (f3 <= f) {
                f = (float)((double)f - this.twoPiLon);
            }
            fArray5[n2] = (float)(f2 < f && f < f3 ? ((double)f - this.lon.getFirst()) * this.lon.getInvstep() : Double.NaN);
            ++n2;
        }
        if (this.LongitudeWrap) {
            float f5 = this.lon.getLength();
            f = f5 - 0.5f;
            float f6 = f5 - 1.0f;
            int n3 = 0;
            while (n3 < n) {
                if (fArray5[n3] > f6) {
                    fArray5[n3] = (float)((double)f6 + (double)(fArray5[n3] - f6) * this.WrapFactor);
                    if (fArray5[n3] > f) {
                        int n4 = n3;
                        fArray5[n4] = fArray5[n4] - f5;
                    }
                } else if ((double)fArray5[n3] < 0.0) {
                    fArray5[n3] = (float)((double)fArray5[n3] * this.WrapFactor);
                    if ((double)fArray5[n3] < -0.5) {
                        int n5 = n3;
                        fArray5[n5] = fArray5[n5] + f5;
                    }
                }
                ++n3;
            }
        }
        float[][] fArray6 = new float[2][];
        fArray6[this.latI] = fArray4[0];
        fArray6[this.lonI] = fArray5;
        return fArray6;
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int[] nArray2;
        if (fArray.length != this.DomainDimension) {
            throw new SetException("LinearLatLonSet Domain dimension should be 2, not " + this.DomainDimension);
        }
        int n = fArray[0].length;
        if (nArray.length != n) {
            throw new SetException("LinearLatLonSet.valueToInterp: indices length " + nArray.length + " doesn't match value[0] length " + fArray[0].length);
        }
        if (fArray2.length != n) {
            throw new SetException("LinearLatLonSet.valueToInterp: weights length " + fArray2.length + " doesn't match value[0] length " + fArray[0].length);
        }
        float[][] fArray3 = this.valueToGrid(fArray);
        int[] nArray3 = new int[2];
        float[] fArray4 = new float[2];
        nArray2 = new int[]{1, nArray2[0] * this.Lengths[0]};
        int n2 = 0;
        while (n2 < n) {
            float[] fArray5;
            int[] nArray4;
            int n3;
            boolean bl = false;
            int n4 = 1;
            if (Double.isNaN(fArray3[this.lonI][n2])) {
                n3 = -1;
            } else {
                nArray3[this.lonI] = (int)((double)fArray3[this.lonI][n2] + 0.5);
                fArray4[this.lonI] = fArray3[this.lonI][n2] - (float)nArray3[this.lonI];
                if (!(nArray3[this.lonI] == 0 && (double)fArray4[this.lonI] <= 0.0 || nArray3[this.lonI] == this.Lengths[this.lonI] - 1 && (double)fArray4[this.lonI] >= 0.0)) {
                    n4 *= 2;
                } else if (this.LongitudeWrap) {
                    n4 *= 2;
                    bl = true;
                }
                n3 = nArray3[this.lonI];
            }
            if (n3 >= 0) {
                if (Double.isNaN(fArray3[this.latI][n2])) {
                    n3 = -1;
                } else {
                    nArray3[this.latI] = (int)((double)fArray3[this.latI][n2] + 0.5);
                    fArray4[this.latI] = fArray3[this.latI][n2] - (float)nArray3[this.latI];
                    if (!(nArray3[this.latI] == 0 && (double)fArray4[this.latI] <= 0.0 || nArray3[this.latI] == this.Lengths[this.latI] - 1 && (double)fArray4[this.latI] >= 0.0)) {
                        n4 *= 2;
                    }
                    n3 = nArray2[this.latI] * nArray3[this.latI] + nArray2[this.lonI] * n3;
                }
            }
            if (n3 < 0) {
                nArray4 = null;
                fArray5 = null;
            } else {
                int n5;
                float f;
                float f2;
                int n6;
                nArray4 = new int[n4];
                fArray5 = new float[n4];
                nArray4[0] = n3;
                fArray5[0] = 1.0f;
                int n7 = 1;
                if (!(nArray3[this.latI] == 0 && (double)fArray4[this.latI] <= 0.0 || nArray3[this.latI] == this.Lengths[this.latI] - 1 && (double)fArray4[this.latI] >= 0.0)) {
                    if ((double)fArray4[this.latI] >= 0.0) {
                        n6 = nArray2[this.latI];
                        f2 = 1.0f - fArray4[this.latI];
                        f = fArray4[this.latI];
                    } else {
                        n6 = -nArray2[this.latI];
                        f2 = 1.0f + fArray4[this.latI];
                        f = -fArray4[this.latI];
                    }
                    n5 = 0;
                    while (n5 < n7) {
                        nArray4[n5 + n7] = nArray4[n5] + n6;
                        fArray5[n5 + n7] = fArray5[n5] * f;
                        int n8 = n5++;
                        fArray5[n8] = fArray5[n8] * f2;
                    }
                    n7 *= 2;
                }
                if (!(!bl && (nArray3[this.lonI] == 0 && (double)fArray4[this.lonI] <= 0.0 || nArray3[this.lonI] == this.Lengths[this.lonI] - 1 && (double)fArray4[this.lonI] >= 0.0))) {
                    if (bl && nArray3[this.lonI] == 0) {
                        n6 = nArray2[this.lonI] * (this.Lengths[this.lonI] - 1);
                        f2 = 1.0f + fArray4[this.lonI];
                        f = -fArray4[this.lonI];
                    } else if (bl && nArray3[this.lonI] == this.Lengths[this.lonI] - 1) {
                        n6 = -nArray2[this.lonI] * (this.Lengths[this.lonI] - 1);
                        f2 = 1.0f - fArray4[this.lonI];
                        f = fArray4[this.lonI];
                    } else if ((double)fArray4[this.lonI] >= 0.0) {
                        n6 = nArray2[this.lonI];
                        f2 = 1.0f - fArray4[this.lonI];
                        f = fArray4[this.lonI];
                    } else {
                        n6 = -nArray2[this.lonI];
                        f2 = 1.0f + fArray4[this.lonI];
                        f = -fArray4[this.lonI];
                    }
                    n5 = 0;
                    while (n5 < n7) {
                        nArray4[n5 + n7] = nArray4[n5] + n6;
                        fArray5[n5 + n7] = fArray5[n5] * f;
                        int n9 = n5++;
                        fArray5[n9] = fArray5[n9] * f2;
                    }
                    n7 *= 2;
                }
            }
            nArray[n2] = nArray4;
            fArray2[n2] = fArray5;
            ++n2;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinearLatLonSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        return this.X.equals(((LinearLatLonSet)object).getX()) && this.Y.equals(((LinearLatLonSet)object).getY());
    }

    public Object clone() {
        try {
            Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone()};
            return new LinearLatLonSet(this.Type, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("LinearLatLonSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone()};
        return new LinearLatLonSet(mathType, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String string) throws VisADException {
        String string2 = string + "LinearLatLonSet: Length = " + this.Length + "\n";
        string2 = string2 + string + "  Dimension 1: Length = " + this.X.getLength() + " Range = " + this.X.getFirst() + " to " + this.X.getLast() + "\n";
        string2 = string2 + string + "  Dimension 2: Length = " + this.Y.getLength() + " Range = " + this.Y.getFirst() + " to " + this.Y.getLast() + "\n";
        return string2;
    }

    public LinearLatLonSet(MathType mathType, Linear1DSet[] linear1DSetArray) throws VisADException {
        this(mathType, linear1DSetArray, null, null, null);
    }

    public LinearLatLonSet(MathType mathType, double d, double d2, int n, double d3, double d4, int n2) throws VisADException {
        this(mathType, d, d2, n, d3, d4, n2, null, null, null);
    }

    public LinearLatLonSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.setParameters();
        this.checkWrap();
    }

    public LinearLatLonSet(MathType mathType, double d, double d2, int n, double d3, double d4, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, d, d2, n, d3, d4, n2, coordinateSystem, unitArray, errorEstimateArray);
        this.setParameters();
        this.checkWrap();
    }
}

