/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADTriangleStripArray;

public class Linear3DSet
extends Gridded3DSet
implements LinearSet {
    Linear1DSet X;
    Linear1DSet Y;
    Linear1DSet Z;

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        float[][] fArray = new float[3][n];
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] >= 0 && nArray[n2] < this.Length) {
                nArray2[n2] = nArray[n2] % this.LengthX;
                int n3 = nArray[n2] / this.LengthX;
                nArray3[n2] = n3 % this.LengthY;
                nArray4[n2] = n3 / this.LengthY;
            } else {
                nArray2[n2] = -1;
                nArray3[n2] = -1;
                nArray4[n2] = -1;
            }
            ++n2;
        }
        float[][] fArray2 = this.X.indexToValue(nArray2);
        float[][] fArray3 = this.Y.indexToValue(nArray3);
        float[][] fArray4 = this.Z.indexToValue(nArray4);
        fArray[0] = fArray2[0];
        fArray[1] = fArray3[0];
        fArray[2] = fArray4[0];
        return fArray;
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        if (fArray.length != this.ManifoldDimension) {
            throw new SetException("Linear3DSet.gridToValue: grid dimension " + fArray.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension != 3) {
            throw new SetException("Linear3DSet.gridToValue: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2) {
            throw new SetException("Linear3DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[][]{fArray[0]};
        float[][] fArray3 = new float[][]{fArray[1]};
        float[][] fArray4 = new float[][]{fArray[2]};
        float[][] fArray5 = this.X.gridToValue(fArray2);
        float[][] fArray6 = this.Y.gridToValue(fArray3);
        float[][] fArray7 = this.Z.gridToValue(fArray4);
        float[][] fArray8 = new float[][]{fArray5[0], fArray6[0], fArray7[0]};
        return fArray8;
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        if (fArray.length != 3) {
            throw new SetException("Linear3DSet.valueToGrid: value dimension must be 3, not " + fArray.length);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2) {
            throw new SetException("Linear3DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[][]{fArray[0]};
        float[][] fArray3 = new float[][]{fArray[1]};
        float[][] fArray4 = new float[][]{fArray[2]};
        float[][] fArray5 = this.X.valueToGrid(fArray2);
        float[][] fArray6 = this.Y.valueToGrid(fArray3);
        float[][] fArray7 = this.Z.valueToGrid(fArray4);
        float[][] fArray8 = new float[][]{fArray5[0], fArray6[0], fArray7[0]};
        return fArray8;
    }

    public Linear1DSet getX() {
        return this.X;
    }

    public Linear1DSet getY() {
        return this.Y;
    }

    public Linear1DSet getZ() {
        return this.Z;
    }

    public boolean isMissing() {
        return false;
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToValue(nArray);
    }

    public VisADGeometryArray[] make3DGeometry(byte[][] byArray) throws VisADException {
        if (this.ManifoldDimension != 3) {
            throw new SetException("Linear3DSet.make3DGeometry: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int n = this.X.getLength();
        int n2 = this.Y.getLength();
        int n3 = this.Z.getLength();
        if (n < 2 || n2 < 2 || n3 < 2 || byArray.length < 4) {
            VisADGeometryArray visADGeometryArray = this.makePointGeometry(byArray);
            return new VisADGeometryArray[]{visADGeometryArray, visADGeometryArray, visADGeometryArray};
        }
        double d = this.X.getFirst();
        double d2 = this.Y.getFirst();
        double d3 = this.Z.getFirst();
        double d4 = this.X.getLast();
        double d5 = this.Y.getLast();
        double d6 = this.Z.getLast();
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n3) {
                    float f = byArray[0][n4 + n * (n5 + n2 * n6)];
                    float f2 = byArray[2][n4 + n * (n5 + n2 * n6)];
                    float f3 = byArray[3][n4 + n * (n5 + n2 * n6)];
                    float f4 = byArray[4][n4 + n * (n5 + n2 * n6)];
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        VisADGeometryArray[] visADGeometryArrayArray = new VisADTriangleStripArray[]{new VisADTriangleStripArray(), new VisADTriangleStripArray(), new VisADTriangleStripArray()};
        return visADGeometryArrayArray;
    }

    public VisADGeometryArray makeLinearIsoSurface(float f, float[] fArray, byte[][] byArray, boolean bl, ScalarMap[] scalarMapArray, int[] nArray) throws VisADException {
        boolean bl2 = false;
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("Linear3DSet.makeLinearIsoSurface: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int n = this.LengthY;
        int n2 = this.LengthX;
        int n3 = this.LengthZ;
        float[] fArray2 = fArray;
        int n4 = n * n2;
        int n5 = n4 * n3;
        int n6 = (n - 1) * (n2 - 1) * (n3 - 1);
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n6 + 1];
        int n7 = Gridded3DSet.flags(f, nArray2, nArray3, nArray4, fArray2, n, n2, n3);
        if (bl2) {
            System.out.println("npolygons= " + n7);
        }
        if (n7 == 0) {
            return null;
        }
        nArray4 = null;
        int n8 = 4 * n7 + 100;
        int n9 = 9 * (n8 + 50);
        int n10 = 7 * n7;
        float[][] fArray3 = new float[1][n8];
        float[][] fArray4 = new float[1][n8];
        float[][] fArray5 = new float[1][n8];
        byte[][] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length][];
        }
        int[] nArray5 = new int[n9];
        int[] nArray6 = new int[n10];
        int[][] nArray7 = new int[][]{nArray5};
        float[] fArray6 = new float[6];
        Unit[] unitArray = this.getSetUnits();
        RealTupleType realTupleType = ((SetType)this.getType()).getDomain();
        Unit[] unitArray2 = realTupleType.getDefaultUnits();
        Linear1DSet[] linear1DSetArray = new Linear1DSet[]{this.getX(), this.getY(), this.getZ()};
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        int n11 = 0;
        while (n11 < 3) {
            double d = linear1DSetArray[n11].getFirst();
            double d2 = linear1DSetArray[n11].getStep();
            if (unitArray[n11] != null && !unitArray[n11].equals(unitArray2[n11])) {
                double d3 = unitArray[n11].toThat(0.0, unitArray2[n11]);
                double d4 = unitArray[n11].toThat(1.0, unitArray2[n11]) - d3;
                d = d3 + d4 * d;
                d2 = d4 * d2;
            }
            scalarMapArray[n11].getScale(dArray, dArray2, dArray3);
            fArray6[2 * n11] = (float)(dArray[1] + dArray[0] * d);
            fArray6[2 * n11 + 1] = (float)(dArray[0] * d2);
            ++n11;
        }
        float f2 = fArray6[0];
        fArray6[0] = fArray6[2];
        fArray6[2] = f2;
        f2 = fArray6[1];
        fArray6[1] = fArray6[3];
        fArray6[3] = f2;
        int n12 = this.linear_isosurf(f, nArray2, n8, n7, fArray2, n, n2, n3, fArray4, fArray3, fArray5, byArray, byArray2, nArray7, nArray6, fArray6);
        nArray5 = nArray7[0];
        if (n12 == 0) {
            return null;
        }
        nArray2 = null;
        nArray3 = null;
        float[][] fArray7 = new float[3][n12];
        System.arraycopy(fArray3[0], 0, fArray7[nArray[0]], 0, n12);
        System.arraycopy(fArray4[0], 0, fArray7[nArray[1]], 0, n12);
        System.arraycopy(fArray5[0], 0, fArray7[nArray[2]], 0, n12);
        fArray3 = null;
        fArray4 = null;
        fArray5 = null;
        byte[][] byArray3 = null;
        if (byArray != null) {
            byArray3 = new byte[byArray.length][n12];
            System.arraycopy(byArray2[0], 0, byArray3[0], 0, n12);
            System.arraycopy(byArray2[1], 0, byArray3[1], 0, n12);
            System.arraycopy(byArray2[2], 0, byArray3[2], 0, n12);
            if (byArray2.length > 3) {
                System.arraycopy(byArray2[3], 0, byArray3[3], 0, n12);
            }
            byArray2 = null;
        }
        if (bl2) {
            System.out.println("nvertex= " + n12);
        }
        float[] fArray8 = new float[n7];
        float[] fArray9 = new float[n7];
        float[] fArray10 = new float[n7];
        float[] fArray11 = new float[n7];
        float[] fArray12 = new float[n7];
        float[] fArray13 = new float[n7];
        float[] fArray14 = new float[n7];
        float[] fArray15 = new float[n7];
        float[] fArray16 = new float[n7];
        float[] fArray17 = new float[n12];
        float[] fArray18 = new float[n12];
        float[] fArray19 = new float[n12];
        Gridded3DSet.make_normals(fArray7[0], fArray7[1], fArray7[2], fArray17, fArray18, fArray19, n12, n7, fArray14, fArray15, fArray16, fArray8, fArray9, fArray10, fArray11, fArray12, fArray13, nArray5, nArray6);
        fArray16 = null;
        fArray15 = null;
        fArray14 = null;
        fArray13 = null;
        fArray12 = null;
        fArray11 = null;
        fArray10 = null;
        fArray9 = null;
        fArray8 = null;
        float[] fArray20 = new float[3 * n12];
        int n13 = 0;
        n11 = 0;
        while (n11 < n12) {
            fArray20[n13++] = fArray17[n11];
            fArray20[n13++] = fArray18[n11];
            fArray20[n13++] = fArray19[n11];
            ++n11;
        }
        fArray19 = null;
        fArray18 = null;
        fArray17 = null;
        int[] nArray8 = new int[6 * n7];
        int[] nArray9 = new int[n7];
        int n14 = Gridded3DSet.poly_triangle_stripe(nArray9, nArray8, n12, n7, nArray5, nArray6);
        nArray5 = null;
        nArray6 = null;
        if (bl) {
            VisADIndexedTriangleStripArray visADIndexedTriangleStripArray = new VisADIndexedTriangleStripArray();
            visADIndexedTriangleStripArray.indexCount = n14;
            visADIndexedTriangleStripArray.indices = new int[n14];
            System.arraycopy(nArray8, 0, visADIndexedTriangleStripArray.indices, 0, n14);
            visADIndexedTriangleStripArray.stripVertexCounts = new int[1];
            visADIndexedTriangleStripArray.stripVertexCounts[0] = n14;
            nArray8 = null;
            SampledSet.setGeometryArray(visADIndexedTriangleStripArray, fArray7, 4, byArray3);
            fArray7 = null;
            byArray3 = null;
            visADIndexedTriangleStripArray.normals = fArray20;
            if (bl2) {
                System.out.println("size_stripe= " + n14);
                int n15 = 0;
                while (n15 < n14) {
                    System.out.println(visADIndexedTriangleStripArray.indices[n15]);
                    ++n15;
                }
            }
            return visADIndexedTriangleStripArray;
        }
        VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
        visADTriangleStripArray.stripVertexCounts = new int[]{n14};
        visADTriangleStripArray.vertexCount = n14;
        visADTriangleStripArray.normals = new float[3 * n14];
        int n16 = 0;
        n11 = 0;
        while (n11 < 3 * n14) {
            n13 = 3 * nArray8[n16];
            visADTriangleStripArray.normals[n11] = fArray20[n13];
            visADTriangleStripArray.normals[n11 + 1] = fArray20[n13 + 1];
            visADTriangleStripArray.normals[n11 + 2] = fArray20[n13 + 2];
            ++n16;
            n11 += 3;
        }
        fArray20 = null;
        visADTriangleStripArray.coordinates = new float[3 * n14];
        n16 = 0;
        n11 = 0;
        while (n11 < 3 * n14) {
            n13 = nArray8[n16];
            visADTriangleStripArray.coordinates[n11] = fArray7[0][n13];
            visADTriangleStripArray.coordinates[n11 + 1] = fArray7[1][n13];
            visADTriangleStripArray.coordinates[n11 + 2] = fArray7[2][n13];
            ++n16;
            n11 += 3;
        }
        fArray7 = null;
        if (byArray3 != null) {
            int n17 = byArray3.length;
            visADTriangleStripArray.colors = new byte[n17 * n14];
            n16 = 0;
            if (n17 == 4) {
                n11 = 0;
                while (n11 < n17 * n14) {
                    n13 = nArray8[n16];
                    visADTriangleStripArray.colors[n11] = byArray3[0][n13];
                    visADTriangleStripArray.colors[n11 + 1] = byArray3[1][n13];
                    visADTriangleStripArray.colors[n11 + 2] = byArray3[2][n13];
                    visADTriangleStripArray.colors[n11 + 3] = byArray3[3][n13];
                    ++n16;
                    n11 += n17;
                }
            } else {
                n11 = 0;
                while (n11 < n17 * n14) {
                    n13 = nArray8[n16];
                    visADTriangleStripArray.colors[n11] = byArray3[0][n13];
                    visADTriangleStripArray.colors[n11 + 1] = byArray3[1][n13];
                    visADTriangleStripArray.colors[n11 + 2] = byArray3[2][n13];
                    ++n16;
                    n11 += n17;
                }
            }
        }
        byArray3 = null;
        nArray8 = null;
        return visADTriangleStripArray;
    }

    private int linear_isosurf(float f, int[] nArray, int n, int n2, float[] fArray, int n3, int n4, int n5, float[][] fArray2, float[][] fArray3, float[][] fArray4, byte[][] byArray, byte[][] byArray2, int[][] nArray2, int[] nArray3, float[] fArray5) throws VisADException {
        int n6;
        int[] nArray4 = new int[13];
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        int n7 = 0;
        int n8 = n3 * n4;
        float f10 = fArray5[0];
        float f11 = fArray5[1];
        float f12 = fArray5[2];
        float f13 = fArray5[3];
        float f14 = fArray5[4];
        float f15 = fArray5[5];
        int n9 = n6 = byArray != null ? byArray.length : 0;
        if (n6 > 0) {
            if (byArray2 == null || byArray2.length != n6) {
                throw new SetException("Linear3DSet.isosurf: auxLevels length " + byArray2.length + " doesn't match expected " + n6);
            }
            int n10 = 0;
            while (n10 < n6) {
                if (byArray[n10].length != this.Length) {
                    throw new SetException("Linear3DSet.isosurf: expected auxValues  length#" + n10 + " to be " + this.Length + ", not " + byArray[n10].length);
                }
                ++n10;
            }
        } else if (byArray2 != null) {
            throw new SetException("Linear3DSet.isosurf: auxValues null but auxLevels not null");
        }
        byte[][] byArray3 = n6 > 0 ? new byte[n6][n] : null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 1;
        int n14 = 1;
        int n15 = 0;
        while (n15 < nArray2[0].length) {
            nArray2[0][n15] = -2000000000;
            ++n15;
        }
        n15 = 8;
        while (n15 < nArray2[0].length) {
            nArray2[0][n15] = 0;
            n15 += 9;
        }
        n15 = 0;
        while (n15 < nArray3.length) {
            nArray3[n15] = -2000000000;
            ++n15;
        }
        n15 = 6;
        while (n15 < nArray3.length) {
            nArray3[n15] = 0;
            n15 += 7;
        }
        int n16 = n8 - n4;
        int n17 = n8 - n3;
        int n18 = n4;
        int n19 = 2 * (n16 + n17 + n18);
        int[] nArray5 = new int[n19];
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        while (n24 < n5 - 1) {
            int n25;
            int n26 = 0;
            while (n26 < n3 - 1) {
                int n27 = 0;
                while (n27 < n4 - 1) {
                    if (nArray[n22] != 0 & nArray[n22] != 255) {
                        int n28;
                        float f16;
                        if (n23 + 12 > n) {
                            n = 2 * (n23 + 12);
                            if (n6 > 0) {
                                int n29 = 0;
                                while (n29 < n6) {
                                    byte[] byArray4 = byArray3[n29];
                                    byArray3[n29] = new byte[n];
                                    System.arraycopy(byArray4, 0, byArray3[n29], 0, n23);
                                    ++n29;
                                }
                            }
                            float[] fArray6 = fArray2[0];
                            fArray2[0] = new float[n];
                            System.arraycopy(fArray6, 0, fArray2[0], 0, fArray6.length);
                            fArray6 = fArray3[0];
                            fArray3[0] = new float[n];
                            System.arraycopy(fArray6, 0, fArray3[0], 0, fArray6.length);
                            fArray6 = fArray4[0];
                            fArray4[0] = new float[n];
                            System.arraycopy(fArray6, 0, fArray4[0], 0, fArray6.length);
                            int n30 = 9 * (n + 50);
                            int[] nArray6 = nArray2[0];
                            nArray2[0] = new int[n30];
                            n15 = 0;
                            while (n15 < nArray2[0].length) {
                                nArray2[0][n15] = -2000000000;
                                ++n15;
                            }
                            n15 = 8;
                            while (n15 < nArray2[0].length) {
                                nArray2[0][n15] = 0;
                                n15 += 9;
                            }
                            System.arraycopy(nArray6, 0, nArray2[0], 0, nArray6.length);
                        }
                        f2 = fArray[n7];
                        f3 = fArray[n7 + n4];
                        f4 = fArray[n7 + 1];
                        f5 = fArray[n7 + n4 + 1];
                        f6 = fArray[n7 + n8];
                        f7 = fArray[n7 + n4 + n8];
                        f8 = fArray[n7 + 1 + n8];
                        f9 = fArray[n7 + 1 + n4 + n8];
                        if (nArray[n22] < 317) {
                            int n31;
                            int n32 = Gridded3DSet.pol_edges[nArray[n22]][2];
                            int n33 = nArray[n22];
                            int n34 = 4;
                            int n35 = n20;
                            int n36 = Gridded3DSet.pol_edges[nArray[n22]][1];
                            n19 = 0;
                            while (n19 < n36) {
                                nArray3[n35 + 6] = n31 = n32 & 0xF;
                                n31 += n35;
                                n15 = n35;
                                while (n15 < n31 && n15 < n35 + 6) {
                                    nArray3[n15] = Gridded3DSet.pol_edges[n33][n34];
                                    if (++n34 >= 16) {
                                        ++n33;
                                        n34 -= 16;
                                    }
                                    ++n15;
                                }
                                n32 >>= 4;
                                n35 += 7;
                                ++n19;
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 2) != 0) {
                                if (n24 != 0 || n27 != 0) {
                                    nArray4[1] = nArray5[n12 * n16 + n26 * n4 + n27];
                                } else {
                                    f16 = (f - f2) / (f3 - f2);
                                    fArray2[0][n23] = f10 + f11 * (f16 + (float)n26);
                                    fArray3[0][n23] = f12 + f13 * (float)n27;
                                    fArray4[0][n23] = f14 + f15 * (float)n24;
                                    int n37 = 0;
                                    while (n37 < n6) {
                                        n28 = (int)(f16 * (byArray[n37][n7 + n4] < 0 ? (float)byArray[n37][n7 + n4] + 256.0f : (float)byArray[n37][n7 + n4]) + (1.0f - f16) * (byArray[n37][n7] < 0 ? (float)byArray[n37][n7] + 256.0f : (float)byArray[n37][n7]));
                                        byArray3[n37][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n37;
                                    }
                                    nArray4[1] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 4) != 0) {
                                if (n24 != 0 || n26 != 0) {
                                    nArray4[2] = nArray5[2 * n16 + n12 * n17 + n27 * n3 + n26];
                                } else {
                                    f16 = (f - f2) / (f4 - f2);
                                    fArray2[0][n23] = f10 + f11 * (float)n26;
                                    fArray3[0][n23] = f12 + f13 * (f16 + (float)n27);
                                    fArray4[0][n23] = f14 + f15 * (float)n24;
                                    int n38 = 0;
                                    while (n38 < n6) {
                                        n28 = (int)(f16 * (byArray[n38][n7 + 1] < 0 ? (float)byArray[n38][n7 + 1] + 256.0f : (float)byArray[n38][n7 + 1]) + (1.0f - f16) * (byArray[n38][n7] < 0 ? (float)byArray[n38][n7] + 256.0f : (float)byArray[n38][n7]));
                                        byArray3[n38][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n38;
                                    }
                                    nArray4[2] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 8) != 0) {
                                if (n26 != 0 || n27 != 0) {
                                    nArray4[3] = nArray5[2 * n16 + 2 * n17 + n11 * n18 + n27];
                                } else {
                                    f16 = (f - f2) / (f6 - f2);
                                    fArray2[0][n23] = f10 + f11 * (float)n26;
                                    fArray3[0][n23] = f12 + f13 * (float)n27;
                                    fArray4[0][n23] = f14 + f15 * (f16 + (float)n24);
                                    int n39 = 0;
                                    while (n39 < n6) {
                                        n28 = (int)(f16 * (byArray[n39][n7 + n8] < 0 ? (float)byArray[n39][n7 + n8] + 256.0f : (float)byArray[n39][n7 + n8]) + (1.0f - f16) * (byArray[n39][n7] < 0 ? (float)byArray[n39][n7] + 256.0f : (float)byArray[n39][n7]));
                                        byArray3[n39][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n39;
                                    }
                                    nArray4[3] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x10) != 0) {
                                if (n24 != 0) {
                                    nArray4[4] = nArray5[2 * n16 + n12 * n17 + n27 * n3 + (n26 + 1)];
                                } else {
                                    f16 = (f - f3) / (f5 - f3);
                                    fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                    fArray3[0][n23] = f12 + f13 * (f16 + (float)n27);
                                    fArray4[0][n23] = f14 + f15 * (float)n24;
                                    int n40 = 0;
                                    while (n40 < n6) {
                                        n28 = (int)(f16 * (byArray[n40][n7 + n4 + 1] < 0 ? (float)byArray[n40][n7 + n4 + 1] + 256.0f : (float)byArray[n40][n7 + n4 + 1]) + (1.0f - f16) * (byArray[n40][n7 + n4] < 0 ? (float)byArray[n40][n7 + n4] + 256.0f : (float)byArray[n40][n7 + n4]));
                                        byArray3[n40][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n40;
                                    }
                                    nArray4[4] = n23;
                                    nArray5[2 * n16 + n12 * n17 + n27 * n3 + (n26 + 1)] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x20) != 0) {
                                if (n27 != 0) {
                                    nArray4[5] = nArray5[2 * n16 + 2 * n17 + n13 * n18 + n27];
                                } else {
                                    f16 = (f - f3) / (f7 - f3);
                                    fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                    fArray3[0][n23] = f12 + f13 * (float)n27;
                                    fArray4[0][n23] = f14 + f15 * (f16 + (float)n24);
                                    int n41 = 0;
                                    while (n41 < n6) {
                                        n28 = (int)(f16 * (byArray[n41][n7 + n4 + n8] < 0 ? (float)byArray[n41][n7 + n4 + n8] + 256.0f : (float)byArray[n41][n7 + n4 + n8]) + (1.0f - f16) * (byArray[n41][n7 + n4] < 0 ? (float)byArray[n41][n7 + n4] + 256.0f : (float)byArray[n41][n7 + n4]));
                                        byArray3[n41][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n41;
                                    }
                                    nArray4[5] = n23;
                                    nArray5[2 * n16 + 2 * n17 + n13 * n18 + n27] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x40) != 0) {
                                if (n24 != 0) {
                                    nArray4[6] = nArray5[n12 * n16 + n26 * n4 + (n27 + 1)];
                                } else {
                                    f16 = (f - f4) / (f5 - f4);
                                    fArray2[0][n23] = f10 + f11 * (f16 + (float)n26);
                                    fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                    fArray4[0][n23] = f14 + f15 * (float)n24;
                                    int n42 = 0;
                                    while (n42 < n6) {
                                        n28 = (int)(f16 * (byArray[n42][n7 + n4 + 1] < 0 ? (float)byArray[n42][n7 + n4 + 1] + 256.0f : (float)byArray[n42][n7 + n4 + 1]) + (1.0f - f16) * (byArray[n42][n7 + 1] < 0 ? (float)byArray[n42][n7 + 1] + 256.0f : (float)byArray[n42][n7 + 1]));
                                        byArray3[n42][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n42;
                                    }
                                    nArray4[6] = n23;
                                    nArray5[n12 * n16 + n26 * n4 + (n27 + 1)] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x80) != 0) {
                                if (n26 != 0) {
                                    nArray4[7] = nArray5[2 * n16 + 2 * n17 + n11 * n18 + (n27 + 1)];
                                } else {
                                    f16 = (f - f4) / (f8 - f4);
                                    fArray2[0][n23] = f10 + f11 * (float)n26;
                                    fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                    fArray4[0][n23] = f14 + f15 * (f16 + (float)n24);
                                    int n43 = 0;
                                    while (n43 < n6) {
                                        n28 = (int)(f16 * (byArray[n43][n7 + 1 + n8] < 0 ? (float)byArray[n43][n7 + 1 + n8] + 256.0f : (float)byArray[n43][n7 + 1 + n8]) + (1.0f - f16) * (byArray[n43][n7 + 1] < 0 ? (float)byArray[n43][n7 + 1] + 256.0f : (float)byArray[n43][n7 + 1]));
                                        byArray3[n43][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n43;
                                    }
                                    nArray4[7] = n23;
                                    nArray5[2 * n16 + 2 * n17 + n11 * n18 + (n27 + 1)] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x100) != 0) {
                                f16 = (f - f5) / (f9 - f5);
                                fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                fArray4[0][n23] = f14 + f15 * (f16 + (float)n24);
                                int n44 = 0;
                                while (n44 < n6) {
                                    n28 = (int)(f16 * (byArray[n44][n7 + 1 + n4 + n8] < 0 ? (float)byArray[n44][n7 + 1 + n4 + n8] + 256.0f : (float)byArray[n44][n7 + 1 + n4 + n8]) + (1.0f - f16) * (byArray[n44][n7 + n4 + 1] < 0 ? (float)byArray[n44][n7 + n4 + 1] + 256.0f : (float)byArray[n44][n7 + n4 + 1]));
                                    byArray3[n44][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                    ++n44;
                                }
                                nArray4[8] = n23;
                                nArray5[2 * n16 + 2 * n17 + n13 * n18 + (n27 + 1)] = n23++;
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x200) != 0) {
                                if (n27 != 0) {
                                    nArray4[9] = nArray5[n14 * n16 + n26 * n4 + n27];
                                } else {
                                    f16 = (f - f6) / (f7 - f6);
                                    fArray2[0][n23] = f10 + f11 * (f16 + (float)n26);
                                    fArray3[0][n23] = f12 + f13 * (float)n27;
                                    fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                    int n45 = 0;
                                    while (n45 < n6) {
                                        n28 = (int)(f16 * (byArray[n45][n7 + n4 + n8] < 0 ? (float)byArray[n45][n7 + n4 + n8] + 256.0f : (float)byArray[n45][n7 + n4 + n8]) + (1.0f - f16) * (byArray[n45][n7 + n8] < 0 ? (float)byArray[n45][n7 + n8] + 256.0f : (float)byArray[n45][n7 + n8]));
                                        byArray3[n45][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n45;
                                    }
                                    nArray4[9] = n23;
                                    nArray5[n14 * n16 + n26 * n4 + n27] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x400) != 0) {
                                if (n26 != 0) {
                                    nArray4[10] = nArray5[2 * n16 + n14 * n17 + n27 * n3 + n26];
                                } else {
                                    f16 = (f - f6) / (f8 - f6);
                                    fArray2[0][n23] = f10 + f11 * (float)n26;
                                    fArray3[0][n23] = f12 + f13 * (f16 + (float)n27);
                                    fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                    int n46 = 0;
                                    while (n46 < n6) {
                                        n28 = (int)(f16 * (byArray[n46][n7 + 1 + n8] < 0 ? (float)byArray[n46][n7 + 1 + n8] + 256.0f : (float)byArray[n46][n7 + 1 + n8]) + (1.0f - f16) * (byArray[n46][n7 + n8] < 0 ? (float)byArray[n46][n7 + n8] + 256.0f : (float)byArray[n46][n7 + n8]));
                                        byArray3[n46][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n46;
                                    }
                                    nArray4[10] = n23;
                                    nArray5[2 * n16 + n14 * n17 + n27 * n3 + n26] = n23++;
                                }
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x800) != 0) {
                                f16 = (f - f7) / (f9 - f7);
                                fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                fArray3[0][n23] = f12 + f13 * (f16 + (float)n27);
                                fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                int n47 = 0;
                                while (n47 < n6) {
                                    n28 = (int)(f16 * (byArray[n47][n7 + 1 + n4 + n8] < 0 ? (float)byArray[n47][n7 + 1 + n4 + n8] + 256.0f : (float)byArray[n47][n7 + 1 + n4 + n8]) + (1.0f - f16) * (byArray[n47][n7 + n4 + n8] < 0 ? (float)byArray[n47][n7 + n4 + n8] + 256.0f : (float)byArray[n47][n7 + n4 + n8]));
                                    byArray3[n47][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                    ++n47;
                                }
                                nArray4[11] = n23;
                                nArray5[2 * n16 + n14 * n17 + n27 * n3 + (n26 + 1)] = n23++;
                            }
                            if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x1000) != 0) {
                                f16 = (f - f8) / (f9 - f8);
                                fArray2[0][n23] = f10 + f11 * (f16 + (float)n26);
                                fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                int n48 = 0;
                                while (n48 < n6) {
                                    n28 = (int)(f16 * (byArray[n48][n7 + 1 + n4 + n8] < 0 ? (float)byArray[n48][n7 + 1 + n4 + n8] + 256.0f : (float)byArray[n48][n7 + 1 + n4 + n8]) + (1.0f - f16) * (byArray[n48][n7 + 1 + n8] < 0 ? (float)byArray[n48][n7 + 1 + n8] + 256.0f : (float)byArray[n48][n7 + 1 + n8]));
                                    byArray3[n48][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                    ++n48;
                                }
                                nArray4[12] = n23;
                                nArray5[n14 * n16 + n26 * n4 + (n27 + 1)] = n23++;
                            }
                            n32 = Gridded3DSet.pol_edges[nArray[n22]][2];
                            int n49 = Gridded3DSet.pol_edges[nArray[n22]][1];
                            n19 = 0;
                            while (n19 < n49) {
                                int n50 = n20 + (n32 & 0xF);
                                n15 = n20;
                                while (n15 < n50) {
                                    nArray3[n15] = n31 = nArray4[nArray3[n15]];
                                    int n51 = nArray2[0][n31 * 9 + 8];
                                    nArray2[0][n31 * 9 + n51] = n21;
                                    nArray2[0][n31 * 9 + 8] = n51 + 1;
                                    ++n15;
                                }
                                n32 >>= 4;
                                n20 += 7;
                                ++n21;
                                ++n19;
                            }
                        } else {
                            int n52 = n22;
                            nArray[n52] = nArray[n52] & 0x1FF;
                            if (nArray[n22] != 0 & nArray[n22] != 255) {
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x10) != 0 && n24 == 0 && f5 == f5 && f3 == f3) {
                                    f16 = (f - f3) / (f5 - f3);
                                    fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                    fArray3[0][n23] = f12 + f13 * (f16 + (float)n27);
                                    fArray4[0][n23] = f14 + f15 * (float)n24;
                                    int n53 = 0;
                                    while (n53 < n6) {
                                        n28 = (int)(f16 * (byArray[n53][n7 + n4 + 1] < 0 ? (float)byArray[n53][n7 + n4 + 1] + 256.0f : (float)byArray[n53][n7 + n4 + 1]) + (1.0f - f16) * (byArray[n53][n7 + n4] < 0 ? (float)byArray[n53][n7 + n4] + 256.0f : (float)byArray[n53][n7 + n4]));
                                        byArray3[n53][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n53;
                                    }
                                    nArray5[2 * n16 + n12 * n17 + n27 * n3 + (n26 + 1)] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x20) != 0 && n27 == 0 && f7 == f7 && f3 == f3) {
                                    f16 = (f - f3) / (f7 - f3);
                                    fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                    fArray3[0][n23] = f12 + f13 * (float)n27;
                                    fArray4[0][n23] = f14 + f15 * (f16 + (float)n24);
                                    int n54 = 0;
                                    while (n54 < n6) {
                                        n28 = (int)(f16 * (byArray[n54][n7 + n4 + n8] < 0 ? (float)byArray[n54][n7 + n4 + n8] + 256.0f : (float)byArray[n54][n7 + n4 + n8]) + (1.0f - f16) * (byArray[n54][n7 + n4] < 0 ? (float)byArray[n54][n7 + n4] + 256.0f : (float)byArray[n54][n7 + n4]));
                                        byArray3[n54][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n54;
                                    }
                                    nArray5[2 * n16 + 2 * n17 + n13 * n18 + n27] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x40) != 0 && n24 == 0 && f5 == f5 && f4 == f4) {
                                    f16 = (f - f4) / (f5 - f4);
                                    fArray2[0][n23] = f10 + f11 * (f16 + (float)n26);
                                    fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                    fArray4[0][n23] = f14 + f15 * (float)n24;
                                    int n55 = 0;
                                    while (n55 < n6) {
                                        n28 = (int)(f16 * (byArray[n55][n7 + n4 + 1] < 0 ? (float)byArray[n55][n7 + n4 + 1] + 256.0f : (float)byArray[n55][n7 + n4 + 1]) + (1.0f - f16) * (byArray[n55][n7 + 1] < 0 ? (float)byArray[n55][n7 + 1] + 256.0f : (float)byArray[n55][n7 + 1]));
                                        byArray3[n55][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n55;
                                    }
                                    nArray5[n12 * n16 + n26 * n4 + (n27 + 1)] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x80) != 0 && n26 == 0 && f8 == f8 && f4 == f4) {
                                    f16 = (f - f4) / (f8 - f4);
                                    fArray2[0][n23] = f10 + f11 * (float)n26;
                                    fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                    fArray4[0][n23] = f14 + f15 * (f16 + (float)n24);
                                    int n56 = 0;
                                    while (n56 < n6) {
                                        n28 = (int)(f16 * (byArray[n56][n7 + 1 + n8] < 0 ? (float)byArray[n56][n7 + 1 + n8] + 256.0f : (float)byArray[n56][n7 + 1 + n8]) + (1.0f - f16) * (byArray[n56][n7 + 1] < 0 ? (float)byArray[n56][n7 + 1] + 256.0f : (float)byArray[n56][n7 + 1]));
                                        byArray3[n56][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n56;
                                    }
                                    nArray5[2 * n16 + 2 * n17 + n11 * n18 + (n27 + 1)] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x100) != 0 && f9 == f9 && f5 == f5) {
                                    f16 = (f - f5) / (f9 - f5);
                                    fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                    fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                    fArray4[0][n23] = f14 + f15 * (f16 + (float)n24);
                                    int n57 = 0;
                                    while (n57 < n6) {
                                        n28 = (int)(f16 * (byArray[n57][n7 + 1 + n4 + n8] < 0 ? (float)byArray[n57][n7 + 1 + n4 + n8] + 256.0f : (float)byArray[n57][n7 + 1 + n4 + n8]) + (1.0f - f16) * (byArray[n57][n7 + n4 + 1] < 0 ? (float)byArray[n57][n7 + n4 + 1] + 256.0f : (float)byArray[n57][n7 + n4 + 1]));
                                        byArray3[n57][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n57;
                                    }
                                    nArray5[2 * n16 + 2 * n17 + n13 * n18 + (n27 + 1)] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x200) != 0 && n27 == 0 && f7 == f7 && f6 == f6) {
                                    f16 = (f - f6) / (f7 - f6);
                                    fArray2[0][n23] = f10 + f11 * (f16 + (float)n26);
                                    fArray3[0][n23] = f12 + f13 * (float)n27;
                                    fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                    int n58 = 0;
                                    while (n58 < n6) {
                                        n28 = (int)(f16 * (byArray[n58][n7 + n4 + n8] < 0 ? (float)byArray[n58][n7 + n4 + n8] + 256.0f : (float)byArray[n58][n7 + n4 + n8]) + (1.0f - f16) * (byArray[n58][n7 + n8] < 0 ? (float)byArray[n58][n7 + n8] + 256.0f : (float)byArray[n58][n7 + n8]));
                                        byArray3[n58][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n58;
                                    }
                                    nArray5[n14 * n16 + n26 * n4 + n27] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x400) != 0 && n26 == 0 && f8 == f8 && f6 == f6) {
                                    f16 = (f - f6) / (f8 - f6);
                                    fArray2[0][n23] = f10 + f11 * (float)n26;
                                    fArray3[0][n23] = f12 + f13 * (f16 + (float)n27);
                                    fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                    int n59 = 0;
                                    while (n59 < n6) {
                                        n28 = (int)(f16 * (byArray[n59][n7 + 1 + n8] < 0 ? (float)byArray[n59][n7 + 1 + n8] + 256.0f : (float)byArray[n59][n7 + 1 + n8]) + (1.0f - f16) * (byArray[n59][n7 + n8] < 0 ? (float)byArray[n59][n7 + n8] + 256.0f : (float)byArray[n59][n7 + n8]));
                                        byArray3[n59][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n59;
                                    }
                                    nArray5[2 * n16 + n14 * n17 + n27 * n3 + n26] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x800) != 0 && f9 == f9 && f7 == f7) {
                                    f16 = (f - f7) / (f9 - f7);
                                    fArray2[0][n23] = f10 + f11 * (float)(n26 + 1);
                                    fArray3[0][n23] = f12 + f13 * (f16 + (float)n27);
                                    fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                    int n60 = 0;
                                    while (n60 < n6) {
                                        n28 = (int)(f16 * (byArray[n60][n7 + 1 + n4 + n8] < 0 ? (float)byArray[n60][n7 + 1 + n4 + n8] + 256.0f : (float)byArray[n60][n7 + 1 + n4 + n8]) + (1.0f - f16) * (byArray[n60][n7 + n4 + n8] < 0 ? (float)byArray[n60][n7 + n4 + n8] + 256.0f : (float)byArray[n60][n7 + n4 + n8]));
                                        byArray3[n60][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n60;
                                    }
                                    nArray5[2 * n16 + n14 * n17 + n27 * n3 + (n26 + 1)] = n23++;
                                }
                                if ((Gridded3DSet.pol_edges[nArray[n22]][3] & 0x1000) != 0 && f9 == f9 && f8 == f8) {
                                    f16 = (f - f8) / (f9 - f8);
                                    fArray2[0][n23] = f10 + f11 * (f16 + (float)n26);
                                    fArray3[0][n23] = f12 + f13 * (float)(n27 + 1);
                                    fArray4[0][n23] = f14 + f15 * (float)(n24 + 1);
                                    int n61 = 0;
                                    while (n61 < n6) {
                                        n28 = (int)(f16 * (byArray[n61][n7 + 1 + n4 + n8] < 0 ? (float)byArray[n61][n7 + 1 + n4 + n8] + 256.0f : (float)byArray[n61][n7 + 1 + n4 + n8]) + (1.0f - f16) * (byArray[n61][n7 + 1 + n8] < 0 ? (float)byArray[n61][n7 + 1 + n8] + 256.0f : (float)byArray[n61][n7 + 1 + n8]));
                                        byArray3[n61][n23] = (byte)(n28 < 0 ? 0 : (n28 > 255 ? -1 : (n28 < 128 ? n28 : n28 - 256)));
                                        ++n61;
                                    }
                                    nArray5[n14 * n16 + n26 * n4 + (n27 + 1)] = n23++;
                                }
                            }
                        }
                    }
                    ++n22;
                    ++n7;
                    ++n27;
                }
                n25 = n11;
                n11 = n13;
                n13 = n25;
                ++n7;
                ++n26;
            }
            n25 = n12;
            n12 = n14;
            n14 = n25;
            n7 += n4;
            ++n24;
        }
        int n62 = 0;
        while (n62 < n6) {
            byArray2[n62] = new byte[n23];
            System.arraycopy(byArray3[n62], 0, byArray2[n62], 0, n23);
            ++n62;
        }
        return n23;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Linear3DSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        return this.X.equals(((Linear3DSet)object).getX()) && this.Y.equals(((Linear3DSet)object).getY()) && this.Z.equals(((Linear3DSet)object).getZ());
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.X.hashCode() ^ this.Y.hashCode() ^ this.Z.hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int n) {
        if (n == 0) {
            return this.getX();
        }
        if (n == 1) {
            return this.getY();
        }
        if (n == 2) {
            return this.getZ();
        }
        throw new ArrayIndexOutOfBoundsException("Invalid component index");
    }

    public Object clone() {
        try {
            Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone(), (Linear1DSet)this.Z.clone()};
            return new Linear3DSet(this.Type, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Linear3DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone(), (Linear1DSet)this.Z.clone()};
        return new Linear3DSet(mathType, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String string) throws VisADException {
        String string2 = string + "Linear3DSet: Length = " + this.Length + "\n";
        string2 = string2 + string + "  Dimension 1: Length = " + this.X.getLength() + " Range = " + this.X.getFirst() + " to " + this.X.getLast() + "\n";
        string2 = string2 + string + "  Dimension 2: Length = " + this.Y.getLength() + " Range = " + this.Y.getFirst() + " to " + this.Y.getLast() + "\n";
        string2 = string2 + string + "  Dimension 3: Length = " + this.Z.getLength() + " Range = " + this.Z.getFirst() + " to " + this.Z.getLast() + "\n";
        return string2;
    }

    public Linear3DSet(Linear1DSet[] linear1DSetArray) throws VisADException {
        this((MathType)RealTupleType.Generic3D, linear1DSetArray, null, null, null);
    }

    public Linear3DSet(MathType mathType, Linear1DSet[] linear1DSetArray) throws VisADException {
        this(mathType, linear1DSetArray, null, null, null);
    }

    public Linear3DSet(double d, double d2, int n, double d3, double d4, int n2, double d5, double d6, int n3) throws VisADException {
        this((MathType)RealTupleType.Generic3D, LinearNDSet.get_linear1d_array(RealTupleType.Generic3D, d, d2, n, d3, d4, n2, d5, d6, n3), null, null, null);
    }

    public Linear3DSet(MathType mathType, double d, double d2, int n, double d3, double d4, int n2, double d5, double d6, int n3) throws VisADException {
        this(mathType, LinearNDSet.get_linear1d_array(mathType, d, d2, n, d3, d4, n2, d5, d6, n3), null, null, null);
    }

    public Linear3DSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, null, linear1DSetArray[0].getLength(), linear1DSetArray[1].getLength(), linear1DSetArray[2].getLength(), coordinateSystem, unitArray, errorEstimateArray);
        if (this.DomainDimension != 3) {
            throw new SetException("Linear3DSet: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (linear1DSetArray.length != 3) {
            throw new SetException("Linear3DSet: ManifoldDimension must be 3, not " + linear1DSetArray.length);
        }
        this.X = linear1DSetArray[0];
        this.Y = linear1DSetArray[1];
        this.Z = linear1DSetArray[2];
        this.LengthX = this.X.getLength();
        this.LengthY = this.Y.getLength();
        this.LengthZ = this.Z.getLength();
        this.Length = this.LengthX * this.LengthY * this.LengthZ;
        this.Low[0] = this.X.getLowX();
        this.Hi[0] = this.X.getHiX();
        this.Low[1] = this.Y.getLowX();
        this.Hi[1] = this.Y.getHiX();
        this.Low[2] = this.Z.getLowX();
        this.Hi[2] = this.Z.getHiX();
        if (this.SetErrors[0] != null) {
            this.SetErrors[0] = new ErrorEstimate(this.SetErrors[0].getErrorValue(), (double)(this.Low[0] + this.Hi[0]) / 2.0, this.Length, this.SetErrors[0].getUnit());
        }
        if (this.SetErrors[1] != null) {
            this.SetErrors[1] = new ErrorEstimate(this.SetErrors[1].getErrorValue(), (double)(this.Low[1] + this.Hi[1]) / 2.0, this.Length, this.SetErrors[1].getUnit());
        }
        if (this.SetErrors[2] != null) {
            this.SetErrors[2] = new ErrorEstimate(this.SetErrors[2].getErrorValue(), (double)(this.Low[2] + this.Hi[2]) / 2.0, this.Length, this.SetErrors[2].getUnit());
        }
    }

    public Linear3DSet(MathType mathType, double d, double d2, int n, double d3, double d4, int n2, double d5, double d6, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, LinearNDSet.get_linear1d_array(mathType, d, d2, n, d3, d4, n2, d5, d6, n3), coordinateSystem, unitArray, errorEstimateArray);
    }
}

