/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Linear2DSet
extends Gridded2DSet
implements LinearSet {
    Linear1DSet X;
    Linear1DSet Y;

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        float[][] fArray = new float[2][n];
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] >= 0 && nArray[n2] < this.Length) {
                nArray2[n2] = nArray[n2] % this.LengthX;
                nArray3[n2] = nArray[n2] / this.LengthX;
            } else {
                nArray2[n2] = -1;
                nArray3[n2] = -1;
            }
            ++n2;
        }
        float[][] fArray2 = this.X.indexToValue(nArray2);
        float[][] fArray3 = this.Y.indexToValue(nArray3);
        fArray[0] = fArray2[0];
        fArray[1] = fArray3[0];
        return fArray;
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        if (fArray.length != this.ManifoldDimension) {
            throw new SetException("Linear2DSet.gridToValue: grid dimension " + fArray.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new SetException("Linear2DSet.gridToValue: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Linear2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[][]{fArray[0]};
        float[][] fArray3 = new float[][]{fArray[1]};
        float[][] fArray4 = this.X.gridToValue(fArray2);
        float[][] fArray5 = this.Y.gridToValue(fArray3);
        float[][] fArray6 = new float[][]{fArray4[0], fArray5[0]};
        return fArray6;
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        if (fArray.length != 2) {
            throw new SetException("Linear2DSet.valueToGrid: value dimension must be 2, not " + fArray.length);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Linear2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[][]{fArray[0]};
        float[][] fArray3 = new float[][]{fArray[1]};
        float[][] fArray4 = this.X.valueToGrid(fArray2);
        float[][] fArray5 = this.Y.valueToGrid(fArray3);
        float[][] fArray6 = new float[][]{fArray4[0], fArray5[0]};
        return fArray6;
    }

    public Linear1DSet getX() {
        return this.X;
    }

    public Linear1DSet getY() {
        return this.Y;
    }

    public boolean isMissing() {
        return false;
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToValue(nArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Linear2DSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        return this.X.equals(((Linear2DSet)object).getX()) && this.Y.equals(((Linear2DSet)object).getY());
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.X.hashCode() ^ this.Y.hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int n) {
        if (n == 0) {
            return this.getX();
        }
        if (n == 1) {
            return this.getY();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative component index " + n);
        }
        throw new ArrayIndexOutOfBoundsException("Component index " + n + " must be less than 2");
    }

    public Object clone() {
        try {
            Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone()};
            return new Linear2DSet(this.Type, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Linear2DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone()};
        return new Linear2DSet(mathType, linear1DSetArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String string) throws VisADException {
        String string2 = string + "Linear2DSet: Length = " + this.Length + "\n";
        string2 = string2 + string + "  Dimension 1: Length = " + this.X.getLength() + " Range = " + this.X.getFirst() + " to " + this.X.getLast() + "\n";
        string2 = string2 + string + "  Dimension 2: Length = " + this.Y.getLength() + " Range = " + this.Y.getFirst() + " to " + this.Y.getLast() + "\n";
        return string2;
    }

    public Linear2DSet(Linear1DSet[] linear1DSetArray) throws VisADException {
        this((MathType)RealTupleType.Generic2D, linear1DSetArray, null, null, null);
    }

    public Linear2DSet(MathType mathType, Linear1DSet[] linear1DSetArray) throws VisADException {
        this(mathType, linear1DSetArray, null, null, null);
    }

    public Linear2DSet(double d, double d2, int n, double d3, double d4, int n2) throws VisADException {
        this((MathType)RealTupleType.Generic2D, LinearNDSet.get_linear1d_array(RealTupleType.Generic2D, d, d2, n, d3, d4, n2), null, null, null);
    }

    public Linear2DSet(MathType mathType, double d, double d2, int n, double d3, double d4, int n2) throws VisADException {
        this(mathType, LinearNDSet.get_linear1d_array(mathType, d, d2, n, d3, d4, n2), null, null, null);
    }

    public Linear2DSet(MathType mathType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, null, linear1DSetArray[0].getLength(), linear1DSetArray[1].getLength(), coordinateSystem, unitArray, errorEstimateArray);
        if (this.DomainDimension != 2) {
            throw new SetException("Linear2DSet: DomainDimension must be 2, not " + this.DomainDimension);
        }
        if (linear1DSetArray.length != 2) {
            throw new SetException("Linear2DSet: ManifoldDimension must be 2, not " + linear1DSetArray.length);
        }
        this.X = linear1DSetArray[0];
        this.Y = linear1DSetArray[1];
        this.LengthX = this.X.getLength();
        this.LengthY = this.Y.getLength();
        this.Length = this.LengthX * this.LengthY;
        this.Low[0] = this.X.getLowX();
        this.Hi[0] = this.X.getHiX();
        this.Low[1] = this.Y.getLowX();
        this.Hi[1] = this.Y.getHiX();
        if (this.SetErrors[0] != null) {
            this.SetErrors[0] = new ErrorEstimate(this.SetErrors[0].getErrorValue(), (double)(this.Low[0] + this.Hi[0]) / 2.0, this.Length, this.SetErrors[0].getUnit());
        }
        if (this.SetErrors[1] != null) {
            this.SetErrors[1] = new ErrorEstimate(this.SetErrors[1].getErrorValue(), (double)(this.Low[1] + this.Hi[1]) / 2.0, this.Length, this.SetErrors[1].getUnit());
        }
    }

    public Linear2DSet(MathType mathType, double d, double d2, int n, double d3, double d4, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, LinearNDSet.get_linear1d_array(mathType, d, d2, n, d3, d4, n2), coordinateSystem, unitArray, errorEstimateArray);
    }
}

